package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.TechDocumentDto;
import com.yeejoin.precontrol.common.entity.TechDocument;
import com.yeejoin.precontrol.common.mapper.TechDocumentMapper;
import com.yeejoin.precontrol.common.service.ITechDocumentService;
import com.yeejoin.precontrol.common.vo.TechDocumentVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 技术文库 服务实现类
 *
 * @author duanwei
 * @date 2020-06-30
 */
@Service
public class TechDocumentServiceImpl extends ServiceImpl<TechDocumentMapper, TechDocument> implements ITechDocumentService {

    @Autowired
    TechDocumentMapper techDocumentMapper;

    @Override
    public IPage<TechDocumentVo> listByPage(CommonPageableDto pageable, TechDocumentDto techDocumentDto) {
        if (pageable.getIsAll() == 1) {
            pageable.setPageNumber(0);
            pageable.setPageSize(Integer.MAX_VALUE);
        }
        Page<TechDocumentVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return techDocumentMapper.listByPage(page, techDocumentDto);

    }
}
