package com.yeejoin.amos.boot.module.tzs.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 单位注册信息表
 *
 * @author system_generator
 * @date 2022-08-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_flc_reg_unit_info")
public class RegUnitInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单位名称
     */
    @TableField("name")
    private String name;

    /**
     * 证件code
     */
    @TableField("unit_code")
    private String unitCode;

    /**
     * 证件类型
     */
    @TableField("unit_code_type")
    private String unitCodeType;

    /**
     * 证件类型名称
     */
    private String unitCodeTypeName;

    /**
     * 单位类型
     */
    @TableField("unit_type")
    private String unitType;

    /**
     * 单位类型code
     */
    @TableField("unit_type_code")
    private String unitTypeCode;

    /**
     * 管辖机构
     */
    @TableField("management_unit")
    private String managementUnit;

    /**
     * 管辖单位id
     */
    @TableField("management_unit_id")
    private String managementUnitId;

    /**
     * 区域编码
     */
    @TableField("region_code")
    private String regionCode;

    /**
     * 国家
     */
    @TableField("country")
    private String country;

    /**
     * 省
     */
    @TableField("province")
    private String province;

    /**
     * 市
     */
    @TableField("city")
    private String city;

    /**
     * 县区
     */
    @TableField("district")
    private String district;

    /**
     * 街道
     */
    @TableField("stree")
    private String stree;

    /**
     * 小区
     */
    @TableField("community")
    private String community;

    /**
     * 详细地址
     */
    @TableField("address")
    private String address;

    /**
     * 经度
     */
    @TableField("longitude")
    private String longitude;

    /**
     * 纬度
     */
    @TableField("latitude")
    private String latitude;

    /**
     * 单位法人
     */
    @TableField("legal_person")
    private String legalPerson;

    /**
     * 法人电话
     */
    @TableField("legal_person_tel")
    private String legalPersonTel;

    /**
     * 单位联系人
     */
    @TableField("contact_person")
    private String contactPerson;

    /**
     * 联系人电话
     */
    @TableField("contact_person_tel")
    private String contactPersonTel;

    /**
     * 管理员姓名
     */
    @TableField("admin_name")
    private String adminName;

    /**
     * 管理员用户名
     */
    @TableField("admin_login_name")
    private String adminLoginName;

    /**
     * 管理员密码
     */
    @TableField("admin_login_pwd")
    private String adminLoginPwd;

    /**
     * 管理员手机号
     */
    @TableField("admin_tel")
    private String adminTel;

    /**
     * 管理元身份证号
     */
    @TableField("admin_id_number")
    private String adminIdNumber;

    /**
     * 审核状态：1-无需审核；2-待审核；3-已审核
     */
    @TableField("state")
    private String state;

    /**
     * 平台公司id，平台创建公司后更新
     */
    @TableField("amos_company_seq")
    private String amosCompanySeq;

    /**
     *  平台用户id，平台创建用户后更新
     */
    private String adminUserId;

}
