package com.yeejoin.amos.boot.module.tzs.biz.controller;

import java.util.Arrays;
import java.util.Map;

import com.yeejoin.amos.boot.module.tzs.api.dto.InspectionDetectionInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.MaintainInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.InspectionDetectionInfo;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.InspectionDetectionInfoServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;


/**
 * 安全追溯-检验检测信息表
 *
 * @author cpp
 * @date 2023-04-06 19:18:21
 */
@RestController
@Api(tags ="安全追溯-检验检测信息表Api")
@RequestMapping(value = "/api/inspectiondetectioninfo")
public class InspectionDetectionInfoController extends BaseController {
    @Autowired
    private InspectionDetectionInfoServiceImpl infoService;

    /**
     * 检验检测信息（查询）
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectSpect")
    @ApiOperation(httpMethod = "GET", value = "检验检测信息（查询）", notes = "检验检测信息（查询）")
    public ResponseModel<InspectionDetectionInfoDto> selectSpect(String superviseCode) {
        return ResponseHelper.buildResponse(infoService.selectSpect(superviseCode));
    }



}
