package com.yeejoin.amos.boot.module.tzs.biz.service.impl;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sun.scenario.effect.impl.sw.sse.SSEBlend_SRC_OUTPeer;
import com.yeejoin.amos.boot.module.tzs.api.dto.BaseUnitLicenceDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.EquEnterDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.BaseUnitLicence;
import com.yeejoin.amos.boot.module.tzs.api.entity.PageParam;
import com.yeejoin.amos.boot.module.tzs.api.entity.SpeUseUnit;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.tzs.api.mapper.TzBaseEnterpriseInfoMapper;
import com.yeejoin.amos.boot.module.tzs.api.service.IBaseUnitLicenceService;
import com.yeejoin.amos.boot.module.tzs.api.service.ISpeUseUnitService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzBaseEnterpriseInfoService;
import com.yeejoin.amos.boot.module.tzs.biz.utils.RedisUtil;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.RegUnitIcDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.RegUnitIc;
import com.yeejoin.amos.boot.module.tzs.flc.api.feign.AccessFeignService;
import com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl.RegUnitIcServiceImpl;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;

import java.util.*;


import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

/**
 * 企业数据信息 服务实现类
 *
 * @author duanwei
 * @date 2022-08-10
 */
@Service
public class TzBaseEnterpriseInfoServiceImpl
		extends BaseService<TzBaseEnterpriseInfoDto, TzBaseEnterpriseInfo, TzBaseEnterpriseInfoMapper>
		implements ITzBaseEnterpriseInfoService {

	@Autowired
	RedisUtil redisUtil;

	@Value("${admin.product}")
	String product;

	@Value("${admin.appkey}")
	String appkey;

	@Autowired
	private TzBaseEnterpriseInfoMapper tzBaseEnterpriseInfoMapper;

	@Autowired
	BaseUnitLicenceServiceImpl baseUnitLicenceService;

	@Autowired
	RegUnitIcServiceImpl regUnitIcService;

	@Autowired
	private IBaseUnitLicenceService iBaseUnitLicenceService;

	@Autowired
	private SpeUseUnitServiceImpl speUseUnitService;

	@Autowired
	private AccessFeignService accessFeignService;

	@Override
	public List<EquEnterDto> getInfo(String sequenceNbr) {
		return tzBaseEnterpriseInfoMapper.getInfo(sequenceNbr);
	}

	@Override
	public IPage<TzBaseEnterpriseInfoDto> page(PageParam pageParam, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto) {
		if (tzBaseEnterpriseInfoDto.getSuperviseKey() != null) {
			FeignClientResult<CompanyModel> result = Privilege.companyClient
					.seleteOne(Long.valueOf(tzBaseEnterpriseInfoDto.getSuperviseKey()));
			if (result.getResult() != null) {
				tzBaseEnterpriseInfoDto.setSuperviseOrgCode(result.getResult().getOrgCode());
			}
		}
		Page<TzBaseEnterpriseInfoDto> page = new Page<>(pageParam.getCurrent(), pageParam.getSize());
		return this.baseMapper.page(page, tzBaseEnterpriseInfoDto);
	}

	@Override
	public TzBaseEnterpriseInfoDto detail(Long id) {
		TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto = new TzBaseEnterpriseInfoDto();
		TzBaseEnterpriseInfo tzBaseEnterpriseInfo = this.getById(id);
		if (tzBaseEnterpriseInfo != null) {
			BeanUtils.copyProperties(tzBaseEnterpriseInfo, tzBaseEnterpriseInfoDto);
		}
		// 许可信息
		List<BaseUnitLicence> unitLicences = baseUnitLicenceService.list(new LambdaQueryWrapper<BaseUnitLicence>()
				.eq(BaseUnitLicence::getUnitCode, tzBaseEnterpriseInfo.getUseCode()));
		List<BaseUnitLicenceDto> unitLicenceDtos = new ArrayList<BaseUnitLicenceDto>();
		for (BaseUnitLicence baseUnitLicence : unitLicences) {
			BaseUnitLicenceDto baseUnitLicenceDto = new BaseUnitLicenceDto();
			BeanUtils.copyProperties(baseUnitLicence, baseUnitLicenceDto);
			unitLicenceDtos.add(baseUnitLicenceDto);
		}
		tzBaseEnterpriseInfoDto.setUnitLicences(unitLicenceDtos);
		// 工商信息
		RegUnitIc regUnitIc = regUnitIcService.getOne(
				new LambdaQueryWrapper<RegUnitIc>().eq(RegUnitIc::getUnitCode, tzBaseEnterpriseInfo.getUseCode()));
		RegUnitIcDto regUnitIcDto = new RegUnitIcDto();
		if (regUnitIc != null) {
			BeanUtils.copyProperties(regUnitIc, regUnitIcDto);
		}
		tzBaseEnterpriseInfoDto.setRegUnitIcDto(regUnitIcDto);
		return tzBaseEnterpriseInfoDto;

	}

	@Override
	public List<EquEnterDto> getInfoByUseUnit(String userUnit) {
		return tzBaseEnterpriseInfoMapper.getInfoByUseUnit(userUnit);
	}

	@Override
	public TzBaseEnterpriseInfoDto selectByUseUnit(String useUnit) {
		if(ValidationUtil.isEmpty(useUnit)){
			return new TzBaseEnterpriseInfoDto();
		}
		TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto = new TzBaseEnterpriseInfoDto();
		TzBaseEnterpriseInfo tzBaseEnterpriseInfo = tzBaseEnterpriseInfoMapper.selectByUseUnit(useUnit);
		if (tzBaseEnterpriseInfo != null) {
			BeanUtils.copyProperties(tzBaseEnterpriseInfo, tzBaseEnterpriseInfoDto);
		}
		// 许可信息
		List<BaseUnitLicence> unitLicences = baseUnitLicenceService.list(new LambdaQueryWrapper<BaseUnitLicence>()
				.eq(BaseUnitLicence::getUnitCode, tzBaseEnterpriseInfo.getUseCode()));
		List<BaseUnitLicenceDto> unitLicenceDtos = new ArrayList<BaseUnitLicenceDto>();
		for (BaseUnitLicence baseUnitLicence : unitLicences) {
			BaseUnitLicenceDto baseUnitLicenceDto = new BaseUnitLicenceDto();
			BeanUtils.copyProperties(baseUnitLicence, baseUnitLicenceDto);
			unitLicenceDtos.add(baseUnitLicenceDto);
		}
		tzBaseEnterpriseInfoDto.setUnitLicences(unitLicenceDtos);
		// 工商信息
		RegUnitIc regUnitIc = regUnitIcService.getOne(
				new LambdaQueryWrapper<RegUnitIc>().eq(RegUnitIc::getUnitCode, tzBaseEnterpriseInfo.getUseCode()));
		RegUnitIcDto regUnitIcDto = new RegUnitIcDto();
		if (regUnitIc != null) {
			BeanUtils.copyProperties(regUnitIc, regUnitIcDto);
		}
		tzBaseEnterpriseInfoDto.setRegUnitIcDto(regUnitIcDto);
		return tzBaseEnterpriseInfoDto;

	}

	@Override
	public String syncEnterpriseInfo() {
		RequestContext.setAppKey(appkey);
		RequestContext.setProduct(product);
		RequestContext.setToken(String.valueOf(redisUtil.get("platform_token")));

		List<TzBaseEnterpriseInfo> baseEnterpriseInfoList = new ArrayList<>();

		//获取平台企业表企业名称及sequence_code，并装入map中
		Collection<CompanyModel> companyModels = Privilege.companyClient.queryAgencyTree(null).getResult();
		Map<String,CompanyModel> companyMap = new HashMap<>();

		getCompanyInfoMap(companyModels,companyMap);

		int size = 500;
		int total = speUseUnitService.count();
		int current = total/size;
		current = current + 1;
		for(int i = 1; i<=current; i++){


			IPage<SpeUseUnit> page = new Page<>();
			page.setCurrent(i);
			page.setSize(size);
			List<SpeUseUnit> speUseUnitList = speUseUnitService.page(page).getRecords();
			for (SpeUseUnit speUseUnit : speUseUnitList) {

				if(speUseUnit.getSyncState() != 3){
					CompanyModel companyPrivilegeModel = Privilege.companyClient.queryByCompanyCode(speUseUnit.getCerCode()).getResult();
					QueryWrapper<TzBaseEnterpriseInfo> queryWrapper = new QueryWrapper<TzBaseEnterpriseInfo>();
					queryWrapper.eq("use_code",speUseUnit.getCerCode());
					TzBaseEnterpriseInfo tzBaseEnterprisePrivilegeInfo = this.getOne(queryWrapper);

					Map<String, Object> resultMap = accessFeignService.getData(speUseUnit.getCerCode()).getResult();

					if (ValidationUtil.isEmpty(resultMap)){
						if(!ValidationUtil.isEmpty(companyPrivilegeModel)){
							List<AgencyUserModel> agencyUserModelList = Privilege.agencyUserClient.queryByCompanyId(companyPrivilegeModel.getSequenceNbr(),null,null,null).getResult();
							if(ValidationUtil.isEmpty(agencyUserModelList)){
								//spe表中的数据在工商查不到，且平台无用户，将删除企业数据
								Privilege.companyClient.deleteCompany(String.valueOf(companyPrivilegeModel.getSequenceNbr()));
								if (!ValidationUtil.isEmpty(tzBaseEnterprisePrivilegeInfo)) {
									this.deleteBySeq(tzBaseEnterprisePrivilegeInfo.getSequenceNbr());
								}
							}
						}
						//spe表中的数据在工商查不到,设置spe表状态为1
						speUseUnit.setSyncState(1);
						speUseUnitService.updateById(speUseUnit);
					}else {
						CompanyModel privilegeCompanyModel = Privilege.companyClient.queryByCompanyName(String.valueOf(resultMap.get("registration_authority"))).getResult();
						CompanyModel companyModel = new CompanyModel();
						companyModel.setCompanyName(speUseUnit.getName());
						companyModel.setCompanyCode(speUseUnit.getCerCode());
						companyModel.setLevel("company");
						companyModel.setAgencyCode("tzs");
						companyModel.setCompanyType("使用单位");
						companyModel.setAddress(String.valueOf(resultMap.get("address")));
						companyModel.setParentId(privilegeCompanyModel.getSequenceNbr());


						String area = String.valueOf(resultMap.get("area"));
						String province = "";
						if (area.contains("省")) {
							province = area.substring(0, area.indexOf("省") + 1);
						}
						String city = "";
						if (area.contains("市")) {
							city = area.substring(province.length(), area.indexOf("市") + 1);
						}
						String district = area.substring(city.length() + province.length());
						TzBaseEnterpriseInfo baseEnterpriseInfo = new TzBaseEnterpriseInfo();
						baseEnterpriseInfo.setUseUnit(speUseUnit.getName());
						baseEnterpriseInfo.setUseCode(speUseUnit.getCerCode());
						baseEnterpriseInfo.setUnitType("使用单位");
						baseEnterpriseInfo.setRegistrationAuthority(String.valueOf(resultMap.get("registration_authority")));
						baseEnterpriseInfo.setProvince(province);
						baseEnterpriseInfo.setCity(city);
						baseEnterpriseInfo.setDistrict(district);
						baseEnterpriseInfo.setStreet(String.valueOf(resultMap.get("street")));
						baseEnterpriseInfo.setCommunity(String.valueOf(resultMap.get("community")));
						baseEnterpriseInfo.setAddress(String.valueOf(resultMap.get("address")));
						baseEnterpriseInfo.setLegalPerson(String.valueOf(resultMap.get("legalPeople")));
						baseEnterpriseInfo.setIndustry(String.valueOf(resultMap.get("industry")));
						baseEnterpriseInfo.setSuperviseOrgName(String.valueOf(resultMap.get("registration_authority")));
						baseEnterpriseInfo.setSuperviseOrgCode(privilegeCompanyModel.getOrgCode());
						baseEnterpriseInfo.setOperatingStatus(String.valueOf(resultMap.get("operating_status")));
						baseEnterpriseInfo.setUnitType("使用单位");
						baseEnterpriseInfoList.add(baseEnterpriseInfo);


						//保存平台和业务的企业信息
						try {
							if (tzBaseEnterprisePrivilegeInfo == null && companyPrivilegeModel == null) {
								//当企业表、平台表 中没有时
								this.save(baseEnterpriseInfo);
								Privilege.companyClient.create(companyModel);
							} else if (tzBaseEnterprisePrivilegeInfo == null) {
								//企业表没有，平台表有
								this.save(baseEnterpriseInfo);
								if (!companyPrivilegeModel.getCompanyType().contains(companyModel.getCompanyType())) {
									companyPrivilegeModel.setCompanyType(companyPrivilegeModel.getCompanyType() + "," + companyModel.getCompanyType());
									Privilege.companyClient.update(companyPrivilegeModel, companyPrivilegeModel.getSequenceNbr());
								}
							} else if (companyPrivilegeModel == null) {
								//平台表没有，企业表有
								if (!tzBaseEnterprisePrivilegeInfo.getUnitType().contains(baseEnterpriseInfo.getUnitType())) {
									tzBaseEnterprisePrivilegeInfo.setUnitType(tzBaseEnterprisePrivilegeInfo.getUnitType() + "," + baseEnterpriseInfo.getUnitType());
									this.updateById(tzBaseEnterprisePrivilegeInfo);
								}
								Privilege.companyClient.create(companyModel);
							} else {
								//企业表有 平台表有
								if (!companyPrivilegeModel.getCompanyType().contains(companyModel.getCompanyType())) {
									companyPrivilegeModel.setCompanyType(companyPrivilegeModel.getCompanyType() + "," + companyModel.getCompanyType());
									Privilege.companyClient.update(companyPrivilegeModel, companyPrivilegeModel.getSequenceNbr());
								}
								if (!tzBaseEnterprisePrivilegeInfo.getUnitType().contains(baseEnterpriseInfo.getUnitType())) {
									tzBaseEnterprisePrivilegeInfo.setUnitType(tzBaseEnterprisePrivilegeInfo.getUnitType() + "," + baseEnterpriseInfo.getUnitType());
									this.updateById(tzBaseEnterprisePrivilegeInfo);
								}
							}
							setSpeUseUnitState(3,speUseUnit);
						} catch (Exception e) {
							System.out.println(e.getMessage());
							//当报错时 设置状态为 2
							speUseUnit.setSyncState(2);
							speUseUnitService.updateById(speUseUnit);
						}
					}
				}
			}
		}
		return "ok";
	}


	public void setSpeUseUnitState(int state,SpeUseUnit speUseUnit){
		speUseUnit.setSyncState(state);
		speUseUnitService.updateById(speUseUnit);
	}

	public Map<String, CompanyModel> getCompanyInfoMap(Collection companyModels,Map<String, CompanyModel> map){
		if(companyModels == null){
			return map;
		}
		Iterator iter = companyModels.iterator();
		while(iter.hasNext()){
			String json = JSON.toJSONString(iter.next());
			CompanyModel companyModel =  JSON.parseObject(json,CompanyModel.class);
			map.put(companyModel.getCompanyName(),companyModel);
			getCompanyInfoMap(companyModel.getChildren(),map);
		}
		return map;
	}

}
