package com.yeejoin.amos.boot.module.ugp.api.dto;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.boot.module.ugp.api.entity.Company;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 企业信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CompanyDto", description="企业信息表")
public class CompanyDto  extends BaseDto {

   private static final long serialVersionUID = 1L;

   Company company;

 @ApiModelProperty(value = "企业名称")
 private String name;

 @ApiModelProperty(value = "企业类型")
 private String type;

 @ApiModelProperty(value = "统一信用代码")
 private String creditCode;

 @ApiModelProperty(value = "许可证号")
 private String licenseNumber;

 @ApiModelProperty(value = "有效期至")
 private Date expirationDate;

 @ApiModelProperty(value = "企业地址")
 private String address;

 @ApiModelProperty(value = "联系方式")
 private String contactPhone;

 @ApiModelProperty(value = "联系人")
 private String contact;

 private String remark;

 @ApiModelProperty(value = "统一信用代码证书附件")
 private String creditAttch;

 @ApiModelProperty(value = "许可证附件")
 private String licenseAttch;

 @ApiModelProperty(value = "是否已审核（1已审核，0未审核）")
 private String approved;

 @ApiModelProperty(value = "单位机构代码")
 private String orgCode;

 @ApiModelProperty(value = "企业管理员")
 private String adminName;

 @ApiModelProperty(value = "企业管理员电话")
 private String adminTel;

 @ApiModelProperty(value = "法人")
 private String legalPerson;

 @ApiModelProperty(value = "法人电话")
 private String legalPersonTel;

 @ApiModelProperty(value = "单位电话")
 private String unitTel;

 @ApiModelProperty(value = "成立日期")
 private Date createTime;

 private JSONArray lincensePicUrl;

 @ApiModelProperty(value = "管理员身份证附件")
 private String adminLincensePic;

 @ApiModelProperty(value = "用户名")
 private String adminLoginName;

 @ApiModelProperty(value = "用户密码")
 private String adminLoginPwd;

 @ApiModelProperty(value = "组织机构代码")
 private String regionCode;

 private String regionCodeP;

 private String regionCodeC;

 private String regionCodeD;

}
