package com.yeejoin.amos.supervision.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 消防监督枚举对象
 * @author maoying
 *
 */
public enum SupervisionDictEnum {

    CHECK_ITEM_CLASSIFY("消防监督检查项分类","CHECK_ITEM_CLASSIFY"),
    CHECK_ITEM_TYPE("消防监督检查类别","CHECK_ITEM_TYPE"),
    CHECK_ITEM_LEVEL("消防监督检查项等级","CHECK_ITEM_LEVEL"),
    CHECK_ITEM_CONTENT("消防监督检查类型","CHECK_ITEM_CONTENT");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    private SupervisionDictEnum(String name, String code){
        this.name = name;
        this.code = code;
    }

    public static SupervisionDictEnum getEnum(String code) {
        SupervisionDictEnum instance = null;
        for(SupervisionDictEnum type: SupervisionDictEnum.values()) {
            if (type.getCode().equals(code)) {
                instance = type;
                break;
            }
        }

        return instance;
    }

    public static List<Map<String,String>> getEnumList() {
        List<Map<String,String>> list = new ArrayList<>();
        for(SupervisionDictEnum e : SupervisionDictEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("code", e.getCode());
            map.put("name", e.getName());
            list.add(map);
        }
        return list;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
