package com.yeejoin.amos.supervision.dao.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author xixinzhao
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@Table(name = "p_hidden_danger")
public class HiddenDanger extends BasicEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 隐患id
     */
    @Column(name = "latent_danger_id")
    private Long latentDangerId;

    /**
     * 检查记录id
     */
    @Column(name = "check_id")
    private Long checkId;

    /**
     * 检查项记录id
     */
    @Column(name = "check_input_id")
    private Long checkInputId;

    /**
     * 计划id
     */
    @Column(name = "plan_id")
    private Long planId;

    /**
     * 点id
     */
    @Column(name = "point_id")
    private Long pointId;


    /**
     * 隐患类型（1-防火监督检查；2-自行检查）
     */
    @Column(name = "danger_type")
    private String dangerType;

    /**
     * 隐患类型名称
     */
    @Column(name = "danger_type_name")
    private String dangerTypeName;

    /**
     * 创建者
     */
    private String createBy;

    /**
     * 更新日期
     */
    private Date updateDate;
}
