package com.yeejoin.amos.supervision.business.dao.mapper;

import com.yeejoin.amos.supervision.business.param.InputItemPageParam;
import com.yeejoin.amos.supervision.business.vo.InputItemVo;
import com.yeejoin.amos.supervision.business.vo.PointInputItemVo;
import com.yeejoin.amos.supervision.dao.entity.InputItem;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public interface InputItemMapper {
    void updateInputItem(InputItem item);

    List<HashMap<String, Object>> countByCatalogId(HashMap<String, Object> paramMap);

    long countInputItemInfoData(InputItemPageParam param);

    List<InputItemVo> getInputItemInfo(InputItemPageParam param);

    List<InputItemVo> getInputItemListByNames(@Param("itemNames") String[] items, @Param("orgCode") String orgCode);

    List<PointInputItemVo> queryCustomInputItem(Map<String, Object> param);

    List<InputItemVo> getInputItemListByitemNos(@Param("itemNos") String[] itemNos);

    List<InputItem> getInputItemByEquipmentName(@Param("equipmentName") String equipmentName);

    List<PointInputItemVo> queryCustomInputItemByPointId(@Param("pointId") Long pointId, @Param("equipmentId") String equipmentName);

    Integer insertList(List<InputItem> list);

    List<InputItemVo> getInputItemParent(@Param("id") String id);

    void updatePointById(Map<String, Object> param);

    List<Long> getIds();

    List<InputItem> findByIdIn(@Param("list") List<Long> inputItemIds);

    long queryPageCount(InputItemPageParam param);

    List<InputItemVo> queryPage(InputItemPageParam param);
}
