package com.yeejoin.amos.api.openapi.face.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.csoft.sdk.domain.CsoftDataApiXixianGetzhutiinfoParam;
import com.csoft.sdk.domain.request.CsoftDataApiXixianGetzhutiinfoRequest ;
import com.csoft.sdk.domain.response.CsoftDataApiXixianGetzhutiinfoResponse;
import com.yeejoin.amos.api.openapi.face.orm.dao.DataDictionaryMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.csoft.sdk.client.CsoftDefaultSdkClient;
import com.csoft.sdk.domain.App;
import com.csoft.sdk.domain.CsoftDataTzsbJbxxListParam;
import com.yeejoin.amos.api.openapi.face.model.TaAccessConfigModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.TaAccessConfigMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.TaAccessConfig;
import com.yeejoin.amos.api.openapi.face.orm.entity.TaLicenseBaseInfo;

/**
 * 附件表 服务实现类
 *
 * @author duanwei
 * @date 2022-08-17
 */
@Service
public class TaBusinessServiceImpl extends BaseService<TaAccessConfigModel, TaAccessConfig, TaAccessConfigMapper> {

	@Autowired
	private DataDictionaryMapper dataDictionaryMapper;

	public Map<String, Object> getData(String code) throws Exception {
		Map<String, String> map = TaAccessConfigServiceImpl.licenseConfig;
		String appId = map.get("appId");
		String appKey = map.get("appKey");
		String appSecret = map.get("appSecret");
		String server = map.get("server");
		App app = App.of(appId, appKey, appSecret, server);
		CsoftDefaultSdkClient client = CsoftDefaultSdkClient.of(app);
		// 3.设置参数，发送请求，并处理结果
		CsoftDataApiXixianGetzhutiinfoParam csoftDataApiXixianParam = new CsoftDataApiXixianGetzhutiinfoParam();
		csoftDataApiXixianParam.setUniscid(code);
		CsoftDataApiXixianGetzhutiinfoRequest request = new CsoftDataApiXixianGetzhutiinfoRequest(csoftDataApiXixianParam);
		CsoftDataApiXixianGetzhutiinfoResponse response = client.execute(request);
		Map<String, Object> result = new HashMap<>();
		// 4.返回校验
		if (response.isSuccess()) {
			System.out.println("成功：" + response.getData());
			System.out.println(response.getResult());
			JSONObject jsonObject = JSONObject.parseObject(response.getData());
			JSONObject data = jsonObject.getJSONObject("data");
			//如果不存在该企业 则直接返回null
			if(ValidationUtil.isEmpty(data)){
				return result;
			}
			//分割字符串 根据详细地址分割出 省/市/区、街道地址、小区地址
			String address = data.getString("dom");
			String area = address.substring(0,address.indexOf("区")+1);
			String street = address.substring(area.length()).substring(0,address.substring(area.length()).indexOf("号")+1);
			String community = address.substring(area.length()+street.length());

			String industry = "";
			if(!ValidationUtil.isEmpty(data.get("hydm"))){
				if(data.getString("hydm").length() > 2){
					industry = getIndustry(data.getString("hydm"));
				}

			}


			//所属行业
			result.put("industry", industry);
			//注册地址 省/市/区
			result.put("area", area);
			//注册地址 街道地址
			result.put("street", street);
			//注册地址 小区地址
			result.put("community", community);
			//注册地址 详细地址
			result.put("address", data.get("dom"));
			//登记机关
			result.put("registration_authority", data.get("regorg"));
			//核准时间
			result.put("approval_time", data.get("hzrq"));
			//经营状态
			result.put("operating_status", data.get("opstate"));
			//统一社会信用代码
			result.put("creditCode",data.get("uniscid"));
			//企业名称
			result.put("unitName",data.get("entname"));
			//经营范围
			result.put("businessScope",data.get("opscope"));
			//注册资金(数字，万元)
			result.put("regcap",data.get("regcap"));
			//成立日期
			result.put("estdate",data.get("estdate"));
			//营业期限(yyyy-mm-dd)
			result.put("operatingPeriod",data.get("yyqx"));
			//生产经营地址
			result.put("oploc",data.get("oploc"));
			//登记注册类型中文描述
			result.put("enttype",data.get("enttype"));
			//法定代表人姓名
			result.put("legalPeople",data.get("lerep"));
			//行业小类编码
			result.put("industryCode",data.get("hydm"));
		} else {
			System.out.println("失败：" + response.getErrorMsg());
			System.out.println("失败：" + response.getErrorCode());
			throw new Exception(response.getErrorMsg());
		}
		return result;
	}


	public String getIndustry(String code){
		return dataDictionaryMapper.getData(code.substring(0,2));
	}

}
