package com.yeejoin.equipmanage.common.datasync.enums;

/**
 * <h1>同步数据类型</h1>
 *
 * @Author SingleTian
 * @Date 2021-04-01 09:20
 */
public enum SyncDataTypeEnum {
    /**
     * 巡检项
     */
    ASF_FIRE_PATROL_ITEM("11", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     * 巡检点
     */
    ASF_FIRE_PATROL_POINT("12", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     * 巡检点检查项
     */
    ASF_FIRE_PATROL_POINT_ITEM("60", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     * 巡检路线
     */
    ASF_FIRE_PATROL_ROUTE("61", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     * 巡检路线点
     */
    ASF_FIRE_PATROL_ROUTE_POINT("62", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     * 巡检路线点检查项
     */
    ASF_FIRE_PATROL_ROUTE_POINT_ITEM("63", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     * 巡检计划
     */
    ASF_FIRE_PATROL_PLAN("64", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     * 巡检任务
     */
    ASF_FIRE_PATROL_PLAN_TASK("65", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     * 任务详情
     */
    ASF_FIRE_PATROL_PLAN_TASK_DETAIL("66", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     * 巡检记录
     */
    ASF_FIRE_PATROL_CHECK_RECORD("67", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     * 巡查记录详情
     */
    ASF_FIRE_PATROL_CHECK_RECORD_DETAIL("68", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     *  区域
     */
    AST_AREA("01", "cs/v1/fireAST/dataSync", "isNotIot"),
    /**
     *  建筑
     */
    AST_BUILDING("02", "cs/v1/fireAST/dataSync", "building"),
    /**
     *  围墙
     */
    AST_WALL("03", "cs/v1/fireAST/dataSync", "isNotIot"),
    /**
     *  楼层
     */
    AST_FLOOR("04", "cs/v1/fireAST/dataSync", "floor"),
    /**
     *  小室
     */
    AST_ROOM("05", "cs/v1/fireAST/dataSync", "room"),
    /**
     *  消防系统
     */
    AST_FIRE_FIGHTING("07", "cs/v1/fireAST/dataSync", "isNotIot"),
    /**
     * 消防设备
     */
    AST_FIRE_EQUIP("08", "cs/v1/fireAST/dataSync", "isNotIot"),
    /**
     * 消防设备参数信息
     */
    AST_FIRE_EQUIP_INFO("0801", "cs/v1/fireAST/dataSync", "isNotIot"),
    /**
     * 消防设备量测信息
     */
    AST_FIRE_EQUIP_MEASUREMENT("0802", "cs/v1/fireAST/dataSync", "isIot"),
    /**
     * 消防设备火警
     */
    AST_FIRE_EQUIP_ALARM("0803", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     * 消防设备故障
     */
    AST_FIRE_EQUIP_FAULT_ALARM("0804", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     * 消防设备缺陷
     */
    AST_FIRE_EQUIP_DEFECT_ALARM("0805", "cs/v1/fireASF/dataSync", "isNotIot"),
    /**
     * 消防车辆
     */
    AST_FIRE_VEHICLE("09", "cs/v1/fireAST/dataSync", "isNotIot"),
    /**
     * 消防车辆参数信息
     */
    AST_FIRE_VEHICLE_INFO("0901", "cs/v1/fireAST/dataSync", "isNotIot"),
    /**
     * 消防车辆量测信息
     */
    AST_FIRE_VEHICLE_MEASUREMENT("0902", "cs/v1/fireAST/dataSync", "isIot"),

    ;

    /**
     * 资源类型编码
     */
    private final String sourceCode;
    /** mqtt主题 */
    private final String mqTopic;
    /** 装备物连属性 */
    private final String sign;

    SyncDataTypeEnum(String sourceCode, String mqTopic, String sign) {
        this.sourceCode = sourceCode;
        this.mqTopic = mqTopic;
        this.sign = sign;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public String getMqTopic() {
        return mqTopic;
    }

    public String getSign() {
        return sign;
    }

}
