package com.yeejoin.equipmanage.common.enums;


/**
 * 动态表单下拉枚举字典类型
 * @author DELL
 */

public enum DataOption {

    /**
     * 建筑物分类编码
     */
    BUILD_TYPE("buildType"),
    /**
     * 建筑物使用性质
     */
    BUILD_USE_TYPE("buildUseType"),
    /**
     * 消建筑物火灾危险性
     */
    FIRE_RISK_OF_BUILDINGS("fireRisk"),
    /**
     * 建筑物结构类型
     */
    BUILDING_STRUCTURE_TYPE("structureType"),
    /**
     * 建筑消防系统类别
     */
    BUILD_FIRE_SYSTEM("fireFightingType");


    private String fieldName;

    DataOption(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return fieldName;
    }

    public static DataOption getInstance(String fieldName) {
        DataOption dataOption = null;
        for (DataOption option : DataOption.values()) {
            if (option.getFieldName().contains(fieldName)){
                dataOption = option;
            }
        }
        return dataOption;
    }
}
