package com.yeejoin.equipmanage.common.utils;

import java.util.EnumMap;
import java.util.function.Supplier;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

@Component
public class FileUploadFactory {
	
	
	@Resource(name="iEquipmentDefUpload")
	private ImportFile iEquipmentDefUpload;

	@Resource(name="iEquipmentPointUpload")
	private ImportFile iEquipmentPointUpload;

	
	public ImportFile create(FileUploadTypeEnum type){
		
		setting(type);
		return map.get(type).get();
	}
	
	private void setting(FileUploadTypeEnum type) {
		if(type.getType().equals("EQUIPMENT_DEF")){
			map.put(FileUploadTypeEnum.EQUIPMENT_DEF, ()->iEquipmentDefUpload);
		}
//		else if(type.getType().equals("EQUIPMENT_POINT")){
//			map.put(FileUploadTypeEnum.EQUIPMENT_POINT, ()->iEquipmentPointUpload);
//		}
		
	}

	public static final EnumMap<FileUploadTypeEnum,Supplier<ImportFile>> map = new EnumMap<>(FileUploadTypeEnum.class);
	
	
}

