package com.yeejoin.amos.file.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


@ApiModel("每一页的pdf和img信息")
public class PageInfo {

    @ApiModelProperty("页面Id")
    private String pageId;

    @ApiModelProperty("页码")
    private Integer pageNum;

    @ApiModelProperty("页面高度")
    private Double height;

    @ApiModelProperty("页面宽度")
    private Double width;

    @ApiModelProperty("pdf路径")
    private String pdfUrl;

    @ApiModelProperty("图片路径")
    private String imgUrl;

    @ApiModelProperty("正文")
    private String content;

    public PageInfo(Integer pageNum, Double height, Double width, String pdfUrl, String imgUrl, String content) {
        this.pageNum = pageNum;
        this.height = height;
        this.width = width;
        this.pdfUrl = pdfUrl;
        this.imgUrl = imgUrl;
        this.content = content;
    }

    public String getPageId() {
        return pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public double getHeight() {
        return height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public Double getWidth() {
        return width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public String getPdfUrl() {
        return pdfUrl;
    }

    public void setPdfUrl(String pdfUrl) {
        this.pdfUrl = pdfUrl;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}
