package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
* 调派单位资源
*
* @author tb
* @date 2021-06-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_power_transfer_company_resources")
@ApiModel(value="PowerTransferCompanyResources对象", description="调派单位资源")
public class PowerTransferCompanyResources extends BaseEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "资源类型")
    private String type;

    @ApiModelProperty(value = "资源id")
    private String resourcesId;
    @ApiModelProperty(value = "调派关联部门id")
    protected Long  powerTransferCompanyId;
     
    @ApiModelProperty(value = "资源名称")
    private String resourcesName;

    @ApiModelProperty(value = "资源编号（如车牌号）")
    private String resourcesNum;

    @ApiModelProperty(value = "任务状态")
    private String status;

    @ApiModelProperty(value = "车辆任务状态")
    private String carStatus;


    @ApiModelProperty(value = "任务备注")
    private String  remarks;

    @ApiModelProperty(value = "车辆到场时间")
    private String  arrivalTime;

    @ApiModelProperty(value = "任务状态")
    @TableField(exist = false)
    private String statusName;
    @ApiModelProperty(value = "车辆任务")
    @TableField(exist = false)
    private String carStatusName;


    @ApiModelProperty(value = "随车人员")
    @TableField(exist = false)
    private String pw;




    @ApiModelProperty(value = "任务详情")
    @TableField(exist = false)
    private String taskInformation;
}
