package com.yeejoin.amos.boot.module.jcs.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 
 * <pre>
 * 航空器附件文件类型
 * </pre>
 *
 * @author gwb
 * @version $Id: AircraftFileTypeEnum.java, v 0.1 2021年6月29日 下午4:35:34 gwb Exp $
 */
@Getter
@AllArgsConstructor
public enum AircraftFileTypeEnum {

	APPEARANCE("APPEARANCE", "外观图"),
	PLANE("PLANE", "平面图"),
	RESCUE("RESCUE", "救援图"),
	POSITION("POSITION", "方位图"),
	MODEL("MODEL", "三维模型");

    private String code;
    private String name;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    
	public static AircraftFileTypeEnum getEnum(String code)
	{
		for (AircraftFileTypeEnum status : AircraftFileTypeEnum.values())
		{
			if (status.getCode().equals(code))
			{
				return status;
			}
		}
		return null;
	}
}
