package com.yeejoin.amos.knowledgebase.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * <p>
 * 知识库系统动态选项配置的实例值
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("knowledge_dynamics_value")
public class KnowledgeDynamicsValue extends BaseEntity {


	/**
	 * 字段名
	 */
	@TableField("FIELD_NAME")
	private String fieldName;
	/**
	 * 中文名
	 */
	@TableField("FIELD_LABEL")
	private String fieldLabel;
	/**
	 * 数据类型：文本，数字，枚举,日期
	 */
	@TableField("DATA_TYPE")
	private String dataType;
	/**
	 * 字段分组id
	 */
	@TableField("GROUP_SEQ")
	private Long groupSeq;
	/**
	 * 动态配置字段的值
	 */
	@TableField("FIELD_VALUE")
	private String fieldValue;
	/**
	 * 关联的对象id，即文档id
	 */
	@TableField("INSTANCE_ID")
	private Long instanceId;
	/**
	 * 机构编号
	 */
	@TableField("AGENCY_CODE")
	private String agencyCode;

	@TableField("OPTION_SEQ")
	private Long optionSeq;
	@TableField("QUERY_STRATEGY")
	private String queryStrategy;
}

