package com.yeejoin.equipmanage.service.impl;

import com.yeejoin.equipmanage.common.vo.EquipmentAccountAccVo;
import com.yeejoin.equipmanage.common.vo.EquipmentAccountCarVo;
import com.yeejoin.equipmanage.common.vo.EquipmentAccountFilterVo;
import com.yeejoin.equipmanage.common.vo.EquipmentAccountVo;
import com.yeejoin.equipmanage.common.vo.EquipmentHistoryVo;
import com.yeejoin.equipmanage.mapper.EquipmentAccountMapper;
import com.yeejoin.equipmanage.service.EquipmentAccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
@Service
public class EquipmentAccountServiceImpl implements EquipmentAccountService {

    @Autowired
    EquipmentAccountMapper equipmentAccountMapper;

    @Override
    public Map<String, Object> getAccounList(String eType,String eName,int spage,int pageSize){
        Map<String, Object> map = new HashMap<>();
        if (eType != null && !("").equals(eType)){
            eType=checkid(eType);
        }
        map.put("eType",eType);
        map.put("eName",eName);
        map.put("spage",spage);
        map.put("pageSize",pageSize);
        List<EquipmentAccountVo> accounList = equipmentAccountMapper.getAccounList(map);
        int accounListCount = equipmentAccountMapper.getAccounListCount(map);
        map.clear();
        map.put("dataList",accounList);
        map.put("count",accounListCount);
        return map;
    }

    @Override
    public List<EquipmentAccountFilterVo> getNameList(String id) {
        return equipmentAccountMapper.getNameList(checkid(id));
    }

    @Override
    public Map<String, Object> getMoreCarList(String carNum, int spage, int pageSize, String equipmentName, String accType) {
        Map<String, Object> map = new HashMap<>();
        map.put("carNum", carNum);
        map.put("spage", spage);
        map.put("pageSize", pageSize);
        map.put("equipmentName", equipmentName);
        switch (accType){
            case"inLibCount":
                map.put("accType",1);
                break;
            case"maintainCount":
                map.put("accType",3);
                break;
            case"badCount":
                map.put("accType",7);
                break;
        }
        List<EquipmentAccountCarVo> moreCarList = equipmentAccountMapper.getMoreCarList(map);
        int moreCarListCount = equipmentAccountMapper.getMoreCarListCount(map);
        map.clear();
        map.put("dataList",moreCarList);
        map.put("count",moreCarListCount);
        return map;
    }

    @Override
    public Map<String, Object> getMoreAccList(String code, int spage, int pageSize, String equipmentName, String accType) {
        Map<String, Object> map = new HashMap<>();
        map.put("code", code);
        map.put("spage", spage);
        map.put("pageSize", pageSize);
        map.put("equipmentName", equipmentName);
        switch (accType){
            case"inLibCount":
                map.put("accType",1);
                break;
            case"onCarCount":
                map.put("accType",10);
                break;
            case"maintainCount":
                map.put("accType",3);
                break;
            case"badCount":
                map.put("accType",7);
                break;
            case"wasteCount":
                map.put("accType",11);
                break;
        }
        List<EquipmentAccountAccVo> moreAccList = equipmentAccountMapper.getMoreAccList(map);
        int moreAccListCount = equipmentAccountMapper.getMoreAccListCount(map);
        map.clear();
        map.put("dataList",moreAccList);
        map.put("count",moreAccListCount);
        return map;
    }

    @Override
    public  List<EquipmentHistoryVo> selectHistoryById(Long id) {
        return equipmentAccountMapper.selectHistoryById(id);
    }

    @Override
    public Map<String, Object> getAccData(Long id) {
        Map<String, Object> map = new HashMap<>();
        String  equipmentAccountAccVos = equipmentAccountMapper.getaccData(id);
        List<EquipmentHistoryVo> equipmentHistoryVos = equipmentAccountMapper.selectAccHistoryById(id);
        String s = equipmentAccountMapper.getaccId(id);
        map.put("data",equipmentAccountAccVos);
        map.put("history",equipmentHistoryVos);
        map.put("eqId",s);
        return map;
    }


    private String checkid(String id){
        String substring = id.substring(1, 2);
        String substring1 = id.substring(2, 4);
        String substring2 = id.substring(4, 6);
        String substring3 = id.substring(6);
        if (!substring.equals("0")){
            substring = id.substring(0, 2);
            if (!substring1.equals("00")){
                substring += substring1;
                if(!substring2.equals("00")){
                    substring += substring2;
                    if(!substring3.equals("00")){
                        substring += substring3;
                    }
                }
            }
        }else {
            substring = id.substring(0, 1);
        }

        return substring;
    }
}
