package com.yeejoin.equipmanage.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieModel;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.SystemDic;
import com.yeejoin.equipmanage.mapper.SystemDicMapper;
import com.yeejoin.equipmanage.service.ISystemDicService;

/**
 * 数据字典 服务实现类
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Service
public class SystemDicServiceImpl extends ServiceImpl<SystemDicMapper, SystemDic> implements ISystemDicService {

	@Override
	public List<SystemDic> findAllByType(String type) {
		Map<String, Object> columnMap = new HashMap<String, Object>();
		columnMap.put("type", type);
		List<SystemDic> systemDics = this.baseMapper.selectByMap(columnMap);
		return systemDics;
	}

	@Override
	public SystemDic findByTypeAndCode(String type, String code) {
		QueryWrapper<SystemDic> queryWrapper = new QueryWrapper<SystemDic>();
		queryWrapper.lambda().eq(SystemDic::getType, type).eq(SystemDic::getCode, code);
		SystemDic systemDic = this.baseMapper.selectOne(queryWrapper);
		return systemDic;
	}

	public SystemDic  getByIdforAll(Long id) {
		Map<String, Object> columnMap = new HashMap<String, Object>();
		columnMap.put("id", id);
		SystemDic systemDics = this.baseMapper.selectByMap(columnMap).get(0);
		return systemDics;
	}

}
