package com.yeejoin.amos.knowledgebase.controller;

import com.yeejoin.amos.knowledgebase.face.model.KnowledgeDocAnnotateModel;
import com.yeejoin.amos.knowledgebase.face.service.DocAnnotateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * <p>
 * 知识库文档注释 前端控制器
 * </p>
 *
 * @author ningtianqing
 * @since 2020-09-16
 */

@RestController
@TycloudResource(module = "knowledgebase", value = "docannotate")
@RequestMapping(value = "/v1/docannotate")
@Api(tags = "knowledgebase-文档注释")
public class DocAnnotateResource {

    private final Logger logger = LogManager.getLogger(DocAnnotateResource.class);

    @Autowired
    private DocAnnotateService docAnnotateService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "创建注释")
    @RequestMapping(value = "", method = RequestMethod.POST)
    public ResponseModel<KnowledgeDocAnnotateModel> create(@RequestBody KnowledgeDocAnnotateModel model) {
        if (ValidationUtil.isEmpty(model)
                || ValidationUtil.isEmpty(model.getDocSeq())
                || ValidationUtil.isEmpty(model.getAnnotateContent()))
            throw new BadRequest("参数校验失败.");

        return ResponseHelper.buildResponse(docAnnotateService.createAnnotate(model));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "更新注释")
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.PUT)
    public ResponseModel<KnowledgeDocAnnotateModel> update(
            @RequestBody KnowledgeDocAnnotateModel model,
            @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        if (ValidationUtil.isEmpty(model)
                || ValidationUtil.isEmpty(model.getDocSeq())
                || ValidationUtil.isEmpty(model.getAnnotateContent()))
            throw new BadRequest("参数校验失败.");
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(docAnnotateService.updateAnnotate(model));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "批量删除注释")
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.DELETE)
    public ResponseModel deleteComments(
            @RequestBody KnowledgeDocAnnotateModel model,
            @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(docAnnotateService.deleteAnnotate(model));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据文档id获取文档下注释集合")
    @RequestMapping(value = "/{docSeq}", method = RequestMethod.GET)
    public ResponseModel getAnnotateByDocSeq(@PathVariable(value = "docSeq") String docSeq) {
        List<KnowledgeDocAnnotateModel> list = docAnnotateService.queryForAnnotateList(docSeq);
        return ResponseHelper.buildResponse(list);
    }
}
