package com.yeejoin.amos.maintenance.core.framework;

import com.yeejoin.amos.maintenance.business.constants.XJConstant;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.io.File;

@Configuration
public class PatrolApplicationConfig implements WebMvcConfigurer {
	
	@Value("${windows.img.path}")
	private String winImgPath;
	@Value("${linux.img.path}")
	private String linuxImgPath;
	
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
    	String localPath = "";
    	if ("\\".equals(File.separator)) {
    		localPath += winImgPath;
    	} else if ("/".equals(File.separator)) {
    		localPath += linuxImgPath;
    	}    	
        registry.addResourceHandler("/upload/**").addResourceLocations("file:"+localPath.trim()+XJConstant.UPLOAD_ROOT_PATH + File.separator);
//        registry.addResourceHandler("/upload/video/**").addResourceLocations("file:G:/upload/video/");
    }
}
