/*
Navicat MySQL Data Transfer

Source Server         : 172.16.10.66
Source Server Version : 50722
Source Host           : 172.16.10.66:3306
Source Database       : safety-business-3.0.0-empty

Target Server Type    : MYSQL
Target Server Version : 50722
File Encoding         : 65001

Date: 2021-04-21 16:44:32
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for contingency_original_data
-- ----------------------------
DROP TABLE IF EXISTS `contingency_original_data`;
CREATE TABLE `contingency_original_data` (
  `id` varchar(36) NOT NULL COMMENT 'rule',
  `fire_Equipment_Name` varchar(32) NOT NULL COMMENT '记录类型：消息MESSAGE，操作OPERATE',
  `fire_Equipment_Id` varchar(500) NOT NULL COMMENT '记录内容：文本信息或者json数据',
  `layer` int(11) NOT NULL COMMENT '一级分类',
  `fire_Equipment_Layer` int(11) NOT NULL COMMENT '二级分类',
  `fire_Equipment_Position` varchar(255) DEFAULT NULL COMMENT '图标,url，或者文件名',
  `equipment_Id` int(11) NOT NULL COMMENT '排序',
  `equipment_Name` varchar(255) DEFAULT NULL,
  `mobile` varchar(255) DEFAULT NULL,
  `admin_Name` varchar(255) DEFAULT NULL,
  `camera_Codes` varchar(255) DEFAULT NULL,
  `camera_Ids` varchar(255) DEFAULT NULL,
  `fire_Count` int(11) DEFAULT NULL,
  `confirm` varchar(255) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(50) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(50) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `batch_No` varchar(36) NOT NULL,
  `picture1` varchar(255) DEFAULT NULL,
  `picture2` varchar(255) DEFAULT NULL,
  `picture4` varchar(255) DEFAULT NULL,
  `picture3` varchar(255) DEFAULT NULL,
  `fire_Truck_Route` varchar(2000) DEFAULT NULL,
  `runstep` bit(1) DEFAULT NULL,
  `step_state` varchar(255) DEFAULT NULL,
  `step` varchar(255) DEFAULT NULL,
  `equipment_position3d` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `INDEX_BATCH_NO` (`batch_No`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='应急预案信息节点定义';

-- ----------------------------
-- Records of contingency_original_data
-- ----------------------------

-- ----------------------------
-- Table structure for contingency_plan
-- ----------------------------
DROP TABLE IF EXISTS `contingency_plan`;
CREATE TABLE `contingency_plan` (
  `id` varchar(36) NOT NULL COMMENT 'rule',
  `record_type` varchar(32) NOT NULL COMMENT '记录类型：消息MESSAGE，操作OPERATE',
  `content` varchar(500) NOT NULL COMMENT '记录内容：文本信息或者json数据',
  `category` varchar(36) NOT NULL COMMENT '一级分类',
  `sub_category` varchar(36) NOT NULL COMMENT '二级分类',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标,url，或者文件名',
  `sort` int(11) NOT NULL COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='应急预案信息节点定义';

-- ----------------------------
-- Records of contingency_plan
-- ----------------------------

-- ----------------------------
-- Table structure for contingency_plan_instance
-- ----------------------------
DROP TABLE IF EXISTS `contingency_plan_instance`;
CREATE TABLE `contingency_plan_instance` (
  `id` varchar(36) NOT NULL COMMENT 'rule',
  `record_type` varchar(32) NOT NULL COMMENT '记录类型：消息MESSAGE，操作OPERATE',
  `category` varchar(36) DEFAULT NULL COMMENT '一级分类',
  `content` varchar(2000) NOT NULL COMMENT '记录内容：文本信息或者json数据',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标,url，或者文件名',
  `sort` int(11) DEFAULT NULL COMMENT '所有节点一起的排序号',
  `sequence_num` int(11) DEFAULT NULL COMMENT '用于显示的序号',
  `batch_no` varchar(36) NOT NULL COMMENT '预案实例编号,暂时无法区分多个火灾，暂时存储报警设备id',
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(50) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(50) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `tips` varchar(255) DEFAULT NULL,
  `runstate` bit(1) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='应急预案执行记录实例';

-- ----------------------------
-- Records of contingency_plan_instance
-- ----------------------------

-- ----------------------------
-- Table structure for co_access_recording
-- ----------------------------
DROP TABLE IF EXISTS `co_access_recording`;
CREATE TABLE `co_access_recording` (
  `id` bigint(20) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `cardholder_avatar` varchar(100) DEFAULT NULL COMMENT '持卡人头像',
  `cardholder_name` varchar(100) DEFAULT NULL COMMENT '持卡人姓名',
  `cardholder_gender` varchar(100) DEFAULT NULL COMMENT '持卡人性别',
  `card_code` varchar(100) DEFAULT NULL COMMENT '卡号',
  `access_number` varchar(100) DEFAULT NULL COMMENT '门禁编号',
  `cardholder_department` varchar(100) DEFAULT NULL COMMENT '所属部门',
  `access_position` varchar(100) DEFAULT NULL COMMENT '门禁位置',
  `cardholder_character` varchar(100) DEFAULT NULL COMMENT '角色',
  `cross_time` varchar(100) DEFAULT NULL COMMENT '开门时间',
  `in_or_out` tinyint(1) DEFAULT NULL COMMENT '进/出，0-进',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='开门记录';

-- ----------------------------
-- Records of co_access_recording
-- ----------------------------

-- ----------------------------
-- Table structure for co_visitor_recording
-- ----------------------------
DROP TABLE IF EXISTS `co_visitor_recording`;
CREATE TABLE `co_visitor_recording` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `recording_code` varchar(100) DEFAULT NULL COMMENT '登记号',
  `visitor_time` datetime NOT NULL COMMENT '来访时间',
  `departure_time` datetime DEFAULT NULL COMMENT '离场时间',
  `visitor_name` varchar(100) NOT NULL COMMENT '访客姓名',
  `phone_number` varchar(100) DEFAULT NULL COMMENT '电话',
  `identity_number` varchar(50) DEFAULT NULL,
  `visitors_number` int(11) DEFAULT NULL,
  `visitor_company` varchar(200) DEFAULT NULL,
  `visit_cause` varchar(1023) DEFAULT NULL COMMENT '来访事由',
  `carrying_goods` varchar(1023) DEFAULT NULL COMMENT '携带物品',
  `car_plate` varchar(20) DEFAULT NULL COMMENT '车牌号',
  `target_department` varchar(100) DEFAULT NULL COMMENT '被访部门',
  `target_department_id` varchar(30) DEFAULT NULL COMMENT '被访部门id',
  `host_name` varchar(50) DEFAULT NULL,
  `deleted` bit(1) DEFAULT b'0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `record_code_idx` (`recording_code`) USING BTREE COMMENT '访问记录唯一索引'
) ENGINE=InnoDB AUTO_INCREMENT=14272 DEFAULT CHARSET=utf8mb4 COMMENT='访客记录';

-- ----------------------------
-- Records of co_visitor_recording
-- ----------------------------

-- ----------------------------
-- Table structure for c_plan_classify_tree
-- ----------------------------
DROP TABLE IF EXISTS `c_plan_classify_tree`;
CREATE TABLE `c_plan_classify_tree` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `classify_name` varchar(255) DEFAULT NULL COMMENT '预案分类名称',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '父类id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `creator` varchar(255) DEFAULT NULL COMMENT '创建人',
  `org_code` varchar(255) DEFAULT NULL COMMENT '组织机构',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='预案分类树';

-- ----------------------------
-- Records of c_plan_classify_tree
-- ----------------------------

-- ----------------------------
-- Table structure for c_plan_detail
-- ----------------------------
DROP TABLE IF EXISTS `c_plan_detail`;
CREATE TABLE `c_plan_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '数字预案ID',
  `plan_name` varchar(255) DEFAULT NULL COMMENT '预案名称',
  `code` varchar(255) DEFAULT NULL COMMENT '预案编号',
  `classify_id` bigint(20) DEFAULT NULL COMMENT '预案类型',
  `plan_range` varchar(255) DEFAULT NULL COMMENT '适用范围',
  `edit_org_name` varchar(255) DEFAULT NULL COMMENT '编写部门',
  `edition` varchar(255) DEFAULT NULL COMMENT '版次',
  `implementation_time` datetime DEFAULT NULL COMMENT '实施时间',
  `create_date` datetime NOT NULL COMMENT '录入时间',
  `remark` text COMMENT '备注',
  `status` int(255) DEFAULT NULL COMMENT '预案状态',
  `creator` varchar(255) DEFAULT NULL COMMENT '创建人',
  `reviser` varchar(255) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `org_code` varchar(255) DEFAULT NULL COMMENT '部门code',
  `is_delete` tinyint(1) DEFAULT '0' COMMENT '删除状态（0、正常，1、删除）',
  `input_time` datetime DEFAULT NULL COMMENT '录入时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='预案详情表';

-- ----------------------------
-- Records of c_plan_detail
-- ----------------------------

-- ----------------------------
-- Table structure for c_plan_doc
-- ----------------------------
DROP TABLE IF EXISTS `c_plan_doc`;
CREATE TABLE `c_plan_doc` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `plan_id` bigint(20) DEFAULT NULL COMMENT '预案ID',
  `doc_id` bigint(20) DEFAULT NULL COMMENT '文档ID',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `is_delete` tinyint(1) DEFAULT NULL COMMENT '删除状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='预案文档关系表';

-- ----------------------------
-- Records of c_plan_doc
-- ----------------------------

-- ----------------------------
-- Table structure for c_plan_equipment
-- ----------------------------
DROP TABLE IF EXISTS `c_plan_equipment`;
CREATE TABLE `c_plan_equipment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `plan_id` bigint(20) DEFAULT NULL COMMENT '预案ID',
  `fire_equipment_id` bigint(20) DEFAULT NULL COMMENT '电力装备ID',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `is_delete` tinyint(1) DEFAULT NULL COMMENT '删除状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='预案电力设备关系表';

-- ----------------------------
-- Records of c_plan_equipment
-- ----------------------------

-- ----------------------------
-- Table structure for c_plan_operation_record
-- ----------------------------
DROP TABLE IF EXISTS `c_plan_operation_record`;
CREATE TABLE `c_plan_operation_record` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `plan_id` bigint(20) DEFAULT NULL COMMENT '预案ID',
  `plan_pattern` tinyint(4) DEFAULT NULL COMMENT '运行模式（4、模拟，5、自动）',
  `status` tinyint(4) DEFAULT NULL COMMENT '运行状态（0、运行中，1、完毕，3、中断）',
  `execution_type` tinyint(4) DEFAULT NULL COMMENT '执行方式（0、预案验证 1、火灾处置）',
  `start_time` datetime DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束时间',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `batch_no` varchar(255) DEFAULT NULL COMMENT '批次号',
  `is_delete` tinyint(1) DEFAULT NULL COMMENT '是否删除',
  `start_user_name` varchar(255) DEFAULT NULL COMMENT '启动人名称',
  `start_user_id` varchar(255) DEFAULT NULL COMMENT '启动人id',
  `equipment_code` varchar(20) DEFAULT NULL COMMENT '装备code',
  `equipment_name` varchar(255) DEFAULT NULL COMMENT '装备名称',
  `equipment_id` bigint(11) DEFAULT NULL COMMENT '装备ID',
  `fire_equipment_id` bigint(255) DEFAULT NULL COMMENT '电力设备ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=134 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='预案运行记录表';

-- ----------------------------
-- Records of c_plan_operation_record
-- ----------------------------

-- ----------------------------
-- Table structure for c_plan_rule
-- ----------------------------
DROP TABLE IF EXISTS `c_plan_rule`;
CREATE TABLE `c_plan_rule` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `rule_id` varchar(32) DEFAULT NULL COMMENT '规则ID',
  `plan_id` bigint(20) DEFAULT NULL COMMENT '预案ID',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `is_delete` tinyint(1) DEFAULT NULL COMMENT '是否删除',
  `rule_name` varchar(100) DEFAULT NULL COMMENT '规则名称',
  `pic_url` varchar(100) DEFAULT NULL COMMENT '规则树形图路径',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of c_plan_rule
-- ----------------------------

-- ----------------------------
-- Table structure for databasechangelog
-- ----------------------------
DROP TABLE IF EXISTS `databasechangelog`;
CREATE TABLE `databasechangelog` (
  `ID` varchar(255) NOT NULL,
  `AUTHOR` varchar(255) NOT NULL,
  `FILENAME` varchar(255) NOT NULL,
  `DATEEXECUTED` datetime NOT NULL,
  `ORDEREXECUTED` int(11) NOT NULL,
  `EXECTYPE` varchar(10) NOT NULL,
  `MD5SUM` varchar(35) DEFAULT NULL,
  `DESCRIPTION` varchar(255) DEFAULT NULL,
  `COMMENTS` varchar(255) DEFAULT NULL,
  `TAG` varchar(255) DEFAULT NULL,
  `LIQUIBASE` varchar(20) DEFAULT NULL,
  `CONTEXTS` varchar(255) DEFAULT NULL,
  `LABELS` varchar(255) DEFAULT NULL,
  `DEPLOYMENT_ID` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of databasechangelog
-- ----------------------------
INSERT INTO `databasechangelog` VALUES ('18292829954-1', 'zjw', 'classpath:/db/changelog/fas-1.0.0.xml', '2020-09-04 14:52:15', '1', 'EXECUTED', '8:f1c19d20c27cc7fbc8e466a55dc770e4', 'sql', 'create f_equipment_manage', null, '3.6.3', null, null, '9202078205');
INSERT INTO `databasechangelog` VALUES ('18292829954-1', 'zjw', 'classpath:/db/changelog/fas-1.0.0.xml', '2020-09-04 14:52:15', '1', 'EXECUTED', '8:f1c19d20c27cc7fbc8e466a55dc770e4', 'sql', 'create f_equipment_manage', null, '3.6.3', null, null, '9202078205');
INSERT INTO `databasechangelog` VALUES ('18292829954-1', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-07 17:50:01', '2', 'MARK_RAN', '8:f1c19d20c27cc7fbc8e466a55dc770e4', 'sql', 'create f_equipment_manage', null, '3.6.3', null, null, '9471978175');
INSERT INTO `databasechangelog` VALUES ('18292829954-2', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-07 17:57:10', '3', 'EXECUTED', '8:7216703f2b424e4798067235538d2444', 'sql', '用于保存同步数据时源数据的ID和code', null, '3.6.3', null, null, '9472406365');
INSERT INTO `databasechangelog` VALUES ('18292829954-3', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-07 17:58:57', '4', 'EXECUTED', '8:11041cac198df0974198dcc5c8938168', 'sql', '用于保存同步数据时源数据的ID和code', null, '3.6.3', null, null, '9472513276');
INSERT INTO `databasechangelog` VALUES ('18292829955-1', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-08 16:45:27', '5', 'EXECUTED', '8:8a466b6829dd9b796e016b116db38c57', 'sql', '源数据表中ID，防止脏数据，添加唯一约束', null, '3.6.3', null, null, '9554501840');
INSERT INTO `databasechangelog` VALUES ('18292829955-2', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-08 16:45:27', '6', 'EXECUTED', '8:63ea0dabef6f704d57afc372b5720b19', 'sql', '源数据表中ID，防止脏数据，添加唯一约束', null, '3.6.3', null, null, '9554501840');
INSERT INTO `databasechangelog` VALUES ('18292829955-3', 'ZeHua Li', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-14 17:31:03', '7', 'EXECUTED', '8:2ec82e58bd4037da8fc789b08f3c4a73', 'sql', '修改视图中报错字段', null, '3.6.3', null, null, '0075632060');
INSERT INTO `databasechangelog` VALUES ('18292829955-4', 'ZeHua Li', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-23 09:24:45', '8', 'EXECUTED', '8:88621e7ff8e4b1e0d894897f08e42474', 'sql', '修改perf_group_code字段长度', null, '3.6.3', null, null, '0824045159');
INSERT INTO `databasechangelog` VALUES ('1602734081064-1', 'suhuiguang', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-15 12:01:52', '9', 'MARK_RAN', '8:745333daa51c53bc346e805f14ee9fc7', 'sql', '对站消防点位风险与组态关系表', null, '3.6.3', null, null, '2734257547');
INSERT INTO `databasechangelog` VALUES ('1603878601-1', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:04:07', '10', 'MARK_RAN', '8:7e9408ee0cdb68f2b02a760d1cf02b84', 'sql', '删除wl_equ_property表索引', null, '3.6.3', null, null, '3886377956');
INSERT INTO `databasechangelog` VALUES ('1603878601-2', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:04:07', '11', 'MARK_RAN', '8:b9fc2940f5882a6056a5211a53bfec7f', 'sql', '删除wl_equ_property表索引', null, '3.6.3', null, null, '3886377956');
INSERT INTO `databasechangelog` VALUES ('1603878601-3', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '12', 'MARK_RAN', '8:37930936cbd7c2aa6d5a2f11ec1fb0e4', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-4', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '13', 'MARK_RAN', '8:b9d54033a57d0fc2ce03d1446769d18f', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-5', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '14', 'MARK_RAN', '8:86d8ad24d9f2920777bebde304b5bae7', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-6', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '15', 'MARK_RAN', '8:9d7ae77b236f50106d182b1f702214ce', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-7', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '16', 'MARK_RAN', '8:e886325e55c7fda31bd7e016316bf36d', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-8', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:05', '17', 'MARK_RAN', '8:aea6ec2c22cdeaf8c0629715c2e05b59', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-9', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:26:42', '23', 'RERAN', '8:e4f5abbcb1e74d6c92273ddee23e344d', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3887730352');
INSERT INTO `databasechangelog` VALUES ('1603878601-10', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '19', 'EXECUTED', '8:5f7c102239747a7a821ef7d2bf98e2af', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1603878601-11', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '20', 'MARK_RAN', '8:9570e307949d4316e2dea4964423d5c2', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1603878601-12', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '21', 'MARK_RAN', '8:805fe24385ec8f380422cebdccfec76a', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1603878601-13', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '22', 'MARK_RAN', '8:1985eda623f83f55a01dd3b75dceee2c', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('18292829954-1', 'zjw', 'classpath:/db/changelog/fas-1.0.0.xml', '2020-09-04 14:52:15', '1', 'EXECUTED', '8:f1c19d20c27cc7fbc8e466a55dc770e4', 'sql', 'create f_equipment_manage', null, '3.6.3', null, null, '9202078205');
INSERT INTO `databasechangelog` VALUES ('18292829954-1', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-07 17:50:01', '2', 'MARK_RAN', '8:f1c19d20c27cc7fbc8e466a55dc770e4', 'sql', 'create f_equipment_manage', null, '3.6.3', null, null, '9471978175');
INSERT INTO `databasechangelog` VALUES ('18292829954-2', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-07 17:57:10', '3', 'EXECUTED', '8:7216703f2b424e4798067235538d2444', 'sql', '用于保存同步数据时源数据的ID和code', null, '3.6.3', null, null, '9472406365');
INSERT INTO `databasechangelog` VALUES ('18292829954-3', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-07 17:58:57', '4', 'EXECUTED', '8:11041cac198df0974198dcc5c8938168', 'sql', '用于保存同步数据时源数据的ID和code', null, '3.6.3', null, null, '9472513276');
INSERT INTO `databasechangelog` VALUES ('18292829955-1', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-08 16:45:27', '5', 'EXECUTED', '8:8a466b6829dd9b796e016b116db38c57', 'sql', '源数据表中ID，防止脏数据，添加唯一约束', null, '3.6.3', null, null, '9554501840');
INSERT INTO `databasechangelog` VALUES ('18292829955-2', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-08 16:45:27', '6', 'EXECUTED', '8:63ea0dabef6f704d57afc372b5720b19', 'sql', '源数据表中ID，防止脏数据，添加唯一约束', null, '3.6.3', null, null, '9554501840');
INSERT INTO `databasechangelog` VALUES ('18292829955-3', 'ZeHua Li', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-14 17:31:03', '7', 'EXECUTED', '8:2ec82e58bd4037da8fc789b08f3c4a73', 'sql', '修改视图中报错字段', null, '3.6.3', null, null, '0075632060');
INSERT INTO `databasechangelog` VALUES ('18292829955-4', 'ZeHua Li', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-23 09:24:45', '8', 'EXECUTED', '8:88621e7ff8e4b1e0d894897f08e42474', 'sql', '修改perf_group_code字段长度', null, '3.6.3', null, null, '0824045159');
INSERT INTO `databasechangelog` VALUES ('1602734081064-1', 'suhuiguang', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-15 12:01:52', '9', 'MARK_RAN', '8:745333daa51c53bc346e805f14ee9fc7', 'sql', '对站消防点位风险与组态关系表', null, '3.6.3', null, null, '2734257547');
INSERT INTO `databasechangelog` VALUES ('1603878601-1', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:04:07', '10', 'MARK_RAN', '8:7e9408ee0cdb68f2b02a760d1cf02b84', 'sql', '删除wl_equ_property表索引', null, '3.6.3', null, null, '3886377956');
INSERT INTO `databasechangelog` VALUES ('1603878601-2', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:04:07', '11', 'MARK_RAN', '8:b9fc2940f5882a6056a5211a53bfec7f', 'sql', '删除wl_equ_property表索引', null, '3.6.3', null, null, '3886377956');
INSERT INTO `databasechangelog` VALUES ('1603878601-3', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '12', 'MARK_RAN', '8:37930936cbd7c2aa6d5a2f11ec1fb0e4', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-4', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '13', 'MARK_RAN', '8:b9d54033a57d0fc2ce03d1446769d18f', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-5', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '14', 'MARK_RAN', '8:86d8ad24d9f2920777bebde304b5bae7', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-6', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '15', 'MARK_RAN', '8:9d7ae77b236f50106d182b1f702214ce', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-7', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '16', 'MARK_RAN', '8:e886325e55c7fda31bd7e016316bf36d', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-8', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:05', '17', 'MARK_RAN', '8:aea6ec2c22cdeaf8c0629715c2e05b59', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-9', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:26:42', '23', 'RERAN', '8:e4f5abbcb1e74d6c92273ddee23e344d', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3887730352');
INSERT INTO `databasechangelog` VALUES ('1603878601-10', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '19', 'EXECUTED', '8:5f7c102239747a7a821ef7d2bf98e2af', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1603878601-11', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '20', 'MARK_RAN', '8:9570e307949d4316e2dea4964423d5c2', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1603878601-12', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '21', 'MARK_RAN', '8:805fe24385ec8f380422cebdccfec76a', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1603878601-13', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '22', 'MARK_RAN', '8:1985eda623f83f55a01dd3b75dceee2c', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1587349916716-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '24', 'MARK_RAN', '8:2669029069a3b68dd508e36fa8abf134', 'sql', 'f_risk_source add column ue4_location', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587349916716-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '25', 'MARK_RAN', '8:44a25694a7a133588b10350bf03fa0d3', 'sql', 'f_risk_source add column ue4_rotation', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587349916716-3', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '26', 'MARK_RAN', '8:e1372233a58586f63fca48c2d2fabe8d', 'sql', 'f_risk_source add column ue4_extent', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587351415717-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '27', 'MARK_RAN', '8:d676539991eb75081b4a853af44b6c36', 'sql', 'f_equipment add column ue4_location', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587351415717-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '28', 'MARK_RAN', '8:abe47d5f7f7a855b68ed77583a2cc86f', 'sql', 'f_equipment add column ue4_rotation', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350445716-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '29', 'MARK_RAN', '8:12f98cea4194a7173e75e3c2bd386d37', 'sql', 'f_fire_car add column ue4_location', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350445716-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '30', 'MARK_RAN', '8:7e1757b35d092394e57dc69d8f89c53b', 'sql', 'f_fire_car add column ue4_rotation', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350552716-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '31', 'MARK_RAN', '8:465ecf308b0595f3ae875f250c484801', 'sql', 'f_fire_equipment add column ue4_location', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350552716-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:47', '32', 'MARK_RAN', '8:2298e8df7dd1cb70dc8455466e77c748', 'sql', 'f_fire_equipment add column ue4_rotation', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350593716-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:47', '33', 'MARK_RAN', '8:aaa60383619262ccd4a6e686d957eca9', 'sql', 'f_fire_station add column ue4_location', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350593716-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:47', '34', 'MARK_RAN', '8:37000e0c28f283c3c828de020fbd88b5', 'sql', 'f_fire_station add column ue4_rotation', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350759717-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:47', '35', 'MARK_RAN', '8:aff50ecdd58ec8964ae2d05667f33f6a', 'sql', 'f_water_resource add column ue4_location', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350759717-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:47', '36', 'MARK_RAN', '8:99c55eb0b48ab9af131f70d2d9f135dc', 'sql', 'f_water_resource add column ue4_rotation', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350860716-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:47', '37', 'MARK_RAN', '8:173309ce0e26811ed9f8002810164006', 'sql', 'create f_safety_index_change_log', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('0001', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-03 11:21:22', '38', 'MARK_RAN', '8:361a6342742209330e493b13d908364b', 'sql', 'create te_training_result', null, '3.6.3', null, null, '4373405268');
INSERT INTO `databasechangelog` VALUES ('0002', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-03 11:21:22', '39', 'MARK_RAN', '8:3816f69377b924a9f9aa7bd49127b5d4', 'sql', 'create te_training_subjects', null, '3.6.3', null, null, '4373405268');
INSERT INTO `databasechangelog` VALUES ('0003', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-03 11:21:22', '40', 'MARK_RAN', '8:5582db6cd4966f44ff371d650ac2558f', 'sql', 'create te_training_subjects_result', null, '3.6.3', null, null, '4373405268');
INSERT INTO `databasechangelog` VALUES ('0004', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-03 11:21:22', '41', 'MARK_RAN', '8:1ae6b15389cad8d0b078fa52da838c48', 'sql', 'create rpm_person', null, '3.6.3', null, null, '4373405268');
INSERT INTO `databasechangelog` VALUES ('0007', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-03 11:21:34', '42', 'EXECUTED', '8:4181e55856630cbc7e8b827a8b02b392', 'sqlFile', 'init data', null, '3.6.3', null, null, '4373405268');
INSERT INTO `databasechangelog` VALUES ('1587882668719-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:01', '43', 'MARK_RAN', '8:2118becfb5e533e049231ad23676c217', 'createIndex indexName=idx_type, tableName=f_fire_station', '', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1588067351000-1', 'shanqiyun', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:01', '44', 'MARK_RAN', '8:c0b9698c6b1bbe4086b6a0d1174ccde3', 'sql', 'f_risk_source add column route_path', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1588140925893-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:01', '45', 'MARK_RAN', '8:4f234df6f2f6fe23246e698265af1533', 'sql', 'f_safety_index_change_log add column create_date', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1588990926789-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:02', '46', 'MARK_RAN', '8:961301c7fc6234342a4f2d982d528ed5', 'sql', 'f_risk_level add column manage_level 管控级别', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1589165258908-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:02', '47', 'MARK_RAN', '8:fbc7bfb013e9058794e093853c9a008d', 'sql', 'f_rpn_change_log add column trigger_type 触发类型', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1589165258908-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:02', '48', 'MARK_RAN', '8:1b86f6920879b3959e82b15c39ed22f2', 'sql', 'f_risk_source add column flicker_frequency 闪烁频率', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1589444792914-1', 'maoying', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:02', '49', 'EXECUTED', '8:662c949630633790805455b730439d51', 'sql', 'create table f_alarm', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1589444792916-1', 'zhouyi', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '50', 'EXECUTED', '8:317e00f0a9371dfcfad32e7f660884f1', 'sql', 'create table f_station_info', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1589769364577-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '51', 'EXECUTED', '8:971031572a60dbd3d11573ed952f468d', 'sql', 'f_risk_level 增加管控级别 初始化数据', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('11590390304001-1', 'maoying', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '52', 'EXECUTED', '8:bd161b4fa41e702fd9ccbe17e4b55921', 'sql', '修改fire_equipment_id可为空', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1591672147780-1', 'shanqiyun', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '53', 'EXECUTED', '8:b9804e67b6f2ffa576add4772ef44619', 'sql', 'create view toip_biz_message', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1593309428780-1', 'shanqiyun', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '54', 'MARK_RAN', '8:0bd96572033a1429f99624a83c4d1830', 'sql', 'create table contingency_original_data', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1593309428780-2', 'shanqiyun', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '55', 'MARK_RAN', '8:dd499efb094231e964678972c5be6a76', 'sql', 'create table contingency_plan', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1593309428780-3', 'shanqiyun', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '56', 'MARK_RAN', '8:4cb59cdc0cb5eedf8649bffae1a6a255', 'sql', 'create table contingency_plan_instance', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1561454393000-1', 'suhg', 'classpath:/db/changelog/fas-sql-task.xml', '2020-11-03 12:04:03', '57', 'EXECUTED', '8:8a1e7d1404a1b18afa384d2c9142189f', 'sql', 'update f_fmea_equipment_point 更新触发器创建', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1561454393000-2', 'suhg', 'classpath:/db/changelog/fas-sql-task.xml', '2020-11-03 12:04:03', '58', 'EXECUTED', '8:c7d50ea1c4b704d6168aa33d341daa93', 'sql', 'f_risk_source_point_inputitem  更新触发器创建', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1561717770000-1', 'tianbo', 'classpath:/db/changelog/fas-sql-task.xml', '2020-11-03 12:04:03', '59', 'EXECUTED', '8:78ebd22321cd9e8991566ce2f2e25837', 'sql', 'f_fire_equipment_point_update 触发器创建(修改判断条件为->value等于\'true\')', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1588901126338-1', 'shanqiyun', 'classpath:/db/changelog/fas-sql-task.xml', '2020-11-03 12:04:03', '60', 'EXECUTED', '8:1201d1531bd5235267b90b7424ac9bfb', 'sql', 'f_risk_source 查询所有子节点id', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1589954524000-1', 'maoying', 'classpath:/db/changelog/fas-sql-task.xml', '2020-11-03 12:04:04', '61', 'EXECUTED', '8:8d78b9fc0529776dbc5c8dc92bdc14f9', 'sql', 'updatePointConfig 触发器创建', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1597831211780-1', 'shanqiyun', 'classpath:/db/changelog/fas-sql-task.xml', '2020-11-03 12:04:04', '62', 'EXECUTED', '8:b0c68b6f304aa98e4466eef0d6d3239f', 'sql', 'create view toip_biz_message', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1604458366-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-04 10:58:16', '63', 'EXECUTED', '8:281fed82144b67a1d69472547fe56669', 'sqlFile', 'init data', null, '3.6.3', null, null, '4458412097');
INSERT INTO `databasechangelog` VALUES ('1587882668717-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-06 09:29:46', '64', 'EXECUTED', '8:2118becfb5e533e049231ad23676c217', 'createIndex indexName=idx_type, tableName=f_fire_station', '', null, '3.6.3', null, null, '4625199529');
INSERT INTO `databasechangelog` VALUES ('1604885488-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-09 10:28:16', '65', 'EXECUTED', '8:221b8e76de41490cda07947d3b0ceb85', 'sqlFile', 'init data', null, '3.6.3', null, null, '4888606789');
INSERT INTO `databasechangelog` VALUES ('1587367587716-1', 'suhuiguang', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '66', 'MARK_RAN', '8:d562d1c871f7cab400c7a3c31ccbfd16', 'sql', 'p_point add column ue4_rotation', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1587367889717-1', 'suhuiguang', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '67', 'MARK_RAN', '8:12bc3c268cc3b3d3ffc0ba1a543227e3', 'sql', 'p_point add column ue4_location', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1590476067001-1', 'maoying', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '68', 'MARK_RAN', '8:16c7282e662ade79555284b16f66952d', 'sql', 'p_task add column dep_id', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1587367889717-2', 'suhuiguang', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '69', 'MARK_RAN', '8:7501e769788d582aaab6fbf819c5c50b', 'sql', 'p_point', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1587367889717-3', 'suhuiguang', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '70', 'MARK_RAN', '8:a0e8b17d5709e165e267e58416706ff8', 'sql', 'p_point', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1591336116001-1', 'maoying', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '71', 'EXECUTED', '8:7d2766d6a5bcfed3070598261c9507ac', 'sql', 'p_plan_task MODIFY user_id', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1590476067003-1', 'zhouyi', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '72', 'MARK_RAN', '8:3eb44ab5fbae0cb360ef8f7ad9939b40', 'sql', 'p_plan add column user_dept', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1590476067004-1', 'zhouyi', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:30', '73', 'MARK_RAN', '8:1d19f2026a595a8c7d638a6eda0111f9', 'sql', 'p_plan_task add column user_dept', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1550832246000-1', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:30', '74', 'EXECUTED', '8:eedd1212da42d4b25f8fe4ec3672f2e1', 'createView viewName=v_msg_subscribe_check', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1553233487000-1', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:30', '75', 'EXECUTED', '8:080e589266355f71f31da9ccde71325d', 'createView viewName=vcheck', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1554111363112-2', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:30', '76', 'EXECUTED', '8:088881491e42558fea38730655b342d9', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1554111363112-3', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:30', '77', 'EXECUTED', '8:5bdee6c228dac400069e47d3d66d8130', 'sql', 'check_update 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1554111363112-7', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:31', '78', 'EXECUTED', '8:73eb4d154a3eac067ef69f122aa7ec0f', 'sql', 'plan_task_detail_insert 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1554190356000-1', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:31', '79', 'EXECUTED', '8:659436a2f3de94d9be4672826e09ea0a', 'createView viewName=v_point_last_check', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1554691494000-1', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:31', '80', 'EXECUTED', '8:24f34162531d41ee0eb0ca5f064cc60e', 'createView viewName=v_check_info', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1561097898000-1', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:31', '81', 'EXECUTED', '8:3a7948a02892f1356674d08f1f29e61d', 'sql', 'p_point_classify_delete 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1561355156000-1', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:31', '82', 'EXECUTED', '8:391e7a36a11722960d8f80bf92eca76c', 'sql', 'trigger_route_point_insert_update_point_route_info 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1561355156000-2', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:32', '83', 'EXECUTED', '8:652db0fa41a24b794da5501fc0c669bf', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1561355156000-3', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:32', '84', 'EXECUTED', '8:aff5eff2e525843fec5aa974e4670180', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('15640410855-2', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:32', '85', 'EXECUTED', '8:3e4be42ae49cc95fa5f2525577195b25', 'createProcedure procedureName=updatePlanTask', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('15640410888-3', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:32', '86', 'EXECUTED', '8:b68a12af990646631e647ef323e1c903', 'createProcedure procedureName=planTaskStatistics', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('15640410855-4', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:32', '87', 'EXECUTED', '8:ee0d716d5e29ac9f2eac8a050390b9bc', 'createProcedure procedureName=everyDayInitPlanTaskStatistics', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('15640410855000-5', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:03', '29114', 'RERAN', '8:834113f804109e5c1178893fba4aa2f4', 'sql', '', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1571298391000-1', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:33', '89', 'EXECUTED', '8:d13ae4f7f58f7ee19f3bf5b786f12f5d', 'sql', 'addPointConfig 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1571298391000-2', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:33', '90', 'EXECUTED', '8:821396c69666371df4d67ac4330f769c', 'sql', 'deletePointConfig 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1604885489-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-11 14:36:13', '96', 'EXECUTED', '8:b82abb71d09e07d5318dc1bb4c187baa', 'sqlFile', 'init data', null, '3.6.3', null, null, '5076279162');
INSERT INTO `databasechangelog` VALUES ('1604885490-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-11 17:20:53', '97', 'EXECUTED', '8:08b9e4a9ea54148546be62606d82c42b', 'sqlFile', 'init data', null, '3.6.3', null, null, '5086159526');
INSERT INTO `databasechangelog` VALUES ('1604454486-1', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-13 11:34:46', '98', 'MARK_RAN', '8:871b6139b018a5260694ffc1df2ae4a5', 'sql', '修改wl_equipment_specific表结构', null, '3.6.3', null, null, '5238198822');
INSERT INTO `databasechangelog` VALUES ('1604454486-2', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-13 11:34:47', '99', 'EXECUTED', '8:fe1efe4f61358d41d150e4ba37315b77', 'sql', '修改wl_equipment_specific_alarm表结构', null, '3.6.3', null, null, '5238198822');
INSERT INTO `databasechangelog` VALUES ('1604454486-3', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-13 11:34:47', '100', 'MARK_RAN', '8:1d0b81ca41e0fe6b4084551eb7119931', 'sql', '修改wl_car表结构', null, '3.6.3', null, null, '5238198822');
INSERT INTO `databasechangelog` VALUES ('1604454486-4', 'lizehua', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-18 10:58:48', '101', 'MARK_RAN', '8:5b623ab730b26da1b5b915e5f9756390', 'sql', '新增视频表以及关联表', null, '3.6.3', null, null, '5668034842');
INSERT INTO `databasechangelog` VALUES ('1605699890-1', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-19 11:09:14', '102', 'EXECUTED', '8:126c7b407f203f82808445c4476fbc24', 'sql', '修改wl_warehouse_structure表结构', null, '3.6.3', null, null, '5755057392');
INSERT INTO `databasechangelog` VALUES ('1605924681-1', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-21 10:45:47', '103', 'MARK_RAN', '8:1118e8f89be6379e00e19b4c39494200', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '5926450722');
INSERT INTO `databasechangelog` VALUES ('1605924681-2', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-21 10:45:47', '104', 'MARK_RAN', '8:52805ba4751ba783b42f20742fde1439', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '5926450722');
INSERT INTO `databasechangelog` VALUES ('1605924681-3', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-21 10:45:48', '105', 'MARK_RAN', '8:ef0c99d09e632e37d5c40577c5f55006', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '5926450722');
INSERT INTO `databasechangelog` VALUES ('1605951015-1', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-21 17:42:48', '107', 'EXECUTED', '8:4da86f734775f4c0d01a447b6fca0b21', 'sql', '修改wl_unit表结构', null, '3.6.3', null, null, '5950762652');
INSERT INTO `databasechangelog` VALUES ('1605951015-2', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-21 17:42:48', '108', 'EXECUTED', '8:99fc5b13b1ac1f75246653cc8a22adcc', 'sql', '修改wl_unit表结构', null, '3.6.3', null, null, '5950762652');
INSERT INTO `databasechangelog` VALUES ('1606216645-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-24 19:34:55', '136', 'EXECUTED', '8:fa4bce117855909e4bb296804dfa8fc8', 'sqlFile', 'init data', null, '3.6.3', null, null, '6217379107');
INSERT INTO `databasechangelog` VALUES ('1606290088-1', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-25 16:01:31', '155', 'MARK_RAN', '8:92f3488738e11ae7a8e3d13b36d9a37f', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '6290989552');
INSERT INTO `databasechangelog` VALUES ('1606290088-2', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-25 16:01:31', '156', 'MARK_RAN', '8:2a45a641a68edaa7ac002ed9cd444e79', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '6290989552');
INSERT INTO `databasechangelog` VALUES ('1606290088-3', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-25 16:01:31', '157', 'MARK_RAN', '8:734fe567933d74003a2eb69898222a3b', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '6290989552');
INSERT INTO `databasechangelog` VALUES ('1606296980-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-25 17:42:18', '158', 'EXECUTED', '8:81bc252beebce8ffaa8ed599dcb80faa', 'sqlFile', 'init data', null, '3.6.3', null, null, '6296997095');
INSERT INTO `databasechangelog` VALUES ('1606297588-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-25 17:52:11', '159', 'EXECUTED', '8:d1c079bc2ec2681323aa321907344bdf', 'sqlFile', 'init data', null, '3.6.3', null, null, '6297613839');
INSERT INTO `databasechangelog` VALUES ('1606385812-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-26 18:22:34', '160', 'EXECUTED', '8:7ba442d129ba93583858e01c0cfc56e5', 'sqlFile', 'init data', null, '3.6.3', null, null, '6385839971');
INSERT INTO `databasechangelog` VALUES ('1550832246001-1', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:01', '29090', 'RERAN', '8:eedd1212da42d4b25f8fe4ec3672f2e1', 'createView viewName=v_msg_subscribe_check', '', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1553233487001-1', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:01', '29091', 'RERAN', '8:080e589266355f71f31da9ccde71325d', 'createView viewName=vcheck', '', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1554111363113-2', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:48', '5327', 'RERAN', '8:088881491e42558fea38730655b342d9', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1554111363113-3', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:48', '5328', 'RERAN', '8:5bdee6c228dac400069e47d3d66d8130', 'sql', 'check_update 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1554111363113-7', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:49', '5329', 'RERAN', '8:73eb4d154a3eac067ef69f122aa7ec0f', 'sql', 'plan_task_detail_insert 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1554190356001-1', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:02', '29098', 'RERAN', '8:659436a2f3de94d9be4672826e09ea0a', 'createView viewName=v_point_last_check', '', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1554691494001-1', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:02', '29099', 'RERAN', '8:24f34162531d41ee0eb0ca5f064cc60e', 'createView viewName=v_check_info', '', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1561097898001-1', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:50', '5332', 'RERAN', '8:3a7948a02892f1356674d08f1f29e61d', 'sql', 'p_point_classify_delete 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1561355156001-1', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:50', '5333', 'RERAN', '8:391e7a36a11722960d8f80bf92eca76c', 'sql', 'trigger_route_point_insert_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1561355156001-2', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:51', '5334', 'RERAN', '8:652db0fa41a24b794da5501fc0c669bf', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1561355156001-3', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:51', '5335', 'RERAN', '8:aff5eff2e525843fec5aa974e4670180', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('15640410856-2', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:51', '5336', 'RERAN', '8:3e4be42ae49cc95fa5f2525577195b25', 'createProcedure procedureName=updatePlanTask', '', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('15640410889-3', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:52', '5337', 'RERAN', '8:b68a12af990646631e647ef323e1c903', 'createProcedure procedureName=planTaskStatistics', '', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('15640410856-4', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:52', '5338', 'RERAN', '8:ee0d716d5e29ac9f2eac8a050390b9bc', 'createProcedure procedureName=everyDayInitPlanTaskStatistics', '', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1571298391001-1', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:52', '5340', 'RERAN', '8:d13ae4f7f58f7ee19f3bf5b786f12f5d', 'sql', 'addPointConfig 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1571298391001-2', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:53', '5341', 'RERAN', '8:821396c69666371df4d67ac4330f769c', 'sql', 'deletePointConfig 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1607398689-1', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-09 11:35:07', '428', 'RERAN', '8:bc1712261a89f5aa2a0b9d963a3d9321', 'sql', '由于组态组件不支持复杂SQL语句业务因此添加此视图', null, '3.6.3', null, null, '7484586615');
INSERT INTO `databasechangelog` VALUES ('1607432736-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-08 21:18:10', '405', 'EXECUTED', '8:17cd05c5245e24dda20ceb9cac0ce718', 'sqlFile', 'init data', null, '3.6.3', null, null, '7433162685');
INSERT INTO `databasechangelog` VALUES ('1607432736-6', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-08 21:34:30', '406', 'MARK_RAN', '8:8d661b675b62bfe90ec20d24ae8014e2', 'sql', 'create st_study_plan', null, '3.6.3', null, null, '7434149207');
INSERT INTO `databasechangelog` VALUES ('1607432736-7', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-08 21:34:30', '407', 'MARK_RAN', '8:13722199a3df43c8cd247a5850449633', 'sql', 'create st_plan_user', null, '3.6.3', null, null, '7434149207');
INSERT INTO `databasechangelog` VALUES ('1607432736-8', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-08 21:34:30', '408', 'MARK_RAN', '8:b4e838bed302d4c1ec1cad89f6296459', 'sql', 'create st_plan_user_resource', null, '3.6.3', null, null, '7434149207');
INSERT INTO `databasechangelog` VALUES ('1607432736-9', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-08 21:34:30', '409', 'MARK_RAN', '8:c0a35d9ecfa8d7a5cae8310e6476ee92', 'sql', 'create st_plan_resource', null, '3.6.3', null, null, '7434149207');
INSERT INTO `databasechangelog` VALUES ('160595101501-1', 'maoying', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-09 10:44:09', '427', 'EXECUTED', '8:e67ef9e9d89c5b5f914413567e2f89e4', 'sql', '修改wl_car_property表value类型', null, '3.6.3', null, null, '7481528102');
INSERT INTO `databasechangelog` VALUES ('18292829954-1', 'zjw', 'classpath:/changelog/equipment-1.0.1.xml', '2020-12-10 11:52:44', '463', 'MARK_RAN', '8:f1c19d20c27cc7fbc8e466a55dc770e4', 'sql', 'create f_equipment_manage', null, '3.6.3', null, null, '7572041297');
INSERT INTO `databasechangelog` VALUES ('1607398689001-1', 'keyong', 'classpath:/changelog/sql-task.xml', '2021-04-21 15:40:57', '28999', 'RERAN', '8:9365b747b84987dd483864df66023a5b', 'sql', '由于组态组件不支持复杂SQL语句业务因此添加此视图', null, '3.6.3', null, null, '8990853834');
INSERT INTO `databasechangelog` VALUES ('1331790995458-1', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-11 11:53:39', '500', 'EXECUTED', '8:532ae5af8b0c387a809c9c000bb272d4', 'sql', 'create wl_common_tree', null, '3.6.3', null, null, '7658495793');
INSERT INTO `databasechangelog` VALUES ('1331790995458-2', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-11 11:53:40', '501', 'EXECUTED', '8:6cbf8d23778ccd8e8d3548a003d80bbe', 'sqlFile', 'init common_tree data', null, '3.6.3', null, null, '7658495793');
INSERT INTO `databasechangelog` VALUES ('1301232323152', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-15 21:48:17', '502', 'EXECUTED', '8:f3da3aed5c861ec6d136ea9cbf5b8ea7', 'sql', 'wl_equipment_specific_index 添加字段 update_date', null, '3.6.3', null, null, '8039763001');
INSERT INTO `databasechangelog` VALUES ('160595101501-2', 'maoying', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-15 21:48:17', '503', 'EXECUTED', '8:e55874b08983dc8e42a28e2f58bb73dd', 'sql', '修改wl_equipment_specific_index表update_date类型', null, '3.6.3', null, null, '8039763001');
INSERT INTO `databasechangelog` VALUES ('1605951015-3', 'lizehua', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-15 21:48:17', '504', 'MARK_RAN', '8:5606feefc4335fd8b11af09317f0d987', 'sql', '单据增加创建人名字段', null, '3.6.3', null, null, '8039763001');
INSERT INTO `databasechangelog` VALUES ('1301417995522152', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-15 21:48:18', '505', 'EXECUTED', '8:c28f6f26ce90b0d16524f73158bf6cf0', 'sql', '修改f_equipment_manage库名称tof_fire_fighting_system', null, '3.6.3', null, null, '8039763001');
INSERT INTO `databasechangelog` VALUES ('158890112635601-1', 'maoying', 'classpath:/changelog/sql-task.xml', '2021-04-21 15:40:57', '29001', 'RERAN', '8:ff480802d3c2ecc2f59df7e9a9490f3f', 'sql', '', null, '3.6.3', null, null, '8990853834');
INSERT INTO `databasechangelog` VALUES ('158890112635601-2', 'maoying', 'classpath:/changelog/sql-task.xml', '2020-12-24 20:59:58', '3374', 'RERAN', '8:60f2cfb647581119425b1da8982c09e2', 'sql', '', null, '3.6.3', null, null, '8814457163');
INSERT INTO `databasechangelog` VALUES ('1301443434322152', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-16 13:50:30', '530', 'EXECUTED', '8:d0f4ada9b1829a6dd0b44107fb2dc588', 'sql', '修改f_fire_fighting_system 表字段', null, '3.6.3', null, null, '8097498013');
INSERT INTO `databasechangelog` VALUES ('130454545454322152', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-16 17:23:13', '555', 'EXECUTED', '8:6e2439bd33ef43219b6c77a449403cf2', 'sql', '修改f_fire_fighting_system 表字段', null, '3.6.3', null, null, '8110261970');
INSERT INTO `databasechangelog` VALUES ('1304541343432225488', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-17 12:07:26', '712', 'EXECUTED', '8:c0c00539265e9229f18e3cccbe6462da', 'sql', '修改f_fire_fighting_system所有字段', null, '3.6.3', null, null, '8177713476');
INSERT INTO `databasechangelog` VALUES ('158890112635602-2', 'maoying', 'classpath:/changelog/sql-task.xml', '2021-04-21 15:40:57', '29002', 'RERAN', '8:b9fe9ddd3f8eb626c288a794b246dbca', 'sql', '', null, '3.6.3', null, null, '8990853834');
INSERT INTO `databasechangelog` VALUES ('1608798196836-1', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-24 17:04:41', '3289', 'EXECUTED', '8:f7a4615f71573e2c0fe087a9fefad6e6', 'sql', 'create 建筑分组表 wl_form_group 建筑模块使用', null, '3.6.3', null, null, '8800340296');
INSERT INTO `databasechangelog` VALUES ('1608798196836-2', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-24 17:04:41', '3290', 'EXECUTED', '8:72f68928e8ff60770d5eca16ae4f1adf', 'sql', 'create 分组字段表 wl_form_group_column 建筑模块使用', null, '3.6.3', null, null, '8800340296');
INSERT INTO `databasechangelog` VALUES ('1608798196836-3', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-24 17:04:41', '3291', 'EXECUTED', '8:771f8625169b17cf927f12e19ab44b08', 'sql', 'create 实例表 wl_form_instance 建筑模块使用', null, '3.6.3', null, null, '8800340296');
INSERT INTO `databasechangelog` VALUES ('1608798196836-4', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-24 17:04:42', '3292', 'EXECUTED', '8:7416889f99af9ef6eb2ca3fbc324d5b6', 'sql', 'create 资源与文件关联关系表 wl_source_file 建筑模块使用', null, '3.6.3', null, null, '8800340296');
INSERT INTO `databasechangelog` VALUES ('1608798196836-5', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-24 17:04:42', '3293', 'EXECUTED', '8:ca659ad4827cc49bf0347035f1f50b7d', 'sql', 'create 资源与场景关联关系表 wl_source_scene 建筑模块使用', null, '3.6.3', null, null, '8800340296');
INSERT INTO `databasechangelog` VALUES ('1608798196836-6', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-24 17:04:43', '3294', 'EXECUTED', '8:a56ddf1bae0053246d7a28967d1852b2', 'sqlFile', '初始话表单数据', null, '3.6.3', null, null, '8800340296');
INSERT INTO `databasechangelog` VALUES ('1608279637-1', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-12-29 15:36:13', '3776', 'EXECUTED', '8:d59e07fac5bc1c598cdcc40da4c7f14f', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '9227384840');
INSERT INTO `databasechangelog` VALUES ('1608279637-2', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-12-29 15:36:14', '3777', 'EXECUTED', '8:24e2b67057a0b1aed2d4dce6c2cb1171', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '9227384840');
INSERT INTO `databasechangelog` VALUES ('1608279637-3', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-12-29 15:36:14', '3778', 'EXECUTED', '8:df0905e25800b630bf9faebf0eb580ce', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '9227384840');
INSERT INTO `databasechangelog` VALUES ('1609226808866-1', 'shg', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-12-29 15:36:14', '3779', 'EXECUTED', '8:5283d1dfc0122e597b1fe2ba716bdb35', 'sql', 'f_risk_source add column source_id', null, '3.6.3', null, null, '9227384840');
INSERT INTO `databasechangelog` VALUES ('1561717770001-1', 'tianbo', 'classpath:/db/changelog/fas-sql-task.xml', '2021-01-11 15:12:58', '5254', 'RERAN', '8:78ebd22321cd9e8991566ce2f2e25837', 'sql', 'f_fire_equipment_point_update 触发器创建(修改判断条件为->value等于\'true\')', null, '3.6.3', null, null, '0349186328');
INSERT INTO `databasechangelog` VALUES ('1597831211781-1', 'shanqiyun', 'classpath:/db/changelog/fas-sql-task.xml', '2021-04-15 20:27:38', '26218', 'RERAN', '8:b0c68b6f304aa98e4466eef0d6d3239f', 'sql', 'create view toip_biz_message', null, '3.6.3', null, null, '8489657072');
INSERT INTO `databasechangelog` VALUES ('12323232456565', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-29 21:51:18', '3978', 'EXECUTED', '8:88fba02bd0a02878c00e4a39a79749eb', 'sql', '添加 wl_equipment_system_source_statistics', null, '3.6.3', null, null, '9249890494');
INSERT INTO `databasechangelog` VALUES ('1609226808866-2', 'shg', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-12-30 10:00:33', '4057', 'EXECUTED', '8:f4775fe284225ffbda5bab19a1971e76', 'sql', 'f_risk_source add UNIQUE source_id', null, '3.6.3', null, null, '9293633597');
INSERT INTO `databasechangelog` VALUES ('23123123231-1', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-31 09:43:53', '4326', 'EXECUTED', '8:bfc3f515485abff3e619be2e41b30d72', 'sql', '修改wl_car_property表value类型', null, '3.6.3', null, null, '9379033051');
INSERT INTO `databasechangelog` VALUES ('32323443543-1', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-31 09:43:53', '4327', 'MARK_RAN', '8:0f699520d2fa33b1b82bf8b2a21d028f', 'sql', '修改wl_car_property表value类型', null, '3.6.3', null, null, '9379033051');
INSERT INTO `databasechangelog` VALUES ('20210104-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:11', '4398', 'EXECUTED', '8:a9af669c8c15178480ff2815ddfa4f8a', 'sql', '修改wl_wastage_bill_detail 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-02', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4399', 'EXECUTED', '8:447e3d641b34b66e8f2f62b82dae9f0f', 'sql', '修改wl_wastage_bill 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-03', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4400', 'EXECUTED', '8:73bf1a7ef1960a82bb2affd17cfc2a81', 'sql', '修改wl_upload_file 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-04', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4401', 'EXECUTED', '8:dcf7ddcaf60a1cf3bd6c8ae4f0187535', 'sql', '修改wl_stock_detail 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-05', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4402', 'EXECUTED', '8:5aa2ef256cf85da922c001d46a033797', 'sql', '修改wl_stock_bill_detail 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-06', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4403', 'EXECUTED', '8:3dc054bd5487ca62fd363f85109ebcaa', 'sql', '修改wl_stock_bill 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-07', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4404', 'EXECUTED', '8:fb251da9d59fc718b6f4f3f21782ca89', 'sql', '修改wl_scrap_detail 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-08', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4405', 'EXECUTED', '8:3ddc38465c17d0828ea79fcf49f606fa', 'sql', '修改wl_scrap 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-09', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4406', 'EXECUTED', '8:289ef82ecc8b0dd55ea2200fabdfa4c0', 'sql', '修改wl_risk_source_scene 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-10', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4407', 'EXECUTED', '8:2be03ced1c7667f2b6c6314971eacc6f', 'sql', '修改wl_repair_detail 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-11', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:13', '4408', 'EXECUTED', '8:c2a903038c8f0e7dfe73ad99458c5541', 'sql', '修改wl_perf_quota_definition 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-12', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:13', '4409', 'EXECUTED', '8:e011fc29867303a547c767ae5ee032eb', 'sql', '修改wl_perf_quota 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-13', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:13', '4410', 'EXECUTED', '8:ce5999a1e5133f42e858fe26ceceff04', 'sql', '修改wl_notice 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-14', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:13', '4411', 'EXECUTED', '8:6cdf6a4d4ada84f184daf521700ea38a', 'sql', '修改wl_manufacturer_info 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-15', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:13', '4412', 'EXECUTED', '8:687ccc3d013568261bb538d40d977fe7', 'sql', '修改wl_journal 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-16', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:13', '4413', 'EXECUTED', '8:0eb2c1dda85bd9ff800c39e465b1269b', 'sql', '修改wl_extinguishant_on_car 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-17', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:14', '4414', 'EXECUTED', '8:f157c27d8f38a5c6ec25c0ce3766c087', 'sql', '修改wl_equipment_system_source_statistics 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('1609233028-9', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-05 16:45:20', '4569', 'EXECUTED', '8:e377324cc2961fc1d5fc565c83dd598c', 'sql', '用于保存考试记录评定结果', null, '3.6.3', null, null, '9836320026');
INSERT INTO `databasechangelog` VALUES ('1562323293001-1', 'suhg', 'classpath:/db/changelog/fas-sql-task.xml', '2021-01-05 17:03:19', '4571', 'RERAN', '8:e1ec28aedfe863fcbdadbaffb49acc19', 'sql', 'update f_fmea_equipment_point 更新触发器创建', null, '3.6.3', null, null, '9837411069');
INSERT INTO `databasechangelog` VALUES ('152323223001-1', 'suhg', 'classpath:/db/changelog/fas-sql-task.xml', '2021-01-05 17:03:19', '4572', 'EXECUTED', '8:b3206a1fc3cd7bd5c0460f07be7ce0b0', 'sql', 'update f_fmea_equipment_point 更新触发器创建', null, '3.6.3', null, null, '9837411069');
INSERT INTO `databasechangelog` VALUES ('20210104-18', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4812', 'EXECUTED', '8:57e63129b587d0c8d2ab01d793d4b9e0', 'sql', '修改wl_equipmentdef_qrcode 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-19', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4813', 'EXECUTED', '8:1d8c2fc06ff3dbfdc16568068e230635', 'sql', '修改wl_equipment_specific_index 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-20', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4814', 'EXECUTED', '8:a3a8ff9c00594d9f6f0f6ac26191b7d6', 'sql', '修改wl_equipment_qrcode 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-21', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4815', 'EXECUTED', '8:93bbc0d36ebb6bf89ce4f3375cecc684', 'sql', '修改wl_equipment_point 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-22', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4816', 'EXECUTED', '8:6bffa2de355a8cd0adf933f8e8ac294a', 'sql', '修改wl_equipment_on_car 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-23', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4817', 'EXECUTED', '8:4aaf292541ebf698f469f4be17400a45', 'sql', '修改wl_equipment_index 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-24', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4818', 'EXECUTED', '8:cef529ec5fb154f3bb767013467596fe', 'sql', '修改wl_equipment 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-25', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4819', 'EXECUTED', '8:8e26c28080d337b309a2e68583215c6d', 'sql', '修改wl_equ_property 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-26', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4820', 'EXECUTED', '8:cf758852aa7ec1634861b23c1626d047', 'sql', '修改wl_car_property 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-27', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4821', 'EXECUTED', '8:a3cc4d7baebf078c12c8537582d18393', 'sql', '修改wl_car_liquid_level 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210106-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:24', '4822', 'EXECUTED', '8:e17aeb73a39741a5a70401737dba5d87', 'sql', '修改wl_source_scene', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('1610006738717-1', 'shg', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 16:11:54', '4839', 'EXECUTED', '8:a99a7724575ff31ebdf7a20c55b2ba53', 'sql', 'wl_warehouse_structure code字段长度加长', null, '3.6.3', null, null, '0007116754');
INSERT INTO `databasechangelog` VALUES ('20210107-01', 'tiantao', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 16:13:26', '4848', 'MARK_RAN', '8:67626c7eb843c547f97840b404f6cc84', 'sql', '修改wl_equipment', null, '3.6.3', null, null, '0007209576');
INSERT INTO `databasechangelog` VALUES ('20210107-02', 'tiantao', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 16:13:26', '4849', 'MARK_RAN', '8:e388be490e7a537939222ed548833f0e', 'sql', '修改wl_equipment', null, '3.6.3', null, null, '0007209576');
INSERT INTO `databasechangelog` VALUES ('20210107-03', 'tiantao', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 16:13:27', '4850', 'MARK_RAN', '8:015531e6840ab746e8443ccb3e24e3af', 'sql', '修改wl_equipment', null, '3.6.3', null, null, '0007209576');
INSERT INTO `databasechangelog` VALUES ('20210107-04', 'tiantao', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 16:13:27', '4851', 'MARK_RAN', '8:4488e11fbd50fb3030f7dd1c2fd7f4f0', 'sql', '修改wl_equipment', null, '3.6.3', null, null, '0007209576');
INSERT INTO `databasechangelog` VALUES ('1580000025-2', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-11 09:31:13', '5070', 'EXECUTED', '8:bd262bb67f6f1546da869bd6943f04bf', 'sql', '', null, '3.6.3', null, null, '0328681643');
INSERT INTO `databasechangelog` VALUES ('1610345850-1', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-11 14:25:13', '5215', 'EXECUTED', '8:00f75f86561fd128db5f65af07cc7481', 'sql', '删除表wl_car_liquid_level', null, '3.6.3', null, null, '0346322991');
INSERT INTO `databasechangelog` VALUES ('1610345850-2', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-11 14:25:13', '5216', 'EXECUTED', '8:b2245457a02cca3e9602d045132c985d', 'sql', '删除表wl_equipmentdef_qrcode', null, '3.6.3', null, null, '0346322991');
INSERT INTO `databasechangelog` VALUES ('1609989898-1', 'gaojianqiang', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-01-11 15:12:58', '5251', 'EXECUTED', '8:e745a6efb1e1dac2a2e73a3e80d93bc4', 'sql', '修改f_equipment表结构', null, '3.6.3', null, null, '0349186328');
INSERT INTO `databasechangelog` VALUES ('1580000026-2', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:07', '5422', 'MARK_RAN', '8:1b99fef6fe1bbe8d725dc3e333ccf73f', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1580000026-3', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:07', '5423', 'MARK_RAN', '8:6b3d54ed536900ced84ec5e6886af207', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1580000026-4', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:07', '5424', 'MARK_RAN', '8:1ca769430bf2a082a83c23380f30e2f9', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1580000026-5', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:07', '5425', 'MARK_RAN', '8:cbf1aec24851aaa0cf88013743aa508f', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1580000026-6', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:07', '5426', 'MARK_RAN', '8:12d504402103489e7f6015d0ed57e3e9', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1580000026-8', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:07', '5427', 'MARK_RAN', '8:2f9701466f705cff3784c74dcc3a4a1f', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1580000026-9', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:08', '5428', 'EXECUTED', '8:03d0855f17ca26fb942fffa295a8858c', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1554111363113-4', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 09:51:47', '5435', 'EXECUTED', '8:e2768897108fc4e2644179fac41068b8', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '0416317451');
INSERT INTO `databasechangelog` VALUES ('15541113631138-2', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 10:59:34', '5451', 'EXECUTED', '8:c04d4a85061ee62d9f44960950a8550f', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '0420384736');
INSERT INTO `databasechangelog` VALUES ('15541113631139-1', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5472', 'RERAN', '8:a1aef2e0b4176d5766e4fc42034babd1', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-2', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5473', 'RERAN', '8:c04d4a85061ee62d9f44960950a8550f', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-3', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5474', 'RERAN', '8:7b5f631ea99bfbfd0bac4647445f4e28', 'sql', 'check_update 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-4', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5475', 'RERAN', '8:19ab0de6255da3dd628398e716655442', 'sql', 'check_update 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-5', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5476', 'RERAN', '8:a8bdee1c2d2c83ee7630303ccfe7c07f', 'sql', 'plan_task_detail_insert 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-6', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5477', 'RERAN', '8:1b3d09113a9e17de1d38430f03441111', 'sql', 'plan_task_detail_insert 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-7', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5480', 'RERAN', '8:19732aa4d6156fb23c489667653db9e7', 'sql', 'p_point_classify_delete 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-8', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5481', 'RERAN', '8:393e89ede95ceb53c80080fe6927f368', 'sql', 'p_point_classify_delete 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-10', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5482', 'RERAN', '8:579a8dcfe972b54c5e09d9a3f04fd1ca', 'sql', 'trigger_route_point_insert_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-11', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5483', 'RERAN', '8:c0e030f33907ce41c58717d33744ebba', 'sql', 'trigger_route_point_insert_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-12', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5484', 'RERAN', '8:05d3aa34603d59c3265614a4f9bcb4db', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-13', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5485', 'RERAN', '8:9035eed706219b6f7a4f5de098b05085', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-14', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5486', 'RERAN', '8:7d21c89d5b7e16261fc2b019711a98af', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-15', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5487', 'RERAN', '8:e2fd47543ee53e8ac2c0373931fc6483', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-20', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5488', 'EXECUTED', '8:ae36415d04b81fc32c7f4f1614e7169b', 'createProcedure procedureName=updatePlanTask', '', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-21', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5489', 'EXECUTED', '8:3119cbd45b548be5bfa00e55f0b34ab1', 'createProcedure procedureName=updatePlanTask', '', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-22', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5490', 'EXECUTED', '8:0aeaf538b80f16e9d17eb060c99ce379', 'createProcedure procedureName=planTaskStatistics', '', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-23', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5491', 'EXECUTED', '8:68fa1b5431afb6c73ddd85869576233b', 'createProcedure procedureName=planTaskStatistics', '', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-24', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5492', 'EXECUTED', '8:aafa72adc776aa914459206ce3a6b849', 'createProcedure procedureName=everyDayInitPlanTaskStatistics', '', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-25', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5493', 'EXECUTED', '8:a0d80840cd406c60c733b30828278bd4', 'createProcedure procedureName=everyDayInitPlanTaskStatistics', '', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-16', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5495', 'EXECUTED', '8:d9dba034c2d8bbdf83b862594dd6028d', 'sql', 'addPointConfig 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-17', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5496', 'EXECUTED', '8:9cebea1ef701192a90a5e86567c57611', 'sql', 'addPointConfig 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-18', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5497', 'EXECUTED', '8:54c4458cf3c3fb2d402f22d908782857', 'sql', 'deletePointConfig 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-19', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5498', 'EXECUTED', '8:d11c3d04496d304612c99ff1a588a0c1', 'sql', 'deletePointConfig 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('1610421278000-1', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:01', '29092', 'RERAN', '8:a1aef2e0b4176d5766e4fc42034babd1', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-2', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:01', '29093', 'RERAN', '8:c04d4a85061ee62d9f44960950a8550f', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-3', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:01', '29094', 'RERAN', '8:7b5f631ea99bfbfd0bac4647445f4e28', 'sql', 'check_update 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-4', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:02', '29095', 'RERAN', '8:19ab0de6255da3dd628398e716655442', 'sql', 'check_update 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-5', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:02', '29096', 'RERAN', '8:a8bdee1c2d2c83ee7630303ccfe7c07f', 'sql', 'plan_task_detail_insert 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-6', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:02', '29097', 'RERAN', '8:1b3d09113a9e17de1d38430f03441111', 'sql', 'plan_task_detail_insert 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-7', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:02', '29100', 'RERAN', '8:19732aa4d6156fb23c489667653db9e7', 'sql', 'p_point_classify_delete 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-8', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:02', '29101', 'RERAN', '8:393e89ede95ceb53c80080fe6927f368', 'sql', 'p_point_classify_delete 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-10', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:02', '29102', 'RERAN', '8:579a8dcfe972b54c5e09d9a3f04fd1ca', 'sql', 'trigger_route_point_insert_update_point_route_info 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-11', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:02', '29103', 'RERAN', '8:c0e030f33907ce41c58717d33744ebba', 'sql', 'trigger_route_point_insert_update_point_route_info 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-12', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:02', '29104', 'RERAN', '8:05d3aa34603d59c3265614a4f9bcb4db', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-13', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:03', '29105', 'RERAN', '8:9035eed706219b6f7a4f5de098b05085', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-14', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:03', '29106', 'RERAN', '8:7d21c89d5b7e16261fc2b019711a98af', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-15', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:03', '29107', 'RERAN', '8:e2fd47543ee53e8ac2c0373931fc6483', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-20', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:03', '29108', 'RERAN', '8:ae36415d04b81fc32c7f4f1614e7169b', 'createProcedure procedureName=updatePlanTask', '', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-21', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:03', '29109', 'RERAN', '8:3119cbd45b548be5bfa00e55f0b34ab1', 'createProcedure procedureName=updatePlanTask', '', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-22', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:03', '29110', 'RERAN', '8:0aeaf538b80f16e9d17eb060c99ce379', 'createProcedure procedureName=planTaskStatistics', '', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-23', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:03', '29111', 'RERAN', '8:68fa1b5431afb6c73ddd85869576233b', 'createProcedure procedureName=planTaskStatistics', '', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-24', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:03', '29112', 'RERAN', '8:aafa72adc776aa914459206ce3a6b849', 'createProcedure procedureName=everyDayInitPlanTaskStatistics', '', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-25', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:03', '29113', 'RERAN', '8:a0d80840cd406c60c733b30828278bd4', 'createProcedure procedureName=everyDayInitPlanTaskStatistics', '', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-16', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:03', '29115', 'RERAN', '8:d9dba034c2d8bbdf83b862594dd6028d', 'sql', 'addPointConfig 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-17', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:03', '29116', 'RERAN', '8:9cebea1ef701192a90a5e86567c57611', 'sql', 'addPointConfig 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-18', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:03', '29117', 'RERAN', '8:54c4458cf3c3fb2d402f22d908782857', 'sql', 'deletePointConfig 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('1610421278000-19', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-04-21 16:29:04', '29118', 'RERAN', '8:d11c3d04496d304612c99ff1a588a0c1', 'sql', 'deletePointConfig 触发器创建', null, '3.6.3', null, null, '8993742262');
INSERT INTO `databasechangelog` VALUES ('20210113-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-13 15:42:22', '5867', 'EXECUTED', '8:8db85a52c7b3000d65091587c9e6322a', 'sql', '修改 wl_equipment_specific_alarm', null, '3.6.3', null, null, '0523742002');
INSERT INTO `databasechangelog` VALUES ('1610523503355-1', 'shg', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-13 15:47:22', '5876', 'EXECUTED', '8:1b08b81fad654451b60327ff83958101', 'sql', 'wl_form_group_column 可乐二期修改字段为非必输', null, '3.6.3', null, null, '0524042161');
INSERT INTO `databasechangelog` VALUES ('1610523503355-2', 'shg', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-14 09:01:08', '5902', 'MARK_RAN', '8:94a45bb52e75371dfcb0b2111e564426', 'sql', '可乐需求增加部门字段', null, '3.6.3', null, null, '0586070535');
INSERT INTO `databasechangelog` VALUES ('20210114-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-14 09:28:59', '5915', 'EXECUTED', '8:78aebd7c2fe5c7ceb0d22168ed1b846b', 'sql', '修改 wl_equipment_specific_alarm', null, '3.6.3', null, null, '0587741213');
INSERT INTO `databasechangelog` VALUES ('20210114-02', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-14 09:30:12', '5920', 'EXECUTED', '8:1f42f37cfc45c365fc88dbbff78a2109', 'sql', '修改 wl_equipment_specific_alarm', null, '3.6.3', null, null, '0587814297');
INSERT INTO `databasechangelog` VALUES ('20210114-03', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-14 15:15:41', '6057', 'EXECUTED', '8:6c2ae3670c3e9d8a7434ddfc274af980', 'sql', '修改 wl_equipment_specific_alarm', null, '3.6.3', null, null, '0608543908');
INSERT INTO `databasechangelog` VALUES ('20210114-04', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-14 16:53:25', '6126', 'EXECUTED', '8:003bc62b771d22052d9b3be7c72f30ea', 'sql', '修改 wl_video', null, '3.6.3', null, null, '0614407908');
INSERT INTO `databasechangelog` VALUES ('20210115-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-15 09:31:31', '6247', 'EXECUTED', '8:6721b0e691ebe0a185b2d212a8863098', 'sql', '修改 wl_video', null, '3.6.3', null, null, '0674295121');
INSERT INTO `databasechangelog` VALUES ('1611041746-1', 'keyong', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-19 15:39:44', '6988', 'MARK_RAN', '8:a74002eafe11921b55bcf0c66567f6cc', 'sql', '可乐需求新增行业表', null, '3.6.3', null, null, '1041997254');
INSERT INTO `databasechangelog` VALUES ('1611041746-2', 'keyong', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-19 15:57:25', '7005', 'EXECUTED', '8:55c2b66a79590d21554aadf67caecf88', 'sql', '装备分类添加行业id列', null, '3.6.3', null, null, '1043057607');
INSERT INTO `databasechangelog` VALUES ('1611041746-3', 'keyong', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-19 19:13:02', '7182', 'EXECUTED', '8:4b494bf1ee70e823f13dff7098de5025', 'sql', '装备分类添加行业编码列', null, '3.6.3', null, null, '1054795760');
INSERT INTO `databasechangelog` VALUES ('20210120-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-20 15:47:58', '7452', 'EXECUTED', '8:1ff553f34b0be99d2e96e5541322c0fe', 'sql', '修改 wl_equipment_detail', null, '3.6.3', null, null, '1128878067');
INSERT INTO `databasechangelog` VALUES ('1611092688-1', 'keyong', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-20 17:37:28', '7601', 'EXECUTED', '8:27530b9d232f7b14adc2f0e8bd8ca63e', 'sql', '行业表添加排序字段', null, '3.6.3', null, null, '1135449994');
INSERT INTO `databasechangelog` VALUES ('1611092688-2', 'tb', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-21 09:48:22', '7790', 'EXECUTED', '8:a0029b29d2ee265df36bde8704dae391', 'sql', '行业编码唯一索引', null, '3.6.3', null, null, '1193704919');
INSERT INTO `databasechangelog` VALUES ('1611716870-1', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 11:15:39', '8608', 'EXECUTED', '8:f76d8d81e71481242a9404992f3d1ec0', 'createIndex indexName=point_id_index, tableName=p_point_classify', '', null, '3.6.3', null, null, '1717339637');
INSERT INTO `databasechangelog` VALUES ('1611716870-2', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 11:15:40', '8609', 'EXECUTED', '8:6b71099067d601211ab25f6f2b7e1476', 'createIndex indexName=check_id_index, tableName=p_task', '', null, '3.6.3', null, null, '1717339637');
INSERT INTO `databasechangelog` VALUES ('1611716870-3', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 11:15:40', '8610', 'EXECUTED', '8:f1df4a6d76c704aba49aca941de398eb', 'createIndex indexName=check_time_index, tableName=p_check', '', null, '3.6.3', null, null, '1717339637');
INSERT INTO `databasechangelog` VALUES ('1611716870-4', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 11:15:41', '8611', 'EXECUTED', '8:af0ee8e356ac71debc563ec7e321e6f4', 'sql', '', null, '3.6.3', null, null, '1717339637');
INSERT INTO `databasechangelog` VALUES ('1611716870-5', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 11:15:41', '8612', 'EXECUTED', '8:d255e2f874b99e6fbbf9d07d9d24d697', 'sql', '', null, '3.6.3', null, null, '1717339637');
INSERT INTO `databasechangelog` VALUES ('1611628333-1', 'keyong', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 18:19:42', '8703', 'EXECUTED', '8:f29d52bd7c034a8b4542a6df27fca7f4', 'sql', '创建隐患表p_latent_danger', null, '3.6.3', null, null, '1742784224');
INSERT INTO `databasechangelog` VALUES ('1611628333-2', 'keyong', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 18:19:42', '8704', 'EXECUTED', '8:43ffa32776154fbf8266c9811441e462', 'sql', '创建隐患工作流记录表p_latent_danger_flow_record', null, '3.6.3', null, null, '1742784224');
INSERT INTO `databasechangelog` VALUES ('1611628333-3', 'keyong', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 18:19:43', '8705', 'EXECUTED', '8:5db06d1cf5e94e8b88281582071aebcc', 'sql', '创建隐患巡检关系表p_latent_danger_patrol', null, '3.6.3', null, null, '1742784224');
INSERT INTO `databasechangelog` VALUES ('1611628333-4', 'keyong', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 18:19:43', '8706', 'EXECUTED', '8:897388d51d5d0b7102f8279551254f0c', 'sql', '创建隐患图片表p_latent_danger_photo', null, '3.6.3', null, null, '1742784224');
INSERT INTO `databasechangelog` VALUES ('1611890480-1', 'ky', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-29 11:25:16', '10783', 'EXECUTED', '8:c54f7b97e75c11079bfb03f029d155f4', 'sql', '', null, '3.6.3', null, null, '1890718254');
INSERT INTO `databasechangelog` VALUES ('1611890480-2', 'ky', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-29 11:25:17', '10784', 'EXECUTED', '8:887d6e5820f1954ea230ff72c5ecec66', 'sql', '', null, '3.6.3', null, null, '1890718254');
INSERT INTO `databasechangelog` VALUES ('1611890480-3', 'ky', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-29 19:21:38', '11353', 'EXECUTED', '8:bff9165516b1b46a890098392eed637c', 'sql', '', null, '3.6.3', null, null, '1919300804');
INSERT INTO `databasechangelog` VALUES ('1611716870-5', 'wjk', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-02-02 14:23:27', '11719', 'EXECUTED', '8:f311b79cf5c3c4e762091bfcd7b12fc7', 'sql', '', null, '3.6.3', null, null, '2247017341');
INSERT INTO `databasechangelog` VALUES ('1612272587000-1', 'wujunkai', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-02-02 21:31:52', '12329', 'MARK_RAN', '8:f7770ca9622778cd6a0d61211fdddc52', 'sql', 'create table c_plan_classify_tree', null, '3.6.3', null, null, '2272721811');
INSERT INTO `databasechangelog` VALUES ('1612272587000-2', 'wujunkai', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-02-02 21:31:52', '12330', 'MARK_RAN', '8:ab54313768f0cb818197f88b78fa75e0', 'sql', 'create table c_plan_detail', null, '3.6.3', null, null, '2272721811');
INSERT INTO `databasechangelog` VALUES ('1612272587000-3', 'wujunkai', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-02-02 21:31:52', '12331', 'MARK_RAN', '8:20906b155791925a7a3a0789341ed33f', 'sql', 'create table c_plan_doc', null, '3.6.3', null, null, '2272721811');
INSERT INTO `databasechangelog` VALUES ('1612272587000-4', 'wujunkai', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-02-02 21:31:52', '12332', 'MARK_RAN', '8:0ba0041db647780e7112f8d862b67ee1', 'sql', 'create table c_plan_equipment', null, '3.6.3', null, null, '2272721811');
INSERT INTO `databasechangelog` VALUES ('1612272587000-5', 'wujunkai', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-02-02 21:31:52', '12333', 'MARK_RAN', '8:ed7ae73b12adb12b02324c68ec0565d5', 'sql', 'create table c_plan_operation_record', null, '3.6.3', null, null, '2272721811');
INSERT INTO `databasechangelog` VALUES ('1612272587000-6', 'wujunkai', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-02-02 21:31:52', '12334', 'MARK_RAN', '8:b3f39018ff2f06c3903d8bfc884b04da', 'sql', 'create table c_plan_rule', null, '3.6.3', null, null, '2272721811');
INSERT INTO `databasechangelog` VALUES ('161195101-1', 'ky', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-02-07 14:56:04', '13082', 'EXECUTED', '8:46502fb23bbcec23dabdd52e4091a65e', 'sql', '', null, '3.6.3', null, null, '2680972912');
INSERT INTO `databasechangelog` VALUES ('1561454393001-1', 'suhg', 'classpath:/db/changelog/fas-sql-task.xml', '2021-04-15 20:27:37', '26215', 'RERAN', '8:8a1e7d1404a1b18afa384d2c9142189f', 'sql', 'update f_fmea_equipment_point 更新触发器创建', null, '3.6.3', null, null, '8489657072');
INSERT INTO `databasechangelog` VALUES ('1588901126339-1', 'shanqiyun', 'classpath:/db/changelog/fas-sql-task.xml', '2021-04-15 20:27:38', '26216', 'RERAN', '8:1201d1531bd5235267b90b7424ac9bfb', 'sql', 'f_risk_source 查询所有子节点id', null, '3.6.3', null, null, '8489657072');
INSERT INTO `databasechangelog` VALUES ('1589954524001-1', 'maoying', 'classpath:/db/changelog/fas-sql-task.xml', '2021-04-15 20:27:38', '26217', 'RERAN', '8:8d78b9fc0529776dbc5c8dc92bdc14f9', 'sql', 'updatePointConfig 触发器创建', null, '3.6.3', null, null, '8489657072');
INSERT INTO `databasechangelog` VALUES ('20210226-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-02-26 15:33:17', '14140', 'EXECUTED', '8:3e3a92530f1c9246c8f33f9fb6d05be5', 'sql', '修改 wl_video', null, '3.6.3', null, null, '4324801520');
INSERT INTO `databasechangelog` VALUES ('20210301-01', 'tiantao', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-01 14:34:36', '14516', 'MARK_RAN', '8:ae51b8971d0b2b4c2419b990ecf20687', 'sql', '创建 co_access_recording', null, '3.6.3', null, null, '4580485044');
INSERT INTO `databasechangelog` VALUES ('20210301-02', 'tiantao', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-01 14:34:36', '14517', 'MARK_RAN', '8:d72fbaf6134b721ff5057c8fd05b3191', 'sql', '创建 co_visitor_recording', null, '3.6.3', null, null, '4580485044');
INSERT INTO `databasechangelog` VALUES ('20210317-tb-1', 'tb', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-17 11:35:44', '17873', 'MARK_RAN', '8:647936acfd8dd5493f989d038d8ce552', 'sql', '访问记录唯一索引', null, '3.6.3', null, null, '5952141126');
INSERT INTO `databasechangelog` VALUES ('20210317-tb-2', 'tb', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-17 11:35:44', '17874', 'MARK_RAN', '8:8e6847e57eb73eb61a92e1b53be94a1d', 'addPrimaryKey tableName=co_visitor_recording', '', null, '3.6.3', null, null, '5952141126');
INSERT INTO `databasechangelog` VALUES ('1616047461-1', 'wjk', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-03-18 14:05:12', '18378', 'MARK_RAN', '8:ce89cbea0226f09c61766b1ce2a08ec8', 'sql', '', null, '3.6.3', null, null, '6047514072');
INSERT INTO `databasechangelog` VALUES ('20210318-tb-1', 'tb', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-18 14:26:47', '18474', 'EXECUTED', '8:82abdbeae13fa80e0c698217e93d2a3d', 'addColumn tableName=co_visitor_recording', '添加逻辑删除字段', null, '3.6.3', null, null, '6048808850');
INSERT INTO `databasechangelog` VALUES ('20210319-tb-1', 'tb', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-19 10:14:24', '18791', 'EXECUTED', '8:8308c25b223c0a99dd8e94f2d228e9e8', 'modifyDataType columnName=identity_number, tableName=co_visitor_recording; modifyDataType columnName=visitor_company, tableName=co_visitor_recording; modifyDataType columnName=visitors_number, tableName=co_visitor_recording; modifyDataType columnN...', '修改证件号码、访客单位、访客人数、员工姓名字段长度', null, '3.6.3', null, null, '6120064478');
INSERT INTO `databasechangelog` VALUES ('20210311-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-25 09:50:41', '20629', 'EXECUTED', '8:8fc55001a67791a118d20700ef31b1e9', 'sql', '修改 f_fire_fighting_system', null, '3.6.3', null, null, '6637041848');
INSERT INTO `databasechangelog` VALUES ('1616636836455-1', 'shg', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-25 09:54:14', '20641', 'EXECUTED', '8:74fe61ad526b72c44cec7ef846afbbb4', 'sql', 'create wl_dynamic_form_column 消防系统动态表单', null, '3.6.3', null, null, '6637256150');
INSERT INTO `databasechangelog` VALUES ('1616636836455-2', 'shg', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-25 09:54:14', '20642', 'EXECUTED', '8:d8d5dad8074042e5a2a3b8963b637788', 'sql', 'create wl_dynamic_form_group 消防系统动态表单', null, '3.6.3', null, null, '6637256150');
INSERT INTO `databasechangelog` VALUES ('1616636836455-3', 'shg', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-25 09:54:14', '20643', 'EXECUTED', '8:711faa3fa2436d48ebff3f0ff9745d07', 'sql', 'create wl_dynamic_form_instance 消防系统动态表单', null, '3.6.3', null, null, '6637256150');
INSERT INTO `databasechangelog` VALUES ('1616636836455-4', 'shg', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-25 13:01:09', '20714', 'EXECUTED', '8:2d9870034997ea1c8c88f4710c925e8f', 'sql', '消防系统管理,动态表单调整', null, '3.6.3', null, null, '6648471725');
INSERT INTO `databasechangelog` VALUES ('1616636836455-5', 'shg', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-25 13:01:09', '20715', 'EXECUTED', '8:8e8f9b57811871cfb8b95dbabbb9627d', 'sql', '消防系统管理,动态表单调整', null, '3.6.3', null, null, '6648471725');
INSERT INTO `databasechangelog` VALUES ('1607398689001-2', 'keyong', 'classpath:/changelog/sql-task.xml', '2021-04-20 08:58:54', '27473', 'RERAN', '8:de4c0c92563107e33f69345c7f147f96', 'sql', '由于组态组件不支持复杂SQL语句业务因此添加此视图', null, '3.6.3', null, null, '8880345393');
INSERT INTO `databasechangelog` VALUES ('1618828879-1', 'xixinzhao', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-04-19 19:34:11', '27380', 'MARK_RAN', '8:305d93566fbb700952fe2f09b18219fa', 'sql', 'p_plan_task add column user_name', null, '3.6.3', null, null, '8832061051');
INSERT INTO `databasechangelog` VALUES ('1607398689001-3', 'keyong', 'classpath:/changelog/sql-task.xml', '2021-04-21 15:40:57', '29000', 'RERAN', '8:f42342fff5ad2a2bb233c5bd8f5b36c2', 'sql', '由于组态组件不支持复杂SQL语句业务因此添加此视图', null, '3.6.3', null, null, '8990853834');

-- ----------------------------
-- Table structure for databasechangeloglock
-- ----------------------------
DROP TABLE IF EXISTS `databasechangeloglock`;
CREATE TABLE `databasechangeloglock` (
  `ID` int(11) NOT NULL,
  `LOCKED` bit(1) NOT NULL,
  `LOCKGRANTED` datetime DEFAULT NULL,
  `LOCKEDBY` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of databasechangeloglock
-- ----------------------------
INSERT INTO `databasechangeloglock` VALUES ('1', '\0', null, null);

-- ----------------------------
-- Table structure for d_arrange
-- ----------------------------
DROP TABLE IF EXISTS `d_arrange`;
CREATE TABLE `d_arrange` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(255) DEFAULT NULL COMMENT '部门org_code',
  `name` varchar(255) DEFAULT NULL COMMENT '班次名称',
  `start_time` varchar(255) DEFAULT NULL COMMENT '开始时间',
  `end_time` varchar(255) DEFAULT NULL COMMENT '结束时间',
  `app_key` varchar(255) DEFAULT NULL COMMENT '系统标识',
  `creater` varchar(255) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `updater` varchar(255) DEFAULT NULL COMMENT '修改者',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='班次';

-- ----------------------------
-- Records of d_arrange
-- ----------------------------

-- ----------------------------
-- Table structure for d_duty_details
-- ----------------------------
DROP TABLE IF EXISTS `d_duty_details`;
CREATE TABLE `d_duty_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL COMMENT '用户id',
  `duty_name` varchar(255) DEFAULT NULL COMMENT '值班人',
  `duty_date` datetime DEFAULT NULL COMMENT '值班日期',
  `arrange_id` bigint(20) DEFAULT NULL COMMENT '班次ID',
  `post_type` varchar(255) DEFAULT NULL COMMENT '岗位类型（来源数据字典）',
  `sort` int(10) DEFAULT NULL COMMENT '排序',
  `is_duty` bit(1) DEFAULT NULL COMMENT '是否值班【0：否；1：是】',
  `is_adjust` bit(1) DEFAULT NULL COMMENT '是否调班【0：否；1：是】',
  `creater` varchar(255) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `updater` varchar(255) DEFAULT NULL COMMENT '修改者',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3948 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='值班表';

-- ----------------------------
-- Records of d_duty_details
-- ----------------------------

-- ----------------------------
-- Table structure for elec_bills_alarm_info
-- ----------------------------
DROP TABLE IF EXISTS `elec_bills_alarm_info`;
CREATE TABLE `elec_bills_alarm_info` (
  `SEQUENCE_NBR` bigint(20) NOT NULL COMMENT '主键',
  `BILL_SEQ` bigint(20) NOT NULL COMMENT '登记单主键',
  `FIRE_EQUIPMENT_NAME` varchar(255) DEFAULT NULL COMMENT '探测器名称',
  `ALARM_DESC` varchar(255) DEFAULT NULL COMMENT '告警描述',
  `HANDLE_STATE` tinyint(4) DEFAULT NULL COMMENT '处理结果：0-未开始；1-已完成',
  `FILE_PATH` varchar(500) DEFAULT NULL COMMENT '附件照片路径',
  `ORIGIN_SEQ` bigint(20) DEFAULT NULL COMMENT '原始数据表主键（冗余追查数据用）',
  `CREATE_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `REC_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `REC_USER_ID` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `REMARK` varchar(255) DEFAULT NULL COMMENT '255',
  PRIMARY KEY (`SEQUENCE_NBR`) USING BTREE,
  KEY `idx_bill_warn_bill_seq` (`BILL_SEQ`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='安全监管单告警信息表';

-- ----------------------------
-- Records of elec_bills_alarm_info
-- ----------------------------

-- ----------------------------
-- Table structure for elec_bills_basic_info
-- ----------------------------
DROP TABLE IF EXISTS `elec_bills_basic_info`;
CREATE TABLE `elec_bills_basic_info` (
  `SEQUENCE_NBR` bigint(20) NOT NULL COMMENT '主键',
  `BILL_NO` varchar(20) NOT NULL COMMENT '单据编号',
  `STATION_SEQ` bigint(20) NOT NULL COMMENT '站编号',
  `STATION_NAME` varchar(255) DEFAULT NULL COMMENT '站名称',
  `DISTRIBUTION_USER_ID` bigint(20) DEFAULT NULL COMMENT '整改下发人员',
  `DISTRIBUTION_USER_NAME` varchar(50) DEFAULT NULL COMMENT '整改下发人员姓名',
  `STATION_CHARGE_PERSON` varchar(50) DEFAULT NULL COMMENT '换流站负责人',
  `CHARGE_PERSON_PHONE` varchar(20) DEFAULT NULL COMMENT '负责人联系电话',
  `SAFETY_CHARGE_PERSON` varchar(50) DEFAULT NULL COMMENT '安全负责人',
  `SAFETY_PERSON_PHONE` varchar(20) DEFAULT NULL COMMENT '安全负责人联系电话',
  `DISTRIBUTION_DATE` date DEFAULT NULL COMMENT '登记日期',
  `REQUIREMENT_DATE` date DEFAULT NULL COMMENT '要求完成时间',
  `ACTUAL_FINISH_DATE` date DEFAULT NULL COMMENT '实际完成日期',
  `FINISH_USER_NAME` varchar(50) DEFAULT NULL COMMENT '完成人员名称',
  `STATUS` tinyint(4) DEFAULT NULL COMMENT '当前状态：0-待下发；1-已下发；2-已完成；3-已关闭；',
  `REFORM_RESULT` varchar(255) DEFAULT NULL COMMENT '整改结果',
  `FEEDBACK_RESULT` varchar(255) DEFAULT NULL COMMENT '反馈结果',
  `VIEWS_AND_SUGGESTIONS` varchar(255) DEFAULT NULL COMMENT '意见及建议',
  `CREATE_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `REC_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `REC_USER_ID` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `REMARK` varchar(255) DEFAULT NULL COMMENT '255',
  PRIMARY KEY (`SEQUENCE_NBR`) USING BTREE,
  UNIQUE KEY `unique_key_basic_info_bill_no` (`BILL_NO`) USING BTREE,
  KEY `idx_base_bill_station_seq` (`STATION_SEQ`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='安全隐患整改单基本信息表';

-- ----------------------------
-- Records of elec_bills_basic_info
-- ----------------------------

-- ----------------------------
-- Table structure for elec_bills_danger_info
-- ----------------------------
DROP TABLE IF EXISTS `elec_bills_danger_info`;
CREATE TABLE `elec_bills_danger_info` (
  `SEQUENCE_NBR` bigint(20) NOT NULL COMMENT '主键',
  `BILL_SEQ` bigint(20) NOT NULL COMMENT '登记单主键',
  `DANGER_LEVEL` tinyint(4) DEFAULT NULL COMMENT '隐患等级（1：一般隐患；2：重大隐患） ',
  `DANGER_NAME` varchar(255) DEFAULT NULL COMMENT '风险点名称',
  `INPUT_ITEM_NAME` varchar(255) DEFAULT NULL COMMENT '检查项名称',
  `ORIGIN_SEQ` bigint(20) DEFAULT NULL COMMENT '原始数据表主键（冗余追查数据用）',
  `HANDLE_STATE` tinyint(4) DEFAULT NULL COMMENT '处理结果：0-未开始；1-已完成',
  `FILE_PATH` varchar(500) DEFAULT NULL COMMENT '附件照片路径',
  `CREATE_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `REC_USER_ID` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `REC_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `REMARK` varchar(255) DEFAULT NULL COMMENT '255',
  PRIMARY KEY (`SEQUENCE_NBR`) USING BTREE,
  KEY `idx_bill_danger_bill_seq` (`BILL_SEQ`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='安全监管表单隐患信息';

-- ----------------------------
-- Records of elec_bills_danger_info
-- ----------------------------

-- ----------------------------
-- Table structure for elec_bills_fire_safety_control
-- ----------------------------
DROP TABLE IF EXISTS `elec_bills_fire_safety_control`;
CREATE TABLE `elec_bills_fire_safety_control` (
  `SEQUENCE_NBR` bigint(20) NOT NULL COMMENT '主键',
  `BILL_SEQ` bigint(20) NOT NULL COMMENT '登记单主键',
  `TYPE` tinyint(4) DEFAULT NULL COMMENT '比较类型：0-消防应急预案；1-消防安全培训；2-消防日常训练；3-消防器材保养；',
  `ACTUAL_NUMBER` int(11) DEFAULT NULL COMMENT '实际数量',
  `THRESHOLD` int(11) DEFAULT NULL COMMENT '阈值',
  `STATE` tinyint(4) DEFAULT NULL COMMENT '状态:0-正常；1-异常（冗余字段）',
  `CREATE_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `REC_USER_ID` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `REC_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `REMARK` varchar(255) DEFAULT NULL COMMENT '255',
  PRIMARY KEY (`SEQUENCE_NBR`) USING BTREE,
  KEY `idx_bill_fire_bill_seq` (`BILL_SEQ`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='安全监管表单消防安全管理';

-- ----------------------------
-- Records of elec_bills_fire_safety_control
-- ----------------------------

-- ----------------------------
-- Table structure for elec_bills_risk_info
-- ----------------------------
DROP TABLE IF EXISTS `elec_bills_risk_info`;
CREATE TABLE `elec_bills_risk_info` (
  `SEQUENCE_NBR` bigint(20) NOT NULL COMMENT '主键',
  `BILL_SEQ` bigint(20) NOT NULL COMMENT '登记单主键',
  `POINT_NAME` varchar(255) DEFAULT NULL COMMENT '风险点名称',
  `LEVEL_NAME` varchar(32) DEFAULT NULL COMMENT '等级名称 ',
  `RISK_FACTOR_NAME` varchar(255) DEFAULT NULL COMMENT '危险因素名称',
  `ORIGIN_SEQ` bigint(20) DEFAULT NULL COMMENT '原始数据表主键（冗余追查数据用）',
  `CREATE_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `FEEDBACK` varchar(255) DEFAULT NULL COMMENT '反馈',
  `REC_USER_ID` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `REC_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `REMARK` varchar(255) DEFAULT NULL COMMENT '255',
  PRIMARY KEY (`SEQUENCE_NBR`) USING BTREE,
  KEY `idx_bill_risk_bill_seq` (`BILL_SEQ`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='安全监管风险信息表';

-- ----------------------------
-- Records of elec_bills_risk_info
-- ----------------------------

-- ----------------------------
-- Table structure for f_accident_type
-- ----------------------------
DROP TABLE IF EXISTS `f_accident_type`;
CREATE TABLE `f_accident_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `name` varchar(100) DEFAULT NULL COMMENT '事故类型',
  `evaluation_sid` bigint(32) DEFAULT NULL COMMENT 'evaluation_model 中 type 为s 的id',
  `influence` varchar(255) DEFAULT NULL COMMENT '失效/事故影响',
  `severity` varchar(255) DEFAULT NULL COMMENT '严重度',
  `dept_id` varchar(255) DEFAULT '0' COMMENT '维护部门',
  `create_by` varchar(255) DEFAULT '0' COMMENT '维护人员',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='事故类型表';

-- ----------------------------
-- Records of f_accident_type
-- ----------------------------
INSERT INTO `f_accident_type` VALUES ('1', '10', '设备故障', '26', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('2', '10', '断电设备突然停运', '27', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('3', '10', '其他', '30', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('4', '10', '电源短路', '25', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('5', '10', '火灾', '23', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('6', '10', '其他伤害', '29', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('7', '10', '触电事故', '25', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('11', '10', '人身触电', '25', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('12', '10', 'SF6气体防护', '25', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('13', '10', '高空坠落', '26', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('14', '10', '设备故障', '24', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('16', '10', '高空落物', '26', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('17', '10', '雷击事故', '22', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('18', '10', '静电及放射线事故', '26', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:11', null);
INSERT INTO `f_accident_type` VALUES ('19', '10', '小的事故类型', '22', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:11', null);
INSERT INTO `f_accident_type` VALUES ('23', '10', '测试世故', '23', null, null, '1232939516555915265', '1713102', '2021-02-04 13:03:53', null);

-- ----------------------------
-- Table structure for f_dict
-- ----------------------------
DROP TABLE IF EXISTS `f_dict`;
CREATE TABLE `f_dict` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `dict_name` varchar(255) DEFAULT NULL COMMENT '名称',
  `dict_code` varchar(255) DEFAULT NULL COMMENT '编码',
  `parent_id` bigint(11) DEFAULT NULL COMMENT '父ID',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否已经删除',
  `dict_value` varchar(255) DEFAULT NULL COMMENT '值',
  `dict_order` bigint(11) DEFAULT NULL COMMENT '序号',
  `remark` longtext COMMENT '说明',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of f_dict
-- ----------------------------
INSERT INTO `f_dict` VALUES ('1', '火警', 'fire_equipment_switch', '0', '\0', 'alarm_type_fire', '0', '火警');
INSERT INTO `f_dict` VALUES ('2', '开关', 'fire_equipment_switch', '0', '\0', 'alarm_type_power', '1', '开关');
INSERT INTO `f_dict` VALUES ('3', '液位', 'fire_equipment_analogue', '0', '\0', 'analogue_water_level', '0', '液位');
INSERT INTO `f_dict` VALUES ('4', '流量', 'fire_equipment_analogue', '0', '\0', 'analogue_water_flow', '1', '流量');
INSERT INTO `f_dict` VALUES ('5', '容量', 'fire_equipment_analogue', '0', '\0', 'analogue_water_capacity', '2', '容量');
INSERT INTO `f_dict` VALUES ('6', '换流变', 'fire_equipment_switch', '0', '\0', 'alarm_type_rheology', '2', '换流变');
INSERT INTO `f_dict` VALUES ('7', '故障', 'fire_equipment_switch', '0', '\0', 'alarm_type_trouble', '2', '故障告警');
INSERT INTO `f_dict` VALUES ('8', '消防车', 'plan_source_type', '0', '\0', 'fireCar', '0', null);
INSERT INTO `f_dict` VALUES ('9', '探测器', 'plan_source_type', '0', '\0', 'monitorEquipment', '1', null);
INSERT INTO `f_dict` VALUES ('10', '消防耗材', 'plan_source_type', '0', '\0', 'fireConsumables', '2', null);
INSERT INTO `f_dict` VALUES ('11', '视频监控', 'plan_source_type', '0', '\0', 'video', '3', null);
INSERT INTO `f_dict` VALUES ('12', '灭火器材', 'plan_source_type', '0', '\0', 'fireEquipment', '4', null);
INSERT INTO `f_dict` VALUES ('13', '重点装备', 'plan_source_type', '0', '\0', 'impEquipment', '5', null);
INSERT INTO `f_dict` VALUES ('14', '消防力量', 'plan_source_type', '0', '\0', 'fireStrength', '6', null);
INSERT INTO `f_dict` VALUES ('15', '消防小室', 'plan_source_type', '0', '\0', 'fireChamber', '7', null);
INSERT INTO `f_dict` VALUES ('16', '消防泡沫间', 'plan_source_type', '0', '\0', 'fireFoamRoom', '8', null);
INSERT INTO `f_dict` VALUES ('17', '消火栓', 'plan_source_type', '0', '\0', 'hydrant', '9', null);
INSERT INTO `f_dict` VALUES ('18', '消防水池', 'plan_source_type', '0', '\0', 'pool', '10', null);
INSERT INTO `f_dict` VALUES ('19', '名称', 'fireCar', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('20', '车牌号', 'fireCar', '0', '\0', 'car_num', '1', null);
INSERT INTO `f_dict` VALUES ('21', '发动机编号', 'fireCar', '0', '\0', 'engine_num', '2', null);
INSERT INTO `f_dict` VALUES ('22', '名称', 'monitorEquipment', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('23', '编号', 'monitorEquipment', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('24', '名称', 'fireConsumables', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('25', '编号', 'fireConsumables', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('26', '名称', 'video', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('27', '编号', 'video', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('30', '名称', 'fireEquipment', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('31', '编号', 'fireEquipment', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('32', '名称', 'impEquipment', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('33', '编号', 'impEquipment', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('34', '名称', 'fireStrength', '0', '\0', 'username', '0', null);
INSERT INTO `f_dict` VALUES ('35', '编号', 'fireStrength', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('36', '名称', 'fireChamber', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('37', '编号', 'fireChamber', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('38', '名称', 'fireFoamRoom', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('39', '编号', 'fireFoamRoom', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('40', '名称', 'hydrant', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('41', '编号', 'hydrant', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('42', '名称', 'pool', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('43', '编号', 'pool', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('44', '状态', 'fire_equipment_switch', '0', '\0', 'equipment_state', '3', null);
INSERT INTO `f_dict` VALUES ('45', '启停', 'fire_equipment_switch', '0', '\0', 'equipment_start_stop', '4', null);
INSERT INTO `f_dict` VALUES ('46', '警告', 'fire_equipment_switch', '0', '\0', 'equipment_warning', '5', null);

-- ----------------------------
-- Table structure for f_equipment
-- ----------------------------
DROP TABLE IF EXISTS `f_equipment`;
CREATE TABLE `f_equipment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `name` varchar(255) DEFAULT NULL COMMENT '设备名称',
  `position3d` varchar(100) DEFAULT NULL COMMENT '3位坐标',
  `ue4_rotation` text COMMENT 'ue4旋转',
  `ue4_location` text COMMENT 'ue4位置',
  `floor3d` varchar(100) DEFAULT NULL COMMENT '3维楼层',
  `is_indoor` bit(1) NOT NULL DEFAULT b'1' COMMENT '是否室内:0-否；1-是',
  `building` varchar(255) DEFAULT NULL COMMENT '建筑物',
  `room` varchar(255) DEFAULT NULL COMMENT '房间号',
  `address` varchar(255) DEFAULT NULL COMMENT '位置',
  `charge_dept_id` varchar(255) DEFAULT '0' COMMENT '责任部门',
  `charge_user_id` varchar(255) DEFAULT '0' COMMENT '责任人',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `fire_station_id` bigint(20) DEFAULT NULL COMMENT '消防小室id',
  `reserve_plan` varchar(100) DEFAULT NULL COMMENT '预案配置',
  `sort_num` int(11) DEFAULT NULL,
  `fire_truck_route` varchar(255) DEFAULT NULL COMMENT '消防车到重点设备行车路线',
  `risk_source_id` bigint(20) DEFAULT '0' COMMENT '风险区域id',
  `status` tinyint(4) DEFAULT '0' COMMENT '预案状态：1-启动，0-未启动',
  `start_time` datetime DEFAULT NULL COMMENT '预案开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '预案结束时间',
  `reserve_source` tinyint(4) DEFAULT '0' COMMENT '预案来源：1-手动触发，0-自动触发（默认）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='重点设备表';

-- ----------------------------
-- Records of f_equipment
-- ----------------------------

-- ----------------------------
-- Table structure for f_equipment_fire_equipment
-- ----------------------------
DROP TABLE IF EXISTS `f_equipment_fire_equipment`;
CREATE TABLE `f_equipment_fire_equipment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `equipment_id` bigint(20) NOT NULL COMMENT '设备id',
  `fire_equipment_id` bigint(20) NOT NULL COMMENT '消防装备id',
  `create_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=994 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='重点设备与消防设备关联中间表';

-- ----------------------------
-- Records of f_equipment_fire_equipment
-- ----------------------------

-- ----------------------------
-- Table structure for f_equipment_manage
-- ----------------------------
DROP TABLE IF EXISTS `f_equipment_manage`;
CREATE TABLE `f_equipment_manage` (
  `SEQUENCE_NBR` bigint(20) NOT NULL COMMENT '主键',
  `NAME` varchar(255) DEFAULT NULL COMMENT '名称',
  `CODE` varchar(32) NOT NULL COMMENT '编号',
  `SYSTEM_TYPE` tinyint(4) DEFAULT NULL COMMENT '系统类别',
  `INSTALL_DATE` datetime DEFAULT NULL COMMENT '安装日期',
  `CHARGE_PERSON` varchar(10) DEFAULT NULL COMMENT '负责人',
  `CONSTRUCTION_UNIT` varchar(10) DEFAULT NULL COMMENT '施工单位',
  `MAINTENANCE_UNIT` varchar(10) DEFAULT NULL COMMENT '维保单位',
  `MAINTENANCE_FREQUENCY` varchar(10) DEFAULT NULL COMMENT '维保频率',
  `FIRST_MAINTENANCE_DATE` datetime DEFAULT NULL COMMENT '首次维保日期',
  `REC_USER_ID` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `REC_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `REMARK` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`SEQUENCE_NBR`) USING BTREE,
  UNIQUE KEY `f_equipment_manage_uniq` (`CODE`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='消防设施管理';

-- ----------------------------
-- Records of f_equipment_manage
-- ----------------------------

-- ----------------------------
-- Table structure for f_evaluation_model
-- ----------------------------
DROP TABLE IF EXISTS `f_evaluation_model`;
CREATE TABLE `f_evaluation_model` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `name` varchar(100) DEFAULT NULL COMMENT '模型名称',
  `standard` text COMMENT '模型内容',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `coefficient` varchar(50) DEFAULT NULL COMMENT '系数',
  `influence` varchar(500) DEFAULT NULL COMMENT '影响',
  `describe` varchar(500) DEFAULT NULL COMMENT '描述',
  `type` varchar(50) DEFAULT NULL COMMENT '类型：S，D，O',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='评价模型表';

-- ----------------------------
-- Records of f_evaluation_model
-- ----------------------------
INSERT INTO `f_evaluation_model` VALUES ('22', '1', null, null, '2019-05-28 00:36:56', '0', null, '10', '无警告的危害', '在没有任何预兆的情况下发生，影响人员或设备安全，或违反有关法律法规的及严重的故障模式。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('23', '1', null, null, '2019-05-28 00:36:56', '0', null, '9', '有警告的危害', '在有故障预兆的情况下发生，影响人员或设备安全，或违反有关法律法规的及严重的故障模式。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('24', '1', null, null, '2019-05-28 00:36:56', '0', null, '8', '很大', '对生产造成较大的破坏，设备全部或主要功能无法正常运行，但设备是安全的。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('25', '1', null, null, '2019-05-28 00:36:56', '0', null, '7', '大', '设备性能受到影响，但仍可实现功能并是安全的。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('26', '1', null, null, '2019-05-28 00:36:56', '0', null, '6', '中等', '设备性能退化，但仍可以工作并是安全的。局部故障，但仍可以工作。不重要零件不能工作。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('27', '1', null, null, '2019-05-28 00:36:56', '0', null, '5', '小', '对设备性能有中等程度的影响，不重要零件故障需要维修', 'S');
INSERT INTO `f_evaluation_model` VALUES ('28', '1', null, null, '2019-05-28 00:36:56', '0', null, '4', '很小', '队产品性能有较小影响。故障不需要维修', 'S');
INSERT INTO `f_evaluation_model` VALUES ('29', '1', null, null, '2019-05-28 00:36:56', '0', null, '3', '轻微', '对设备性能有轻微影响。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('30', '1', null, null, '2019-05-28 00:36:56', '0', null, '2', '很轻微', '对设备性能有非常轻微的影响。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('31', '1', null, null, '2019-05-28 00:36:56', '0', null, '1', '无', '无影响。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('32', '1', null, null, '2019-05-28 00:36:56', '0', null, '10', '几乎不可能', '不可能探测或没有检查', 'D');
INSERT INTO `f_evaluation_model` VALUES ('33', '1', null, null, '2019-05-28 00:36:56', '0', null, '9', '很微小', '只能再失效发生后才能检测出', 'D');
INSERT INTO `f_evaluation_model` VALUES ('34', '1', null, null, '2019-05-28 00:36:56', '0', null, '8', '微小', '只能通过相关设备来进行探测', 'D');
INSERT INTO `f_evaluation_model` VALUES ('35', '1', null, null, '2019-05-28 00:36:56', '0', null, '7', '很小', '已全部纳管进安全执行系统或进行自动信号采集', 'D');
INSERT INTO `f_evaluation_model` VALUES ('36', '1', null, null, '2019-05-28 00:36:56', '0', null, '6', '小', '只能通过目测或手触来进行探测', 'D');
INSERT INTO `f_evaluation_model` VALUES ('37', '1', null, null, '2019-05-28 00:36:56', '0', null, '5', '中等', '只通过目测即可进行探测', 'D');
INSERT INTO `f_evaluation_model` VALUES ('38', '1', null, null, '2019-05-28 00:36:56', '0', null, '4', '中等偏上', '可通过仪表读数进行探测', 'D');
INSERT INTO `f_evaluation_model` VALUES ('39', '1', null, null, '2019-05-28 00:36:56', '0', null, '3', '高', '可通过中控仪表盘进行探测', 'D');
INSERT INTO `f_evaluation_model` VALUES ('40', '1', null, null, '2019-05-28 00:36:56', '0', null, '2', '很高', '有相应报警提示，出现故障后可在中控仪表盘中不断闪红', 'D');
INSERT INTO `f_evaluation_model` VALUES ('41', '1', null, null, '2019-05-28 00:36:56', '0', null, '1', '几乎肯定能', '有相应报警装置一旦出现故障可报警提示', 'D');
INSERT INTO `f_evaluation_model` VALUES ('42', '1', null, null, '2020-02-14 14:35:53', '0', null, '10', '很高：故障几乎不可避免', '0.9<O&&O<=1', 'O');
INSERT INTO `f_evaluation_model` VALUES ('43', '1', null, null, '2020-02-14 14:35:53', '0', null, '9', '很高：故障几乎不可避免', '0.8<O&&O<=0.9', 'O');
INSERT INTO `f_evaluation_model` VALUES ('44', '1', null, null, '2020-02-14 14:35:53', '0', null, '8', '高：反复发生的故障', '0.7<O&&O<=0.8', 'O');
INSERT INTO `f_evaluation_model` VALUES ('45', '1', null, null, '2020-02-14 14:35:53', '0', null, '7', '高：反复发生的故障', '0.6<O&&O<=0.7', 'O');
INSERT INTO `f_evaluation_model` VALUES ('46', '1', null, null, '2020-02-14 14:35:53', '0', null, '6', '中等：偶尔发生的故障', '0.5<O&&O<=0.6', 'O');
INSERT INTO `f_evaluation_model` VALUES ('47', '1', null, null, '2020-02-14 14:35:54', '0', null, '5', '中等：偶尔发生的故障', '0.4<O&&O<=0.5', 'O');
INSERT INTO `f_evaluation_model` VALUES ('48', '1', null, null, '2020-02-14 14:35:54', '0', null, '4', '中等：偶尔发生的故障', '0.3<O&&O<=0.4', 'O');
INSERT INTO `f_evaluation_model` VALUES ('49', '1', null, null, '2020-02-14 14:35:54', '0', null, '3', '低：相对很少发生', '0.2<O&&O<=0.3', 'O');
INSERT INTO `f_evaluation_model` VALUES ('50', '1', null, null, '2020-02-14 14:35:54', '0', null, '2', '低：相对很少发生', '0.1<O&&O<=0.2', 'O');
INSERT INTO `f_evaluation_model` VALUES ('51', '1', null, null, '2020-02-14 14:35:54', '0', null, '1', '极低：几乎不可能发生', '0<=O&&O<=0.1', 'O');

-- ----------------------------
-- Table structure for f_fire_equipment
-- ----------------------------
DROP TABLE IF EXISTS `f_fire_equipment`;
CREATE TABLE `f_fire_equipment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `equip_classify` int(11) DEFAULT '0' COMMENT '装备分类：0-设备类；1-耗材类;2-视频监控;3-灭火器材',
  `equip_type` varchar(255) DEFAULT NULL COMMENT '装备类型',
  `equip_code` varchar(255) DEFAULT NULL COMMENT '装备编码',
  `position3d` varchar(100) DEFAULT NULL COMMENT '3维坐标',
  `ue4_rotation` text COMMENT 'ue4旋转',
  `ue4_location` text COMMENT 'ue4位置',
  `floor3d` varchar(100) DEFAULT NULL COMMENT '3维楼层',
  `is_indoor` bit(1) NOT NULL DEFAULT b'1' COMMENT '是否室内:0-否；1-是',
  `name` varchar(255) DEFAULT NULL COMMENT '装备名称',
  `model` varchar(255) DEFAULT NULL COMMENT '规格型号',
  `maintenance_cycle` int(11) DEFAULT '0' COMMENT '保养周期',
  `manufacturer` varchar(255) DEFAULT NULL COMMENT '厂商',
  `brand` varchar(255) DEFAULT NULL COMMENT '品牌',
  `production_date` date DEFAULT NULL COMMENT '生产日期',
  `effective_date` date DEFAULT NULL COMMENT '有效时间',
  `number` int(11) DEFAULT '0' COMMENT '数量',
  `unit` varchar(255) DEFAULT NULL COMMENT '单位',
  `production_area` varchar(255) DEFAULT NULL COMMENT '区域',
  `room` varchar(255) DEFAULT NULL COMMENT '房间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `equip_status` int(11) DEFAULT '0' COMMENT '设备状态（1，告警； 0，正常; ）',
  `video_url` varchar(255) DEFAULT NULL COMMENT '视频路径',
  `weight` decimal(10,2) DEFAULT NULL COMMENT '重量',
  `action_state` varchar(50) DEFAULT '' COMMENT '动作状态',
  `eruption_state` varchar(50) DEFAULT '' COMMENT '喷发状态',
  `risk_source_id` bigint(20) DEFAULT '0' COMMENT '风险区域id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防装备表';

-- ----------------------------
-- Records of f_fire_equipment
-- ----------------------------

-- ----------------------------
-- Table structure for f_fire_equipment_point
-- ----------------------------
DROP TABLE IF EXISTS `f_fire_equipment_point`;
CREATE TABLE `f_fire_equipment_point` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `fire_equipment_id` bigint(20) NOT NULL COMMENT '消防装备id',
  `create_by` varchar(225) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
  `remark` varchar(255) DEFAULT NULL,
  `type` varchar(32) NOT NULL COMMENT '类型：模拟量ANALOGUE，开关量SWITCH',
  `value` varchar(50) DEFAULT NULL COMMENT '当前值保存时若为开关量（1,0）默认为1',
  `unit` varchar(50) DEFAULT NULL COMMENT '指标项名称',
  `org_code` varchar(50) DEFAULT NULL COMMENT '组织',
  `alarm_type` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防装备点表';

-- ----------------------------
-- Records of f_fire_equipment_point
-- ----------------------------

-- ----------------------------
-- Table structure for f_fire_fighting_system
-- ----------------------------
DROP TABLE IF EXISTS `f_fire_fighting_system`;
CREATE TABLE `f_fire_fighting_system` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `code` varchar(32) NOT NULL COMMENT '编号',
  `system_type` bigint(20) DEFAULT NULL COMMENT '系统类别',
  `form_group_id` bigint(20) DEFAULT NULL COMMENT '动态表单分组id',
  `install_date` datetime DEFAULT NULL COMMENT '安装日期',
  `charge_person` varchar(20) DEFAULT NULL COMMENT '负责人',
  `construction_unit` bigint(20) DEFAULT NULL COMMENT '施工单位',
  `maintenance_unit` bigint(20) DEFAULT NULL COMMENT '维保单位',
  `maintenance_frequency` varchar(20) DEFAULT NULL COMMENT '维保频率',
  `first_maintenance_date` datetime DEFAULT NULL COMMENT '首次维保日期',
  `rec_user_id` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `rec_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `scene_id` bigint(20) DEFAULT NULL COMMENT '画布id',
  `sort` bigint(20) DEFAULT NULL COMMENT '排序',
  `charge_person_phone` varchar(20) DEFAULT NULL COMMENT '负责人电话',
  `maintenance_phone` varchar(20) DEFAULT NULL COMMENT '维保电话',
  `org_code` varchar(20) DEFAULT NULL,
  `contro_box_build` bigint(20) DEFAULT NULL COMMENT '控制柜所在建筑',
  `pro_object` varchar(255) DEFAULT NULL COMMENT '保护对象',
  `instance_id` bigint(20) DEFAULT NULL COMMENT '动态表单实例id',
  `pro_code` varchar(32) DEFAULT NULL COMMENT '产品编码',
  `factory` bigint(20) DEFAULT NULL COMMENT '生产厂家',
  `contro_box_address` varchar(255) DEFAULT NULL COMMENT '控制柜安装位置',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `f_equipment_manage_uniq` (`code`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1618392659474 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='消防系统管理';

-- ----------------------------
-- Records of f_fire_fighting_system
-- ----------------------------

-- ----------------------------
-- Table structure for f_fmea
-- ----------------------------
DROP TABLE IF EXISTS `f_fmea`;
CREATE TABLE `f_fmea` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `risk_source_id` bigint(20) NOT NULL COMMENT '风险点id',
  `risk_factors_id` bigint(20) DEFAULT '0' COMMENT '危险因素id',
  `evaluation_sid` bigint(20) DEFAULT '0' COMMENT '危险程度',
  `evaluation_oid` bigint(20) DEFAULT '0' COMMENT '故障频数',
  `evaluation_did` bigint(20) DEFAULT '0' COMMENT '探测度',
  `rpni` decimal(10,2) DEFAULT NULL COMMENT '固有rpn',
  `rpn` decimal(10,2) DEFAULT NULL COMMENT '实时rpn',
  `new_evaluation_oid` bigint(20) DEFAULT NULL COMMENT '最新故障频数',
  `engineering` text COMMENT '工程措施',
  `management` text COMMENT '管理措施',
  `train` text COMMENT '培训教育',
  `protection` text COMMENT '个体防护',
  `disposal` text COMMENT '应急处置',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `company_leader` varchar(255) DEFAULT NULL COMMENT '公司负责人',
  `department_leader` varchar(255) DEFAULT NULL COMMENT '部门负责人',
  `group_leader` varchar(255) DEFAULT NULL COMMENT '班组负责人',
  `person_leader` varchar(255) DEFAULT NULL COMMENT '个人负责人',
  `identify_user` varchar(255) DEFAULT NULL COMMENT '辨识人',
  `identify_method` varchar(255) DEFAULT NULL COMMENT '辨识方法',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `risk_level_id` bigint(20) DEFAULT NULL COMMENT '风险等级id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=217 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='FEMA表';

-- ----------------------------
-- Records of f_fmea
-- ----------------------------

-- ----------------------------
-- Table structure for f_fmea_equipment_point
-- ----------------------------
DROP TABLE IF EXISTS `f_fmea_equipment_point`;
CREATE TABLE `f_fmea_equipment_point` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `fmea_id` bigint(20) NOT NULL COMMENT 'fmea编号',
  `equipment_point_id` bigint(20) NOT NULL COMMENT '装备指标编号',
  `state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '装备指标状态（0：正常；1：告警）',
  `important_equipment_id` bigint(20) NOT NULL COMMENT '所属重点设备id',
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='fmea和装备指标的关系';

-- ----------------------------
-- Records of f_fmea_equipment_point
-- ----------------------------

-- ----------------------------
-- Table structure for f_fmea_point_inputitem
-- ----------------------------
DROP TABLE IF EXISTS `f_fmea_point_inputitem`;
CREATE TABLE `f_fmea_point_inputitem` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `fmea_id` bigint(20) NOT NULL COMMENT 'fmea编号',
  `point_inputitem_id` bigint(20) NOT NULL COMMENT '检查点和项关系编号',
  `state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '检查项状态（0：正常；1：不合格）',
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=905 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='fmea和检查项的关系';

-- ----------------------------
-- Records of f_fmea_point_inputitem
-- ----------------------------

-- ----------------------------
-- Table structure for f_preplan_picture
-- ----------------------------
DROP TABLE IF EXISTS `f_preplan_picture`;
CREATE TABLE `f_preplan_picture` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `equipment_id` bigint(20) NOT NULL COMMENT '设备编号',
  `type` int(11) NOT NULL COMMENT '类型',
  `name` varchar(255) DEFAULT NULL COMMENT '装备名称',
  `picture` text COMMENT '图片路径地址',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=271 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='重点设备预案图';

-- ----------------------------
-- Records of f_preplan_picture
-- ----------------------------

-- ----------------------------
-- Table structure for f_risk_factor
-- ----------------------------
DROP TABLE IF EXISTS `f_risk_factor`;
CREATE TABLE `f_risk_factor` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `accident_type_id` bigint(20) NOT NULL COMMENT '失效/事故影响',
  `type` varchar(255) DEFAULT NULL COMMENT '分类',
  `dept_id` varchar(255) DEFAULT '0' COMMENT '维护部门',
  `create_by` varchar(255) DEFAULT '0' COMMENT '维护人员',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='危险因素表';

-- ----------------------------
-- Records of f_risk_factor
-- ----------------------------
INSERT INTO `f_risk_factor` VALUES ('1', '10', '设备老化产生故障', '1', 'firefight', '1232939516555915265', '1713102', '2021-02-04 12:59:34', null);
INSERT INTO `f_risk_factor` VALUES ('2', '10', '可能电源短路', '5', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:24', null);
INSERT INTO `f_risk_factor` VALUES ('3', '10', '设备运行故障，不能及时感知火灾', '6', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:24', null);
INSERT INTO `f_risk_factor` VALUES ('4', '10', '电线老化', '7', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:25', null);
INSERT INTO `f_risk_factor` VALUES ('5', '10', '电线接地', '7', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:25', null);
INSERT INTO `f_risk_factor` VALUES ('8', '10', '误碰、误动、误登运行设备，\n误入带电间隔。', '11', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:25', null);
INSERT INTO `f_risk_factor` VALUES ('9', '10', '设备有接地故障时，巡视人员误入产生跨步电压。\n', '11', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:26', null);
INSERT INTO `f_risk_factor` VALUES ('12', '10', '登高检查设备，如登上开关机构平台检查设备时，感应电造成人员失去平衡，造成人员碰伤、摔伤。\n', '13', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:26', null);
INSERT INTO `f_risk_factor` VALUES ('13', '10', '高空落物伤人。\n', '16', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:26', null);
INSERT INTO `f_risk_factor` VALUES ('14', '10', '使用无线通讯设备，造成保护误动。\n', '14', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:27', null);
INSERT INTO `f_risk_factor` VALUES ('15', '10', '小动物进入，造成事故。\n', '14', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:29', null);
INSERT INTO `f_risk_factor` VALUES ('16', '10', 'OWS上报出换流阀故障告警信号', '14', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:30', null);
INSERT INTO `f_risk_factor` VALUES ('17', '10', '阀塔设备冒烟、着火', '5', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:30', null);
INSERT INTO `f_risk_factor` VALUES ('18', '10', '阀塔设备、阀塔下方地面有水迹或阀塔水管喷水', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:31', null);
INSERT INTO `f_risk_factor` VALUES ('19', '10', '阀塔设备、阀塔下方地面有水迹或阀塔水管喷水', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:32', null);
INSERT INTO `f_risk_factor` VALUES ('20', '10', '换流阀运行声音有异常变化', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:33', null);
INSERT INTO `f_risk_factor` VALUES ('21', '10', '换流变压器喷油、漏油、冒烟', '14', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:34', null);
INSERT INTO `f_risk_factor` VALUES ('22', '10', '换流变压器冒烟着火', '5', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:34', null);
INSERT INTO `f_risk_factor` VALUES ('23', '10', '换流变压器冒烟着火', '5', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:34', null);
INSERT INTO `f_risk_factor` VALUES ('24', '10', '换流变压器声音与正常运行时对比有明显增大且伴有各种噪音', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:35', null);
INSERT INTO `f_risk_factor` VALUES ('25', '10', '换流变压器套管炸裂、严重漏油', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:35', null);
INSERT INTO `f_risk_factor` VALUES ('26', '10', '套管SF6压力低', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:35', null);
INSERT INTO `f_risk_factor` VALUES ('27', '10', '绕组温度/油温异常升高', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:35', null);
INSERT INTO `f_risk_factor` VALUES ('28', '10', '空调机组停止运行', '1', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:36', null);
INSERT INTO `f_risk_factor` VALUES ('29', '10', '空调控制系统发压差传感器报警', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:36', null);
INSERT INTO `f_risk_factor` VALUES ('30', '10', '空调控制系统发压差传感器报警', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:36', null);
INSERT INTO `f_risk_factor` VALUES ('31', '10', '风挡卡住', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:37', null);
INSERT INTO `f_risk_factor` VALUES ('32', '10', '风挡卡住', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:37', null);
INSERT INTO `f_risk_factor` VALUES ('33', '10', '除湿机不工作', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:37', null);
INSERT INTO `f_risk_factor` VALUES ('34', '10', '站间通讯中断', '14', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:37', null);
INSERT INTO `f_risk_factor` VALUES ('35', '10', '站间通讯中断', '14', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:37', null);
INSERT INTO `f_risk_factor` VALUES ('36', '10', '服务器死机', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:38', null);
INSERT INTO `f_risk_factor` VALUES ('37', '10', '控制保护屏柜、板卡电源显示异常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:38', null);
INSERT INTO `f_risk_factor` VALUES ('38', '10', 'UPS装置面板异常故障报警', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:38', null);
INSERT INTO `f_risk_factor` VALUES ('39', '10', '空调外机异响、通风口异物、柜门密封差', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:38', null);
INSERT INTO `f_risk_factor` VALUES ('41', '10', '实际位置与电气、机械位置指示不相符', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('42', '10', '压力管道渗漏', '1', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('43', '10', '氮气动力源铅封破损，气体压力指示不是0MPa；氮气启动源源铅封破损，气体压力压力小于4MPa', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('44', '10', '电磁控制阀有碰撞变形及其它机械性损伤，表盘非“SHUT”状态；减压阀有碰撞变形及其它机械性损伤', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('45', '10', '水雾喷头异物堵塞', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('46', '10', '冬季检查泡沫消防间温度低于0℃', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('47', '10', '装置运行不正常、液晶显示不正确、有异常声音及气味', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('48', '10', '运行指示不正常，电源开关位置不正常，装置告警信号', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('49', '10', '主水回路管道及法兰连接处、仪表及传感器安装处、管道阀门及主水过滤器有渗漏', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('50', '10', '表计（压力表、压差表、氮气瓶压力等）指示不在正常范围内', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:40', null);
INSERT INTO `f_risk_factor` VALUES ('51', '10', '各回路阀门位置未在指定正确方向', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:40', null);
INSERT INTO `f_risk_factor` VALUES ('52', '10', '火灾报警控制器各指示灯显示异常，异常报警', '1', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:40', null);
INSERT INTO `f_risk_factor` VALUES ('53', '10', '控制柜各指示灯显示异常，有异常及告警信号，工作状态不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:40', null);
INSERT INTO `f_risk_factor` VALUES ('54', '10', '蓄电池有变形、凸出、漏液爆炸裂开、烧焦、螺丝连接处氧化物渗出', '1', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:40', null);
INSERT INTO `f_risk_factor` VALUES ('55', '10', '消防砂池开裂、漏砂', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:40', null);
INSERT INTO `f_risk_factor` VALUES ('56', '10', '消防室杂乱有渗、漏雨；门窗有破损', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:41', null);
INSERT INTO `f_risk_factor` VALUES ('57', '10', '消防箱、消防桶、消防铲、消防斧损旧、锈蚀、破损', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:41', null);
INSERT INTO `f_risk_factor` VALUES ('58', '10', '进入户内SF6设备室或SF6设备发生故障气体外逸，巡视人员窒息或中毒。', '12', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:41', null);
INSERT INTO `f_risk_factor` VALUES ('59', '10', '机构箱、端子箱内加热器故障、防火封堵未到位', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:42', null);
INSERT INTO `f_risk_factor` VALUES ('60', '10', '母线存在变形，异物，跨接线过大弧垂和摆动\n', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:43', null);
INSERT INTO `f_risk_factor` VALUES ('61', '10', '母线终端、连接金具破损，接头松动，软连接有断片。\n', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:44', null);
INSERT INTO `f_risk_factor` VALUES ('62', '10', '母线均压环外观不正常、母线有异常声音。', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:45', null);
INSERT INTO `f_risk_factor` VALUES ('63', '10', '断路器分合状态指示正常，蝶（弹）簧在压缩位置，液压机构油位未在1/2处。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('64', '10', '断路器压力指示指针未在绿色区域，SF6压力不正常。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('65', '10', '断路器套管和液压机构观察孔污秽现象，断路器套管破损、裂纹。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('66', '10', '基础有破损或开裂，基础有无下沉，支架是否锈蚀或变形。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('67', '10', '汇控柜、端子箱、机构箱、动力箱温湿度控制器显示不正常、加热器运行不正常。（冬季）', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('68', '10', '实际位置与电气、机械位置指示不相符。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('69', '10', '瓷柱无裂纹和破损，无污秽现象、无放电和闪络的痕迹。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('70', '10', '连杆无弯曲、无松动、无锈蚀，开口销齐全。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('71', '10', '引线连接部分无过热现象，引线弧度适中。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('72', '10', '无影响设备安全运行的障碍物、附着物。\n', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('73', '10', '操作机构箱柜门密封良好，箱门锁紧，基础构架无变形。\n热器运行正常。（冬季）', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('74', '10', '构架及机构上无鸟巢、蜂巢。\n', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('75', '10', '机构箱温湿度控制器显示正常、加热器运行正常。（冬季）', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('76', '10', '电流互感器伞群、法兰等无破损、裂纹及放电闪络痕迹', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('77', '10', '电流互感器伞群污秽、不完整、存在裂纹、老化迹象。', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('78', '10', '电流互感器油位不正常，有渗、漏油现象', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('79', '10', '电流互感器引线异物，接头连接不牢固', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('80', '10', '电流互感器套管运行声音不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('81', '10', '本体存在破损、污秽、有锈蚀、裂纹', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('82', '10', '电流互感器接线板发热松动，放电声不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('83', '10', '平波电抗器顶部油温、绕组温度不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('84', '10', '平波电抗器本体、阀门、冷却器有渗、漏油现象，有异物挂落,套管油位不在正常区域，油枕油位不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('85', '10', '平波电抗器呼吸器外壳破裂现象，硅胶变色部分超过3/4', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:52', null);
INSERT INTO `f_risk_factor` VALUES ('86', '10', '平波电抗器呼吸器外壳破裂现象，硅胶变色部分超过3/4', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:52', null);
INSERT INTO `f_risk_factor` VALUES ('87', '10', '平波电抗器冷却器运行不正常, 散热片严重污秽现象,油流指示器指示不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:52', null);
INSERT INTO `f_risk_factor` VALUES ('88', '10', '电抗器冷却器控制柜内冷却器切换把手位置不正确', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:52', null);
INSERT INTO `f_risk_factor` VALUES ('89', '10', '主变压器顶部油温、绕组温度正常。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:52', null);
INSERT INTO `f_risk_factor` VALUES ('90', '10', '主变压器本体、阀门、冷却器有渗、漏油现象，异物挂落,套管油位在非正常区域，本体油枕油位不正常；\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:53', null);
INSERT INTO `f_risk_factor` VALUES ('91', '10', '主变压器呼吸器外壳存在破裂现象，硅胶变色部分超过2/3；', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:53', null);
INSERT INTO `f_risk_factor` VALUES ('92', '10', '主变压器套管污秽现象, 闪络放电痕迹；\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:53', null);
INSERT INTO `f_risk_factor` VALUES ('93', '10', '变压器冷却器运行不正常, 散热片严重污秽现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('94', '10', '主变压器本体、冷却器运行声音不正常。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('95', '10', '主变压器冷却器控制柜内冷却器操作把手位置不正确；\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('96', '10', '电容器存在渗漏油、生锈、鼓肚变形。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('97', '10', '运行声音异常及其它异常现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('98', '10', '各引线和接头有无松动、变色、过热现象。', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('99', '10', '电抗器本体存在破损、污秽、锈蚀、开裂。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('100', '10', '电抗器接地良好。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('101', '10', '电抗器接地良好。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('102', '10', '电抗器各引线和接头有松动、变色、过热现象', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('103', '10', '避雷器引流线松股、断股和弛度过紧及过松现象；接头松动、发热或变色等现象。', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('104', '10', '\n避雷器均压环存在位移、变形、锈蚀现象，有放电痕迹。', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('105', '10', '避雷器瓷套部分裂纹、破损、放电现象，防污闪涂层有破裂、起皱、鼓泡、脱落；硅橡胶复合绝缘外套伞裙破损、变形。\n密封结构金属件和法兰盘裂纹、锈蚀。\n压力释放装置封闭破损异物。', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('106', '10', '避雷器设备基础有塌陷；底座固定牢固、整体倾斜；绝缘底座表面破损、积污。', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('107', '10', '避雷器接地引下线连接不可靠，锈蚀、断裂。\n引下线支持小套管碎裂，螺栓松动情况', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:57', null);
INSERT INTO `f_risk_factor` VALUES ('108', '10', '避雷器运行时异常声响。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:57', null);
INSERT INTO `f_risk_factor` VALUES ('109', '10', '避雷器监测装置外观不完整、密封较差、连接不紧固，表计指示不正常，数值超标；放电计数器而问题，内部无受潮、进水。\n接地标识、设备铭牌、设备标示牌不齐全、模糊。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:58', null);
INSERT INTO `f_risk_factor` VALUES ('110', '10', '电阻器箱体破损变形，接头引线放电现象，运行声音不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:58', null);
INSERT INTO `f_risk_factor` VALUES ('111', '10', '电阻器箱体破损变形，接头引线放电现象，运行声音不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:59', null);
INSERT INTO `f_risk_factor` VALUES ('112', '10', '联络变油色谱在线监测柜灯状态异常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:00', null);
INSERT INTO `f_risk_factor` VALUES ('113', '10', '联络变风冷控制柜状态显示异常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:00', null);
INSERT INTO `f_risk_factor` VALUES ('114', '10', '呼吸器油杯油位、套管油位、开关油位、油枕油位调补变端子箱油温油位未在规定范围内', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:00', null);
INSERT INTO `f_risk_factor` VALUES ('115', '10', '故障录波指示灯指示运行状态异常，打印机异常常，打印纸缺失', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:01', null);
INSERT INTO `f_risk_factor` VALUES ('116', '10', '很大的危险因素', '19', '1', '1245230062576365570', '1530151', '2020-06-28 09:49:01', null);
INSERT INTO `f_risk_factor` VALUES ('117', '10', 'SCADA-系统\n1.中央报警系统故障告警。\n2.OWS上各界面显示异常。\n3.站控制监视系统屏柜内设备运行声音异常\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:01', null);
INSERT INTO `f_risk_factor` VALUES ('118', '10', '消防系统-火灾检测：火灾报警后台上有报警。\n', '1', '1', '1245230062576365570', '1530151', '2020-06-28 09:49:02', null);
INSERT INTO `f_risk_factor` VALUES ('119', '10', '\"图像监控系统：\n1.视频监控显示器显示、切换异常，摄像机控制不灵活。\n2.视频主机屏上指示灯异常，网络连接断开，交换机（网桥）指示灯异常。\n3.视频主机屏内设备存在发热、死机等现象。\n\n\"\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:02', null);
INSERT INTO `f_risk_factor` VALUES ('120', '10', '直流控制保护系统面板、板卡等指示灯异常告警。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:02', null);
INSERT INTO `f_risk_factor` VALUES ('121', '10', '直流控制保护系统屏柜内有杂物，凝结水现象\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:03', null);
INSERT INTO `f_risk_factor` VALUES ('122', '10', '\"直流控制保护系统电源开关异常，电源指示异常，接点抖动，异常声响，焦糊味，防火封堵有损。\n\"\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:03', null);
INSERT INTO `f_risk_factor` VALUES ('123', '10', '直流控制保护系统压板、转换开关、按钮有损坏，位置偏移。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:03', null);
INSERT INTO `f_risk_factor` VALUES ('124', '10', '直流控制保护系统屏柜端子排存在放电现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:03', null);
INSERT INTO `f_risk_factor` VALUES ('125', '10', '直流控制保护系统OWS中央发出告警信号。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:03', null);
INSERT INTO `f_risk_factor` VALUES ('126', '10', '母线变形，有异物，跨接线存在过大弧垂和摆动。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('127', '10', '母线终端、连接金具有破损、生锈，接头松动，软连接存在断片。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('128', '10', '母线均压环外观正常。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('129', '10', '瓷裙放电现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('130', '10', '瓷裙、法兰裂纹、破损现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('131', '10', '高压瓷柱绝缘支柱倾斜。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('132', '10', '设备法兰及铁件等部分出现裂纹、裂缝现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('133', '10', '互感器本体有异常声响、震动和气味有渗漏油现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:05', null);
INSERT INTO `f_risk_factor` VALUES ('134', '10', '互感器本体有异物悬挂\n', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:05', null);
INSERT INTO `f_risk_factor` VALUES ('135', '10', 'fffff', '1', '2', '1263370637087387649', '1740481', '2020-11-10 18:50:09', null);

-- ----------------------------
-- Table structure for f_risk_level
-- ----------------------------
DROP TABLE IF EXISTS `f_risk_level`;
CREATE TABLE `f_risk_level` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `level` varchar(100) DEFAULT NULL COMMENT '等级',
  `evaluation_model_id` bigint(20) DEFAULT '1' COMMENT '评价模型id',
  `severity` varchar(255) DEFAULT NULL COMMENT '严重度',
  `name` varchar(255) DEFAULT NULL COMMENT '结果描述',
  `color` varchar(255) DEFAULT NULL COMMENT '图标颜色',
  `create_by` varchar(255) DEFAULT '0' COMMENT '维护人员',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `top_limit` decimal(10,2) DEFAULT NULL COMMENT '上限',
  `down_limit` decimal(10,2) DEFAULT NULL COMMENT '下限',
  `manage_level` tinyint(4) DEFAULT NULL COMMENT '管控级别',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='风险等级表';

-- ----------------------------
-- Records of f_risk_level
-- ----------------------------
INSERT INTO `f_risk_level` VALUES ('1', '10', '1', null, '大', '1级', '红色', '1666891', '2020-08-03 09:29:07', null, '1000.00', '501.00', '1');
INSERT INTO `f_risk_level` VALUES ('2', '10', '2', null, '较大', '2级', '橙色', '1666891', '2020-06-28 09:42:37', null, '500.00', '101.00', '2');
INSERT INTO `f_risk_level` VALUES ('3', '10', '3', null, '中等', '3级', '黄色', '1666891', '2020-06-28 09:42:38', null, '100.00', '51.00', '3');
INSERT INTO `f_risk_level` VALUES ('4', '10', '4', null, '小', '4级', '蓝色', '2362673', '2020-12-09 14:34:13', null, '50.00', '10.00', '4');
INSERT INTO `f_risk_level` VALUES ('24', '10', '5', null, '很小', '5级', '蓝色', '1713102', '2021-02-04 13:02:30', null, '9.00', '1.00', '4');

-- ----------------------------
-- Table structure for f_risk_source
-- ----------------------------
DROP TABLE IF EXISTS `f_risk_source`;
CREATE TABLE `f_risk_source` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `name` varchar(255) DEFAULT NULL COMMENT '装备名称',
  `position3d` varchar(100) DEFAULT NULL COMMENT '3维坐标',
  `route_path` varchar(2000) DEFAULT NULL COMMENT '路径坐标',
  `ue4_extent` text COMMENT 'ue4缩放',
  `ue4_rotation` text COMMENT 'ue4旋转',
  `ue4_location` text COMMENT 'ue4位置',
  `floor3d` varchar(100) DEFAULT NULL COMMENT '3维楼层',
  `is_indoor` bit(1) NOT NULL DEFAULT b'1' COMMENT '是否室内:0-否；1-是',
  `parent_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '上级编号id',
  `risk_level_id` bigint(20) DEFAULT '0' COMMENT '风险等级id',
  `rpn` decimal(10,2) DEFAULT NULL COMMENT '实时rpn',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_region` varchar(16) DEFAULT NULL,
  `status` varchar(16) DEFAULT NULL COMMENT '状态(正常NORMAL，异常ANOMALY)',
  `source_id` bigint(20) DEFAULT NULL,
  `flicker_frequency` int(11) DEFAULT '0' COMMENT '闪烁频率',
  `increment` decimal(10,2) DEFAULT NULL COMMENT 'rpn增量',
  `rpni` decimal(10,2) DEFAULT NULL COMMENT 'rpni属性',
  `sort_num` int(10) DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `unique_idx_source_id` (`source_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1343932351087284346 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='风险点表';

-- ----------------------------
-- Records of f_risk_source
-- ----------------------------
INSERT INTO `f_risk_source` VALUES ('1', '10', '10000', '驻马店换流站', '', '{\"routePath\":[[17.079148024797885,0.343399992585239,-84.45929764990139],[17.079148024797885,0.343399992585239,-84.45929764990139],[17.81494655571701,1.8589476774618903,-44.693501181995664],[17.81494655571701,1.8589476774618903,-44.693501181995664],[29.555583981591777,4.327830942666742,-44.312174758295846],[29.555583981591777,4.327830942666742,-44.312174758295846],[29.144411095378658,3.998613656115231,-34.15752817812134],[29.144411095378658,3.998613656115231,-34.15752817812134],[61.06120248363433,0.7587837490314427,-34.75475704067761],[61.06120248363433,0.7587837490314427,-34.75475704067761],[61.21116200592177,2.5130187586109174,-82.53540110937914],[61.21116200592177,2.5130187586109174,-82.53540110937914],[17.02595480267508,1.864093625095427,-84.13885460848527],[17.02595480267508,1.864093625095427,-84.13885460848527],[40.12696697766146,0.5862984921100519,-64.898290297985]],\"regionHeigth\":10}', '[9643,6499,500]', '[]', '[]', '1', '\0', '0', '2', '400.00', null, '1726318', '2020-08-17 09:41:09', 'TRUE', 'NORMAL', null, null, '0.00', '100.00', '99');
-- ----------------------------
-- Table structure for f_rpn_change_log
-- ----------------------------
DROP TABLE IF EXISTS `f_rpn_change_log`;
CREATE TABLE `f_rpn_change_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `risk_source_id` bigint(20) NOT NULL COMMENT '风险点id',
  `fmea_id` bigint(20) NOT NULL COMMENT 'fmeaId',
  `rpn` decimal(10,2) DEFAULT NULL COMMENT '实时rpn',
  `rpni` decimal(10,2) DEFAULT NULL COMMENT '固有rpn',
  `type` int(11) DEFAULT '0' COMMENT '变化类型：0-上升；1-下降',
  `trigger_by` bigint(20) DEFAULT '0' COMMENT '触发风险id',
  `trigger_type` varchar(20) DEFAULT NULL COMMENT '触发类型：巡检、告警、评价、删除',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=17811 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='rpn变化流水表';

-- ----------------------------
-- Records of f_rpn_change_log
-- ----------------------------

-- ----------------------------
-- Table structure for f_safety_index_change_log
-- ----------------------------
DROP TABLE IF EXISTS `f_safety_index_change_log`;
CREATE TABLE `f_safety_index_change_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '物理主键',
  `safety_index` decimal(4,1) DEFAULT NULL COMMENT '安全指数',
  `collect_date` date DEFAULT NULL COMMENT '统计日期',
  `org_code` varchar(100) DEFAULT NULL COMMENT '机构',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `Index_org_code` (`org_code`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=382 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='安全指数日流水';

-- ----------------------------
-- Records of f_safety_index_change_log
-- ----------------------------

-- ----------------------------
-- Table structure for f_station_info
-- ----------------------------
DROP TABLE IF EXISTS `f_station_info`;
CREATE TABLE `f_station_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(20) DEFAULT NULL COMMENT '名称',
  `station_code` varchar(32) NOT NULL COMMENT '环流站编码',
  `code` varchar(10) DEFAULT NULL COMMENT '后三位编码',
  `elec_type` tinyint(4) DEFAULT NULL COMMENT '换流站类型：1-发电类型；2-收电类型',
  `use_type` tinyint(4) NOT NULL COMMENT '用途类型:1-电厂升压变电站；2-公用普通变电站；3-公用换流变电站；4-企业自备变电站；5-其他',
  `province_code` varchar(32) DEFAULT NULL COMMENT '省份编码',
  `city_code` varchar(32) DEFAULT NULL COMMENT '市区编码',
  `district_code` varchar(32) DEFAULT NULL COMMENT '区县编码',
  `address` varchar(255) DEFAULT NULL COMMENT '详细地址',
  `status` bit(1) NOT NULL DEFAULT b'0' COMMENT '0-启用；1-停用',
  `longitude` double DEFAULT NULL COMMENT '经度',
  `latitude` double DEFAULT NULL COMMENT '纬度',
  `station_charge_user_id` varchar(50) DEFAULT NULL COMMENT '换流站负责人',
  `safety_charge_user_id` varchar(50) DEFAULT NULL COMMENT '安全负责人',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `create_by` varchar(255) DEFAULT NULL COMMENT '创建人',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `station_charge_user_name` varchar(20) DEFAULT NULL COMMENT '换流站负责人姓名',
  `safety_charge_user_name` varchar(20) DEFAULT NULL COMMENT '安全负责人姓名',
  `create_user_name` varchar(20) DEFAULT NULL COMMENT '创建人姓名',
  `create_user_phone_num` varchar(20) DEFAULT NULL COMMENT '创建人联系方式',
  `station_user_phone_num` varchar(20) DEFAULT NULL COMMENT '换流站负责人联系方式',
  `safety_user_phone_num` varchar(20) DEFAULT NULL COMMENT '安全负责人联系方式',
  `fire_captain_name` varchar(20) DEFAULT NULL COMMENT '驻站消防队队长姓名',
  `fire_captain_phone_num` varchar(20) DEFAULT NULL COMMENT '驻站消防队队长电话',
  `fire_captain_user_id` varchar(20) DEFAULT NULL COMMENT '驻站消防队队长',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `f_station_info_uniq` (`station_code`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='站端信息表';

-- ----------------------------
-- Records of f_station_info
-- ----------------------------
INSERT INTO `f_station_info` VALUES ('21', '灵州换流站', '3610113305', '305', '1', '3', '1296739849038123010', '1296743473197752321', '1296746010378379265', '唐延路35号', '\0', '102.140137', '36.357685', '1749675', '1749675', '2021-04-15 13:52:21', '2268583', null, 'ue4', 'ue4', 'zheng', null, null, null, 'ue4', null, '1749675');

-- ----------------------------
-- Table structure for f_text_plan
-- ----------------------------
DROP TABLE IF EXISTS `f_text_plan`;
CREATE TABLE `f_text_plan` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `app_id` varchar(255) NOT NULL COMMENT '预案id',
  `text_name` varchar(255) NOT NULL DEFAULT '' COMMENT '文本预案名称',
  `file_path` varchar(255) NOT NULL COMMENT '预案路径',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文本预案';

-- ----------------------------
-- Records of f_text_plan
-- ----------------------------

-- ----------------------------
-- Table structure for f_topography_line
-- ----------------------------
DROP TABLE IF EXISTS `f_topography_line`;
CREATE TABLE `f_topography_line` (
  `id` varchar(36) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(255) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(255) DEFAULT NULL,
  `app_id` varchar(32) DEFAULT NULL COMMENT 'appid',
  `clickable` bit(1) DEFAULT NULL COMMENT '可点击',
  `from` varchar(32) DEFAULT NULL COMMENT '起点',
  `has_arrow` bit(1) DEFAULT NULL COMMENT '有箭头',
  `is_dash` bit(1) DEFAULT NULL COMMENT '是虚线',
  `line_color` int(11) DEFAULT NULL COMMENT '线颜色',
  `to` varchar(32) DEFAULT NULL COMMENT '终点',
  `from_port` varchar(32) DEFAULT NULL,
  `to_port` varchar(32) DEFAULT NULL,
  `type` varchar(32) DEFAULT NULL COMMENT '1 领导架构 | 2 任务流程',
  `category` varchar(32) DEFAULT '' COMMENT '类别',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of f_topography_line
-- ----------------------------

-- ----------------------------
-- Table structure for f_topography_node
-- ----------------------------
DROP TABLE IF EXISTS `f_topography_node`;
CREATE TABLE `f_topography_node` (
  `id` varchar(36) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(255) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(255) DEFAULT NULL,
  `category` varchar(32) DEFAULT NULL COMMENT '类别',
  `group` varchar(32) DEFAULT '' COMMENT '分组',
  `is_group` bit(1) DEFAULT NULL COMMENT '是否是组',
  `key` varchar(32) DEFAULT NULL COMMENT 'key',
  `loc` varchar(255) DEFAULT NULL COMMENT '位置',
  `picture` varchar(32) DEFAULT NULL COMMENT '图片',
  `size` varchar(32) DEFAULT NULL COMMENT '大小',
  `source_id` varchar(32) DEFAULT NULL COMMENT '资源id',
  `text` varchar(32) DEFAULT NULL COMMENT '文本',
  `app_id` varchar(32) DEFAULT NULL COMMENT 'appid',
  `type` varchar(32) DEFAULT NULL COMMENT '1 领导架构 | 2 任务流程',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of f_topography_node
-- ----------------------------

-- ----------------------------
-- Table structure for f_topography_node_detail
-- ----------------------------
DROP TABLE IF EXISTS `f_topography_node_detail`;
CREATE TABLE `f_topography_node_detail` (
  `id` varchar(36) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(255) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(255) DEFAULT NULL,
  `node_detail` text COMMENT '详情',
  `nodeid` varchar(36) DEFAULT NULL,
  `nodekey` varchar(32) DEFAULT NULL COMMENT '节点key',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of f_topography_node_detail
-- ----------------------------

-- ----------------------------
-- Table structure for p_app_version
-- ----------------------------
DROP TABLE IF EXISTS `p_app_version`;
CREATE TABLE `p_app_version` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `version` varchar(255) DEFAULT NULL COMMENT '版本号',
  `remark` longtext COMMENT '说明',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `publisher` int(255) DEFAULT NULL COMMENT '发布者id',
  `publisher_name` varchar(255) DEFAULT NULL COMMENT '发布者名称',
  `update_type` int(11) DEFAULT NULL COMMENT '版本更新类型：1.强制更新，2.非强制更新',
  `is_latest_version` bit(1) DEFAULT NULL COMMENT '是否为最新版本',
  `url` longtext COMMENT 'app文件保存路径',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_app_version
-- ----------------------------

-- ----------------------------
-- Table structure for p_catalog_tree
-- ----------------------------
DROP TABLE IF EXISTS `p_catalog_tree`;
CREATE TABLE `p_catalog_tree` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `name` varchar(100) NOT NULL COMMENT '分类名称',
  `order_no` int(11) NOT NULL COMMENT '排序号',
  `parent_id` bigint(20) NOT NULL COMMENT '上级分类id',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_catalog_tree
-- ----------------------------

-- ----------------------------
-- Table structure for p_check
-- ----------------------------
DROP TABLE IF EXISTS `p_check`;
CREATE TABLE `p_check` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录编号',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `user_id` varchar(200) NOT NULL COMMENT '巡检人id，有可能有多个以,隔开',
  `point_id` bigint(20) NOT NULL COMMENT '巡检点id',
  `point_name` varchar(500) DEFAULT '' COMMENT '巡检点名称',
  `check_time` datetime DEFAULT NULL COMMENT '检查时间',
  `upload_time` datetime DEFAULT NULL COMMENT '记录上传时间',
  `error` varchar(1000) DEFAULT NULL COMMENT '不合格项目',
  `device_id` varchar(100) DEFAULT NULL COMMENT '设备编号',
  `longitude` varchar(50) DEFAULT NULL COMMENT '经度',
  `latitude` varchar(50) DEFAULT NULL COMMENT '纬度',
  `address` varchar(500) DEFAULT NULL COMMENT '参考地址',
  `shot_number` int(11) NOT NULL COMMENT '拍照数量',
  `remark` varchar(1000) DEFAULT NULL COMMENT '巡检备注说明',
  `plan_task_id` bigint(20) DEFAULT NULL COMMENT '计划执行编号',
  `route_id` bigint(20) DEFAULT NULL COMMENT '路线编号',
  `route_name` varchar(500) DEFAULT '' COMMENT '线路名称',
  `is_ok` varchar(6) DEFAULT NULL COMMENT '是否合格',
  `score` int(11) DEFAULT NULL COMMENT '评分',
  `plan_id` bigint(20) DEFAULT NULL COMMENT '计划编号',
  `plan_name` varchar(500) DEFAULT '' COMMENT '计划名称',
  `check_mode` varchar(10) DEFAULT NULL COMMENT '巡检方式',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `plan_task_detail_id` bigint(20) DEFAULT NULL COMMENT '执行计划详情id',
  `error_classify` varchar(200) DEFAULT NULL COMMENT '不合格检查项分类',
  `user_name` varchar(200) DEFAULT '' COMMENT '执行人名称',
  `dep_id` varchar(200) DEFAULT '' COMMENT '执行部门ids',
  `dep_name` varchar(200) DEFAULT '' COMMENT '执行部门名称',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `plan_task_id` (`plan_task_id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `complex_id_index` (`user_id`,`point_id`,`plan_task_id`,`route_id`,`plan_id`,`plan_task_detail_id`) USING BTREE,
  KEY `check_time_index` (`check_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=640 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_check
-- ----------------------------

-- ----------------------------
-- Table structure for p_check_input
-- ----------------------------
DROP TABLE IF EXISTS `p_check_input`;
CREATE TABLE `p_check_input` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检记录检查项id',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `check_id` bigint(20) NOT NULL COMMENT '巡检记录id',
  `input_id` bigint(20) NOT NULL COMMENT '检查项id',
  `order_no` int(11) NOT NULL COMMENT '序号',
  `input_value` varchar(1000) DEFAULT NULL COMMENT '输入值',
  `is_ok` varchar(6) NOT NULL COMMENT '是否合格',
  `score` int(11) NOT NULL COMMENT '评分',
  `route_point_item_id` bigint(20) DEFAULT NULL COMMENT '巡检点检查项id',
  `remark` varchar(500) DEFAULT NULL,
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `point_classify_id` bigint(20) DEFAULT NULL COMMENT '检查点扩展分类id',
  `point_classify_name` varchar(100) DEFAULT NULL COMMENT '检查点扩展分类名称',
  `input_name` varchar(1000) DEFAULT NULL COMMENT '检查项名称',
  `danger_handle_state` tinyint(4) DEFAULT NULL COMMENT '隐患处理状态 0：处理中；1：处理完成',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `check_id` (`check_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4333 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_check_input
-- ----------------------------

-- ----------------------------
-- Table structure for p_check_shot
-- ----------------------------
DROP TABLE IF EXISTS `p_check_shot`;
CREATE TABLE `p_check_shot` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录照片编号',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `check_id` bigint(20) NOT NULL COMMENT '巡检记录id',
  `check_input_id` bigint(20) DEFAULT NULL,
  `shot_type` varchar(4) NOT NULL COMMENT '拍照类型',
  `photo_data` text COMMENT '照片内容',
  `point_name` varchar(100) DEFAULT NULL COMMENT '拍照点名称',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `classify_id` bigint(20) DEFAULT NULL COMMENT '扩展分类id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_check_shot
-- ----------------------------

-- ----------------------------
-- Table structure for p_config
-- ----------------------------
DROP TABLE IF EXISTS `p_config`;
CREATE TABLE `p_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '配置接口id',
  `des` varchar(50) DEFAULT NULL COMMENT '描述',
  `name` varchar(100) NOT NULL COMMENT '名称',
  `attribute` varchar(500) NOT NULL COMMENT '属性',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_config
-- ----------------------------
INSERT INTO `p_config` VALUES ('2', '主题颜色', 'theme', 'blue', '2019-07-10 00:00:00');
INSERT INTO `p_config` VALUES ('3', 'logo地址', 'logo', 'http://', '2019-07-10 00:00:00');
INSERT INTO `p_config` VALUES ('4', '最新修改时间', 'timestamp', '1559178441', '2019-07-10 00:00:00');
INSERT INTO `p_config` VALUES ('5', '权限服务器地址', 'securityAddress', 'http://198.120.112.182:8800', '2019-07-10 00:00:00');
INSERT INTO `p_config` VALUES ('6', '业务服务地址', 'businessAddress', 'http://198.120.112.182:8082/', '2019-07-10 00:00:00');
INSERT INTO `p_config` VALUES ('7', '升级地址', 'updateAddress', 'http://198.120.112.182:8080/apk/version.json', '2019-07-10 00:00:00');

-- ----------------------------
-- Table structure for p_input_item
-- ----------------------------
DROP TABLE IF EXISTS `p_input_item`;
CREATE TABLE `p_input_item` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(100) NOT NULL COMMENT '机构编码',
  `name` varchar(200) DEFAULT NULL COMMENT '检查项名称',
  `order_no` int(11) DEFAULT NULL COMMENT '排序字段',
  `item_type` varchar(50) NOT NULL COMMENT '检查项类型:文本,选择,数字',
  `is_must` varchar(2) DEFAULT NULL COMMENT '是否必填',
  `is_score` varchar(2) DEFAULT NULL COMMENT '是否评分',
  `default_value` varchar(100) DEFAULT NULL COMMENT '默认值',
  `is_multiline` varchar(2) DEFAULT NULL COMMENT '是否执行多行输入',
  `catalog_id` bigint(20) DEFAULT NULL COMMENT '类型',
  `input_json` longtext,
  `data_json` longtext COMMENT '检查说明',
  `remark` longtext COMMENT '备注',
  `picture_json` longtext COMMENT '拍照配置',
  `create_by` varchar(255) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
  `level` varchar(10) DEFAULT NULL COMMENT '巡检项等级1-5',
  `item_no` varchar(100) NOT NULL COMMENT '检查项编号',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  `basis_json` text COMMENT '标准依据',
  `risk_desc` varchar(500) DEFAULT '' COMMENT '风险描述',
  `input_type` int(10) DEFAULT NULL COMMENT '0.表示手动录入，1.表示规则同步',
  `input_classify` varchar(255) DEFAULT NULL COMMENT '检查点分类',
  `equipment_name` varchar(255) DEFAULT NULL COMMENT '装备定义名称',
  `title` varchar(255) DEFAULT NULL COMMENT '内容',
  `unit` varchar(255) DEFAULT NULL COMMENT '数字项默认值单位',
  `check_method` varchar(255) DEFAULT NULL COMMENT '检查方法',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=243 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_input_item
-- ----------------------------

-- ----------------------------
-- Table structure for p_latent_danger
-- ----------------------------
DROP TABLE IF EXISTS `p_latent_danger`;
CREATE TABLE `p_latent_danger` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `business_key` varchar(255) NOT NULL COMMENT '业务唯一标识',
  `org_code` varchar(255) DEFAULT NULL COMMENT '公司',
  `danger_name` varchar(500) NOT NULL COMMENT '隐患名称',
  `current_flow_record_id` bigint(20) DEFAULT NULL COMMENT '当前工作流记录编号',
  `instance_id` varchar(50) DEFAULT NULL COMMENT '工作流实例编号',
  `danger_level` tinyint(4) NOT NULL DEFAULT '1' COMMENT '隐患等级（1：一般隐患；2：重大隐患；0：安全问题）',
  `danger_position` varchar(255) DEFAULT NULL COMMENT '隐患地点',
  `danger_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '隐患类型（1：无码无计划隐患；2：巡检隐患；3：有码无计划隐患；4：随手拍）',
  `remark` text COMMENT '备注',
  `overtime_state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否逾期（0：否；1：是）',
  `reform_type` tinyint(4) DEFAULT NULL COMMENT '整改类型（1：常规整改；2：安措计划；3：延期治理）',
  `reform_limit_date` datetime DEFAULT NULL COMMENT '整改限制时间',
  `reform_json` text COMMENT '整改对象',
  `danger_state` tinyint(4) NOT NULL DEFAULT '1' COMMENT '隐患状态（1：待评审；2：待治理；3：安措计划中；4：待验证；5：治理完毕；6：已撤销；7：延期治理中；8：延期治理待车间部门审核；9：延期治理待公司审核',
  `discoverer_user_id` varchar(255) NOT NULL COMMENT '发现人',
  `discoverer_department_id` varchar(255) DEFAULT NULL COMMENT '发现人部门编号',
  `photo_urls` text COMMENT '图片',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
  `delay_limit_date` datetime DEFAULT NULL COMMENT '延期治理时间',
  `problem_description` varchar(500) DEFAULT NULL COMMENT '问题描述',
  `reason_analysis` varchar(500) DEFAULT NULL COMMENT '原因分析',
  `infer_other_things` varchar(500) DEFAULT NULL COMMENT '举一反三',
  `check_input_id` bigint(20) DEFAULT NULL COMMENT '检查记录创建隐患对应check_input_id',
  `structure_id` bigint(20) DEFAULT NULL COMMENT '建筑ID',
  `structure_name` varchar(255) DEFAULT NULL COMMENT '建筑名称',
  `instance_key` varchar(255) DEFAULT NULL COMMENT '流程实例key',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=212 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='隐患表';

-- ----------------------------
-- Records of p_latent_danger
-- ----------------------------

-- ----------------------------
-- Table structure for p_latent_danger_flow_record
-- ----------------------------
DROP TABLE IF EXISTS `p_latent_danger_flow_record`;
CREATE TABLE `p_latent_danger_flow_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `danger_id` bigint(20) NOT NULL COMMENT '隐患编号',
  `action_flag` varchar(50) NOT NULL COMMENT '执行标志',
  `flow_task_name` varchar(255) DEFAULT NULL COMMENT '当前节点名称',
  `flow_task_user_ids` text COMMENT '当前节点可执行人（多个逗号分开）',
  `flow_task_id` varchar(255) DEFAULT NULL COMMENT '当前节点编号',
  `excute_state` tinyint(4) NOT NULL DEFAULT '1' COMMENT '执行状态（1：未执行；2：通过；3：驳回）',
  `excute_user_id` varchar(255) DEFAULT NULL COMMENT '执行人',
  `excute_department_id` varchar(255) DEFAULT NULL COMMENT '执行部门编号',
  `excute_result` varchar(255) DEFAULT NULL COMMENT '执行结果',
  `remark` text COMMENT '备注',
  `flow_json` text COMMENT '上传数据',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=269 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='隐患工作流记录表';

-- ----------------------------
-- Records of p_latent_danger_flow_record
-- ----------------------------

-- ----------------------------
-- Table structure for p_latent_danger_patrol
-- ----------------------------
DROP TABLE IF EXISTS `p_latent_danger_patrol`;
CREATE TABLE `p_latent_danger_patrol` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `latent_danger_id` bigint(20) DEFAULT NULL COMMENT '隐患编号',
  `point_classify_id` bigint(20) DEFAULT NULL COMMENT '巡检项分类编号',
  `check_id` bigint(20) DEFAULT NULL COMMENT '检查记录编号',
  `item_id` bigint(20) DEFAULT NULL COMMENT '巡检项编号',
  `risk_factor_flow_id` varchar(255) DEFAULT NULL COMMENT '风险因素工作流编号',
  `point_id` bigint(20) DEFAULT NULL COMMENT '巡检点编号',
  `route_id` bigint(20) DEFAULT NULL COMMENT '巡检路线编号',
  `route_point_item_id` bigint(20) DEFAULT NULL COMMENT '路线、点、检查项关联编号',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='隐患巡检关系表';

-- ----------------------------
-- Records of p_latent_danger_patrol
-- ----------------------------

-- ----------------------------
-- Table structure for p_latent_danger_photo
-- ----------------------------
DROP TABLE IF EXISTS `p_latent_danger_photo`;
CREATE TABLE `p_latent_danger_photo` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `biz_code` varchar(255) DEFAULT NULL COMMENT '类型编码',
  `url` varchar(500) DEFAULT NULL COMMENT '图片路径',
  `biz_id` bigint(20) DEFAULT NULL COMMENT '业务编号',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_latent_danger_id` (`biz_id`) USING BTREE COMMENT '隐患编号索引'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='隐患图片';

-- ----------------------------
-- Records of p_latent_danger_photo
-- ----------------------------

-- ----------------------------
-- Table structure for p_measures
-- ----------------------------
DROP TABLE IF EXISTS `p_measures`;
CREATE TABLE `p_measures` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '管控措施编号',
  `level` varchar(10) DEFAULT NULL COMMENT '风险等级',
  `accident_type` text COMMENT '事故类型',
  `point_id` bigint(20) DEFAULT NULL COMMENT '风险点id',
  `update_by` varchar(255) DEFAULT NULL COMMENT '更新用户id',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `engineering` text COMMENT '工程措施',
  `management` text COMMENT '管理措施',
  `train` text COMMENT '培训教育',
  `protection` text COMMENT '个体防护',
  `disposal` text COMMENT '应急处置',
  `is_del` int(11) DEFAULT '0' COMMENT '是否删除',
  `risk_factors` text COMMENT '风险因素',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_measures
-- ----------------------------

-- ----------------------------
-- Table structure for p_msg
-- ----------------------------
DROP TABLE IF EXISTS `p_msg`;
CREATE TABLE `p_msg` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '公司orgCode',
  `title` varchar(255) NOT NULL COMMENT '消息标题',
  `body` text NOT NULL COMMENT '内容',
  `msg_type` varchar(255) NOT NULL COMMENT '消息类型',
  `status` int(4) DEFAULT NULL COMMENT '发送状态',
  `send_time` datetime DEFAULT NULL COMMENT '发送时间',
  `relation_id` bigint(20) DEFAULT NULL COMMENT '关联id',
  `is_immediately` bit(1) DEFAULT b'1' COMMENT '是否立即发送',
  `fixed_time` datetime DEFAULT NULL COMMENT '定点发送时间',
  `create_by` varchar(255) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_read` bit(1) DEFAULT b'0' COMMENT '是否已读',
  `target_tel` varchar(500) DEFAULT NULL,
  `reciver_name` varchar(255) DEFAULT NULL COMMENT '接受人名称',
  `user_id` varchar(255) DEFAULT NULL COMMENT '接收人id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6390 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_msg
-- ----------------------------

-- ----------------------------
-- Table structure for p_msg_subscribe
-- ----------------------------
DROP TABLE IF EXISTS `p_msg_subscribe`;
CREATE TABLE `p_msg_subscribe` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(50) NOT NULL COMMENT '公司code',
  `user_id` varchar(255) NOT NULL COMMENT '用户ID',
  `msg_type` varchar(255) NOT NULL COMMENT '消息类型',
  `attribute1` varchar(255) DEFAULT NULL COMMENT '属性1',
  `attribute2` varchar(255) DEFAULT NULL COMMENT '属性2',
  `attribute3` varchar(255) DEFAULT NULL COMMENT '属性3',
  `attribute4` varchar(255) DEFAULT NULL COMMENT '属性4',
  `attribute5` varchar(255) DEFAULT NULL COMMENT '属性5',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_msg_subscribe
-- ----------------------------

-- ----------------------------
-- Table structure for p_plan
-- ----------------------------
DROP TABLE IF EXISTS `p_plan`;
CREATE TABLE `p_plan` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '计划编号',
  `name` varchar(100) NOT NULL COMMENT '计划名称',
  `org_code` varchar(100) NOT NULL COMMENT '公司Id',
  `dept_id` varchar(225) DEFAULT NULL COMMENT '部门id',
  `route_id` bigint(20) NOT NULL COMMENT '路线编号',
  `plan_type` varchar(50) NOT NULL COMMENT '计划类型：1-日，2-周，3-月，4-年',
  `is_fixed_date` varchar(2) NOT NULL COMMENT '是否固定巡检日期：0-否；1-是',
  `in_order` varchar(2) DEFAULT '0' COMMENT '是否必须按照顺序执行：0-否；1-是',
  `plan_begin` date DEFAULT NULL COMMENT '计划开始日期',
  `plan_end` date DEFAULT NULL COMMENT '计划结束日期',
  `day_rate` int(11) DEFAULT NULL COMMENT '每天频率：0-一次；1-多次',
  `day_time` time DEFAULT NULL COMMENT '开始时间（执行频率为一次时，使用）',
  `day_interval` int(11) DEFAULT NULL COMMENT '执行间隔（每天执行频率为多次时使用）',
  `day_interval_unit` varchar(50) DEFAULT NULL COMMENT '执行间隔单位：1-小时，2-分钟，3-秒',
  `day_begin` time DEFAULT NULL COMMENT '开始时间',
  `day_end` time DEFAULT NULL COMMENT '结束时间',
  `execute_interval` int(11) DEFAULT NULL COMMENT '执行间隔',
  `month_type` varchar(50) DEFAULT NULL COMMENT '月执行类型：1-第，2-在',
  `what_day` varchar(50) DEFAULT NULL COMMENT '哪一天',
  `what_week` int(11) DEFAULT NULL COMMENT '第几周',
  `week_day` int(11) DEFAULT NULL COMMENT '周几',
  `duration` int(11) DEFAULT NULL COMMENT '工作时长（分钟）',
  `user_id` varchar(500) DEFAULT NULL COMMENT '用户编号',
  `execute_rate` int(11) DEFAULT NULL COMMENT '执行频率（年计划使用）',
  `week_begin_num` int(11) DEFAULT NULL COMMENT '开始编号',
  `week_end_num` int(11) DEFAULT NULL COMMENT '结束编号',
  `min_space` int(11) DEFAULT NULL COMMENT '最少间隔',
  `is_score` varchar(2) DEFAULT NULL COMMENT '是否评分',
  `score_formula` varchar(512) DEFAULT NULL COMMENT '评分计算公式',
  `status` tinyint(4) DEFAULT '0' COMMENT '状态:0-正常；1-已停用',
  `error` bigint(10) DEFAULT '0' COMMENT '允许误差(分钟)',
  `next_gen_date` date DEFAULT NULL COMMENT '下次任务生成日期',
  `create_by` int(11) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `last_upd_by` int(11) DEFAULT NULL COMMENT '最近更新者',
  `last_upd_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '最近更新时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `remark1` varchar(255) DEFAULT NULL COMMENT '备注1',
  `remark2` varchar(255) DEFAULT NULL COMMENT '备注2',
  `first_flag` int(4) DEFAULT '0' COMMENT '初始状态标识：0-首次 1-其他',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  `plan_task_id` bigint(20) DEFAULT '0' COMMENT '最新任务id',
  `is_single_execution` bit(1) DEFAULT b'0' COMMENT '是否单人执行:0多人执行；1单人执行',
  `user_dept` text COMMENT '冗余用户部门',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_org_code_route_id` (`org_code`,`route_id`) USING BTREE,
  KEY `idx_is_stop_next_gen_date` (`status`,`next_gen_date`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_plan
-- ----------------------------

-- ----------------------------
-- Table structure for p_plan_exec_statistics
-- ----------------------------
DROP TABLE IF EXISTS `p_plan_exec_statistics`;
CREATE TABLE `p_plan_exec_statistics` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `check_time` varchar(40) NOT NULL COMMENT '巡检日期',
  `org_code` varchar(255) NOT NULL COMMENT '计划任务执行人orgCode',
  `user_id` varchar(50) NOT NULL COMMENT '用户ID',
  `plan_task_num` int(11) DEFAULT NULL COMMENT '计划执行个数',
  `exec_plan_task_num` int(11) DEFAULT '0' COMMENT '计划执行完成个数',
  `missed_check_num` int(11) DEFAULT '0' COMMENT '漏检个数',
  `outside_plan_num` int(11) DEFAULT '0' COMMENT '计划外执行个数',
  PRIMARY KEY (`id`,`org_code`,`user_id`,`check_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=613 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of p_plan_exec_statistics
-- ----------------------------

-- ----------------------------
-- Table structure for p_plan_task
-- ----------------------------
DROP TABLE IF EXISTS `p_plan_task`;
CREATE TABLE `p_plan_task` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '批次号',
  `batch_no` bigint(20) NOT NULL COMMENT '计划批次号',
  `org_code` varchar(255) DEFAULT NULL COMMENT '计划任务执行人orgCode',
  `plan_id` bigint(20) NOT NULL COMMENT '计划编号',
  `route_id` bigint(20) DEFAULT NULL COMMENT '路线编号',
  `user_id` varchar(500) DEFAULT NULL COMMENT '用户编号',
  `point_num` int(11) DEFAULT NULL COMMENT '巡检点数',
  `finish_num` int(11) DEFAULT '0' COMMENT '已完成巡检点数',
  `check_date` date DEFAULT NULL COMMENT '巡检日期',
  `begin_time` datetime DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束时间',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `finish_status` int(4) DEFAULT '0' COMMENT '完成状态：0-未开始；1-进行中;2-已结束；3-已超时',
  `status` int(4) DEFAULT '0' COMMENT '状态：0-有效；1-无效',
  `in_order` varchar(2) DEFAULT '0' COMMENT '是否必须按照顺序执行：0-否；1-是',
  `user_dept` varchar(255) DEFAULT NULL COMMENT '人员部门信息',
  `user_name` varchar(255) DEFAULT NULL COMMENT '用户姓名',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `plan_id` (`plan_id`) USING BTREE,
  KEY `begin_time` (`begin_time`) USING BTREE,
  KEY `end_time` (`end_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=904 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_plan_task
-- ----------------------------

-- ----------------------------
-- Table structure for p_plan_task_detail
-- ----------------------------
DROP TABLE IF EXISTS `p_plan_task_detail`;
CREATE TABLE `p_plan_task_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务明细编号',
  `task_no` bigint(20) NOT NULL COMMENT '批次号',
  `point_id` bigint(20) NOT NULL COMMENT '点编号',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_finish` int(11) DEFAULT '0' COMMENT '是否完成：0-未完成，1-已完成，2-超时漏检',
  `status` varchar(50) DEFAULT '合格' COMMENT '状态',
  `executor_id` bigint(20) DEFAULT '0' COMMENT '执行人id',
  `executor_date` datetime DEFAULT NULL COMMENT '执行时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `task_no` (`task_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1216 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_plan_task_detail
-- ----------------------------

-- ----------------------------
-- Table structure for p_point
-- ----------------------------
DROP TABLE IF EXISTS `p_point`;
CREATE TABLE `p_point` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '点id',
  `route_id` varchar(1000) DEFAULT NULL COMMENT '路线id',
  `route_name` varchar(1000) DEFAULT NULL COMMENT '路线名称',
  `name` varchar(100) NOT NULL COMMENT '点名称',
  `point_no` varchar(100) NOT NULL DEFAULT '0' COMMENT '编号',
  `remark` varchar(1000) DEFAULT NULL COMMENT '备注说明',
  `save_gps` varchar(10) DEFAULT NULL COMMENT '是否保存地理信',
  `distance` int(11) DEFAULT NULL COMMENT '有效巡检距离',
  `usually_shot` varchar(10) DEFAULT NULL COMMENT '是否允许普通拍照',
  `shot_min_number` int(11) NOT NULL COMMENT '最小拍照数',
  `shot_max_number` int(11) NOT NULL COMMENT '最大拍照数',
  `fixed_shot` int(11) NOT NULL COMMENT '定点拍照数',
  `latitude` varchar(50) DEFAULT NULL COMMENT '经度',
  `longitude` varchar(50) DEFAULT NULL COMMENT '纬度',
  `address` varchar(1000) DEFAULT NULL COMMENT '参考地址',
  `offline` bit(1) DEFAULT NULL COMMENT '是否允许离线巡检:0不支持1支持',
  `is_fixed` varchar(50) DEFAULT NULL COMMENT '是否为固定',
  `catalog_id` int(11) DEFAULT NULL COMMENT '分类编号',
  `extend_json` longtext COMMENT '扩展字段',
  `is_score` varchar(50) DEFAULT NULL COMMENT '无计划巡检是否评分',
  `level` varchar(100) NOT NULL DEFAULT '1' COMMENT '风险等级',
  `last_update_time` datetime DEFAULT NULL COMMENT '最新更新时间',
  `creator_id` varchar(255) NOT NULL COMMENT '创建用户id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `coordinates` varchar(100) DEFAULT NULL COMMENT '3维坐标',
  `ue4_location` text COMMENT 'ue4旋转',
  `ue4_rotation` text COMMENT 'ue4旋转',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
  `charge_dept_id` varchar(255) DEFAULT '0' COMMENT '责任部门id',
  `charge_person_id` varchar(255) DEFAULT NULL COMMENT '负责人id',
  `status` varchar(50) DEFAULT '0' COMMENT '状态：0 未纳入巡检，1 合格；2 不合格；3 漏检',
  `floor` int(4) DEFAULT '1' COMMENT '3维模型楼层',
  `error` varchar(1000) DEFAULT NULL COMMENT '最新不合格信息',
  `check_time` datetime DEFAULT NULL COMMENT '最新检查时间',
  `is_indoor` bit(1) DEFAULT b'0' COMMENT '是否室内：0表示室外，1表示室内',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  `risk_source_id` varchar(255) DEFAULT NULL COMMENT '风险区域id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_point
-- ----------------------------

-- ----------------------------
-- Table structure for p_point_classify
-- ----------------------------
DROP TABLE IF EXISTS `p_point_classify`;
CREATE TABLE `p_point_classify` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检点分类id',
  `point_id` bigint(20) NOT NULL COMMENT '点id',
  `name` varchar(100) NOT NULL COMMENT '点分类名称',
  `creator_id` varchar(255) NOT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `order_no` int(11) DEFAULT NULL COMMENT '排序号',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  `equipment_id` varchar(255) DEFAULT NULL COMMENT '装备id',
  `inspection_spec_name` varchar(255) DEFAULT NULL COMMENT '巡查规范名称',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `point_id_index` (`point_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=191 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_point_classify
-- ----------------------------

-- ----------------------------
-- Table structure for p_point_config
-- ----------------------------
DROP TABLE IF EXISTS `p_point_config`;
CREATE TABLE `p_point_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(1000) DEFAULT NULL COMMENT '转发名称',
  `point_id` bigint(20) DEFAULT NULL COMMENT '巡检点ID',
  `point_code` varchar(255) DEFAULT NULL COMMENT '点编码',
  `infomation_address` int(20) DEFAULT NULL COMMENT '转发信息地址依次递增（唯一）',
  `status` bit(1) DEFAULT NULL COMMENT '巡检点状态（code=0时，status=1漏检，status=0正常；code=1时，status=1不合格，status=0合格）',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否已经删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=519 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_point_config
-- ----------------------------

-- ----------------------------
-- Table structure for p_point_inputitem
-- ----------------------------
DROP TABLE IF EXISTS `p_point_inputitem`;
CREATE TABLE `p_point_inputitem` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `point_id` bigint(20) NOT NULL COMMENT '巡检点id',
  `input_item_id` bigint(20) NOT NULL COMMENT '巡检项id',
  `classify_ids` varchar(255) DEFAULT NULL COMMENT '点分类id集合',
  `order_no` int(11) DEFAULT NULL COMMENT '排序号',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=629 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_point_inputitem
-- ----------------------------

-- ----------------------------
-- Table structure for p_point_photo
-- ----------------------------
DROP TABLE IF EXISTS `p_point_photo`;
CREATE TABLE `p_point_photo` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检点图片编号',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `point_id` bigint(20) NOT NULL COMMENT '巡检点id',
  `order_no` int(11) NOT NULL COMMENT '序号',
  `photo_path` varchar(200) DEFAULT NULL COMMENT '图片路径',
  `file_name` varchar(200) DEFAULT NULL COMMENT '图片名称',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_point_photo
-- ----------------------------

-- ----------------------------
-- Table structure for p_route
-- ----------------------------
DROP TABLE IF EXISTS `p_route`;
CREATE TABLE `p_route` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检路线id',
  `creator_id` varchar(255) NOT NULL COMMENT '创建人id',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `name` varchar(50) NOT NULL COMMENT '路线名称',
  `boss` varchar(255) DEFAULT NULL COMMENT '负责人',
  `tel` varchar(50) DEFAULT NULL COMMENT '联系电话',
  `remark` varchar(1000) DEFAULT NULL COMMENT '备注说明',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `coordinates` varchar(500) DEFAULT NULL COMMENT '路线3维坐标',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
  `dept_id` varchar(255) DEFAULT '0',
  `user_id` varchar(255) DEFAULT '0',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_route
-- ----------------------------

-- ----------------------------
-- Table structure for p_route_point
-- ----------------------------
DROP TABLE IF EXISTS `p_route_point`;
CREATE TABLE `p_route_point` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(100) NOT NULL COMMENT '权限org code',
  `route_id` bigint(20) NOT NULL COMMENT '路线id',
  `point_id` bigint(20) NOT NULL COMMENT '点id',
  `order_no` int(11) DEFAULT '0' COMMENT '排序',
  `creator_id` varchar(255) NOT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `exclude_items` varchar(1000) DEFAULT NULL COMMENT '巡查项排除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_route_point
-- ----------------------------

-- ----------------------------
-- Table structure for p_route_point_item
-- ----------------------------
DROP TABLE IF EXISTS `p_route_point_item`;
CREATE TABLE `p_route_point_item` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `route_point_id` bigint(20) NOT NULL COMMENT '路线点id',
  `order_no` int(11) DEFAULT NULL COMMENT '排序号',
  `point_input_item_id` bigint(20) DEFAULT NULL COMMENT '检查点-项id',
  `creator_id` varchar(255) DEFAULT NULL,
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `point_classify_id` bigint(20) DEFAULT NULL COMMENT '检查点扩展分类id',
  `basis_json` text COMMENT '标准依据',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=158 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_route_point_item
-- ----------------------------

-- ----------------------------
-- Table structure for p_task
-- ----------------------------
DROP TABLE IF EXISTS `p_task`;
CREATE TABLE `p_task` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `org_code` varchar(100) DEFAULT NULL COMMENT '公司id',
  `title` varchar(500) DEFAULT NULL COMMENT '任务标题',
  `publisher` varchar(255) DEFAULT NULL COMMENT '任务发布人id',
  `dep_id` varchar(255) DEFAULT NULL COMMENT '执行人部门',
  `publisher_name` varchar(40) DEFAULT NULL COMMENT '任务发布人名称',
  `publish_time` datetime DEFAULT NULL COMMENT '任务发布时间',
  `finish_time` datetime DEFAULT NULL COMMENT '任务应该完成时间',
  `fact_finish_time` datetime DEFAULT NULL COMMENT '任务实际完成时间',
  `is_warn` varchar(50) DEFAULT NULL COMMENT '是否告警通知（1 通知 ； 2 不通知 ）',
  `status` int(11) DEFAULT NULL COMMENT '任务状态0 处理中，1已完成2取消3超时',
  `warn_time` datetime DEFAULT NULL COMMENT '告警通知时间',
  `feedback_num` int(11) DEFAULT NULL COMMENT '回复个数',
  `executor` varchar(2000) DEFAULT NULL COMMENT '任务执行人',
  `depth` int(11) DEFAULT NULL COMMENT '当前任务发转次数',
  `max_depth` int(11) DEFAULT NULL COMMENT '任务最大转发次数',
  `remark` varchar(1000) DEFAULT NULL COMMENT '说明',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `config` longtext COMMENT '任务拍照配置',
  `executor_id` varchar(255) NOT NULL,
  `check_id` bigint(20) DEFAULT '0' COMMENT '任务关联检查项ID',
  `point_id` bigint(11) DEFAULT '0' COMMENT '任务关联巡检点id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `check_id_index` (`check_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_task
-- ----------------------------

-- ----------------------------
-- Table structure for p_task_detail
-- ----------------------------
DROP TABLE IF EXISTS `p_task_detail`;
CREATE TABLE `p_task_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) DEFAULT NULL COMMENT '任务id',
  `item_id` bigint(20) DEFAULT NULL COMMENT '检查项ID',
  `check_id` bigint(20) DEFAULT NULL COMMENT '检查记录id',
  `status` int(11) DEFAULT NULL COMMENT '任务相状态（1.完成，2.未完成，3.执行中）',
  `remark` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `point_id` bigint(20) DEFAULT NULL COMMENT '巡检点ID',
  `route_id` bigint(20) DEFAULT NULL COMMENT '路线ID',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_task_detail
-- ----------------------------

-- ----------------------------
-- Table structure for p_task_feedback
-- ----------------------------
DROP TABLE IF EXISTS `p_task_feedback`;
CREATE TABLE `p_task_feedback` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(100) NOT NULL COMMENT '组织编码',
  `task_id` bigint(20) NOT NULL COMMENT '任务ID',
  `user_id` varchar(255) NOT NULL COMMENT '任务回复人ID',
  `user_name` varchar(50) NOT NULL COMMENT '任务回复人名称',
  `feedback_time` datetime NOT NULL COMMENT '回复时间',
  `message` text COMMENT '任务回复信息',
  `picture_number` int(11) DEFAULT NULL COMMENT '拍照个数',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `message_type` varchar(20) DEFAULT NULL COMMENT '任务类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_task_feedback
-- ----------------------------

-- ----------------------------
-- Table structure for p_task_forward_log
-- ----------------------------
DROP TABLE IF EXISTS `p_task_forward_log`;
CREATE TABLE `p_task_forward_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) DEFAULT NULL COMMENT '任务ID',
  `executor` varchar(255) DEFAULT NULL COMMENT '任务执行人',
  `executor_id` varchar(255) DEFAULT NULL,
  `created_by` bigint(20) DEFAULT NULL COMMENT '记录创建者',
  `content` varchar(2000) DEFAULT NULL COMMENT '任务转发记录详情',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_task_forward_log
-- ----------------------------

-- ----------------------------
-- Table structure for p_task_picture
-- ----------------------------
DROP TABLE IF EXISTS `p_task_picture`;
CREATE TABLE `p_task_picture` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(100) NOT NULL COMMENT '组织编码',
  `task_id` bigint(20) NOT NULL COMMENT '任务ID',
  `feedback_id` bigint(20) NOT NULL COMMENT '任务回复ID',
  `photo_data` longtext NOT NULL COMMENT '回复照片',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_task_picture
-- ----------------------------

-- ----------------------------
-- Table structure for toip_rm_snapshot
-- ----------------------------
DROP TABLE IF EXISTS `toip_rm_snapshot`;
CREATE TABLE `toip_rm_snapshot` (
  `id` varchar(36) NOT NULL,
  `batch_no` varchar(36) NOT NULL COMMENT '规则执行的批次号',
  `package_id` varchar(36) DEFAULT NULL COMMENT '规则id',
  `method_class` varchar(255) NOT NULL COMMENT 'bean方法的类名',
  `method_name` varchar(255) NOT NULL COMMENT 'bean方法名',
  `equipment_id` varchar(32) DEFAULT NULL COMMENT '设备类型',
  `method_param` varchar(2000) DEFAULT NULL COMMENT '方法参数',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `create_millisecond` varchar(64) NOT NULL COMMENT '当前动作执行时的毫秒数',
  `previous_interval` bigint(20) NOT NULL COMMENT '与上一次的动作执行的时间差',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of toip_rm_snapshot
-- ----------------------------

-- ----------------------------
-- Table structure for toip_sys_log
-- ----------------------------
DROP TABLE IF EXISTS `toip_sys_log`;
CREATE TABLE `toip_sys_log` (
  `id` varchar(36) DEFAULT NULL,
  `time` datetime DEFAULT NULL COMMENT '时间',
  `context` text COMMENT '内容',
  `type` varchar(36) DEFAULT NULL COMMENT '类型',
  `biz_id` varchar(36) DEFAULT NULL COMMENT '业务表id',
  `bizclass_name` varchar(255) DEFAULT NULL COMMENT '实体名，例如com.yeejoin.amos.toip.bizrulebridge.entity.Fire',
  `ip` varchar(20) DEFAULT NULL COMMENT 'ip',
  `result` varchar(255) DEFAULT NULL COMMENT '结果',
  `remark` text COMMENT '备注，预留字段',
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(50) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(50) DEFAULT NULL,
  `action_id` varchar(36) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='日志表';

-- ----------------------------
-- Records of toip_sys_log
-- ----------------------------

-- ----------------------------
-- Table structure for toip_sys_message
-- ----------------------------
DROP TABLE IF EXISTS `toip_sys_message`;
CREATE TABLE `toip_sys_message` (
  `id` varchar(36) DEFAULT NULL,
  `time` datetime DEFAULT NULL COMMENT '时间',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `content` longtext COMMENT '内容',
  `type` varchar(36) DEFAULT NULL COMMENT '类型',
  `sender` varchar(255) DEFAULT NULL COMMENT '发送者',
  `receiver` varchar(255) DEFAULT NULL COMMENT '接受者',
  `reader` varchar(255) DEFAULT NULL COMMENT '阅读者',
  `biz_id` varchar(36) DEFAULT NULL COMMENT '业务关联表id',
  `bizclass_name` varchar(255) DEFAULT NULL COMMENT '实体名，例如com.yeejoin.amos.toip.bizrulebridge.entity.Fire',
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(50) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(50) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消息表';

-- ----------------------------
-- Records of toip_sys_message
-- ----------------------------

-- ----------------------------
-- Table structure for wl_building
-- ----------------------------
DROP TABLE IF EXISTS `wl_building`;
CREATE TABLE `wl_building` (
  `id` bigint(20) NOT NULL COMMENT '主键',
  `code` char(20) NOT NULL COMMENT '编码',
  `name` char(100) NOT NULL COMMENT '名称',
  `address` char(255) DEFAULT NULL COMMENT '地址',
  `equipment_code` char(20) NOT NULL COMMENT '类型（数据来自于装备定义--其他类消防装备器材--消防重点部位下面的选项）',
  `system_id` bigint(20) DEFAULT NULL COMMENT '数据来自于消防设施系统列表',
  `area_measure` double DEFAULT NULL COMMENT '面积(㎡)',
  `height` double DEFAULT NULL COMMENT '高度/最大液位(㎡)',
  `warn_height` double DEFAULT NULL COMMENT '告警液位(㎡)',
  `region_id` bigint(20) NOT NULL COMMENT '区域id',
  `region_name` char(100) NOT NULL COMMENT '区域名称',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `creator_name` char(100) DEFAULT NULL COMMENT '创建人名',
  `company_name` char(100) DEFAULT NULL COMMENT '公司名称',
  `org_code` char(100) DEFAULT NULL COMMENT '公司code',
  `department_name` char(100) DEFAULT NULL COMMENT '部门名称',
  `department_orgcode` char(100) DEFAULT NULL COMMENT '部门code',
  `equipment_category_name` char(100) DEFAULT NULL COMMENT '分类名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wl_building
-- ----------------------------

-- ----------------------------
-- Table structure for wl_car
-- ----------------------------
DROP TABLE IF EXISTS `wl_car`;
CREATE TABLE `wl_car` (
  `id` bigint(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `car_num` varchar(32) DEFAULT NULL COMMENT '车牌号',
  `equipment_id` bigint(20) DEFAULT NULL COMMENT '车辆类型',
  `standard` varchar(255) DEFAULT NULL COMMENT '规格型号',
  `car_state` char(20) DEFAULT NULL COMMENT '车辆状态',
  `brand` varchar(255) DEFAULT NULL COMMENT '品牌',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `manufacturer_id` bigint(20) DEFAULT NULL COMMENT '厂商id',
  `chassis_country` varchar(50) DEFAULT NULL COMMENT '底盘国别',
  `chassis_brand` varchar(50) DEFAULT NULL COMMENT '底盘品牌',
  `is_import` tinyint(50) DEFAULT NULL COMMENT '进口国产\r\n',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '负责人',
  `country` varchar(255) DEFAULT NULL COMMENT '国别',
  `qr_code` varchar(225) DEFAULT NULL COMMENT '车辆二维码',
  `org_code` varchar(255) DEFAULT NULL COMMENT '组织机构',
  `company_name` varchar(255) DEFAULT NULL COMMENT '公司名',
  `department_orgcode` varchar(255) DEFAULT NULL COMMENT '部门code',
  `department_name` varchar(255) DEFAULT NULL COMMENT '部门名',
  `create_date` datetime DEFAULT NULL,
  `maintenance_cycle` decimal(18,0) DEFAULT NULL COMMENT '保养周期',
  `ccc_auth` tinyint(4) DEFAULT NULL COMMENT '3c认证',
  `iot_code` char(100) DEFAULT NULL COMMENT '物联编码',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `car_state_id` (`car_state`) USING BTREE,
  KEY `country_id` (`country`) USING BTREE,
  KEY `manufacturer_id` (`manufacturer_id`) USING BTREE,
  KEY `ix_car_for_equipment_id` (`equipment_id`) USING BTREE,
  KEY `ix_car_for_charge_user_id` (`creator_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防车信息';

-- ----------------------------
-- Records of wl_car
-- ----------------------------

-- ----------------------------
-- Table structure for wl_car_property
-- ----------------------------
DROP TABLE IF EXISTS `wl_car_property`;
CREATE TABLE `wl_car_property` (
  `id` bigint(20) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `car_id` bigint(20) NOT NULL COMMENT '车辆id',
  `value` text COMMENT '指标值',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `equipment_index_id` bigint(20) DEFAULT NULL COMMENT '指标id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='车辆性能指标';

-- ----------------------------
-- Records of wl_car_property
-- ----------------------------

-- ----------------------------
-- Table structure for wl_common_tree
-- ----------------------------
DROP TABLE IF EXISTS `wl_common_tree`;
CREATE TABLE `wl_common_tree` (
  `id` bigint(20) NOT NULL,
  `name` varchar(100) NOT NULL COMMENT '名称',
  `tree_type` varchar(50) DEFAULT NULL COMMENT '树类型（定义不同的树）',
  `code` varchar(50) NOT NULL COMMENT '编号(前端绑定风险模型时使用到)',
  `node_type` varchar(50) DEFAULT NULL COMMENT '节点类型（单位、设备、建筑、区域）',
  `parent_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '父级id',
  `icon` varchar(50) DEFAULT NULL COMMENT '图标',
  `sort` int(11) DEFAULT '1' COMMENT '排序',
  `create_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `unique_idx_tree_node_type_code` (`tree_type`,`node_type`,`code`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='公共树表';

-- ----------------------------
-- Records of wl_common_tree
-- ----------------------------

-- ----------------------------
-- Table structure for wl_dynamic_form_column
-- ----------------------------
DROP TABLE IF EXISTS `wl_dynamic_form_column`;
CREATE TABLE `wl_dynamic_form_column` (
  `id` bigint(20) NOT NULL,
  `field_name` varchar(100) NOT NULL COMMENT '字段名',
  `field_label` varchar(100) NOT NULL COMMENT '中文名',
  `data_type` varchar(100) NOT NULL COMMENT '数据类型：文本，数字，枚举,日期',
  `group_id` bigint(20) NOT NULL COMMENT '字段分组主键',
  `query_strategy` varchar(100) DEFAULT NULL COMMENT '查询策略;全等,模糊,区间',
  `not_null` bit(1) NOT NULL DEFAULT b'0' COMMENT '不能为空',
  `is_must` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否必须：0-否；1-是；控制是否可勾选掉字段，暂时没用到标准版使用',
  `group_type` varchar(20) NOT NULL COMMENT '分组类型',
  `group_code` varchar(50) NOT NULL COMMENT '所属分组编号',
  `data_source` json DEFAULT NULL COMMENT '配置json',
  `remark` varchar(255) DEFAULT NULL COMMENT '提示信息',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `unique_idx_code_type_name` (`group_type`,`group_code`,`field_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='动态表单树形分组字段表';

-- ----------------------------
-- Records of wl_dynamic_form_column
-- ----------------------------

-- ----------------------------
-- Table structure for wl_dynamic_form_group
-- ----------------------------
DROP TABLE IF EXISTS `wl_dynamic_form_group`;
CREATE TABLE `wl_dynamic_form_group` (
  `id` bigint(20) NOT NULL COMMENT '物理主键',
  `group_name` varchar(100) NOT NULL COMMENT '分组名称',
  `group_code` varchar(50) NOT NULL COMMENT '分组编号',
  `group_type` varchar(20) NOT NULL DEFAULT '' COMMENT '分组类型',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '父级id',
  `relation_id` bigint(20) DEFAULT NULL COMMENT '关联id(在数据有关联关系时使用)',
  `group_config` json DEFAULT NULL COMMENT '分组配置',
  `org_code` varchar(255) DEFAULT NULL COMMENT '组织机构',
  `is_must` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否必须：0-否；1-是；控制前端tab是否可勾选掉',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '更新者id',
  `create_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `unique_idx_group_code` (`group_type`,`group_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='动态表单树形分组表';

-- ----------------------------
-- Records of wl_dynamic_form_group
-- ----------------------------

-- ----------------------------
-- Table structure for wl_dynamic_form_instance
-- ----------------------------
DROP TABLE IF EXISTS `wl_dynamic_form_instance`;
CREATE TABLE `wl_dynamic_form_instance` (
  `id` bigint(20) NOT NULL,
  `field_name` varchar(100) NOT NULL COMMENT '字段名',
  `field_label` varchar(100) NOT NULL COMMENT '中文名',
  `data_type` varchar(100) NOT NULL COMMENT '数据类型：文本，数字，枚举,日期',
  `group_type` varchar(20) NOT NULL COMMENT '分组类型(冗余字段便于查询）',
  `group_code` varchar(100) NOT NULL COMMENT '分组编号',
  `group_id` bigint(20) NOT NULL COMMENT '字段分组id',
  `field_value` varchar(1024) DEFAULT NULL COMMENT '动态配置字段的值',
  `instance_id` bigint(20) NOT NULL COMMENT '设备实例id',
  `form_column_id` bigint(20) NOT NULL COMMENT '字段定义信息的主键',
  `query_strategy` varchar(100) DEFAULT NULL COMMENT '查询策略;全等,模糊,区间',
  `creator_id` bigint(20) NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `u_idx_instance_id` (`instance_id`,`group_code`,`field_name`,`group_type`) USING BTREE,
  KEY `idx_group_code` (`group_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='动态表单实例表';

-- ----------------------------
-- Records of wl_dynamic_form_instance
-- ----------------------------

-- ----------------------------
-- Table structure for wl_equipment
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment`;
CREATE TABLE `wl_equipment` (
  `id` bigint(20) NOT NULL,
  `name` varchar(50) NOT NULL COMMENT '名称',
  `code` varchar(50) NOT NULL COMMENT '编码',
  `category_id` bigint(20) NOT NULL COMMENT '装备分类id',
  `country` varchar(20) DEFAULT NULL COMMENT '国别',
  `maintenance_cycle` decimal(12,0) DEFAULT NULL COMMENT '保养周期',
  `check_cycle` decimal(12,0) DEFAULT NULL COMMENT '检查周期（天）',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `management_style` bigint(20) DEFAULT NULL COMMENT '管理方式 单件还是批量管理模式，单件S，批量：P',
  `reviser_id` bigint(20) DEFAULT NULL COMMENT '修改人',
  `date_updated` datetime DEFAULT NULL COMMENT '修改时间',
  `creater_id` bigint(20) DEFAULT NULL COMMENT '创建人',
  `unit_id` bigint(20) DEFAULT NULL COMMENT '单位id',
  `made_in` varchar(50) DEFAULT NULL COMMENT '生产源地 0国产1进口9其他',
  `manufacturer` bigint(20) DEFAULT NULL COMMENT '生产厂家',
  `img` varchar(255) DEFAULT NULL COMMENT '头像图片url',
  `video` varchar(20) DEFAULT NULL,
  `mark_specification` text COMMENT '标识规范',
  `supplier_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `pref_quota` text COMMENT '非核心指标内容',
  `create_date` datetime DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL COMMENT '公司名',
  `department_orgcode` varchar(255) DEFAULT NULL COMMENT '部门code',
  `department_name` varchar(255) DEFAULT NULL COMMENT '部门名',
  `inspection_spec` varchar(100) DEFAULT NULL COMMENT '巡查规范名称',
  `maintenance_spec` varchar(100) DEFAULT NULL COMMENT '维保规范名称',
  `area` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `management_style` (`management_style`) USING BTREE,
  KEY `supplier_id` (`supplier_id`) USING BTREE,
  KEY `unit_id` (`unit_id`) USING BTREE,
  KEY `ix_equipment_for_code` (`code`) USING BTREE,
  KEY `ix_equipment_for_category_id` (`category_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='装备定义';

-- ----------------------------
-- Records of wl_equipment
-- ----------------------------

-- ----------------------------
-- Table structure for wl_equipment_category
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_category`;
CREATE TABLE `wl_equipment_category` (
  `id` bigint(20) NOT NULL,
  `parent_id` varchar(32) DEFAULT NULL,
  `code` varchar(50) NOT NULL COMMENT '装备分类编码',
  `name` varchar(50) NOT NULL COMMENT '装备分类名称',
  `is_consumptive` tinyint(4) DEFAULT NULL COMMENT '消耗性装备标志',
  `description` varchar(200) DEFAULT NULL COMMENT '用途或性能',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_date` datetime DEFAULT NULL,
  `industry_code` varchar(50) DEFAULT NULL COMMENT '行业编码',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `ix_equipment_category_for_parent_id` (`parent_id`) USING BTREE,
  KEY `ix_equipment_category_for_code` (`code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='装备分类';

-- ----------------------------
-- Records of wl_equipment_category
-- ----------------------------
INSERT INTO `wl_equipment_category` VALUES ('1', null, '10000000', '消防人员防护装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('2', '1', '11000000', '基本防护装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('3', '2', '11010000', '消防头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('4', '3', '11010100', '全盔式消防头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('5', '3', '11010200', '半盔式消防头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('6', '3', '11019900', '其他消防头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('7', '2', '11020000', '消防员灭火防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('8', '7', '11020100', '消防员灭火防护服下裤', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('9', '2', '11030000', '消防手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('10', '9', '11030100', '1类消防手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('11', '9', '11030200', '2类消防手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('12', '9', '11030300', '3类消防手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('13', '9', '11039900', '其他消防手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('14', '2', '11040000', '消防安全腰带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('15', '2', '11050000', '消防员灭火防护靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('16', '15', '11050100', '灭火防护胶靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('17', '15', '11050200', '灭火防护皮靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('18', '15', '11059900', '其他灭火防护靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('19', '2', '11060000', '正压式消防空气呼吸器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('20', '2', '11070000', '佩戴式防爆照明灯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('21', '2', '11080000', '消防员呼救器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('22', '21', '11080100', '充电式呼救器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('23', '21', '11080200', '非充电式呼救器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('24', '21', '11089900', '其他呼救器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('25', '2', '11090000', '方位灯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('26', '2', '11100000', '消防轻型安全绳', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('27', '2', '11110000', '消防腰斧', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('28', '2', '11120000', '安全钩', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('29', '2', '11130000', '备用气瓶', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('30', '2', '11140000', '消防指挥服', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('31', '2', '11990000', '其他基本防护装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('32', '1', '12000000', '特种防护装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('33', '32', '12010000', '防护头盔及头面部防护装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('34', '33', '12010100', '抢险救援头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('35', '34', '12010101', '全盔式抢险救援头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('36', '34', '12010102', '半盔式抢险救援头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('37', '34', '12010199', '其他抢险救援头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('38', '33', '12010200', '消防员灭火防护头套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('39', '33', '12010300', '消防护目镜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('40', '33', '12019900', '其他防护头盔及头面部防护装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('41', '32', '12020000', '消防员特种防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('42', '41', '12020100', '消防员隔热防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('43', '41', '12020200', '消防员避火防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('44', '41', '12020300', '抢险救援服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('45', '41', '12020400', '化学防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('46', '45', '12020401', '二级化学防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('47', '45', '12020402', '一级化学防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('48', '45', '12020403', '特级化学防护服', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('49', '45', '12020499', '其他化学防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('50', '41', '12020500', '防火防化服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('51', '41', '12029000', '其他消防员特种防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('52', '51', '12029001', '防核防化服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('53', '51', '12029002', '防蜂服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('54', '51', '12029003', '防爆服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('55', '51', '12029004', '电绝缘装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('56', '51', '12029005', '防静电服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('57', '51', '12029006', '防静电内衣', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('58', '51', '12029007', '消防专用救生衣', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('59', '51', '12029008', '消防阻燃毛衣', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('60', '51', '12029009', '消防员降温背心', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('61', '51', '12029011', '核沾染防护服', '0', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('62', '32', '12030000', '消防员特种防护手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('63', '62', '12030100', '内置纯棉手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('64', '62', '12030200', '防高温手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('65', '62', '12030300', '防化手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('66', '65', '12030301', 'PVC厚手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('67', '65', '12030302', '天然橡胶手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('68', '65', '12030303', '氯丁橡胶手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('69', '65', '12030304', '聚氨酯手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('70', '65', '12030305', '丁腈橡胶手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('71', '65', '12030306', '氯磺化聚乙烯手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('72', '65', '12030307', 'PVA手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('73', '65', '12030399', '其他防化手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('74', '62', '12030400', '抢险救援手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('75', '62', '12039900', '其他特种防护手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('76', '32', '12040000', '消防员特种防护靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('77', '76', '12040100', '抢险救援靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('78', '76', '12040200', '化学防护靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('79', '76', '12040300', '防静电靴', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('80', '76', '12049900', '其他特种防护靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('81', '32', '12050000', '特种消防用防坠落装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('82', '81', '12050100', '消防通用安全绳', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('83', '81', '12050200', '消防安全吊带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('84', '83', '12050201', '消防Ⅰ类安全吊带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('85', '83', '12050202', '消防Ⅱ类安全吊带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('86', '83', '12050203', '消防Ⅲ类安全吊带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('87', '83', '12050299', '其他消防安全吊带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('88', '81', '12050300', '消防防坠落辅助部件', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('89', '81', '12059900', '其他特种消防用防坠落装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('90', '32', '12060000', '消防员特种呼吸保护装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('91', '90', '12060100', '长管空气呼吸器（移动供气源）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('92', '90', '12060200', '正压式消防氧气呼吸器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('93', '90', '12060300', '强制送风呼吸器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('94', '90', '12060400', '消防过滤式综合防毒面具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('95', '90', '12060500', '移动供气源', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('96', '90', '12069900', '其他特种呼吸保护装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('97', '32', '12070000', '消防水下保护装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('98', '97', '12070100', '潜水装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('99', '97', '12070200', '潜水服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('100', '99', '12070201', '干式潜水服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('101', '99', '12070202', '湿式潜水服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('102', '99', '12070299', '其他潜水服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('103', '97', '12070300', '潜水头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('104', '97', '12070400', '水下通信设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('105', '97', '12070500', '水下工具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('106', '97', '12070600', '水下照明灯具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('107', '97', '12079900', '其他消防水下保护装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('108', '32', '12080000', '特种防护装备及器具配件', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('109', '108', '12080100', '救援护膝护肘', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('110', '108', '12080200', '抢险救援腰带', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('111', '32', '12990000', '其他类特种防护装备及器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('112', '111', '12990100', '消防员特种照明灯具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('113', '112', '12990101', '手提式强光照明灯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('114', '112', '12990102', '消防用荧光棒', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('115', '112', '12990199', '其他特种照明灯具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('116', '111', '12990200', '消防员特种通信装置', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('117', '116', '12990201', '消防员呼救器后场接收装置', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('118', '116', '12990202', '头骨振动式通信装置', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('119', '116', '12990203', '防爆手持电台', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('120', '116', '12990204', '消防员单兵定位装置', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('121', '111', '12999900', '其他特种防护装备及器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('122', null, '20000000', '消防车、船（艇）、飞行器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('123', '122', '21000000', '消防车辆装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('124', '123', '21010000', '消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('125', '124', '21010100', '灭火类消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('126', '125', '21010101', '水罐消防车（SG）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('127', '125', '21010102', '泡沫消防车（PM）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('128', '125', '21010103', '压缩空气泡沫消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('129', '125', '21010104', '高倍泡沫消防车（GP）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('130', '125', '21010105', '泵浦消防车（BP）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('131', '125', '21010106', '干粉消防车（GF）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('132', '125', '21010107', '干粉泡沫联用消防车（GP）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('133', '125', '21010108', '干粉水联用消防车（GL）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('134', '125', '21010109', '涡喷消防车（WP）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('135', '125', '21010110', '二氧化碳消防车（EY）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('136', '125', '21010111', '细水雾消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('138', '125', '21010113', ' 干粉二氧化碳联用消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('139', '125', '21010199', '其他灭火消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('140', '124', '21010200', '举高类消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('141', '140', '21010201', '登高平台消防车（DG）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('142', '140', '21010202', '云梯消防车（YT）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('143', '140', '21010203', '举高喷射消防车（JP）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('144', '140', '21010299', '其他举高消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('145', '124', '21010300', '专勤类消防', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('146', '145', '21010301', '抢险救援消防车（JY）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('147', '145', '21010302', '排烟消防车（PY）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('148', '145', '21010303', '照明消防车（ZM）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('149', '145', '21010304', '排烟照明消防车（PZ）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('150', '145', '21010305', '高倍泡沫排烟消防车（PP）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('151', '145', '21010306', '水带敷设消防车（DF）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('152', '145', '21010307', '化学事故抢险救援消防车（HJ）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('153', '145', '21010308', '化学洗消消防车（HX）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('154', '145', '21010309', '核生化侦检消防车（ZJ）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('155', '145', '21010310', '勘察消防车（KC）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('156', '145', '21010311', '通讯指挥消防车（TZ）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('157', '145', '21010312', '宣传消防车（XC）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('158', '145', '21010399', '其他专勤消防', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('159', '124', '21010400', '战勤保障消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('160', '159', '21010401', '器材消防车（QC）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('161', '159', '21010402', '供水消防车（GS）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('162', '159', '21010403', '供液消防车（GY）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('163', '159', '21010404', '供气消防车（GQ）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('164', '159', '21010405', '自卸式消防车（ZX）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('165', '159', '21010406', '装备抢修车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('166', '159', '21010407', '饮食保障车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('167', '159', '21010408', '加油车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('168', '159', '21010409', '运兵车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('169', '159', '21010410', '宿营车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('170', '159', '21010411', '卫勤保障车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('171', '159', '21010412', '发电车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('172', '159', '21010413', '淋浴车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('173', '159', '21010414', '挖掘机', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('174', '159', '21010415', '装备拖车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('175', '159', '21010416', '吊车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('176', '159', '21010499', '其他后援消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('177', '124', '21010500', '机场消防车（JX）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('178', '177', '21010501', '机场快速调动消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('179', '177', '21010502', '机场主力泡沫消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('180', '177', '21010599', '其他机场消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('181', '124', '21010600', '防爆消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('182', '124', '21010700', '轨道消防车（GD）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('183', '124', '21019900', '其他类消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('184', '123', '21020000', '消防摩托车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('185', '184', '21020100', '灭火消防摩托车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('186', '184', '21020200', '抢险救援摩托车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('187', '184', '21029900', '其他消防摩托车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('188', '123', '21990000', '其他消防车辆', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('189', '122', '22000000', '消防船艇', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('190', '189', '22010000', '大型消防艇', '0', null, '排水量800吨以上', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('191', '189', '22020000', '中型消防艇', '0', null, '排水量小于等于800吨，大于100吨', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('192', '189', '22030000', '小型消防艇', '0', null, '排水量小于等于100吨', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('193', '189', '22040000', '冲锋舟', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('194', '189', '22050000', '橡皮艇', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('195', '189', '22990000', '其他消防船艇', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('196', '122', '23000000', '消防飞行器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('197', '196', '23010000', '固定翼飞机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('198', '196', '23020000', '直升机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('199', '196', '23030000', '飞艇', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('200', '196', '23040000', '无人飞行器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('201', '196', '23990000', '其他消防飞行器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('202', null, '30000000', '灭火器材装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('203', '202', '31000000', '消防器具类', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('204', '203', '31010000', '输水器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('205', '204', '31010100', '吸水管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('206', '205', '31010101', '胶管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('207', '205', '31010102', 'PVC管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('208', '205', '31010199', '其他材料吸水管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('209', '204', '31010200', '吸水附属器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('210', '209', '31010201', '吸水管接口', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('211', '209', '31010202', '滤水器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('212', '209', '31010203', '吸水管扳手', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('213', '209', '31010204', '排吸器', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('214', '209', '31010299', '其他吸水附属器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('215', '204', '31010400', '消防水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('216', '215', '31010401', '低压消防水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('217', '215', '31010402', '中压消防水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('218', '215', '31010403', '高压消防水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('219', '215', '31010404', 'A类泡沫专用水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('220', '215', '31010405', '水幕水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('221', '215', '31010499', '其他水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('222', '204', '31010500', '分水器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('223', '204', '31010600', '集水器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('224', '204', '31010700', '消防球阀', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('225', '204', '31010800', '水囊（槽）', '0', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('226', '204', '31010900', 'A/B类泡沫比例混合器', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('228', '204', '31011200', '消防水带附属器具', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('229', '228', '31011201', '卡式水带接口', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('230', '228', '31011202', '内扣式水带接口', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('231', '228', '31011203', '螺纹式水带接口', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('232', '228', '31011211', '水带包布', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('233', '228', '31011221', '水带卷盘', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('234', '228', '31011222', '移动式水带卷盘', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('235', '228', '31011231', '水带护桥', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('236', '228', '31011241', '水带挂钩', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('237', '204', '31019900', '其他输水器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('238', '203', '31020000', '消防枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('239', '238', '31020100', '消防水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('240', '239', '31020101', '直流水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('241', '239', '31020102', '喷雾水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('242', '239', '31020103', '直流喷雾水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('243', '239', '31020104', '多功能消防水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('244', '239', '31020105', '脉冲水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('245', '239', '31020106', '开花水枪', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('246', '239', '31020107', '带架水枪', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('247', '239', '31020199', '其他水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('248', '238', '31020200', '消防泡沫枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('249', '248', '31020201', '低倍数泡沫枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('250', '248', '31020202', '中倍数泡沫枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('251', '248', '31020203', '低倍数中倍数联用泡沫枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('252', '248', '31020204', '压缩空气泡沫系统专用枪', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('253', '248', '31020299', '其他泡沫枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('254', '238', '31020300', '泡沫钩管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('255', '238', '31020400', '干粉枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('256', '238', '31029900', '其他消防枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('257', '203', '31030000', '移动消防炮', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('258', '257', '31030100', '消防水炮', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('259', '257', '31030200', '消防泡沫炮', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('260', '257', '31030300', '消防干粉炮', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('261', '257', '31030400', '大流量移动消防炮（拖车式）', '0', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('262', '257', '31030500', '自摆式消防炮', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('263', '257', '31030600', '手动消防炮', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('264', '257', '31030700', '电动遥控炮', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('265', '257', '31030800', '电动泡沫遥控炮', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('266', '257', '31039900', '其他消防炮', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('267', '203', '31040000', '灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('268', '267', '31040100', '水基型灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('269', '268', '31040101', '水型灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('270', '268', '31040102', '泡沫灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('271', '268', '31040199', '其他水基型', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('272', '267', '31040200', '干粉灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('273', '272', '31040201', 'BC干粉灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('274', '272', '31040202', 'ABC干粉灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('275', '272', '31040203', 'D类火灾专用灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('276', '272', '31040299', '其他干粉灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('277', '267', '31040300', '二氧化碳灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('278', '267', '31040400', '清洁气体灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('279', '278', '31040401', '卤代烷烃类', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('280', '278', '31040402', '惰性气体', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('281', '278', '31040499', '其他清洁气体', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('282', '267', '31040500', '移动式细水雾灭火装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('283', '267', '31040600', '风力灭火机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('284', '267', '31049900', '其他灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('285', '203', '31990000', '其他消防器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('286', '285', '31990100', '转换接口', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('287', '286', '31990101', '异径接口', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('288', '286', '31990102', '异形接口', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('289', '202', '32000000', '消防泵类', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('290', '289', '32010000', '低压消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('291', '289', '32020000', '中压消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('292', '289', '32030000', '中低压消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('293', '289', '32040000', '高压消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('294', '289', '32050000', '高低压消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('295', '289', '32060000', '超高压消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('296', '289', '32990000', '其他消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('297', '296', '32990100', '手抬机动泵', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('298', '296', '32990200', '浮艇泵', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('299', '296', '32990300', '泡沫泵', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('300', '202', '39000000', '其他灭火器材装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('301', '300', '39010000', '消防锹', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('302', '300', '39020000', '铁挺', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('303', '300', '39030000', '消防镐', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('304', '300', '39040000', '消防斧', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('305', '300', '39050000', '消防锤', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('306', '300', '39060000', '帆布水桶', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('307', '300', '39070000', '地下消火栓钥匙', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('308', '300', '39080000', '地上消火栓钥匙', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('309', '300', '39090000', '消防钩', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('310', null, '40000000', '灭火药剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('311', '310', '41000000', '水灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('312', '311', '41001234', '水灭火剂C', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('313', '311', '41002358', '水灭火剂A', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('314', '311', '41005326', '水灭火剂B', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('315', '310', '42000000', '泡沫灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('316', '315', '42010000', '机械泡沫灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('317', '316', '42010100', '蛋白泡沫灭火剂（P）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('318', '316', '42010200', '氟蛋白泡沫灭火剂（FP）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('319', '316', '42010300', '合成泡沫灭火剂（S）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('320', '316', '42010400', '抗溶泡沫灭火剂（AR）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('321', '316', '42010500', '水成膜泡沫灭火剂（AFFF）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('322', '316', '42010600', '成膜氟蛋白泡沫灭火剂（FFFP）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('323', '316', '42019900', '其他机械泡沫灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('324', '315', '42020000', '压缩空气泡沫灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('325', '315', '42030000', '化学泡沫灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('326', '315', '42040000', '蛋白泡沫（P）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('327', '315', '42050000', '氟蛋白泡沫（FP）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('328', '315', '42060000', '抗溶性氟蛋白泡沫（FP/AR）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('329', '315', '42070000', '成膜氟蛋白泡沫灭火剂（FFFP）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('330', '315', '42080000', '抗溶性成膜氟蛋白泡沫（FFFP/AR）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('331', '315', '42090000', '普通合成泡沫灭火剂（S）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('332', '315', '42100000', '高倍数泡沫或高中低倍通用泡沫', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('333', '315', '42110000', '合成型抗溶泡沫(S/AR)', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('334', '315', '42120000', '水成膜泡沫（AFFF）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('335', '315', '42130000', '抗溶性水成膜泡沫（AFFF/AR）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('336', '315', '42140000', 'A类泡沫', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('337', '315', '42990000', '其他泡沫灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('338', '310', '43000000', '干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('339', '338', '43010000', '普通干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('340', '339', '43010100', 'BC类干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('341', '339', '43010200', 'ABC类干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('342', '339', '43019900', '其他普通干粉', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('343', '338', '43020000', '超细干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('344', '343', '43020100', 'BC类超细干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('345', '343', '43020200', 'ABC类超细干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('346', '343', '43029900', '其他超细干粉', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('347', '338', '43030000', '金属火灾干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('348', '347', '43030100', '石墨类', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('349', '347', '43030200', '氯化钠类', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('350', '347', '43030300', '碳酸钠类', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('351', '347', '43039900', '其他金属火灾干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('352', '338', '43990000', '其他干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('353', '310', '44000000', '气体灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('354', '353', '44010000', '卤代烷烃灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('355', '354', '44010100', '七氟丙烷（HFC227ea）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('356', '354', '44010200', '三氟丙烷（HFC23）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('357', '354', '44010300', '六氟丙烷（HFC236fa）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('358', '354', '44010400', '哈龙1301', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('359', '354', '44010500', '哈龙1211', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('360', '354', '44019900', '其他卤代烷烃', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('361', '353', '44020000', '二氧化碳灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('362', '353', '44030000', '惰性气体灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('363', '362', '44030100', 'IG01', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('364', '362', '44030200', 'IG100', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('365', '362', '44030300', 'IG55', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('366', '362', '44030400', 'IG541', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('367', '362', '44039900', '其他惰性气体', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('368', '353', '44990000', '其他气体灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('369', '310', '49000000', '其他灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('370', null, '50000000', '抢险救援器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('371', '370', '51000000', '侦检器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('372', '371', '51010000', '有毒气体探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('373', '371', '51020000', '军事毒剂侦检仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('374', '371', '51030000', '可燃气体检测器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('375', '371', '51040000', '水质分析仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('376', '371', '51050000', '电子气象仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('377', '371', '51060000', '音频生命探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('378', '371', '51070000', '视频生命探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('379', '371', '51080000', '生命探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('380', '379', '51080100', '音频生命探测仪', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('381', '379', '51080200', '视频生命探测仪', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('382', '379', '51080300', '雷达生命探测仪', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('383', '371', '51090000', '消防用红外热像仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('384', '371', '51100000', '漏电探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('385', '371', '51110000', '核放射探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('386', '371', '51120000', '电子酸碱测试仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('387', '371', '51130000', '移动式生物快速侦检仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('388', '371', '51140000', '水深探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('389', '371', '51150000', '无线复合气体探测仪', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('390', '371', '51160000', '测温仪', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('391', '371', '51170000', '激光测距仪', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('392', '371', '51180000', '便携危险化学品检测片', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('393', '371', '51190000', '金属探测仪', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('394', '371', '51990000', '其他侦检器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('395', '370', '52000000', '警戒器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('396', '395', '52010000', '警戒标志杆', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('397', '395', '52020000', '锥型事故标志柱', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('398', '395', '52030000', '隔离警示带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('399', '395', '52040000', '出入口标志牌', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('400', '395', '52050000', '危险警示牌', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('401', '400', '52050100', '有毒标志', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('402', '400', '52050200', '易燃标志', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('403', '400', '52050300', '泄漏标志', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('404', '400', '52050400', '爆炸标志', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('405', '400', '52050500', '放射标志', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('406', '395', '52060000', '闪光警示灯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('407', '395', '52070000', '手持扩音器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('408', '395', '52990000', '其他警戒器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('409', '370', '53000000', '消防梯及救生器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('410', '409', '53010000', '消防梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('411', '410', '53010100', '单杆梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('412', '410', '53010200', '挂钩梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('413', '410', '53010300', '拉梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('414', '413', '53010301', '二节拉梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('415', '413', '53010302', '三节拉梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('416', '413', '53010399', '其他拉梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('417', '410', '53010400', '折叠式救援梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('418', '410', '53010500', '救生软梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('419', '410', '53019900', '其他消防梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('420', '409', '53020000', '救生器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('421', '420', '53020100', '躯体固定气囊', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('422', '420', '53020200', '肢体固定气囊', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('423', '420', '53020300', '婴儿呼吸袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('424', '420', '53020400', '逃生面罩', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('425', '420', '53020500', '救生照明线', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('426', '420', '53020600', '折叠式担架', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('427', '420', '53020700', '伤员固定抬板', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('428', '420', '53020800', '多功能担架', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('429', '420', '53020900', '消防救生气垫', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('430', '420', '53021000', '救生缓降器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('431', '420', '53021100', '灭火毯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('432', '420', '53021200', '医药急救箱', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('433', '420', '53021300', '医用简易呼吸器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('434', '420', '53021400', '气动起重气垫', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('435', '420', '53021500', '救援支架', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('436', '420', '53021600', '救生抛投器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('437', '420', '53021700', '水面漂浮救生绳', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('438', '420', '53021800', '机动橡皮舟', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('439', '420', '53021900', '敛尸袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('440', '420', '53022000', '消防过滤式自救呼吸器', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('441', '420', '53022100', '自喷荧光漆', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('442', '420', '53022200', '通讯救生安全绳 ', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('443', '420', '53022300', '打捞网', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('444', '420', '53022400', '救生杆', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('445', '420', '53022500', '水面救援装具', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('446', '420', '53029900', '其他救生器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('447', '409', '53990000', '其他消防梯及救生器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('448', '370', '54000000', '破拆器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('449', '448', '54010000', '电动剪扩钳', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('450', '448', '54020000', '液压剪切器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('451', '448', '54030000', '液压万向剪切钳', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('452', '448', '54040000', '液压剪扩器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('453', '448', '54050000', '双轮异向切割锯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('454', '448', '54060000', '机动链锯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('455', '448', '54070000', '无齿锯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('456', '448', '54080000', '等离子切割器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('457', '448', '54090000', '气动切割刀', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('458', '448', '54100000', '液压扩张器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('459', '448', '54110000', '液压撑顶器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('460', '448', '54120000', '重型支撑套具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('461', '460', '54120100', '液压式', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('462', '460', '54120200', '气压式', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('463', '460', '54120300', '机械手动式', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('464', '448', '54130000', '液压机动泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('465', '464', '54130100', '内燃式液压机动泵', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('466', '464', '54130200', '电池液压机动泵', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('467', '448', '54140000', '手动液压泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('468', '448', '54150000', '开门器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('469', '448', '54160000', '冲击钻', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('470', '448', '54170000', '凿岩机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('471', '448', '54180000', '玻璃破碎器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('472', '448', '54190000', '手持式钢筋速断器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('473', '448', '54200000', '液压破拆工具组', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('474', '448', '54210000', '手动破拆工具组', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('475', '448', '54220000', '混凝土液压破拆工具组', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('476', '448', '54230000', '便携式防盗门破拆工具组', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('477', '448', '54240000', '便携式汽油金属切割器', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('478', '448', '54250000', '液压千斤顶', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('479', '448', '54260000', '多功能刀具', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('480', '448', '54270000', '绝缘剪断钳', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('481', '448', '54280000', '毁锁器', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('482', '448', '54290000', '多功能挠钩', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('483', '448', '54310000', '便携式手动液压剪扩钳', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('484', '448', '54320000', '封管器', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('485', '448', '54990000', '其他破拆器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('486', '370', '55000000', '堵漏器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('487', '486', '55010000', '内封式堵漏袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('488', '487', '55010100', '直径10/20mm', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('489', '487', '55010200', '直径20/40mm', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('490', '487', '55010300', '直径30/60mm', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('491', '487', '55010400', '直径50/100mm', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('492', '486', '55020000', '外封式堵漏袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('493', '486', '55030000', '捆绑式堵漏袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('494', '493', '55030100', '5/20mm', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('495', '493', '55030200', '20/48mm', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('496', '486', '55040000', '下水道阻流袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('497', '486', '55050000', '金属堵漏套管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('498', '486', '55060000', '堵漏枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('499', '498', '55060100', '圆锥', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('500', '498', '55060200', '楔型', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('501', '500', '55060201', '1型', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('502', '500', '55060202', '2型', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('503', '500', '55060203', '3型', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('504', '486', '55070000', '阀门堵漏套具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('505', '486', '55080000', '注入式堵漏工具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('506', '486', '55090000', '粘贴式堵漏工具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('507', '486', '55100000', '电磁式堵漏工具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('508', '486', '55110000', '木制堵漏楔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('509', '486', '55120000', '气动吸盘式堵漏器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('510', '486', '55130000', '管道粘结剂', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('511', '486', '55140000', '无火花工具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('512', '486', '55150000', '强磁堵漏工具', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('513', '486', '55990000', '其他堵漏器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('514', '370', '56000000', '输转器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('515', '514', '56010000', '手动隔膜抽吸泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('516', '514', '56020000', '防爆输转泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('517', '514', '56030000', '粘稠液体抽吸泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('518', '514', '56040000', '排污泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('519', '514', '56050000', '有毒物质密封桶', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('520', '514', '56060000', '围油栏', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('521', '514', '56070000', '吸附垫', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('522', '514', '56080000', '集污袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('523', '514', '56990000', '其他输转器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('524', '370', '57000000', '消防洗消装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('525', '524', '57010000', '洗消剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('526', '525', '57010100', '强酸、碱清洗剂', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('527', '525', '57010200', '洗消粉', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('528', '527', '57010201', '三合一强氧化洗消粉', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('529', '527', '57010299', '其他洗消粉', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('530', '525', '57010300', '三合二洗消剂', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('531', '525', '57010400', '有机磷降解酶', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('532', '525', '57010500', '消毒粉', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('533', '525', '57019900', '其他洗消剂', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('534', '524', '57020000', '洗消装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('535', '534', '57020100', '强酸、碱洗消器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('536', '534', '57020200', '生化洗消装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('537', '534', '57020300', '简易洗消喷淋器', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('538', '534', '57020400', '消防面罩超声波清洗机', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('539', '534', '57020500', '洗消净水池', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('540', '534', '57020600', '洗消污水池', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('541', '534', '57020700', '洗眼器', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('542', '534', '57029900', '其他洗消装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('543', '524', '57030000', '洗消站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('544', '543', '57030100', '单人洗消帐篷', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('545', '543', '57030200', '公众洗消站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('546', '543', '57039900', '其他洗消站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('547', '524', '57990000', '其他消防洗消装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('548', '370', '58000000', '照明、排烟器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('549', '548', '58010000', '移动式排烟机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('550', '548', '58020000', '坑道小型空气输送机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('551', '548', '58030000', '移动照明灯组', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('552', '548', '58040000', '移动发电机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('553', '548', '58050000', '水驱动排烟机', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('554', '548', '58990000', '其他照明、排烟器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('555', '370', '59000000', '其他类器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('556', '555', '59010000', '空气充填泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('557', '555', '59020000', '防化服清洗烘干器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('558', '555', '59030000', '消防移动储水装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('559', '555', '59040000', '高倍数泡沫发生器', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('560', '555', '59050000', '电源逆变器', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('561', '555', '59060000', '液压动力站', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('562', '555', '59070000', '液压胶管', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('563', '555', '59080000', '装备技师工具箱', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('564', '555', '59990000', '其他特勤器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('565', '564', '59990100', '野外炊事保障单元', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('566', null, '60000000', '消防通信指挥装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('567', '566', '61000000', '计算机通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('568', '567', '61010000', '路由器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('569', '567', '61020000', '交换机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('570', '567', '61090000', '其他计算机通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('571', '566', '62000000', '有线通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('572', '571', '62010000', '程控交换机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('573', '571', '62020000', '光电传输设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('574', '571', '62030000', '复用设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('575', '571', '62040000', '电信终端设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('576', '571', '62050000', 'VoIP网关', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('577', '571', '62060000', '附加设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('578', '571', '62090000', '其他有线通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('579', '566', '63000000', '无线通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('580', '579', '63010000', '无线常规网', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('581', '580', '63010100', '一级网通信基站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('582', '580', '63010200', '一级网移动通信基站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('583', '580', '63010300', '一级网固定电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('584', '580', '63010400', '一级网车载电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('585', '580', '63010500', '二级网手持电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('586', '580', '63010600', '三级网手持电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('587', '580', '63010700', '无线地下中继设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('588', '580', '63010800', '无线数据网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('589', '580', '63019900', '其他无线常规网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('590', '579', '63020000', '无线集群网', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('591', '590', '63020100', '分调度台设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('592', '590', '63020200', '移动通信基站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('593', '590', '63020300', '车载电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('594', '590', '63020400', '手持电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('595', '590', '63020500', '编程器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('596', '590', '63029900', '其他无线集群网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('597', '566', '64000000', '卫星通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('598', '597', '64010000', '卫星固定站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('599', '597', '64020000', '卫星移动站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('600', '599', '64020100', '车载站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('601', '599', '64020200', '便携站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('602', '597', '64030000', '卫星电话终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('603', '597', '64990000', '其他卫星通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('604', '566', '65000000', '信息中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('605', '604', '65010000', '服务器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('606', '604', '65020000', '存储设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('607', '604', '65030000', '安全保障设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('608', '607', '65030100', '网络安全设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('609', '608', '65030101', '防火墙', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('610', '608', '65030102', '入侵检测系统（IDS）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('611', '608', '65030103', '入侵防御系统(IPS)', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('612', '608', '65030104', '隔离网闸', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('613', '608', '65030105', '统一威胁管理系统（UTM）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('614', '608', '65030106', '抗分布式拒绝服务攻击网关（DD0S）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('615', '608', '65030107', '防病毒网关', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('616', '608', '65030108', '站防护系统（Web应用防火墙）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('617', '608', '65030109', '漏洞扫描系统', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('618', '608', '65030110', '网络安全管理平台（SQC）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('619', '608', '65030199', '其他信息中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('620', '607', '65030200', '公钥基础设施（PKI）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('621', '620', '65030201', '地注册代理（LRA）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('622', '620', '65030202', 'PKI从目录系统', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('623', '620', '65030203', '集中认证网关', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('624', '620', '65030204', '审计查询系统（AQS）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('625', '620', '65030299', '其他公钥基础设施', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('626', '607', '65030300', '安全接入系统设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('627', '626', '65030301', 'VPN安全网关', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('628', '626', '65030302', '短信安全网关', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('629', '626', '65030303', 'AAA认证服务器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('630', '626', '65030304', '集成CA*LDAP*RA服务器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('631', '626', '65030305', '终端安全加固系统', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('632', '626', '65030306', '应用代理和终端安全管理服务器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('633', '626', '65030307', '安全接入管理平台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('634', '626', '65030399', '其他安全接入系统设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('635', '607', '65039900', '其他安全保障设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('636', '604', '65040000', '电源设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('637', '636', '65040100', '交流电源', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('638', '636', '65040200', 'UPS电源', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('639', '604', '65990000', '其他电源设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('640', '566', '66000000', '指挥中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('641', '640', '66010000', '通信指挥中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('642', '641', '66010100', '接警调度终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('643', '641', '66010200', '指挥调度终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('644', '641', '66010300', '综合信息管理终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('645', '641', '66010400', '电话机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('646', '641', '66010500', '打印、传真机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('647', '641', '66010600', '大屏幕显示设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('648', '647', '66010601', 'DLP', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('649', '647', '66010602', '投影', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('650', '647', '66010603', '液晶', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('651', '647', '66010604', 'LED', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('652', '647', '66010699', '其他', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('653', '641', '66010700', '指挥大厅音响设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('654', '653', '66010701', '调音台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('655', '653', '66010702', '功放机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('656', '653', '66010703', '音箱', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('657', '653', '66010799', '其他', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('658', '641', '66010800', '火警广播设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('659', '658', '66010801', '话筒', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('660', '658', '66010802', '功放机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('661', '658', '66010803', '扬声器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('662', '658', '66010899', '其他火警广播设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('663', '641', '66010900', '指挥会议设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('664', '663', '66010901', '视频会议终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('665', '663', '66010902', '数字会议设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('666', '663', '66010903', '音响设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('667', '663', '66010904', '交互电子白板', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('668', '663', '66010999', '其他指挥会议设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('669', '641', '66011000', '视频设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('670', '669', '66011001', '视频会议多点控制单元（MCU）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('671', '669', '66011002', '视频解码器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('672', '669', '66011003', '分配器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('673', '669', '66011004', '切换矩阵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('674', '669', '66011005', '录像机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('675', '669', '66011099', '其他视频设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('676', '641', '66011100', '综合图像管理平台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('677', '641', '66011200', '综合语音管理平台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('678', '641', '66011300', '集中控制设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('679', '678', '66011301', '控制主机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('680', '678', '66011302', '无线触摸屏', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('681', '678', '66011303', '灯光控制器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('682', '678', '66011304', '以太网控制卡', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('683', '678', '66011305', '视音频切换设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('684', '678', '66011399', '其他集中控制设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('685', '641', '66011400', '录音录时设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('686', '641', '66019900', '其他通信指挥中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('687', '640', '66020000', '消防站设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('688', '687', '66020100', '消防站火警终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('689', '687', '66020200', '电话机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('690', '687', '66020300', '打印、传真机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('691', '687', '66020400', '紧急信号接收机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('692', '687', '66020500', '火警广播设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('693', '687', '66020600', '录音录时设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('694', '687', '66020700', '联动控制设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('695', '687', '66020800', '视频监控设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('696', '687', '66020900', '指挥会议设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('697', '687', '66021000', '网络设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('698', '687', '66021100', 'UPS电源', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('699', '687', '66029900', '其他消防站设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('700', '640', '66030000', '移动指挥中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('701', '700', '66030100', '电话交换设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('702', '700', '66030200', '电话机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('703', '700', '66030300', '车外广播扩音设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('704', '700', '66030400', '无线视频传输系统', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('705', '700', '66030500', '短波电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('706', '705', '66030501', '短波固定电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('707', '705', '66030502', '短波背负电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('708', '700', '66030600', '网络交换机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('709', '700', '66030700', '紧急信号发送设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('710', '700', '66030800', '通信组网管理设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('711', '700', '66030900', '车载计算机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('712', '700', '66031000', '便携式计算机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('713', '700', '66031100', '便携式作战指挥平台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('714', '700', '66031200', '视音频会议系统终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('715', '700', '66031300', '打印、复印、传真机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('716', '700', '66031400', '现场图像采集设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('717', '700', '66031500', '气象采集设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('718', '700', '66031600', '标准时钟', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('719', '700', '66031700', '综合显示屏及附件', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('720', '700', '66031800', '显示控制设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('721', '700', '66031900', '音视频存储设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('722', '700', '66032000', '定制车厢', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('723', '700', '66032100', '会议桌、椅', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('724', '700', '66032200', '指挥通信终端、机柜等', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('725', '700', '66032300', '储物柜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('726', '700', '66032400', '外接口面板仓和接口', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('727', '700', '66032500', '升降杆', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('728', '700', '66032600', '电缆盘、盘架、线缆', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('729', '700', '66032700', '综合布线', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('730', '700', '66032800', '行车设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('731', '700', '66032900', '警示设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('732', '700', '66033000', '供电设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('733', '700', '66033100', '配电盘柜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('734', '700', '66033200', '隔离变压器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('735', '700', '66033300', 'UPS电源', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('736', '700', '66033400', '驻车空调', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('737', '700', '66033500', '车内照明', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('738', '700', '66033600', '车外照明', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('739', '700', '66033700', '卫生间设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('740', '700', '66033800', '饮用水设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('741', '700', '66033900', '食品加热设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('742', '700', '66034000', '食品冷藏设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('743', '700', '66034100', '车内音响系统', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('744', '700', '66034200', '灭火救援指挥箱', '0', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('745', '700', '66039900', '其他移动指挥中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('746', '640', '66990000', '其他指挥中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('747', '566', '69000000', '其他消防通信指挥装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('748', '747', '69010000', '水下通信设备', '0', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('749', null, '70000000', '特种消防装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('750', '749', '71000000', '消防灭火机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('751', '750', '71010000', '灭火机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('752', '750', '71020000', '侦察机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('753', '750', '71030000', '救援机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('754', '750', '71040000', '消防排烟机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('755', '750', '71050000', '反恐排爆机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('756', '750', '71060000', '潜水救助机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('757', '750', '71070000', '消防破拆机器人', '0', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('758', '750', '71990000', '其他消防机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('759', '749', '72000000', '消防坦克', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('760', '749', '73000000', '消防装甲车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('761', '749', '74000000', '全地形消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('762', '749', '75000000', '水陆两用消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('763', '749', '79000000', '其他特种消防装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('764', null, '80000000', '防火检查与火灾调查装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('765', '764', '81000000', '建筑消防设施现场检测装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('766', '765', '81010000', '点形感烟火灾探测器功能试验器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('767', '765', '81020000', '点形感温火灾探测器功能试验器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('768', '765', '81030000', '线形光束感烟火灾探测器功能试验器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('769', '765', '81040000', '火焰探测器功能试验器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('770', '765', '81050000', '数字照度计', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('771', '765', '81060000', '数字声级计', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('772', '765', '81070000', '数字测距仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('773', '765', '81080000', '数字风速计', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('774', '765', '81090000', '数字微压计', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('775', '765', '81100000', '消火栓测压装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('776', '765', '81110000', '喷淋末端试水接头', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('777', '765', '81120000', '超声波流量计', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('778', '765', '81130000', '防火涂料测厚仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('779', '765', '81140000', '接地电阻测量仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('780', '765', '81150000', '绝缘电阻测量仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('781', '765', '81160000', '数字万用表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('782', '765', '81170000', '泡沫称重电子秤', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('783', '765', '81990000', '其他建筑消防设施现场检测装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('784', '764', '82000000', '防火检查装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('785', '784', '82010000', '红外测温仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('786', '784', '82020000', '红外热像仪或红外热电视', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('787', '784', '82030000', '超声波探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('788', '784', '82040000', '普通钳形表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('789', '784', '82050000', '谐波分析仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('790', '784', '82060000', '漏电电流测试仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('791', '784', '82070000', '绝缘电阻测试仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('792', '784', '82080000', '钳式接地电阻测试仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('793', '784', '82090000', '低欧姆表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('794', '784', '82100000', '静电电压表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('795', '784', '82110000', '可燃（毒性）气体检测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('796', '784', '82990000', '其他防火检查装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('797', '764', '83000000', '火灾调查装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('798', '797', '83010000', '望远镜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('799', '797', '83020000', '金属硬度检验仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('800', '797', '83030000', '回弹仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('801', '797', '83040000', '特斯拉计（剩磁测试仪）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('802', '797', '83050000', '笔式数字多用表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('803', '797', '83060000', '炭化深度测试仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('804', '797', '83070000', '万用表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('805', '797', '83080000', '接地电阻测量仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('806', '797', '83090000', '绝缘电阻测试仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('807', '797', '83100000', '静电电压表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('808', '797', '83110000', '数字测温表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('809', '797', '83120000', '小型X光检测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('810', '797', '83130000', '金属探测器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('811', '797', '83140000', '体视显微镜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('812', '797', '83150000', '便携式金相显微镜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('813', '797', '83160000', '便携式气相色谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('814', '797', '83170000', '便携式红外光谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('815', '797', '83180000', '易燃液体探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('816', '797', '83190000', '可燃气体探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('817', '797', '83200000', '可燃气体检测管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('818', '797', '83210000', '薄层色谱分析仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('819', '797', '83220000', '现场勘查灯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('820', '797', '83230000', '碘钨灯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('821', '797', '83240000', '（数码）照相机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('822', '797', '83250000', '数码摄像机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('823', '797', '83260000', '现场勘查工具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('824', '797', '83270000', '电子测距仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('825', '797', '83280000', '尸体袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('826', '797', '83290000', '物证保存袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('827', '797', '83300000', '火灾现场勘查专用车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('828', '797', '83990000', '其他火灾调查装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('829', '764', '84000000', '火灾物证鉴定设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('830', '829', '84010000', '薄层色谱分析装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('831', '829', '84020000', '紫外光谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('832', '829', '84030000', '红外光谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('833', '829', '84040000', '高效液相色谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('834', '829', '84050000', '气相色谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('835', '829', '84060000', '气相色谱/质谱联用仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('836', '829', '84070000', '金相显微镜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('837', '829', '84080000', '扫描电子显微镜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('838', '829', '84090000', 'X射线能谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('839', '829', '84100000', 'X射线衍射仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('840', '829', '84110000', '电子探针', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('841', '829', '84120000', '俄歇电子谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('842', '829', '84130000', '差热热重联用分析仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('843', '829', '84140000', '差式扫描量热仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('844', '829', '84990000', '其他火灾物证鉴定设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('845', '764', '89000000', '其他防火检查与火灾调查装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('846', null, '90000000', '其他类消防装备器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('850', '122', '24000000', '船外发动机', '0', null, '船外发动机', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('1001', null, '10000000', '电子围栏', '0', null, '初始导入', '2021-01-13 15:59:42', '1');
INSERT INTO `wl_equipment_category` VALUES ('1002', null, '30000000', '门禁', '0', null, '初始导入', '2021-01-13 15:59:42', '1');
INSERT INTO `wl_equipment_category` VALUES ('1003', null, '50000000', '摄像头', '0', null, '初始导入', '2021-01-13 15:59:42', '1');
INSERT INTO `wl_equipment_category` VALUES ('1285805968926138369', '820', '83230100', '测试数据3', '0', null, '', '2020-07-22 13:16:47', '2');
INSERT INTO `wl_equipment_category` VALUES ('1285806521185951746', '1285805968926138369', '83230101', '测试数据4', '0', null, '', '2020-07-22 13:18:58', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301100791327756289', '204', '31011300', '消防水池', '0', null, null, '2020-09-02 18:12:57', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301101144869834753', '203', '31050000', '消火栓', '0', null, null, '2020-09-02 18:14:21', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301101280379408386', '1301101144869834753', '31050100', '室内消火栓', '0', null, null, '2020-09-02 18:14:53', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301101456850554881', '1301101144869834753', '31050200', '室外消火栓', '0', null, null, '2020-09-02 18:15:35', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301101841233350658', '204', '31011400', '消防水箱', '0', null, null, '2020-09-02 18:17:07', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301102552125935618', '285', '31990200', '消防控制柜', '0', null, null, '2020-09-02 18:19:56', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301103326134407169', '257', '31030900', '塔式泡沫炮', '0', null, null, '2020-09-02 18:23:01', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301103470523322369', '257', '31031000', '挑檐炮', '0', null, null, '2020-09-02 18:23:35', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301104310931820545', '764', '85000000', '火灾报警', '0', null, null, '2020-09-02 18:26:56', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301104460853022721', '1301104310931820545', '85010000', '火灾探测器', '0', null, null, '2020-09-02 18:27:31', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301105214426845186', '1301104460853022721', '85010100', '感温电缆', '0', null, null, '2020-09-02 18:30:31', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301105291379740674', '1301104460853022721', '85010200', '空气采样', '0', null, null, '2020-09-02 18:30:49', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301105357075124226', '1301104460853022721', '85010300', '手动报警', '0', null, null, '2020-09-02 18:31:05', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301105458006855681', '1301104460853022721', '85010400', '声光报警', '0', null, null, '2020-09-02 18:31:29', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301105538612989953', '1301104460853022721', '85010500', '感温探测器', '0', null, null, '2020-09-02 18:31:48', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301105631399383042', '1301104460853022721', '85010600', '红外火焰探测器', '0', null, null, '2020-09-02 18:32:11', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301106032769110017', '272', '31040204', '手提灭火器', '1', null, null, '2020-09-02 18:33:46', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301106142831841282', '272', '31040205', '推车灭火器', '1', null, null, '2020-09-02 18:34:12', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301106554448252929', '300', '39100000', '消防铲', '0', null, null, '2020-09-02 18:35:51', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301107261524021250', '300', '39110000', '消防桶', '0', null, null, '2020-09-02 18:38:39', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301108080868724737', '204', '31011500', '喷头', '0', null, null, '2020-09-02 18:41:55', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301109211015548929', '202', '33000000', '消防泡沫类', '0', null, null, '2020-09-02 18:46:24', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301109389856477186', '1301109211015548929', '33010000', '空气压缩混合器', '0', null, null, '2020-09-02 18:47:07', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301109592315531266', '1301109211015548929', '33030000', '泡沫罐', '0', null, null, '2020-09-02 18:47:55', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301109676713316353', '1301109211015548929', '33040000', '气瓶组', '0', null, null, '2020-09-02 18:48:15', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302863657076658177', '846', '91000000', '电力设备', '0', null, null, '2020-09-07 14:57:57', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302863809086623746', '846', '92000000', '消防系统', '0', null, null, '2020-09-07 14:58:33', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302870336149262337', '1302863809086623746', '92010000', '消防给水系统', '0', null, null, '2020-09-07 15:24:29', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302870567007948801', '1302863809086623746', '92030000', '空气压缩泡沫系统（CAFS）', '0', null, null, '2020-09-07 15:25:24', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302870628873932802', '1302863809086623746', '92040000', '火灾报警系统', '0', null, null, '2020-09-07 15:25:39', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302870675179048962', '1302863809086623746', '92050000', '水喷淋灭火系统', '0', null, null, '2020-09-07 15:25:50', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302870722163642369', '1302863809086623746', '92060000', '泡沫细水雾涡扇炮系统', '0', null, null, '2020-09-07 15:26:01', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302870772801474562', '1302863809086623746', '92070000', '气体灭火系统', '0', null, null, '2020-09-07 15:26:13', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302871042809794562', '1302863809086623746', '92090000', '应急照明与疏散系统', '1', null, null, '2020-09-07 15:27:17', '2');
INSERT INTO `wl_equipment_category` VALUES ('1326407483682672641', '846', '93000000', '消防设施', '1', null, null, '2020-11-11 14:12:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('1326407970716864514', '1326407483682672641', '93010000', '消防小室', '1', null, null, '2020-11-11 14:14:38', '2');
INSERT INTO `wl_equipment_category` VALUES ('1326408067366211586', '1326407483682672641', '93020000', '消防水池1', '1', null, null, '2020-11-11 14:15:01', '2');
INSERT INTO `wl_equipment_category` VALUES ('1326408197586767873', '1326407483682672641', '93030000', '雨淋阀间', '1', null, null, '2020-11-11 14:15:32', '2');
INSERT INTO `wl_equipment_category` VALUES ('1326408330906914817', '1326407483682672641', '93040000', '消防主控室', '1', null, null, '2020-11-11 14:16:04', '2');
INSERT INTO `wl_equipment_category` VALUES ('1326408969366215893', '1326407483682672641', '93050000', '消防泡沫间', '1', null, null, '2020-11-11 14:14:38', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332593563273990145', '1301104460853022721', '85010700', '感烟探测器--吸气式', '1', null, null, '2020-11-28 15:53:59', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332593683709235201', '1301104460853022721', '85010800', '感烟探测器', '1', null, null, '2020-11-28 15:54:27', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332593780002066433', '1301104460853022721', '85010900', '感烟探测器-防爆型', '1', null, null, '2020-11-28 15:54:50', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332593894552702977', '1301104460853022721', '85011000', '感烟探测器--反射式红外', '1', null, null, '2020-11-28 15:55:18', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332594082667237378', '1301104460853022721', '85011100', '双波段火焰探测器', '1', null, null, '2020-11-28 15:56:02', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332594245926326274', '1301104460853022721', '85011200', '消火栓按钮', '1', null, null, '2020-11-28 15:56:41', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332594425480286210', '1301104460853022721', '85011300', '70度防火阀', '1', null, null, '2020-11-28 15:57:24', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332594597958455297', '1301104460853022721', '85011400', '监视模块', '1', null, null, '2020-11-28 15:58:05', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332594686730899458', '1301104460853022721', '85011500', '控制模块', '1', null, null, '2020-11-28 15:58:26', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332594767668383746', '1301104460853022721', '85011600', '智能说动报警按钮', '1', null, null, '2020-11-28 15:58:46', '2');
INSERT INTO `wl_equipment_category` VALUES ('1336645736423739393', '1301104310931820545', '85020000', '火灾报警器', '1', null, null, '2020-12-09 20:15:52', '2');
INSERT INTO `wl_equipment_category` VALUES ('1348574108949962753', '2', '11150000', '11', '1', null, null, '2021-01-11 10:14:58', '2');
INSERT INTO `wl_equipment_category` VALUES ('1351351711343636482', '31', '11990100', 'Testtest', '1', null, null, '2021-01-19 02:12:10', '2');
INSERT INTO `wl_equipment_category` VALUES ('1352094073110573057', '1003', '51000000', '海康威视摄像头', '1', null, null, '2021-01-21 03:22:02', '1');
INSERT INTO `wl_equipment_category` VALUES ('1352094160775720962', '1003', '52000000', '大华摄像头', '1', null, null, '2021-01-21 03:22:23', '1');
INSERT INTO `wl_equipment_category` VALUES ('1357516030527729665', '1001', '11000000', '脉冲电子', '1', null, null, '2021-02-05 10:26:58', '1');
INSERT INTO `wl_equipment_category` VALUES ('1357516283561701378', '1001', '12000000', '红外线收发器', '1', null, null, '2021-02-05 10:27:58', '1');
INSERT INTO `wl_equipment_category` VALUES ('1357516638475317250', '1002', '31000000', '门禁控制器', '0', null, null, '2021-02-05 10:29:23', '1');
INSERT INTO `wl_equipment_category` VALUES ('1357516701343739905', '1002', '32000000', '读卡器', '1', null, null, '2021-02-05 10:29:38', '1');
INSERT INTO `wl_equipment_category` VALUES ('1357516751000104961', '1002', '33000000', '电控锁', '1', null, null, '2021-02-05 10:29:50', '1');
INSERT INTO `wl_equipment_category` VALUES ('1357516806696267778', '1002', '34000000', '卡片', '1', null, null, '2021-02-05 10:30:03', '1');

-- ----------------------------
-- Table structure for wl_equipment_detail
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_detail`;
CREATE TABLE `wl_equipment_detail` (
  `id` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL COMMENT '名称',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `equipment_id` bigint(20) DEFAULT NULL COMMENT '装备定义id',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `manufacturer_id` bigint(20) DEFAULT NULL COMMENT '生产厂商id',
  `standard` varchar(255) DEFAULT NULL COMMENT '规格',
  `img` varchar(255) DEFAULT NULL COMMENT '图片',
  `video` varchar(255) DEFAULT NULL COMMENT '视频',
  `maintenance_cycle` decimal(18,0) DEFAULT NULL COMMENT '保养周期',
  `agent` text COMMENT '代理商',
  `brand` text COMMENT '品牌',
  `contract_code` text COMMENT '合同编号',
  `production_date` datetime DEFAULT NULL COMMENT '生产日期',
  `perf_quota_str` text COMMENT '核心参数',
  `expiry_date` varchar(20) DEFAULT NULL COMMENT '有效期限',
  `creator_id` bigint(255) DEFAULT NULL COMMENT '创建人id',
  `org_code` varchar(50) DEFAULT NULL COMMENT '归属组织',
  `company_name` varchar(255) DEFAULT NULL COMMENT '公司名',
  `department_orgcode` varchar(255) DEFAULT NULL COMMENT '部门code',
  `department_name` varchar(255) DEFAULT NULL COMMENT '部门名',
  `price_interregional` varchar(255) DEFAULT NULL COMMENT '价格区间',
  `country` varchar(255) DEFAULT NULL COMMENT '国别',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `is_import` tinyint(255) DEFAULT NULL COMMENT '是否进口',
  `supplier_id` bigint(20) DEFAULT NULL COMMENT '供应商id',
  `certifications` varchar(500) DEFAULT NULL COMMENT '证书文件',
  `instruction_manual` varchar(500) DEFAULT NULL COMMENT '说明文件',
  `batch_num` varchar(40) DEFAULT NULL COMMENT '批次号',
  `area` varchar(100) DEFAULT NULL COMMENT '位置信息',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `manufacturer` (`manufacturer_id`) USING BTREE,
  KEY `equipment_id` (`equipment_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='装备详情定义';

-- ----------------------------
-- Records of wl_equipment_detail
-- ----------------------------

-- ----------------------------
-- Table structure for wl_equipment_index
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_index`;
CREATE TABLE `wl_equipment_index` (
  `id` bigint(20) NOT NULL,
  `equipment_id` bigint(20) NOT NULL COMMENT '指标拥有者ID:关联装备定义ID',
  `name` varchar(50) NOT NULL COMMENT '名称',
  `name_key` varchar(50) NOT NULL,
  `unit` varchar(50) DEFAULT NULL COMMENT '单位',
  `index_definition_id` bigint(20) NOT NULL COMMENT '指标原始id，从iot平台接口获取',
  `is_iot` bit(1) DEFAULT b'0' COMMENT '是否物联指标,默认false',
  `type_name` varchar(100) DEFAULT NULL COMMENT '指标类型名称',
  `type_code` varchar(50) DEFAULT NULL COMMENT '指标类型编码',
  `group_name` varchar(255) DEFAULT NULL COMMENT '分组名称',
  `sort_num` tinyint(4) DEFAULT '0' COMMENT '排序字段',
  `type` tinyint(4) NOT NULL COMMENT '车辆或装备区分字段',
  `perf_value` varchar(200) DEFAULT NULL COMMENT '指标值',
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `equipment_id` (`equipment_id`) USING BTREE,
  CONSTRAINT `wl_equipment_index_ibfk_1` FOREIGN KEY (`equipment_id`) REFERENCES `wl_equipment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防装备/消防车指标';

-- ----------------------------
-- Records of wl_equipment_index
-- ----------------------------

-- ----------------------------
-- Table structure for wl_equipment_on_car
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_on_car`;
CREATE TABLE `wl_equipment_on_car` (
  `id` bigint(20) NOT NULL,
  `number` varchar(255) DEFAULT NULL,
  `car_id` bigint(20) DEFAULT NULL COMMENT '车辆ID',
  `equipment_detail_id` bigint(20) DEFAULT NULL COMMENT '设备模板ID',
  `equipment_specific_id` bigint(20) DEFAULT NULL COMMENT '设备实例ID',
  `stock_detail_id` bigint(20) DEFAULT NULL COMMENT '库存明细id',
  `amount` decimal(12,2) DEFAULT NULL COMMENT '库存数量',
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `car_id` (`car_id`) USING BTREE,
  KEY `equipment_detail_id` (`equipment_detail_id`) USING BTREE,
  KEY `stock_detail_id` (`stock_detail_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='车载装备关系表';

-- ----------------------------
-- Records of wl_equipment_on_car
-- ----------------------------

-- ----------------------------
-- Table structure for wl_equipment_point
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_point`;
CREATE TABLE `wl_equipment_point` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `equipment_id` bigint(20) DEFAULT NULL COMMENT '消防装备id',
  `create_by` varchar(225) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
  `remark` varchar(255) DEFAULT NULL,
  `type` varchar(32) NOT NULL COMMENT '类型：模拟量ANALOGUE，开关量SWITCH',
  `value` varchar(50) DEFAULT NULL COMMENT '当前值保存时若为开关量（1,0）默认为1',
  `unit` bigint(20) DEFAULT NULL COMMENT '单位id',
  `org_code` varchar(50) DEFAULT NULL COMMENT '组织',
  `alarm_type` bigint(20) DEFAULT NULL COMMENT '告警类型',
  `equipment_class` bigint(20) DEFAULT NULL COMMENT '装备分类',
  `unit_name` varchar(50) DEFAULT NULL COMMENT '单位名称',
  `equipment_name` varchar(50) DEFAULT NULL COMMENT '设备名称',
  `equipment_code` varchar(50) DEFAULT NULL COMMENT '装备编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='装备点位表';

-- ----------------------------
-- Records of wl_equipment_point
-- ----------------------------

-- ----------------------------
-- Table structure for wl_equipment_qrcode
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_qrcode`;
CREATE TABLE `wl_equipment_qrcode` (
  `id` bigint(20) NOT NULL,
  `equipment_detail_id` bigint(20) DEFAULT NULL COMMENT '装备详情定义id',
  `q_r_code` varchar(255) DEFAULT NULL COMMENT '二维码',
  `create_date` datetime DEFAULT NULL,
  `is_single_used` tinyint(4) DEFAULT NULL COMMENT '是否单件并已被使用',
  `car_id` bigint(20) DEFAULT NULL COMMENT '车辆id',
  `shelf_cell_id` bigint(20) DEFAULT NULL,
  `product_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `ix_equipment_qrcode_for_equipment_detail_id_and_qrcode` (`equipment_detail_id`,`q_r_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='装备二维码';

-- ----------------------------
-- Records of wl_equipment_qrcode
-- ----------------------------

-- ----------------------------
-- Table structure for wl_equipment_specific
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_specific`;
CREATE TABLE `wl_equipment_specific` (
  `id` bigint(20) NOT NULL,
  `equipment_detail_id` bigint(20) DEFAULT NULL COMMENT '设备id',
  `qr_code` varchar(255) DEFAULT NULL COMMENT '二维码',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `single` bit(1) DEFAULT b'1' COMMENT '管理方式(默认单件)',
  `system_id` bigint(20) DEFAULT NULL COMMENT '所属系统',
  `iot_code` varchar(50) DEFAULT NULL COMMENT '物联编码',
  `org_code` varchar(255) DEFAULT NULL COMMENT '单位编码',
  `code` char(100) DEFAULT NULL COMMENT '编码',
  `department_id` bigint(20) DEFAULT NULL COMMENT '所属部门',
  `is_binding` bit(1) DEFAULT b'0' COMMENT '是否绑定',
  `input_way` bigint(1) DEFAULT NULL COMMENT '录入方式(0: 单个录入 1:批量录入)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `ix_equipment_qrcode_for_equipment_detail_id_and_qrcode` (`equipment_detail_id`,`qr_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统编码表';

-- ----------------------------
-- Records of wl_equipment_specific
-- ----------------------------

-- ----------------------------
-- Table structure for wl_equipment_specific_alarm
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_specific_alarm`;
CREATE TABLE `wl_equipment_specific_alarm` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `equipment_specific_name` varchar(100) NOT NULL,
  `equipment_specific_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '消防设备id',
  `iot_code` varchar(255) NOT NULL COMMENT '设备编码',
  `equipment_specific_index_name` varchar(255) NOT NULL COMMENT '指标名称',
  `equipment_specific_index_key` varchar(255) NOT NULL COMMENT '指标编码',
  `equipment_specific_index_value` varchar(500) NOT NULL COMMENT '报警值',
  `frequency` int(10) NOT NULL DEFAULT '1' COMMENT '发生频次',
  `status` bit(1) NOT NULL DEFAULT b'1' COMMENT '报警状态：1报警0恢复',
  `type` varchar(50) NOT NULL COMMENT '报警类型:alarm_type_fire（火灾报警）/alarm_type_trouble（故障告警）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `recovery_date` datetime DEFAULT NULL COMMENT '告警恢复时间',
  `equipment_index_id` bigint(20) DEFAULT NULL,
  `confirm_type` varchar(20) DEFAULT NULL COMMENT '确认类型',
  `alam_reason` varchar(300) DEFAULT NULL COMMENT '报警原因',
  `resolve_result` varchar(300) DEFAULT NULL COMMENT '处理情况',
  `confirm_user` varchar(20) DEFAULT NULL COMMENT '确警人员',
  `confirm_date` datetime DEFAULT NULL COMMENT '确警时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1382669112030859267 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='设备报警信息表';

-- ----------------------------
-- Records of wl_equipment_specific_alarm
-- ----------------------------

-- ----------------------------
-- Table structure for wl_equipment_specific_index
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_specific_index`;
CREATE TABLE `wl_equipment_specific_index` (
  `id` bigint(20) NOT NULL,
  `equipment_specific_id` bigint(20) DEFAULT NULL COMMENT '系统编码表id',
  `value` varchar(255) DEFAULT NULL COMMENT '指标值',
  `create_date` datetime DEFAULT NULL,
  `equipment_index_id` bigint(20) DEFAULT NULL COMMENT '指标id',
  `update_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `ix_equ_property_for_equipment_detail_id` (`equipment_specific_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='装备性能指标';

-- ----------------------------
-- Records of wl_equipment_specific_index
-- ----------------------------

-- ----------------------------
-- Table structure for wl_equipment_specific_relation
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_specific_relation`;
CREATE TABLE `wl_equipment_specific_relation` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `equipment_specific_id` bigint(20) NOT NULL COMMENT '装备id',
  `relation_equipment_specific_id` bigint(20) NOT NULL COMMENT '被绑定装备id',
  `type` varchar(32) NOT NULL COMMENT '类型：1-安防；2-消防',
  `create_by` varchar(225) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
  `remark` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uni_idx_bind_relation_id` (`equipment_specific_id`,`relation_equipment_specific_id`) USING BTREE,
  KEY `index_type` (`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1357510085613486082 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='设备关联关系表';

-- ----------------------------
-- Records of wl_equipment_specific_relation
-- ----------------------------

-- ----------------------------
-- Table structure for wl_equipment_system_source_statistics
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_system_source_statistics`;
CREATE TABLE `wl_equipment_system_source_statistics` (
  `id` bigint(20) NOT NULL,
  `equipment_specific_id` bigint(20) DEFAULT NULL COMMENT '设备id',
  `source_id` bigint(20) DEFAULT NULL COMMENT '区域id',
  `system_id` bigint(20) DEFAULT NULL COMMENT '系统id',
  `status` int(1) DEFAULT NULL COMMENT '状态（1停运  2运行 3故障 4火警）',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='物联监控 矩阵表';

-- ----------------------------
-- Records of wl_equipment_system_source_statistics
-- ----------------------------

-- ----------------------------
-- Table structure for wl_equ_property
-- ----------------------------
DROP TABLE IF EXISTS `wl_equ_property`;
CREATE TABLE `wl_equ_property` (
  `id` bigint(20) NOT NULL,
  `equipment_detail_id` bigint(20) DEFAULT NULL COMMENT '准备详情定义id',
  `value` varchar(255) DEFAULT NULL COMMENT '指标值',
  `create_date` datetime DEFAULT NULL,
  `equipment_index_id` bigint(20) DEFAULT NULL COMMENT '指标id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `ix_equ_property_for_equipment_detail_id` (`equipment_detail_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='装备性能指标';

-- ----------------------------
-- Records of wl_equ_property
-- ----------------------------

-- ----------------------------
-- Table structure for wl_extinguishant_on_car
-- ----------------------------
DROP TABLE IF EXISTS `wl_extinguishant_on_car`;
CREATE TABLE `wl_extinguishant_on_car` (
  `id` bigint(20) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `car_id` bigint(20) NOT NULL COMMENT '车辆id',
  `stock_detail_id` bigint(20) NOT NULL COMMENT '库存明细id',
  `equipment_detail_id` bigint(20) NOT NULL COMMENT '装备详情定义id',
  `amount` decimal(12,2) DEFAULT NULL COMMENT '库存数量',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `equipment_detail_id` (`equipment_detail_id`) USING BTREE,
  KEY `stock_detail_id` (`stock_detail_id`) USING BTREE,
  KEY `idx__wl_extinguishant_on_car_car_id` (`car_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='车载灭火药剂';

-- ----------------------------
-- Records of wl_extinguishant_on_car
-- ----------------------------

-- ----------------------------
-- Table structure for wl_form_group
-- ----------------------------
DROP TABLE IF EXISTS `wl_form_group`;
CREATE TABLE `wl_form_group` (
  `id` bigint(20) NOT NULL COMMENT '物理主键',
  `group_name` varchar(100) NOT NULL COMMENT '分组名称',
  `group_code` varchar(50) NOT NULL COMMENT '分组编号',
  `group_type` varchar(20) NOT NULL DEFAULT '0' COMMENT '分组类型（点位图过滤用）',
  `allow_operation` varchar(255) NOT NULL DEFAULT '' COMMENT '允许的操作（逗号分隔ids）',
  `creator_id` bigint(20) NOT NULL COMMENT '更新者id',
  `create_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `unique_idx_group_code` (`group_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='分组表';

-- ----------------------------
-- Records of wl_form_group
-- ----------------------------
INSERT INTO `wl_form_group` VALUES ('0', '全部建筑', 'allBuilding', 'allBuilding', 'building_add,pool_add,fireRoom_add,rainRoom_add,fireFoamRoom_add,fireControlRoom_add', '2581805', '2020-12-22 11:01:43');
INSERT INTO `wl_form_group` VALUES ('132828674810', '建(构)筑', 'building', 'building', 'edit,delete,floor_add,room_add', '2581805', '2020-12-22 11:01:44');
INSERT INTO `wl_form_group` VALUES ('132828674811', '消防控制室', 'fireControlRoom', 'building', 'edit,delete,floor_add,room_add', '2581805', '2020-12-22 11:01:44');
INSERT INTO `wl_form_group` VALUES ('132828674812', '消防水池', 'pool', 'building', 'edit,delete,floor_add,room_add', '2581805', '2020-12-22 11:01:44');
INSERT INTO `wl_form_group` VALUES ('132828674813', '消防小室', 'fireRoom', 'building', 'edit,delete,floor_add,room_add', '2581805', '2020-12-22 11:01:44');
INSERT INTO `wl_form_group` VALUES ('132828674814', '雨淋阀间', 'rainRoom', 'building', 'edit,delete,floor_add,room_add', '2581805', '2020-12-22 11:01:44');
INSERT INTO `wl_form_group` VALUES ('132828674815', '消防泡沫间', 'fireFoamRoom', 'building', 'edit,delete,floor_add,room_add', '2581805', '2020-12-22 11:01:44');
INSERT INTO `wl_form_group` VALUES ('132828674817', '消防控制室', 'r_fireControlRoom', 'room', 'edit,delete', '2581805', '2020-12-18 11:29:34');
INSERT INTO `wl_form_group` VALUES ('132828674818', '消防水池', 'r_pool', 'room', 'edit,delete', '2581805', '2020-12-18 11:29:34');
INSERT INTO `wl_form_group` VALUES ('132828674819', '消防小室', 'r_fireRoom', 'room', 'edit,delete', '2581805', '2020-12-18 11:29:34');
INSERT INTO `wl_form_group` VALUES ('132828674820', '雨淋阀间', 'r_rainRoom', 'room', 'edit,delete', '2581805', '2020-12-18 11:29:34');
INSERT INTO `wl_form_group` VALUES ('132828674821', '消防泡沫间', 'r_fireFoamRoom', 'room', 'edit,delete', '2581805', '2020-12-18 11:29:34');
INSERT INTO `wl_form_group` VALUES ('132828674822', '楼层', 'floor', 'floor', 'edit,delete,room_add', '2581805', '2020-12-22 11:01:44');
INSERT INTO `wl_form_group` VALUES ('132828674823', '其他', 'r_else', 'room', 'edit,delete', '2581805', '2020-12-22 11:58:49');

-- ----------------------------
-- Table structure for wl_form_group_column
-- ----------------------------
DROP TABLE IF EXISTS `wl_form_group_column`;
CREATE TABLE `wl_form_group_column` (
  `id` bigint(20) NOT NULL,
  `field_name` varchar(100) NOT NULL COMMENT '字段名',
  `field_label` varchar(100) NOT NULL COMMENT '中文名',
  `data_type` varchar(100) NOT NULL COMMENT '数据类型：文本，数字，枚举,日期',
  `group_id` bigint(20) NOT NULL COMMENT '字段分组主键',
  `query_strategy` varchar(100) DEFAULT NULL COMMENT '查询策略;全等,模糊,区间',
  `not_null` bit(1) NOT NULL DEFAULT b'0' COMMENT '不能为空',
  `group_code` varchar(50) NOT NULL COMMENT '所属分组编号',
  `creator_id` bigint(20) NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `unique_idx_group_code_file_name` (`group_code`,`field_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='分组字段表';

-- ----------------------------
-- Records of wl_form_group_column
-- ----------------------------
INSERT INTO `wl_form_group_column` VALUES ('133000000000', 'code', '建（构）筑编号', 'String', '132828674810', 'eq', '', 'building', '2581805', '2020-12-21 17:27:17');
INSERT INTO `wl_form_group_column` VALUES ('133000000001', 'buildType', '建（构）筑类别', 'Enum', '132828674810', 'eq', '', 'building', '2581805', '2020-12-21 17:28:12');
INSERT INTO `wl_form_group_column` VALUES ('133000000002', 'name', '建（构）筑名称', 'String', '132828674810', 'eq', '', 'building', '2581805', '2020-12-21 17:28:14');
INSERT INTO `wl_form_group_column` VALUES ('133000000003', 'address', '建筑地址', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:12');
INSERT INTO `wl_form_group_column` VALUES ('133000000004', 'constructionUnit', '施工单位', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-21 16:05:42');
INSERT INTO `wl_form_group_column` VALUES ('133000000005', 'designUnit', '设计单位', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-21 16:05:42');
INSERT INTO `wl_form_group_column` VALUES ('133000000006', 'buildUseType', '使用性质', 'Enum', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-21 16:05:42');
INSERT INTO `wl_form_group_column` VALUES ('133000000007', 'buildDate', '建造日期', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:21');
INSERT INTO `wl_form_group_column` VALUES ('133000000008', 'height', '建筑高度（m）', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:22');
INSERT INTO `wl_form_group_column` VALUES ('133000000009', 'area', '建筑面积（㎡）', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:23');
INSERT INTO `wl_form_group_column` VALUES ('133000000010', 'floorArea', '占地面积（㎡）', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:24');
INSERT INTO `wl_form_group_column` VALUES ('133000000011', 'standardFloorArea', '标准层面积（㎡）', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:25');
INSERT INTO `wl_form_group_column` VALUES ('133000000012', 'upperPlies', '地上层数', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:27');
INSERT INTO `wl_form_group_column` VALUES ('133000000013', 'upperArea', '地上建筑面积（㎡）', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:28');
INSERT INTO `wl_form_group_column` VALUES ('133000000014', 'lowerPlies', '地下层数', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:30');
INSERT INTO `wl_form_group_column` VALUES ('133000000015', 'lowerArea', '地下建筑面积（㎡）', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:31');
INSERT INTO `wl_form_group_column` VALUES ('133000000016', 'structureType', '结构类型', 'Enum', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:37');
INSERT INTO `wl_form_group_column` VALUES ('133000000017', 'fireRisk', '火灾危险性', 'Enum', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:38');
INSERT INTO `wl_form_group_column` VALUES ('133000000018', 'fireFightingType', '建筑消防设施类别', 'Enum', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:39');
INSERT INTO `wl_form_group_column` VALUES ('133000000019', 'emergencyExitsNum', '安全出口数量', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2021-01-13 15:24:40');
INSERT INTO `wl_form_group_column` VALUES ('133000000020', 'emergencyExitsLoc', '安全出口位置', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000021', 'emergencyExitsType', '安全出口形式', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000022', 'cableWellLoc', '电缆井位置（强电和弱电）', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000023', 'pipingShaftLoc', '管道井位置', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000024', 'cableInterlayerLoc', '电缆夹层位置', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000025', 'workingPersonNum', '日常工作时间人数', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000026', 'maximumCapacity', '最大容纳人数', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000027', 'code', '消控室编号', 'String', '132828674811', 'eq', '', 'fireControlRoom', '2581805', '2020-12-21 17:29:15');
INSERT INTO `wl_form_group_column` VALUES ('133000000028', 'name', '消控室名称', 'String', '132828674811', 'eq', '', 'fireControlRoom', '2581805', '2020-12-21 17:29:17');
INSERT INTO `wl_form_group_column` VALUES ('133000000029', 'dutyUser', '责任人', 'String', '132828674811', 'eq', '', 'fireControlRoom', '2581805', '2020-12-21 17:29:18');
INSERT INTO `wl_form_group_column` VALUES ('133000000030', 'useDate', '投用日期', 'String', '132828674811', 'eq', '', 'fireControlRoom', '2581805', '2020-12-21 17:29:20');
INSERT INTO `wl_form_group_column` VALUES ('133000000031', 'constructionUnit', '施工单位', 'String', '132828674811', 'eq', '\0', 'fireControlRoom', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000032', 'maintenanceUnit', '维保单位', 'String', '132828674811', 'eq', '', 'fireControlRoom', '2581805', '2020-12-21 17:29:23');
INSERT INTO `wl_form_group_column` VALUES ('133000000033', 'personNum', '每班人数', 'String', '132828674811', 'eq', '', 'fireControlRoom', '2581805', '2020-12-21 17:29:26');
INSERT INTO `wl_form_group_column` VALUES ('133000000034', 'installLoc', '安装位置描述', 'String', '132828674811', 'eq', '', 'fireControlRoom', '2581805', '2020-12-21 17:29:28');
INSERT INTO `wl_form_group_column` VALUES ('133000000035', 'hasFirePlan', '火灾预案（有无）', 'String', '132828674811', 'eq', '\0', 'fireControlRoom', '2581805', '2020-12-22 22:20:37');
INSERT INTO `wl_form_group_column` VALUES ('133000000036', 'certificatesPersonNum', '消防控制室操作人员持证数', 'String', '132828674811', 'eq', '', 'fireControlRoom', '2581805', '2020-12-21 17:29:33');
INSERT INTO `wl_form_group_column` VALUES ('133000000037', 'name', '名称', 'String', '132828674812', 'eq', '', 'pool', '2581805', '2020-12-21 17:29:41');
INSERT INTO `wl_form_group_column` VALUES ('133000000038', 'code', '编码', 'String', '132828674812', 'eq', '', 'pool', '2581805', '2020-12-21 17:29:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000039', 'constructionUnit', '施工单位', 'String', '132828674812', 'eq', '\0', 'pool', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000040', 'designUnit', '设计单位', 'String', '132828674812', 'eq', '\0', 'pool', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000041', 'maintenanceUnit', '维保单位', 'String', '132828674812', 'eq', '\0', 'pool', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000042', 'buildDate', '建造日期', 'String', '132828674812', 'eq', '', 'pool', '2581805', '2020-12-21 17:29:46');
INSERT INTO `wl_form_group_column` VALUES ('133000000043', 'address', '地址', 'String', '132828674812', 'eq', '', 'pool', '2581805', '2020-12-21 17:29:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000044', 'system', '所属系统', 'String', '132828674812', 'eq', '\0', 'pool', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000045', 'volume', '容量(m³)', 'String', '132828674812', 'eq', '\0', 'pool', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000046', 'height', '高度（m）', 'String', '132828674812', 'eq', '', 'pool', '2581805', '2020-12-21 17:29:57');
INSERT INTO `wl_form_group_column` VALUES ('133000000047', 'bottomArea', '底面积（㎡）', 'String', '132828674812', 'eq', '', 'pool', '2581805', '2020-12-21 17:30:01');
INSERT INTO `wl_form_group_column` VALUES ('133000000048', 'lowWaterHeight', '低水位警戒高度（m）', 'String', '132828674812', 'eq', '', 'pool', '2581805', '2020-12-21 17:30:03');
INSERT INTO `wl_form_group_column` VALUES ('133000000049', 'waterStorage', '储水量（m³）', 'String', '132828674812', 'eq', '', 'pool', '2581805', '2020-12-21 17:30:07');
INSERT INTO `wl_form_group_column` VALUES ('133000000050', 'buildDistance', '距建筑物（水泵房除外）的距离（m）', 'String', '132828674812', 'eq', '\0', 'pool', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000051', 'dutyUser', '责任人', 'String', '132828674812', 'eq', '\0', 'pool', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000052', 'antiFreezingMeasures', '防冻措施', 'String', '132828674812', 'eq', '', 'pool', '2581805', '2020-12-21 17:30:10');
INSERT INTO `wl_form_group_column` VALUES ('133000000053', 'liquidLevelMeter', '配套液位计型号', 'String', '132828674812', 'eq', '\0', 'pool', '2581805', '2020-12-21 16:05:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000054', 'name', '名称', 'String', '132828674813', 'eq', '', 'fireRoom', '2581805', '2020-12-21 17:30:23');
INSERT INTO `wl_form_group_column` VALUES ('133000000055', 'code', '编码', 'String', '132828674813', 'eq', '', 'fireRoom', '2581805', '2020-12-21 17:30:26');
INSERT INTO `wl_form_group_column` VALUES ('133000000056', 'system', '所属系统', 'String', '132828674813', 'eq', '\0', 'fireRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000057', 'address', '地址', 'String', '132828674813', 'eq', '', 'fireRoom', '2581805', '2020-12-21 17:30:29');
INSERT INTO `wl_form_group_column` VALUES ('133000000058', 'buildDate', '建造日期', 'String', '132828674813', 'eq', '\0', 'fireRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000059', 'area', '面积(㎡)', 'String', '132828674813', 'eq', '\0', 'fireRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000060', 'dutyUser', '责任人', 'String', '132828674813', 'eq', '\0', 'fireRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000061', 'name', '名称', 'String', '132828674814', 'eq', '', 'rainRoom', '2581805', '2020-12-21 17:30:40');
INSERT INTO `wl_form_group_column` VALUES ('133000000062', 'code', '编码', 'String', '132828674814', 'eq', '', 'rainRoom', '2581805', '2020-12-21 17:30:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000063', 'system', '所属系统', 'String', '132828674814', 'eq', '\0', 'rainRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000064', 'address', '地址', 'String', '132828674814', 'eq', '', 'rainRoom', '2581805', '2020-12-21 17:30:45');
INSERT INTO `wl_form_group_column` VALUES ('133000000065', 'area', '面积(㎡)', 'String', '132828674814', 'eq', '\0', 'rainRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000066', 'name', '名称', 'String', '132828674815', 'eq', '', 'fireFoamRoom', '2581805', '2020-12-21 17:30:53');
INSERT INTO `wl_form_group_column` VALUES ('133000000067', 'code', '编码', 'String', '132828674815', 'eq', '', 'fireFoamRoom', '2581805', '2020-12-21 17:30:57');
INSERT INTO `wl_form_group_column` VALUES ('133000000068', 'system', '所属系统', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000069', 'address', '地址', 'String', '132828674815', 'eq', '', 'fireFoamRoom', '2581805', '2020-12-21 17:31:02');
INSERT INTO `wl_form_group_column` VALUES ('133000000070', 'installDate', '安装日期', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000071', 'area', '面积(㎡)', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000072', 'maintenanceUnit', '维保单位', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000073', 'constructionUnit', '施工单位', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000074', 'dutyUser', '责任人', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000075', 'fireSystem', '所属系统', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000076', 'protectedObjects', '保护对象', 'String', '132828674815', 'eq', '', 'fireFoamRoom', '2581805', '2020-12-21 17:31:16');
INSERT INTO `wl_form_group_column` VALUES ('133000000077', 'fireFightingTime', '灭火时间（分钟）', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000078', 'waterLevel', '水位(m)', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000079', 'foamLevel', '泡沫液位(m)', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000080', 'foamExtinguishingAgentName', '泡沫灭火剂名称', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000081', 'mixingRatio', '混合比', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000082', 'nozzlesNum', '喷头数量', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000083', 'name', '消控室编号', 'String', '132828674817', 'eq', '', 'r_fireControlRoom', '2581805', '2020-12-21 17:31:45');
INSERT INTO `wl_form_group_column` VALUES ('133000000084', 'code', '消控室名称', 'String', '132828674817', 'eq', '', 'r_fireControlRoom', '2581805', '2020-12-21 17:31:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000085', 'dutyUser', '责任人', 'String', '132828674817', 'eq', '', 'r_fireControlRoom', '2581805', '2020-12-21 17:31:54');
INSERT INTO `wl_form_group_column` VALUES ('133000000086', 'useDate', '投用日期', 'String', '132828674817', 'eq', '', 'r_fireControlRoom', '2581805', '2020-12-22 22:21:35');
INSERT INTO `wl_form_group_column` VALUES ('133000000087', 'constructionUnit', '施工单位', 'String', '132828674817', 'eq', '\0', 'r_fireControlRoom', '2581805', '2020-12-21 16:05:44');
INSERT INTO `wl_form_group_column` VALUES ('133000000088', 'maintenanceUnit', '维保单位', 'String', '132828674817', 'eq', '', 'r_fireControlRoom', '2581805', '2020-12-21 17:32:02');
INSERT INTO `wl_form_group_column` VALUES ('133000000089', 'inwhichBuild', '消控室所在建（构）筑', 'String', '132828674817', 'eq', '', 'r_fireControlRoom', '2581805', '2020-12-21 17:32:05');
INSERT INTO `wl_form_group_column` VALUES ('133000000090', 'installLoc', '安装位置描述', 'String', '132828674817', 'eq', '', 'r_fireControlRoom', '2581805', '2020-12-21 17:32:08');
INSERT INTO `wl_form_group_column` VALUES ('133000000091', 'personNum', '每班人数', 'String', '132828674817', 'eq', '', 'r_fireControlRoom', '2581805', '2020-12-21 17:32:10');
INSERT INTO `wl_form_group_column` VALUES ('133000000092', 'certificatesPersonNum', '消防控制室操作人员持证数', 'String', '132828674817', 'eq', '', 'r_fireControlRoom', '2581805', '2020-12-21 17:32:11');
INSERT INTO `wl_form_group_column` VALUES ('133000000093', 'hasFirePlan', '火灾预案（有无）', 'String', '132828674817', 'eq', '', 'r_fireControlRoom', '2581805', '2020-12-21 17:32:14');
INSERT INTO `wl_form_group_column` VALUES ('133000000094', 'name', '名称', 'String', '132828674818', 'eq', '', 'r_pool', '2581805', '2020-12-21 17:32:20');
INSERT INTO `wl_form_group_column` VALUES ('133000000095', 'code', '编码', 'String', '132828674818', 'eq', '', 'r_pool', '2581805', '2020-12-21 17:32:25');
INSERT INTO `wl_form_group_column` VALUES ('133000000096', 'constructionUnit', '施工单位', 'String', '132828674818', 'eq', '\0', 'r_pool', '2581805', '2020-12-21 16:05:45');
INSERT INTO `wl_form_group_column` VALUES ('133000000097', 'designUnit', '设计单位', 'String', '132828674818', 'eq', '\0', 'r_pool', '2581805', '2020-12-21 16:05:45');
INSERT INTO `wl_form_group_column` VALUES ('133000000098', 'maintenanceUnit', '维保单位', 'String', '132828674818', 'eq', '\0', 'r_pool', '2581805', '2020-12-21 16:05:45');
INSERT INTO `wl_form_group_column` VALUES ('133000000099', 'buildDate', '建造日期', 'String', '132828674818', 'eq', '', 'r_pool', '2581805', '2020-12-21 17:32:26');
INSERT INTO `wl_form_group_column` VALUES ('133000000100', 'inwhichBuild', '所在建筑', 'String', '132828674818', 'eq', '', 'r_pool', '2581805', '2020-12-21 17:32:29');
INSERT INTO `wl_form_group_column` VALUES ('133000000101', 'address', '地址', 'String', '132828674818', 'eq', '', 'r_pool', '2581805', '2020-12-21 17:32:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000102', 'system', '所属系统', 'String', '132828674818', 'eq', '\0', 'r_pool', '2581805', '2020-12-21 16:05:45');
INSERT INTO `wl_form_group_column` VALUES ('133000000103', 'volume', '容量(m³)', 'String', '132828674818', 'eq', '\0', 'r_pool', '2581805', '2020-12-21 16:05:45');
INSERT INTO `wl_form_group_column` VALUES ('133000000104', 'height', '高度（m）', 'String', '132828674818', 'eq', '', 'r_pool', '2581805', '2020-12-21 17:32:46');
INSERT INTO `wl_form_group_column` VALUES ('133000000105', 'bottomArea', '底面积（㎡）', 'String', '132828674818', 'eq', '', 'r_pool', '2581805', '2020-12-21 17:32:49');
INSERT INTO `wl_form_group_column` VALUES ('133000000106', 'lowWaterHeight', '低水位警戒高度（m）', 'String', '132828674818', 'eq', '', 'r_pool', '2581805', '2020-12-21 17:32:51');
INSERT INTO `wl_form_group_column` VALUES ('133000000107', 'waterStorage', '储水量（m³）', 'String', '132828674818', 'eq', '', 'r_pool', '2581805', '2020-12-21 17:32:55');
INSERT INTO `wl_form_group_column` VALUES ('133000000108', 'buildDistance', '距建筑物（水泵房除外）的距离（m）', 'String', '132828674818', 'eq', '\0', 'r_pool', '2581805', '2020-12-21 16:05:46');
INSERT INTO `wl_form_group_column` VALUES ('133000000109', 'dutyUser', '责任人', 'String', '132828674818', 'eq', '\0', 'r_pool', '2581805', '2020-12-21 16:05:46');
INSERT INTO `wl_form_group_column` VALUES ('133000000110', 'antiFreezingMeasures', '防冻措施', 'String', '132828674818', 'eq', '', 'r_pool', '2581805', '2020-12-21 17:32:58');
INSERT INTO `wl_form_group_column` VALUES ('133000000111', 'liquidLevelMeter', '配套液位计型号', 'String', '132828674818', 'eq', '\0', 'r_pool', '2581805', '2020-12-21 16:05:46');
INSERT INTO `wl_form_group_column` VALUES ('133000000112', 'name', '名称', 'String', '132828674819', 'eq', '', 'r_fireRoom', '2581805', '2020-12-21 17:33:13');
INSERT INTO `wl_form_group_column` VALUES ('133000000113', 'code', '编码', 'String', '132828674819', 'eq', '', 'r_fireRoom', '2581805', '2020-12-21 17:33:14');
INSERT INTO `wl_form_group_column` VALUES ('133000000114', 'inwhichBuild', '所在建筑', 'String', '132828674819', 'eq', '', 'r_fireRoom', '2581805', '2020-12-21 17:33:16');
INSERT INTO `wl_form_group_column` VALUES ('133000000115', 'address', '地址', 'String', '132828674819', 'eq', '', 'r_fireRoom', '2581805', '2020-12-21 17:33:17');
INSERT INTO `wl_form_group_column` VALUES ('133000000116', 'system', '所属系统', 'String', '132828674819', 'eq', '\0', 'r_fireRoom', '2581805', '2020-12-21 16:05:46');
INSERT INTO `wl_form_group_column` VALUES ('133000000117', 'area', '面积(㎡)', 'String', '132828674819', 'eq', '\0', 'r_fireRoom', '2581805', '2020-12-21 16:05:46');
INSERT INTO `wl_form_group_column` VALUES ('133000000118', 'buildDate', '建造日期', 'String', '132828674819', 'eq', '\0', 'r_fireRoom', '2581805', '2020-12-21 16:05:46');
INSERT INTO `wl_form_group_column` VALUES ('133000000119', 'dutyUser', '责任人', 'String', '132828674819', 'eq', '\0', 'r_fireRoom', '2581805', '2020-12-21 16:05:46');
INSERT INTO `wl_form_group_column` VALUES ('133000000120', 'name', '名称', 'String', '132828674820', 'eq', '', 'r_rainRoom', '2581805', '2020-12-21 17:33:33');
INSERT INTO `wl_form_group_column` VALUES ('133000000121', 'code', '编码', 'String', '132828674820', 'eq', '', 'r_rainRoom', '2581805', '2020-12-21 17:33:36');
INSERT INTO `wl_form_group_column` VALUES ('133000000122', 'inwhichBuild', '所在建筑', 'String', '132828674820', 'eq', '', 'r_rainRoom', '2581805', '2020-12-21 17:33:38');
INSERT INTO `wl_form_group_column` VALUES ('133000000123', 'address', '地址', 'String', '132828674820', 'eq', '', 'r_rainRoom', '2581805', '2020-12-21 17:33:42');
INSERT INTO `wl_form_group_column` VALUES ('133000000124', 'system', '所属系统', 'String', '132828674820', 'eq', '\0', 'r_rainRoom', '2581805', '2020-12-21 16:05:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000125', 'area', '面积(㎡)', 'String', '132828674820', 'eq', '\0', 'r_rainRoom', '2581805', '2020-12-21 16:05:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000126', 'name', '名称', 'String', '132828674821', 'eq', '', 'r_fireFoamRoom', '2581805', '2020-12-21 17:33:50');
INSERT INTO `wl_form_group_column` VALUES ('133000000127', 'code', '编码', 'String', '132828674821', 'eq', '', 'r_fireFoamRoom', '2581805', '2020-12-21 17:33:52');
INSERT INTO `wl_form_group_column` VALUES ('133000000128', 'inwhichBuild', '所在建筑', 'String', '132828674821', 'eq', '', 'r_fireFoamRoom', '2581805', '2020-12-21 17:33:53');
INSERT INTO `wl_form_group_column` VALUES ('133000000129', 'address', '地址', 'String', '132828674821', 'eq', '', 'r_fireFoamRoom', '2581805', '2020-12-21 17:35:01');
INSERT INTO `wl_form_group_column` VALUES ('133000000130', 'system', '所属系统', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-21 16:05:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000131', 'area', '面积(㎡)', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-21 16:05:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000132', 'installDate', '安装日期', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-21 16:05:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000133', 'constructionUnit', '施工单位', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-21 16:05:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000134', 'maintenanceUnit', '维保单位', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-21 16:05:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000135', 'dutyUser', '责任人', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-21 16:05:48');
INSERT INTO `wl_form_group_column` VALUES ('133000000137', 'protectedObjects', '保护对象', 'String', '132828674821', 'eq', '', 'r_fireFoamRoom', '2581805', '2020-12-21 17:35:12');
INSERT INTO `wl_form_group_column` VALUES ('133000000138', 'fireFightingTime', '灭火时间（分钟）', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-21 16:05:48');
INSERT INTO `wl_form_group_column` VALUES ('133000000139', 'waterLevel', '水位(m)', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-21 16:05:48');
INSERT INTO `wl_form_group_column` VALUES ('133000000140', 'foamLevel', '泡沫液位(m)', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-21 16:05:48');
INSERT INTO `wl_form_group_column` VALUES ('133000000141', 'foamExtinguishingAgentName', '泡沫灭火剂名称', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-21 16:05:48');
INSERT INTO `wl_form_group_column` VALUES ('133000000142', 'mixingRatio', '混合比', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-21 16:05:48');
INSERT INTO `wl_form_group_column` VALUES ('133000000143', 'nozzlesNum', '喷头数量', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-21 16:05:49');
INSERT INTO `wl_form_group_column` VALUES ('133000000144', 'name', '名称', 'String', '132828674823', 'eq', '', 'r_else', '2581805', '2020-12-22 12:00:21');
INSERT INTO `wl_form_group_column` VALUES ('133000000145', 'code', '编码', 'String', '132828674823', 'eq', '', 'r_else', '2581805', '2020-12-22 12:00:22');
INSERT INTO `wl_form_group_column` VALUES ('133000000146', 'inwhichBuild', '所在建筑', 'String', '132828674823', 'eq', '', 'r_else', '2581805', '2020-12-22 12:00:22');
INSERT INTO `wl_form_group_column` VALUES ('133000000147', 'address', '地址', 'String', '132828674823', 'eq', '\0', 'r_else', '2581805', '2021-01-13 15:35:05');
INSERT INTO `wl_form_group_column` VALUES ('133000000148', 'area', '面积(㎡)', 'String', '132828674823', 'eq', '\0', 'r_else', '2581805', '2020-12-22 12:00:23');
INSERT INTO `wl_form_group_column` VALUES ('133000000149', 'usage', '使用用途', 'String', '132828674823', 'eq', '\0', 'r_else', '2581805', '2021-01-13 15:35:07');
INSERT INTO `wl_form_group_column` VALUES ('133000000150', 'dutyUser', '责任人', 'String', '132828674823', 'eq', '\0', 'r_else', '2581805', '2020-12-22 12:00:24');
INSERT INTO `wl_form_group_column` VALUES ('133000000151', 'inwhichBuild', '所在建（构）筑', 'String', '132828674822', 'eq', '', 'floor', '2581805', '2020-12-22 12:01:03');
INSERT INTO `wl_form_group_column` VALUES ('133000000152', 'name', '楼层', 'String', '132828674822', 'eq', '', 'floor', '2581805', '2020-12-22 12:01:04');
INSERT INTO `wl_form_group_column` VALUES ('133000000154', 'parentId', '父级id', 'String', '132828674810', 'eq', '', 'building', '2581805', '2020-12-21 17:36:08');
INSERT INTO `wl_form_group_column` VALUES ('133000000155', 'parentId', '父级id', 'String', '132828674811', 'eq', '', 'fireControlRoom', '2581805', '2020-12-21 17:36:10');
INSERT INTO `wl_form_group_column` VALUES ('133000000156', 'parentId', '父级id', 'String', '132828674812', 'eq', '', 'pool', '2581805', '2020-12-21 17:36:11');
INSERT INTO `wl_form_group_column` VALUES ('133000000157', 'parentId', '父级id', 'String', '132828674813', 'eq', '', 'fireRoom', '2581805', '2020-12-21 17:36:14');
INSERT INTO `wl_form_group_column` VALUES ('133000000158', 'parentId', '父级id', 'String', '132828674815', 'eq', '', 'fireFoamRoom', '2581805', '2020-12-21 17:36:16');
INSERT INTO `wl_form_group_column` VALUES ('133000000159', 'parentId', '父级id', 'String', '132828674817', 'eq', '', 'r_fireControlRoom', '2581805', '2020-12-21 17:36:18');
INSERT INTO `wl_form_group_column` VALUES ('133000000160', 'parentId', '父级id', 'String', '132828674818', 'eq', '', 'r_pool', '2581805', '2020-12-21 17:36:19');
INSERT INTO `wl_form_group_column` VALUES ('133000000161', 'parentId', '父级id', 'String', '132828674819', 'eq', '', 'r_fireRoom', '2581805', '2020-12-21 17:36:22');
INSERT INTO `wl_form_group_column` VALUES ('133000000162', 'parentId', '父级id', 'String', '132828674821', 'eq', '', 'r_fireFoamRoom', '2581805', '2020-12-21 17:36:23');
INSERT INTO `wl_form_group_column` VALUES ('133000000163', 'parentId', '父级id', 'String', '132828674823', 'eq', '', 'r_else', '2581805', '2020-12-22 12:00:25');
INSERT INTO `wl_form_group_column` VALUES ('133000000164', 'parentId', '父级id', 'String', '132828674820', 'eq', '', 'r_rainRoom', '2581805', '2020-12-21 17:36:32');
INSERT INTO `wl_form_group_column` VALUES ('133000000165', 'parentId', '父级id', 'String', '132828674822', 'eq', '', 'floor', '2581805', '2020-12-22 12:01:04');
INSERT INTO `wl_form_group_column` VALUES ('133000000166', 'dutyUser', '责任人', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-21 16:05:51');
INSERT INTO `wl_form_group_column` VALUES ('133000000167', 'dutyUserPhone', '责任人电话', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-21 16:05:51');
INSERT INTO `wl_form_group_column` VALUES ('133000000168', 'parentId', '父级id', 'String', '132828674814', 'eq', '', 'rainRoom', '2581805', '2020-12-21 17:36:43');
INSERT INTO `wl_form_group_column` VALUES ('133000000171', 'code', '编号', 'String', '132828674822', 'eq', '\0', 'floor', '2581805', '2020-12-22 12:01:04');
INSERT INTO `wl_form_group_column` VALUES ('133000000172', 'isRisk', '是否为风险区域', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000173', 'isRisk', '是否为风险区域', 'String', '132828674811', 'eq', '\0', 'fireControlRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000174', 'isRisk', '是否为风险区域', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000175', 'isRisk', '是否为风险区域', 'String', '132828674813', 'eq', '\0', 'fireRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000176', 'isRisk', '是否为风险区域', 'String', '132828674822', 'eq', '\0', 'floor', '2581805', '2020-12-22 12:01:04');
INSERT INTO `wl_form_group_column` VALUES ('133000000177', 'isRisk', '是否为风险区域', 'String', '132828674812', 'eq', '\0', 'pool', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000178', 'isRisk', '是否为风险区域', 'String', '132828674814', 'eq', '\0', 'rainRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000179', 'isRisk', '是否为风险区域', 'String', '132828674823', 'eq', '\0', 'r_else', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000180', 'isRisk', '是否为风险区域', 'String', '132828674817', 'eq', '\0', 'r_fireControlRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000181', 'isRisk', '是否为风险区域', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000182', 'isRisk', '是否为风险区域', 'String', '132828674819', 'eq', '\0', 'r_fireRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000183', 'isRisk', '是否为风险区域', 'String', '132828674818', 'eq', '\0', 'r_pool', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000184', 'isRisk', '是否为风险区域', 'String', '132828674820', 'eq', '\0', 'r_rainRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000185', 'riskPointId', '风险区域根节点', 'String', '132828674810', 'eq', '\0', 'building', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000186', 'riskPointId', '风险区域根节点', 'String', '132828674811', 'eq', '\0', 'fireControlRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000187', 'riskPointId', '风险区域根节点', 'String', '132828674815', 'eq', '\0', 'fireFoamRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000188', 'riskPointId', '风险区域根节点', 'String', '132828674813', 'eq', '\0', 'fireRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000201', 'riskPointId', '风险区域根节点', 'String', '132828674812', 'eq', '\0', 'pool', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000202', 'riskPointId', '风险区域根节点', 'String', '132828674814', 'eq', '\0', 'rainRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000203', 'riskPointId', '风险区域根节点', 'String', '132828674823', 'eq', '\0', 'r_else', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000204', 'riskPointId', '风险区域根节点', 'String', '132828674817', 'eq', '\0', 'r_fireControlRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000205', 'riskPointId', '风险区域根节点', 'String', '132828674821', 'eq', '\0', 'r_fireFoamRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000206', 'riskPointId', '风险区域根节点', 'String', '132828674819', 'eq', '\0', 'r_fireRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000207', 'riskPointId', '风险区域根节点', 'String', '132828674818', 'eq', '\0', 'r_pool', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000208', 'riskPointId', '风险区域根节点', 'String', '132828674820', 'eq', '\0', 'r_rainRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` VALUES ('133000000210', 'riskPointId', '风险区域根节点', 'String', '132828674822', 'eq', '\0', 'floor', '2581805', '2020-12-22 12:01:04');
INSERT INTO `wl_form_group_column` VALUES ('133000000211', 'dutyUser', '责任人', 'String', '132828674814', 'eq', '\0', 'rainRoom', '2581805', '2020-12-22 12:01:04');
INSERT INTO `wl_form_group_column` VALUES ('133000000212', 'dutyUser', '责任人', 'String', '132828674820', 'eq', '\0', 'r_rainRoom', '2581805', '2020-12-22 12:01:04');
INSERT INTO `wl_form_group_column` (`id`, `field_name`, `field_label`, `data_type`, `group_id`, `query_strategy`, `not_null`, `group_code`, `creator_id`, `create_date`) VALUES ('133000000213', 'belongAreaId', '所属物理区域', 'String', '132828674810', 'eq', b'0', 'building', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` (`id`, `field_name`, `field_label`, `data_type`, `group_id`, `query_strategy`, `not_null`, `group_code`, `creator_id`, `create_date`) VALUES ('133000000214', 'belongAreaId', '所属物理区域', 'String', '132828674811', 'eq', b'0', 'fireControlRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` (`id`, `field_name`, `field_label`, `data_type`, `group_id`, `query_strategy`, `not_null`, `group_code`, `creator_id`, `create_date`) VALUES ('133000000215', 'belongAreaId', '所属物理区域', 'String', '132828674815', 'eq', b'0', 'fireFoamRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` (`id`, `field_name`, `field_label`, `data_type`, `group_id`, `query_strategy`, `not_null`, `group_code`, `creator_id`, `create_date`) VALUES ('133000000216', 'belongAreaId', '所属物理区域', 'String', '132828674813', 'eq', b'0', 'fireRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` (`id`, `field_name`, `field_label`, `data_type`, `group_id`, `query_strategy`, `not_null`, `group_code`, `creator_id`, `create_date`) VALUES ('133000000217', 'belongAreaId', '所属物理区域', 'String', '132828674822', 'eq', b'0', 'floor', '2581805', '2020-12-22 12:01:04');
INSERT INTO `wl_form_group_column` (`id`, `field_name`, `field_label`, `data_type`, `group_id`, `query_strategy`, `not_null`, `group_code`, `creator_id`, `create_date`) VALUES ('133000000218', 'belongAreaId', '所属物理区域', 'String', '132828674812', 'eq', b'0', 'pool', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` (`id`, `field_name`, `field_label`, `data_type`, `group_id`, `query_strategy`, `not_null`, `group_code`, `creator_id`, `create_date`) VALUES ('133000000219', 'belongAreaId', '所属物理区域', 'String', '132828674814', 'eq', b'0', 'rainRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` (`id`, `field_name`, `field_label`, `data_type`, `group_id`, `query_strategy`, `not_null`, `group_code`, `creator_id`, `create_date`) VALUES ('133000000220', 'belongAreaId', '所属物理区域', 'String', '132828674823', 'eq', b'0', 'r_else', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` (`id`, `field_name`, `field_label`, `data_type`, `group_id`, `query_strategy`, `not_null`, `group_code`, `creator_id`, `create_date`) VALUES ('133000000221', 'belongAreaId', '所属物理区域', 'String', '132828674817', 'eq', b'0', 'r_fireControlRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` (`id`, `field_name`, `field_label`, `data_type`, `group_id`, `query_strategy`, `not_null`, `group_code`, `creator_id`, `create_date`) VALUES ('133000000222', 'belongAreaId', '所属物理区域', 'String', '132828674821', 'eq', b'0', 'r_fireFoamRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` (`id`, `field_name`, `field_label`, `data_type`, `group_id`, `query_strategy`, `not_null`, `group_code`, `creator_id`, `create_date`) VALUES ('133000000223', 'belongAreaId', '所属物理区域', 'String', '132828674819', 'eq', b'0', 'r_fireRoom', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` (`id`, `field_name`, `field_label`, `data_type`, `group_id`, `query_strategy`, `not_null`, `group_code`, `creator_id`, `create_date`) VALUES ('133000000224', 'belongAreaId', '所属物理区域', 'String', '132828674818', 'eq', b'0', 'r_pool', '2581805', '2020-12-29 12:04:47');
INSERT INTO `wl_form_group_column` (`id`, `field_name`, `field_label`, `data_type`, `group_id`, `query_strategy`, `not_null`, `group_code`, `creator_id`, `create_date`) VALUES ('133000000225', 'belongAreaId', '所属物理区域', 'String', '132828674820', 'eq', b'0', 'r_rainRoom', '2581805', '2020-12-29 12:04:47');

-- ----------------------------
-- Table structure for wl_form_instance
-- ----------------------------
DROP TABLE IF EXISTS `wl_form_instance`;
CREATE TABLE `wl_form_instance` (
  `id` bigint(20) NOT NULL,
  `field_name` varchar(100) NOT NULL COMMENT '字段名',
  `field_label` varchar(100) NOT NULL COMMENT '中文名',
  `data_type` varchar(100) NOT NULL COMMENT '数据类型：文本，数字，枚举,日期',
  `group_type` varchar(20) DEFAULT NULL COMMENT '分组类型(冗余字段便于查询）',
  `group_id` bigint(20) NOT NULL COMMENT '字段分组id',
  `field_value` varchar(1024) DEFAULT NULL COMMENT '动态配置字段的值',
  `instance_id` bigint(20) NOT NULL COMMENT '设备实例id',
  `group_column_id` bigint(20) NOT NULL COMMENT '字段定义信息的主键',
  `query_strategy` varchar(100) DEFAULT NULL COMMENT '查询策略;全等,模糊,区间',
  `group_code` varchar(100) NOT NULL COMMENT '分组编号',
  `creator_id` bigint(20) NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `u_idx_instance_id` (`instance_id`,`field_name`) USING BTREE,
  KEY `idx_group_code` (`group_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='实例表';

-- ----------------------------
-- Records of wl_form_instance
-- ----------------------------

-- ----------------------------
-- Table structure for wl_industry
-- ----------------------------
DROP TABLE IF EXISTS `wl_industry`;
CREATE TABLE `wl_industry` (
  `id` bigint(20) NOT NULL,
  `name` varchar(50) DEFAULT NULL COMMENT '行业名',
  `code` varchar(50) DEFAULT NULL COMMENT '行业编码',
  `industry_sort` bigint(20) DEFAULT NULL COMMENT '排序字段',
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `code_index` (`code`) USING BTREE COMMENT '行业编码唯一索引'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='行业表';

-- ----------------------------
-- Records of wl_industry
-- ----------------------------
INSERT INTO `wl_industry` VALUES ('10001', '安防设备', '1', '2', '2021-01-21 08:58:01');
INSERT INTO `wl_industry` VALUES ('10002', '消防设备', '2', '1', '2021-01-21 08:58:03');
INSERT INTO `wl_industry` VALUES ('10003', '电力设备', '3', '3', '2021-01-21 08:58:05');

-- ----------------------------
-- Table structure for wl_journal
-- ----------------------------
DROP TABLE IF EXISTS `wl_journal`;
CREATE TABLE `wl_journal` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_date` datetime DEFAULT NULL,
  `equipment_detail_id` bigint(20) DEFAULT NULL COMMENT '装备详情定义id',
  `warehouse_structure_id` bigint(20) DEFAULT NULL COMMENT '货位id',
  `state` bigint(20) DEFAULT NULL COMMENT '操作状态，入库，出库，维修，保养，报废，借用，转移等。',
  `amount` decimal(12,2) DEFAULT NULL COMMENT '库存数量',
  `remark` varchar(100) DEFAULT NULL COMMENT '备注',
  `stock_detail_id` bigint(20) DEFAULT NULL COMMENT '单据id',
  `car_id` bigint(20) DEFAULT NULL COMMENT '车辆id',
  `user_id` bigint(100) DEFAULT NULL COMMENT '用户id',
  `user_name` varchar(255) DEFAULT NULL COMMENT '用户名称',
  `org_code` varchar(50) DEFAULT NULL COMMENT '公司code',
  `company_name` varchar(255) DEFAULT NULL COMMENT '公司名',
  `department_orgcode` varchar(255) DEFAULT NULL COMMENT '部门code',
  `department_name` varchar(255) DEFAULT NULL COMMENT '部门名',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `state` (`state`) USING BTREE,
  KEY `ix_journal_for_equipment_detail_id` (`equipment_detail_id`) USING BTREE,
  KEY `ix_journal_for_shelf_cell_id` (`warehouse_structure_id`) USING BTREE,
  KEY `ix_journal_for_stock_detail_id` (`stock_detail_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1384775695683780610 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='流水表';

-- ----------------------------
-- Records of wl_journal
-- ----------------------------

-- ----------------------------
-- Table structure for wl_maintain
-- ----------------------------
DROP TABLE IF EXISTS `wl_maintain`;
CREATE TABLE `wl_maintain` (
  `id` bigint(20) NOT NULL COMMENT 'id',
  `bill_code` varchar(255) NOT NULL COMMENT '单据code',
  `maintain_time` datetime DEFAULT NULL COMMENT '保养时间',
  `bill_type` varchar(20) DEFAULT NULL COMMENT '单据类型',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `user_id` bigint(20) DEFAULT NULL COMMENT '保养人id',
  `org_code` varchar(255) DEFAULT NULL COMMENT '公司code',
  `company_name` varchar(255) DEFAULT NULL COMMENT '公司名称',
  `department_orgcode` varchar(255) DEFAULT NULL COMMENT '部门code',
  `department_name` varchar(255) DEFAULT NULL COMMENT '部门名称',
  `creator_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='保养单据';

-- ----------------------------
-- Records of wl_maintain
-- ----------------------------

-- ----------------------------
-- Table structure for wl_maintain_detail
-- ----------------------------
DROP TABLE IF EXISTS `wl_maintain_detail`;
CREATE TABLE `wl_maintain_detail` (
  `id` bigint(20) NOT NULL COMMENT 'id',
  `stock_detail_id` bigint(20) DEFAULT NULL COMMENT '库存明细id',
  `car_id` bigint(20) DEFAULT NULL COMMENT '车辆id',
  `content` varchar(255) DEFAULT NULL COMMENT '保养内容',
  `amount` double DEFAULT NULL COMMENT '保养的数量',
  `cycle` int(20) DEFAULT NULL COMMENT '保养天数',
  `next_time` datetime DEFAULT NULL COMMENT '保养周期',
  `maintain_id` bigint(20) DEFAULT NULL COMMENT '保养单据id',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='保养单据详情';

-- ----------------------------
-- Records of wl_maintain_detail
-- ----------------------------

-- ----------------------------
-- Table structure for wl_manufacturer_info
-- ----------------------------
DROP TABLE IF EXISTS `wl_manufacturer_info`;
CREATE TABLE `wl_manufacturer_info` (
  `id` bigint(20) NOT NULL COMMENT '以下注释个人猜+有道，有错请修改',
  `name` varchar(200) NOT NULL COMMENT '名称',
  `address` varchar(255) DEFAULT NULL COMMENT '地址',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `contact_number` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `create_date` datetime DEFAULT NULL,
  `maintenanceservices` varchar(10) DEFAULT NULL COMMENT '维保',
  `old_name` varchar(50) DEFAULT NULL COMMENT '曾用名',
  `legal_rep` varchar(50) DEFAULT NULL COMMENT '法人代表',
  `sales_tel` varchar(20) DEFAULT NULL COMMENT '销售电话',
  `service_tel` varchar(50) DEFAULT NULL COMMENT '服务电话',
  `technical_standard` text COMMENT '拟定技术标准',
  `number` int(11) DEFAULT NULL COMMENT '人数',
  `technician_number` int(11) DEFAULT NULL COMMENT '技术人员数',
  `fixed_assets` decimal(12,2) DEFAULT NULL COMMENT '固定资产',
  `testing_equipment` text COMMENT '检测设备',
  `qualifications` text COMMENT '资质',
  `historical_evolution` text COMMENT '历史沿革',
  `research_record` text COMMENT '研制记录',
  `product_type` varchar(50) DEFAULT NULL COMMENT '生产企业类型',
  `img` text COMMENT '图片',
  `registered_capital` decimal(12,2) DEFAULT NULL COMMENT '注册资本',
  `nature_id` bigint(20) DEFAULT NULL COMMENT '企业性质ID',
  `type_id` bigint(20) DEFAULT NULL COMMENT '类型id',
  `country_id` bigint(20) DEFAULT NULL COMMENT '国家id',
  `province_id` bigint(20) DEFAULT NULL COMMENT '省份id',
  `country` varchar(50) DEFAULT NULL COMMENT '国家',
  `nature` varchar(50) DEFAULT NULL COMMENT '企业性质',
  `province` varchar(50) DEFAULT NULL COMMENT '省份',
  `type` varchar(50) DEFAULT NULL COMMENT '类型',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_manufacturer_info_name` (`name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='生成厂商（供应商）';

-- ----------------------------
-- Records of wl_manufacturer_info
-- ----------------------------

-- ----------------------------
-- Table structure for wl_notice
-- ----------------------------
DROP TABLE IF EXISTS `wl_notice`;
CREATE TABLE `wl_notice` (
  `id` bigint(20) NOT NULL,
  `content` text COMMENT '详情内容',
  `notice_type_id` bigint(20) DEFAULT NULL COMMENT '通知类型',
  `title` varchar(255) DEFAULT NULL COMMENT '通知标题',
  `stock_bill_id` bigint(20) DEFAULT NULL COMMENT '单据id',
  `create_date` datetime DEFAULT NULL,
  `org_code` varchar(255) DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `department_name` varchar(255) DEFAULT NULL,
  `department_orgcode` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `stock_bill_id` (`stock_bill_id`) USING BTREE,
  KEY `ix_notice_for_notice_type_id_and_bill_id` (`notice_type_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消息表';

-- ----------------------------
-- Records of wl_notice
-- ----------------------------

-- ----------------------------
-- Table structure for wl_perf_quota
-- ----------------------------
DROP TABLE IF EXISTS `wl_perf_quota`;
CREATE TABLE `wl_perf_quota` (
  `equipment_id` bigint(20) DEFAULT NULL COMMENT '指标拥有者ID:关联装备定义ID、car_id',
  `perf_value` varchar(200) DEFAULT NULL COMMENT '值',
  `id` bigint(20) NOT NULL,
  `perf_quota_definition_id` bigint(20) DEFAULT NULL COMMENT '性能指标定义id',
  `perf_group_code` varchar(30) DEFAULT NULL COMMENT '性能指标分组code',
  `perf_type` bigint(20) DEFAULT NULL COMMENT '性能指标类型：车辆或装备',
  `date_created` datetime DEFAULT NULL,
  `is_importent_parameter` tinyint(4) DEFAULT NULL COMMENT '是否核心参数',
  `symbol` varchar(200) DEFAULT NULL COMMENT '符号',
  `create_date` datetime DEFAULT NULL,
  `group_name` varchar(255) DEFAULT NULL COMMENT '分组，车辆用',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `equipment_id` (`equipment_id`) USING BTREE,
  KEY `perf_type` (`perf_type`) USING BTREE,
  KEY `perf_quota_definition_id` (`perf_quota_definition_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防装备/消防车指标';

-- ----------------------------
-- Records of wl_perf_quota
-- ----------------------------

-- ----------------------------
-- Table structure for wl_perf_quota_definition
-- ----------------------------
DROP TABLE IF EXISTS `wl_perf_quota_definition`;
CREATE TABLE `wl_perf_quota_definition` (
  `id` bigint(20) NOT NULL,
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `unit_id` bigint(20) DEFAULT NULL COMMENT '单位id',
  `perf_level` int(11) DEFAULT NULL COMMENT '指标级别(值越小越重要，用户越关心)：',
  `perf_type` bigint(20) DEFAULT NULL COMMENT '指标类型',
  `remark` varchar(50) DEFAULT NULL COMMENT '备注',
  `create_date` datetime DEFAULT NULL,
  `temp_code` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `unit_id` (`unit_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='性能指标定义';

-- ----------------------------
-- Records of wl_perf_quota_definition
-- ----------------------------

-- ----------------------------
-- Table structure for wl_repair
-- ----------------------------
DROP TABLE IF EXISTS `wl_repair`;
CREATE TABLE `wl_repair` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `bill_code` varchar(30) DEFAULT NULL COMMENT '维修单号',
  `bill_type` varchar(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL COMMENT '创建人',
  `org_code` varchar(50) DEFAULT NULL COMMENT '组织机构（公司+部门）',
  `company_name` varchar(255) DEFAULT NULL,
  `department_name` varchar(255) DEFAULT NULL,
  `department_orgcode` varchar(255) DEFAULT NULL,
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `creator_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `scrap_type_id` (`bill_type`) USING BTREE,
  KEY `ix_scrap_for_number` (`bill_code`) USING BTREE,
  KEY `ix_scrap_for_creator_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1384710528198299651 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='维修单据';

-- ----------------------------
-- Records of wl_repair
-- ----------------------------

-- ----------------------------
-- Table structure for wl_repair_detail
-- ----------------------------
DROP TABLE IF EXISTS `wl_repair_detail`;
CREATE TABLE `wl_repair_detail` (
  `id` bigint(20) NOT NULL,
  `repair_id` bigint(20) DEFAULT NULL COMMENT '维修单id',
  `car_id` bigint(20) DEFAULT NULL COMMENT '车辆id',
  `stock_detail_id` bigint(20) DEFAULT NULL COMMENT '库存明细账id',
  `amount` decimal(12,2) DEFAULT NULL COMMENT '报废数量',
  `reason` text COMMENT '原因',
  `create_date` datetime NOT NULL COMMENT '创建日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `scrap_id` (`repair_id`) USING BTREE,
  KEY `stock_detail_id` (`stock_detail_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='维修单据详情';

-- ----------------------------
-- Records of wl_repair_detail
-- ----------------------------

-- ----------------------------
-- Table structure for wl_risk_source_scene
-- ----------------------------
DROP TABLE IF EXISTS `wl_risk_source_scene`;
CREATE TABLE `wl_risk_source_scene` (
  `id` bigint(20) NOT NULL COMMENT '主键',
  `risk_source_id` bigint(20) NOT NULL COMMENT '风险点id',
  `risk_source_name` varchar(255) DEFAULT NULL COMMENT '风险名称',
  `scene_id` bigint(20) NOT NULL COMMENT '组态场景id',
  `org_code` varchar(20) DEFAULT NULL COMMENT '公司code',
  `create_date` datetime DEFAULT NULL COMMENT '创建日期',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `content` json DEFAULT NULL COMMENT '画布',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_risk_source_id` (`risk_source_id`,`org_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='风险场景关联关系表';

-- ----------------------------
-- Records of wl_risk_source_scene
-- ----------------------------

-- ----------------------------
-- Table structure for wl_scrap
-- ----------------------------
DROP TABLE IF EXISTS `wl_scrap`;
CREATE TABLE `wl_scrap` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `bill_code` varchar(30) DEFAULT NULL COMMENT '报废单号',
  `bill_type` varchar(20) DEFAULT NULL COMMENT '1:装备，2：车辆，3：灭火药剂',
  `attachment` text COMMENT '附件',
  `user_id` bigint(20) DEFAULT NULL COMMENT '创建人',
  `status` int(11) DEFAULT NULL COMMENT '状态',
  `org_code` varchar(50) DEFAULT NULL COMMENT '组织机构（公司+部门）',
  `company_name` varchar(255) DEFAULT NULL COMMENT '公司名称',
  `department_name` varchar(255) DEFAULT NULL COMMENT '部门名称',
  `department_orgcode` varchar(255) DEFAULT NULL COMMENT '部门code',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `creator_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `scrap_type_id` (`bill_type`) USING BTREE,
  KEY `ix_scrap_for_number` (`bill_code`) USING BTREE,
  KEY `ix_scrap_for_creator_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1384749204547809282 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='报废单据';

-- ----------------------------
-- Records of wl_scrap
-- ----------------------------

-- ----------------------------
-- Table structure for wl_scrap_detail
-- ----------------------------
DROP TABLE IF EXISTS `wl_scrap_detail`;
CREATE TABLE `wl_scrap_detail` (
  `id` bigint(20) NOT NULL,
  `scrap_id` bigint(20) DEFAULT NULL COMMENT '报废单id',
  `car_id` bigint(20) DEFAULT NULL COMMENT '车辆id',
  `stock_detail_id` bigint(20) DEFAULT NULL COMMENT '库存明细账id',
  `amount` decimal(12,2) DEFAULT NULL COMMENT '报废数量',
  `reason` text COMMENT '报废原因',
  `create_date` datetime NOT NULL COMMENT '创建日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `scrap_id` (`scrap_id`) USING BTREE,
  KEY `stock_detail_id` (`stock_detail_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='报废单据详情';

-- ----------------------------
-- Records of wl_scrap_detail
-- ----------------------------

-- ----------------------------
-- Table structure for wl_source_file
-- ----------------------------
DROP TABLE IF EXISTS `wl_source_file`;
CREATE TABLE `wl_source_file` (
  `id` bigint(20) NOT NULL COMMENT '物理主键',
  `file_path` varchar(255) NOT NULL COMMENT '文件路径',
  `file_name` varchar(255) NOT NULL COMMENT '文件名称',
  `file_category` varchar(50) NOT NULL COMMENT '文件分类',
  `source_id` bigint(20) NOT NULL COMMENT '所属者',
  `creator_id` bigint(20) NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='资源与文件关联关系表';

-- ----------------------------
-- Records of wl_source_file
-- ----------------------------

-- ----------------------------
-- Table structure for wl_source_scene
-- ----------------------------
DROP TABLE IF EXISTS `wl_source_scene`;
CREATE TABLE `wl_source_scene` (
  `id` bigint(20) NOT NULL COMMENT '主键',
  `source_id` bigint(20) NOT NULL COMMENT '资源点id',
  `source_name` varchar(255) DEFAULT NULL COMMENT '资源点名称',
  `project_id` bigint(20) DEFAULT NULL COMMENT '组态工程id',
  `scene_id` bigint(20) DEFAULT NULL COMMENT '组态场景id',
  `point_in_scene` text COMMENT '场景包含的点（逗号分割）',
  `creator_id` bigint(20) NOT NULL COMMENT '创建者id',
  `create_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `video_in_scene` text COMMENT '视频绑定点',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_risk_source_id` (`source_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='资源与场景关联关系表';

-- ----------------------------
-- Records of wl_source_scene
-- ----------------------------

-- ----------------------------
-- Table structure for wl_stock
-- ----------------------------
DROP TABLE IF EXISTS `wl_stock`;
CREATE TABLE `wl_stock` (
  `id` bigint(20) NOT NULL,
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `equipment_detail_id` bigint(20) DEFAULT NULL COMMENT '装备定义ID',
  `amount` decimal(12,2) DEFAULT NULL COMMENT '库存数量',
  `org_code` varchar(50) DEFAULT NULL COMMENT '组织机构编码',
  `create_date` datetime DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `department_name` varchar(255) DEFAULT NULL,
  `department_orgcode` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `equipment_detail_id` (`equipment_detail_id`) USING BTREE,
  KEY `ix_stock_for_warehouse_id_and_equipment_detail_id` (`warehouse_id`,`equipment_detail_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='库存台账';

-- ----------------------------
-- Records of wl_stock
-- ----------------------------

-- ----------------------------
-- Table structure for wl_stock_bill
-- ----------------------------
DROP TABLE IF EXISTS `wl_stock_bill`;
CREATE TABLE `wl_stock_bill` (
  `id` bigint(20) NOT NULL,
  `bill_code` varchar(20) NOT NULL COMMENT '单据编码',
  `bill_type` bigint(20) DEFAULT NULL COMMENT '单据类型',
  `agent_user_id` bigint(20) DEFAULT NULL COMMENT '经手人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `warehouse_id` bigint(20) DEFAULT NULL COMMENT '仓库ID',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `org_code` varchar(50) DEFAULT NULL COMMENT '组织机构编码',
  `attachment` text COMMENT '附件',
  `company_name` varchar(255) DEFAULT NULL,
  `department_name` varchar(255) DEFAULT NULL,
  `department_orgcode` varchar(255) DEFAULT NULL,
  `creator_name` varchar(50) DEFAULT NULL COMMENT '创建人名称',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_stock_bill_org_code` (`org_code`) USING BTREE,
  KEY `idx_stock_bill_bill_type` (`bill_type`) USING BTREE,
  KEY `ix_stock_bill_for_bill_code` (`bill_code`) USING BTREE,
  KEY `ix_stock_bill_for_bill_type` (`bill_type`) USING BTREE,
  KEY `ix_stock_bill_for_creator_id` (`creator_id`) USING BTREE,
  KEY `ix_stock_bill_for_warehouse_id` (`warehouse_id`) USING BTREE,
  KEY `ix_stock_bill_for_bill_code_and_org_code` (`bill_code`,`org_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='库存单据';

-- ----------------------------
-- Records of wl_stock_bill
-- ----------------------------

-- ----------------------------
-- Table structure for wl_stock_bill_detail
-- ----------------------------
DROP TABLE IF EXISTS `wl_stock_bill_detail`;
CREATE TABLE `wl_stock_bill_detail` (
  `id` bigint(20) NOT NULL,
  `warehouse_structure_id` bigint(20) NOT NULL COMMENT '货位ID',
  `equipment_detail_id` bigint(20) NOT NULL COMMENT '装备定义id',
  `standard` varchar(50) DEFAULT NULL COMMENT '规格型号',
  `batch_num` varchar(50) DEFAULT NULL COMMENT '批次号',
  `single_equip_code` varchar(30) DEFAULT NULL COMMENT '单件装备编码',
  `date_expired` datetime DEFAULT NULL COMMENT '有效期至',
  `amount` decimal(12,2) DEFAULT NULL COMMENT '出入库数量',
  `stock_detail_id` bigint(20) DEFAULT NULL COMMENT '库存明细ID',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `rfid` varchar(10) DEFAULT NULL,
  `stock_bill_id` bigint(20) NOT NULL COMMENT '库存单据id',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '创建人',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `shelf_cell_id` (`warehouse_structure_id`) USING BTREE,
  KEY `idx_stock_bill_detail_date_created` (`create_date`) USING BTREE,
  KEY `idx_stock_bill_detail_equipment_detail_id` (`equipment_detail_id`) USING BTREE,
  KEY `idx_stock_bill_detail_stock_bill_id` (`stock_bill_id`) USING BTREE,
  KEY `ix_stock_bill_detail_for_equipment_detail_id` (`equipment_detail_id`) USING BTREE,
  KEY `ix_stock_bill_detail_for_stock_detail_id` (`stock_detail_id`) USING BTREE,
  KEY `ix_stock_bill_detail_for_stock_bill_id` (`stock_bill_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='库存单据详情';

-- ----------------------------
-- Records of wl_stock_bill_detail
-- ----------------------------

-- ----------------------------
-- Table structure for wl_stock_detail
-- ----------------------------
DROP TABLE IF EXISTS `wl_stock_detail`;
CREATE TABLE `wl_stock_detail` (
  `id` bigint(20) NOT NULL,
  `stock_id` bigint(20) NOT NULL COMMENT '库存ID',
  `amount` decimal(12,2) DEFAULT NULL COMMENT '库存数量',
  `warehouse_structure_id` bigint(20) NOT NULL COMMENT '货位ID',
  `equipment_detail_id` bigint(20) NOT NULL COMMENT '装备详情id',
  `maintenance_time` datetime DEFAULT NULL COMMENT '保养时间',
  `warehouse_id` bigint(20) DEFAULT NULL COMMENT '仓库id',
  `qr_code` varchar(50) DEFAULT NULL COMMENT '二维码',
  `status` varchar(20) DEFAULT NULL COMMENT '状态',
  `rfid` varchar(20) DEFAULT NULL,
  `org_code` varchar(50) DEFAULT NULL COMMENT '组织机构编码',
  `company_name` varchar(255) DEFAULT NULL,
  `department_name` varchar(255) DEFAULT NULL,
  `department_orgcode` varchar(255) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `create_date` datetime DEFAULT NULL COMMENT '建账时间',
  `batch_num` varchar(50) DEFAULT NULL COMMENT '批次号',
  `description` varchar(255) DEFAULT NULL COMMENT '位置描述',
  `equipment_specific_id` bigint(20) DEFAULT NULL COMMENT '单个设备ID',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `equipment_detail_id` (`equipment_detail_id`) USING BTREE,
  KEY `warehouse_id` (`warehouse_id`) USING BTREE,
  KEY `ix_stock_detail_for_stock_id` (`stock_id`) USING BTREE,
  KEY `ix_stock_detail_for_shelf_cell_id` (`warehouse_structure_id`) USING BTREE,
  KEY `ix_stock_detail_for_shelf_cell_id_and_e_and_w` (`warehouse_structure_id`,`equipment_detail_id`,`warehouse_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='库存明细';

-- ----------------------------
-- Records of wl_stock_detail
-- ----------------------------

-- ----------------------------
-- Table structure for wl_stock_warning_rule
-- ----------------------------
DROP TABLE IF EXISTS `wl_stock_warning_rule`;
CREATE TABLE `wl_stock_warning_rule` (
  `id` bigint(20) NOT NULL,
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `stock_id` bigint(20) DEFAULT NULL COMMENT '库存ID',
  `amount` decimal(12,0) DEFAULT NULL COMMENT '预警数量',
  `date_updated` datetime DEFAULT NULL COMMENT '修改时间',
  `reviser_id` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `date_created` datetime DEFAULT NULL COMMENT '创建时间',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `org_code` varchar(50) DEFAULT NULL COMMENT '组织机构编码',
  `equipment_id` bigint(20) NOT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `department_name` varchar(255) DEFAULT NULL,
  `department_orgcode` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `equipment_id` (`equipment_id`) USING BTREE,
  KEY `stock_id` (`stock_id`) USING BTREE,
  KEY `warehouse_id` (`warehouse_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='库存告警规则设置';

-- ----------------------------
-- Records of wl_stock_warning_rule
-- ----------------------------

-- ----------------------------
-- Table structure for wl_system_dic
-- ----------------------------
DROP TABLE IF EXISTS `wl_system_dic`;
CREATE TABLE `wl_system_dic` (
  `id` bigint(20) NOT NULL,
  `code` varchar(10) DEFAULT NULL COMMENT '编码',
  `name` varchar(100) DEFAULT NULL COMMENT '名称',
  `type` varchar(50) DEFAULT NULL COMMENT '类型',
  `create_date` datetime DEFAULT NULL,
  `remark` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `ix_system_dic_for_code_and_type` (`type`,`code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='数据字典';

-- ----------------------------
-- Records of wl_system_dic
-- ----------------------------
INSERT INTO `wl_system_dic` VALUES ('1', '01', '社会单位', 'EnterpriseType', '2017-05-03 10:48:26', null);
INSERT INTO `wl_system_dic` VALUES ('2', '02', '专职单位', 'EnterpriseType', '2017-05-03 10:48:26', null);
INSERT INTO `wl_system_dic` VALUES ('3', '03', '消防单位', 'EnterpriseType', '2017-05-03 10:48:26', null);
INSERT INTO `wl_system_dic` VALUES ('4', '01', '车辆', 'PerfQuotaType', '2017-05-03 10:48:26', null);
INSERT INTO `wl_system_dic` VALUES ('5', '02', '装备', 'PerfQuotaType', '2017-05-03 10:48:26', null);
INSERT INTO `wl_system_dic` VALUES ('6', '01', '消防栓', 'WaterSourceType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('7', '02', '消防水池', 'WaterSourceType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('8', '03', '消防水鹤', 'WaterSourceType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('9', '04', '消防取水码头', 'WaterSourceType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('10', '01', '继续存储', 'SolveSuggestion', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('11', '02', '发放', 'SolveSuggestion', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('12', '03', '维修', 'SolveSuggestion', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('13', '04', '报废', 'SolveSuggestion', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('14', '00', '未进行', 'InventoryState', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('15', '01', '未完成', 'InventoryState', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('16', '02', '已完成', 'InventoryState', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('17', '00', '自动', 'GenerateType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('18', '01', '手动', 'GenerateType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('19', '01', '入库通知', 'NoticeType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('20', '02', '出库通知', 'NoticeType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('21', '03', '调拨通知', 'NoticeType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('22', '04', '退役报废通知', 'NoticeType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('23', '05', '盘点通知', 'NoticeType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('24', '01', '入库', 'JournalType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('25', '02', '出库', 'JournalType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('26', '03', '维修', 'JournalType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('27', '04', '维修完成', 'JournalType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('28', '05', '报废', 'JournalType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('29', '06', '保养', 'JournalType', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('31', '01', '归还', 'DebtState', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('32', '02', '报废', 'DebtState', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('33', '01', '在库', 'AutomaticInventoryState', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('34', '02', '出库', 'AutomaticInventoryState', '2017-05-03 10:48:27', null);
INSERT INTO `wl_system_dic` VALUES ('42', '01', '区', 'CellType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('43', '02', '架', 'CellType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('44', '03', '层', 'CellType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('45', '04', '格', 'CellType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('46', '0', '在用', 'ShelfCellType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('47', '1', '仓储', 'ShelfCellType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('48', '01', '单件', 'EquipmentManagementType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('49', '02', '批量', 'EquipmentManagementType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('50', '1', '入库', 'StockBillType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('51', '2', '保养', 'StockBillType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('52', '3', '维修', 'StockBillType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('53', '4', '维修完成', 'StockBillType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('54', '5', '报废', 'StockBillType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('55', '6', '其他出库', 'StockBillType', '2017-05-03 10:48:28', null);
INSERT INTO `wl_system_dic` VALUES ('56', '01', '网页', 'NoticePlatform', '2017-07-22 00:19:59', null);
INSERT INTO `wl_system_dic` VALUES ('57', '02', '手持机', 'NoticePlatform', '2017-07-22 00:19:59', null);
INSERT INTO `wl_system_dic` VALUES ('58', '03', '平板', 'NoticePlatform', '2017-07-22 00:19:59', null);
INSERT INTO `wl_system_dic` VALUES ('59', '01', '退役', 'ScrapType', '2017-07-22 00:19:59', null);
INSERT INTO `wl_system_dic` VALUES ('60', '02', '报废', 'ScrapType', '2017-07-22 00:19:59', null);
INSERT INTO `wl_system_dic` VALUES ('61', '01', '石油化工', 'ExpertType', '2017-07-22 00:19:59', null);
INSERT INTO `wl_system_dic` VALUES ('62', '02', '高层火灾', 'ExpertType', '2017-07-22 00:19:59', null);
INSERT INTO `wl_system_dic` VALUES ('63', '02', '手持机', 'GenerateType', '2017-07-22 00:19:59', null);
INSERT INTO `wl_system_dic` VALUES ('64', '01', '未归还', 'DebtOnEquipmentDetailState', '2017-07-22 00:20:00', null);
INSERT INTO `wl_system_dic` VALUES ('65', '02', '部分归还', 'DebtOnEquipmentDetailState', '2017-07-22 00:20:00', null);
INSERT INTO `wl_system_dic` VALUES ('66', '03', '已归还', 'DebtOnEquipmentDetailState', '2017-07-22 00:20:00', null);
INSERT INTO `wl_system_dic` VALUES ('67', '01', '原位归还', 'DebtOnEquipmentDetailRecordType', '2017-07-22 00:20:00', null);
INSERT INTO `wl_system_dic` VALUES ('68', '02', '异位归还', 'DebtOnEquipmentDetailRecordType', '2017-07-22 00:20:00', null);
INSERT INTO `wl_system_dic` VALUES ('72', '01', '到期报废', 'ScrapReasonType', '2017-07-22 00:20:02', null);
INSERT INTO `wl_system_dic` VALUES ('73', '02', '损耗报废', 'ScrapReasonType', '2017-07-22 00:20:02', null);
INSERT INTO `wl_system_dic` VALUES ('74', '03', '丢失报废', 'ScrapReasonType', '2017-07-22 00:20:02', null);
INSERT INTO `wl_system_dic` VALUES ('75', '04', '其他报废', 'ScrapReasonType', '2017-07-22 00:20:02', null);
INSERT INTO `wl_system_dic` VALUES ('76', '07', '车载', 'JournalType', '2017-07-22 00:20:03', null);
INSERT INTO `wl_system_dic` VALUES ('77', '08', '卸载', 'JournalType', '2017-07-22 00:20:03', null);
INSERT INTO `wl_system_dic` VALUES ('78', '09', '损耗', 'JournalType', '2017-07-22 00:20:03', null);
INSERT INTO `wl_system_dic` VALUES ('82', '06', '借用通知', 'NoticeType', '2017-07-22 00:20:04', null);
INSERT INTO `wl_system_dic` VALUES ('83', '07', '保养通知', 'NoticeType', '2017-07-22 00:20:04', null);
INSERT INTO `wl_system_dic` VALUES ('84', '1', '待打印', 'DebtOnEquipmentBillState', '2017-07-22 00:20:05', null);
INSERT INTO `wl_system_dic` VALUES ('85', '2', '已借出', 'DebtOnEquipmentBillState', '2017-07-22 00:20:05', null);
INSERT INTO `wl_system_dic` VALUES ('86', '3', '未归还', 'DebtOnEquipmentBillState', '2017-07-22 00:20:05', null);
INSERT INTO `wl_system_dic` VALUES ('87', '08', '检查通知', 'NoticeType', '2017-07-22 00:20:05', null);
INSERT INTO `wl_system_dic` VALUES ('94', '09', '自动入库', 'NoticeType', '2017-07-22 00:20:05', null);
INSERT INTO `wl_system_dic` VALUES ('95', '10', '自动出库', 'NoticeType', '2017-07-22 00:20:05', null);
INSERT INTO `wl_system_dic` VALUES ('96', '01', '库存告警', 'AlarmType', '2017-07-22 00:20:06', null);
INSERT INTO `wl_system_dic` VALUES ('97', '02', '保养到期告警', 'AlarmType', '2017-07-22 00:20:06', null);
INSERT INTO `wl_system_dic` VALUES ('98', '03', '保养过期告警', 'AlarmType', '2017-07-22 00:20:06', null);
INSERT INTO `wl_system_dic` VALUES ('99', '04', '借用到期告警', 'AlarmType', '2017-07-22 00:20:06', null);
INSERT INTO `wl_system_dic` VALUES ('100', '05', '借用过期告警', 'AlarmType', '2017-07-22 00:20:06', null);
INSERT INTO `wl_system_dic` VALUES ('101', '11', '其他仓库入库', 'NoticeType', '2017-07-22 00:20:06', null);
INSERT INTO `wl_system_dic` VALUES ('103', '4', '已归还', 'DebtOnEquipmentBillState', '2017-07-22 00:20:06', null);
INSERT INTO `wl_system_dic` VALUES ('104', '06', '检查到期告警', 'AlarmType', '2017-07-22 00:20:06', null);
INSERT INTO `wl_system_dic` VALUES ('105', '07', '检查过期告警', 'AlarmType', '2017-07-22 00:20:06', null);
INSERT INTO `wl_system_dic` VALUES ('106', '12', '调拨入库通知', 'NoticeType', '2017-07-22 00:20:06', null);
INSERT INTO `wl_system_dic` VALUES ('107', '13', '调拨出库通知', 'NoticeType', '2017-07-22 00:20:06', null);
INSERT INTO `wl_system_dic` VALUES ('108', '08', '其它仓库入库告警', 'AlarmType', '2017-07-22 00:20:06', null);
INSERT INTO `wl_system_dic` VALUES ('109', '09', '未识别标签告警', 'AlarmType', '2017-07-22 00:20:06', null);
INSERT INTO `wl_system_dic` VALUES ('110', '1', '审计日志', 'LogType', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('111', '2', '功能日志', 'LogType', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('112', '1', '库存', 'EquipStatus', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('113', '2', '执勤', 'EquipStatus', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('114', '3', '维修', 'EquipStatus', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('115', '4', '借出', 'EquipStatus', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('116', '5', '借入', 'EquipStatus', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('117', '6', '退役', 'EquipStatus', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('118', '7', '报废', 'EquipStatus', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('119', '1', '在位', 'CarState', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('120', '2', '执勤', 'CarState', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('121', '3', '维修', 'CarState', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('122', '4', '借出', 'CarState', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('123', '5', '借入', 'CarState', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('124', '6', '退役', 'CarState', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('125', '7', '报废', 'CarState', '2017-07-22 00:20:07', null);
INSERT INTO `wl_system_dic` VALUES ('126', '01', '中国', 'Country', '2017-07-29 13:07:43', 'CHN');
INSERT INTO `wl_system_dic` VALUES ('127', '02', '日本', 'Country', '2017-07-29 13:07:43', 'JPN');
INSERT INTO `wl_system_dic` VALUES ('128', '03', '德国', 'Country', '2017-07-29 13:07:43', 'DEU');
INSERT INTO `wl_system_dic` VALUES ('129', '1', '器材', 'BillContent', '2017-08-05 14:55:42', null);
INSERT INTO `wl_system_dic` VALUES ('130', '2', '车辆', 'BillContent', '2017-08-05 14:55:42', null);
INSERT INTO `wl_system_dic` VALUES ('131', '14', '维修通知', 'NoticeType', '2017-08-05 14:55:42', null);
INSERT INTO `wl_system_dic` VALUES ('132', '15', '调拨指令', 'NoticeType', '2017-08-05 14:55:43', null);
INSERT INTO `wl_system_dic` VALUES ('133', '04', '美国', 'Country', '2017-08-05 14:55:43', 'USA');
INSERT INTO `wl_system_dic` VALUES ('134', '05', '韩国', 'Country', '2017-08-05 14:55:43', 'KOR');
INSERT INTO `wl_system_dic` VALUES ('135', '06', '加拿大', 'Country', '2017-08-05 14:55:43', 'CAN');
INSERT INTO `wl_system_dic` VALUES ('136', '07', '波兰', 'Country', '2017-08-05 14:55:43', 'POL');
INSERT INTO `wl_system_dic` VALUES ('137', '08', '英国', 'Country', '2017-08-05 14:55:43', 'GBR');
INSERT INTO `wl_system_dic` VALUES ('138', '09', '法国', 'Country', '2017-08-05 14:55:43', 'FRA');
INSERT INTO `wl_system_dic` VALUES ('139', '10', '奥地利', 'Country', '2017-08-05 14:55:43', 'AUT');
INSERT INTO `wl_system_dic` VALUES ('140', '11', '芬兰', 'Country', '2017-08-05 14:55:43', 'FIN');
INSERT INTO `wl_system_dic` VALUES ('141', '12', '库克', 'Country', '2017-08-05 14:55:43', 'COK');
INSERT INTO `wl_system_dic` VALUES ('142', '13', '瑞典', 'Country', '2017-08-05 14:55:43', 'SWE');
INSERT INTO `wl_system_dic` VALUES ('143', '14', '爱沙尼亚', 'Country', '2017-08-05 14:55:43', 'EST');
INSERT INTO `wl_system_dic` VALUES ('144', '15', '阿鲁巴', 'Country', '2017-08-05 14:55:43', 'ABW');
INSERT INTO `wl_system_dic` VALUES ('145', '5', '已完成', 'DebtOnEquipmentBillState', '2017-08-05 14:55:43', null);
INSERT INTO `wl_system_dic` VALUES ('146', '4', '人员', 'BillContent', '2017-08-05 14:55:43', null);
INSERT INTO `wl_system_dic` VALUES ('147', '01', '单位调派', 'DispatchType', '2017-08-05 15:11:52', null);
INSERT INTO `wl_system_dic` VALUES ('148', '02', '车辆调派', 'DispatchType', '2017-08-05 15:11:52', null);
INSERT INTO `wl_system_dic` VALUES ('149', '03', '器材装备调派', 'DispatchType', '2017-08-05 15:11:52', null);
INSERT INTO `wl_system_dic` VALUES ('150', '04', '重点单位调派', 'DispatchType', '2017-08-05 15:11:52', null);
INSERT INTO `wl_system_dic` VALUES ('151', '05', '专家调派', 'DispatchType', '2017-08-05 15:11:52', null);
INSERT INTO `wl_system_dic` VALUES ('152', '04', '重点单位', 'EnterpriseType', '2017-08-05 15:11:52', null);
INSERT INTO `wl_system_dic` VALUES ('153', '04', '智能调派', 'NoticePlatform', '2017-08-05 15:11:52', null);
INSERT INTO `wl_system_dic` VALUES ('154', '1', '待打印', 'AllocationOrderState', '2017-08-10 09:34:54', null);
INSERT INTO `wl_system_dic` VALUES ('155', '2', '待调出', 'AllocationOrderState', '2017-08-10 09:34:54', null);
INSERT INTO `wl_system_dic` VALUES ('156', '3', '待确认', 'AllocationOrderState', '2017-08-10 09:34:54', null);
INSERT INTO `wl_system_dic` VALUES ('157', '4', '已完成', 'AllocationOrderState', '2017-08-10 09:34:54', null);
INSERT INTO `wl_system_dic` VALUES ('158', '8', '归还', 'EquipStatus', '2017-08-10 09:34:54', null);
INSERT INTO `wl_system_dic` VALUES ('159', '3', '灭火药剂', 'BillContent', '2017-08-10 09:34:54', null);
INSERT INTO `wl_system_dic` VALUES ('160', '01', '待退役', 'ScrapState', '2017-08-15 11:52:59', null);
INSERT INTO `wl_system_dic` VALUES ('161', '02', '待报废', 'ScrapState', '2017-08-15 11:52:59', null);
INSERT INTO `wl_system_dic` VALUES ('162', '03', '已完成', 'ScrapState', '2017-08-15 11:52:59', null);
INSERT INTO `wl_system_dic` VALUES ('163', '01', '达到设计使用寿命', 'RetiredReason', '2017-08-15 11:52:59', null);
INSERT INTO `wl_system_dic` VALUES ('164', '02', '同型号产品因设计缺陷导致事故', 'RetiredReason', '2017-08-15 11:52:59', null);
INSERT INTO `wl_system_dic` VALUES ('165', '03', '安全性能无法判定或不符合要求', 'RetiredReason', '2017-08-15 11:52:59', null);
INSERT INTO `wl_system_dic` VALUES ('166', '04', '无法修复或维修费用超标', 'RetiredReason', '2017-08-15 11:52:59', null);
INSERT INTO `wl_system_dic` VALUES ('167', '05', '其他原因', 'RetiredReason', '2017-08-15 11:52:59', null);
INSERT INTO `wl_system_dic` VALUES ('168', '01', '不具备训练、教学、展示价值', 'ScrapReason', '2017-08-15 11:52:59', null);
INSERT INTO `wl_system_dic` VALUES ('169', '02', '存在安全隐患', 'ScrapReason', '2017-08-15 11:52:59', null);
INSERT INTO `wl_system_dic` VALUES ('170', '03', '安全性能无法判定或不符合要求', 'ScrapReason', '2017-08-15 11:52:59', null);
INSERT INTO `wl_system_dic` VALUES ('171', '04', '无法修复或维修费用超标', 'ScrapReason', '2017-08-15 11:52:59', null);
INSERT INTO `wl_system_dic` VALUES ('172', '05', '其他原因', 'ScrapReason', '2017-08-15 11:52:59', null);
INSERT INTO `wl_system_dic` VALUES ('176', '1', '未下发', 'AllotmentOrderState', '2017-08-19 01:15:27', null);
INSERT INTO `wl_system_dic` VALUES ('177', '2', '已下发', 'AllotmentOrderState', '2017-08-19 01:15:27', null);
INSERT INTO `wl_system_dic` VALUES ('178', '3', '执行中', 'AllotmentOrderState', '2017-08-19 01:15:27', null);
INSERT INTO `wl_system_dic` VALUES ('179', '4', '已完成', 'AllotmentOrderState', '2017-08-19 01:15:27', null);
INSERT INTO `wl_system_dic` VALUES ('180', '01', '过期', 'EXScrapReason', '2017-08-19 01:15:27', null);
INSERT INTO `wl_system_dic` VALUES ('181', '02', '失效', 'EXScrapReason', '2017-08-19 01:15:27', null);
INSERT INTO `wl_system_dic` VALUES ('182', '03', '其他原因', 'EXScrapReason', '2017-08-19 01:15:27', null);
INSERT INTO `wl_system_dic` VALUES ('183', '9', '调拨', 'EquipStatus', '2017-08-24 12:53:03', null);
INSERT INTO `wl_system_dic` VALUES ('184', '16', '退役通知', 'NoticeType', '2017-08-24 12:53:03', null);
INSERT INTO `wl_system_dic` VALUES ('185', '17', '报废通知', 'NoticeType', '2017-08-24 12:53:03', null);
INSERT INTO `wl_system_dic` VALUES ('186', '01', '4*2', 'DriveType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('187', '02', '4*4', 'DriveType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('188', '03', '6*4', 'DriveType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('189', '04', '6*6', 'DriveType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('190', '05', '6*2', 'DriveType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('191', '06', '8*4', 'DriveType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('192', '07', '8*8', 'DriveType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('193', '99', '其他', 'DriveType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('194', '01', '有人_人工控制', 'DrivingStyle', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('195', '02', '有人_预定程序控制', 'DrivingStyle', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('196', '03', '有人_全自动控制', 'DrivingStyle', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('197', '04', '无人_人工控制', 'DrivingStyle', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('198', '05', '无人_预定程序控制', 'DrivingStyle', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('199', '06', '无人_全自动控制', 'DrivingStyle', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('200', '99', '其他', 'DrivingStyle', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('201', '01', '水冷', 'EngineCooling', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('202', '02', '风冷', 'EngineCooling', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('203', '99', '其他', 'EngineCooling', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('204', '01', '四冲程自然吸气式单缸', 'EngineType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('205', '02', '四冲程自然吸气式多缸', 'EngineType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('206', '03', '四冲程增压式发动机单缸', 'EngineType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('207', '04', '四冲程增压式发动机多缸', 'EngineType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('208', '05', '二冲程自然吸气式单缸', 'EngineType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('209', '06', '二冲程自然吸气式多缸', 'EngineType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('210', '07', '二冲程增压式发动机单缸', 'EngineType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('211', '08', '二冲程增压式发动机多缸', 'EngineType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('212', '99', '其他', 'EngineType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('213', '01', '手动', 'GearboxType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('214', '02', '自动', 'GearboxType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('215', '99', '其他', 'GearboxType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('216', '01', '钙基润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('217', '02', '石墨钙基润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('218', '03', '复合钙基润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('219', '04', '通用锂基润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('220', '05', '极压锂基润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('221', '06', '汽车通用锂基润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('222', '07', '二硫化钼极压锂基润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('223', '08', '极压复合锂基润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('224', '09', '钠基润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('225', '10', '铝基润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('226', '11', '极压复合铝基润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('227', '12', '钡基润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('228', '13', '复合铝基润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('229', '14', '膨润土润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('230', '15', '极压膨润土润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('231', '16', '极压聚脲润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('232', '17', '食品机械润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('233', '18', '70141号高温润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('234', '19', '70141号低温润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('235', '20', '70171号高低温润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('236', '21', '特221号润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('237', '22', '7903号耐油密封润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('238', '23', '3号仪表润滑脂', 'GreaseType', '2017-08-21 16:27:05', '(54号低温润滑脂)');
INSERT INTO `wl_system_dic` VALUES ('239', '24', '2号航空润滑脂', 'GreaseType', '2017-08-21 16:27:05', '(202润滑脂)');
INSERT INTO `wl_system_dic` VALUES ('240', '25', '7112号宽温航空润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('241', '26', '7023号低温航空润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('242', '27', '7007、7008号能用航空润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('243', '28', '7407号齿轮润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('244', '29', '压延机用润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('245', '30', '精密机床主轴润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('246', '31', '炮用润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('247', '32', '7106、7107号光学仪器润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('248', '33', '电接点润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('249', '34', '精密机床主轴润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('250', '35', '铁道润滑脂(硬干油)', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('251', '36', '滚珠轴承润滑脂', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('252', '37', '汽车轮轴承润滑', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('253', '99', '其他', 'GreaseType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('254', '01', '发动机润滑油', 'LubricantType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('255', '02', '航空喷气机润滑油', 'LubricantType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('256', '03', '20号航空润滑油', 'LubricantType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('257', '04', '4839号抗化学润滑油', 'LubricantType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('258', '05', '4802号抗化学润滑油', 'LubricantType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('259', '06', '热定型机润滑油', 'LubricantType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('260', '07', '酚精制润滑油', 'LubricantType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('261', '08', '极压润滑油', 'LubricantType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('262', '09', '直馏润滑油', 'LubricantType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('263', '10', '内燃机润滑油', 'LubricantType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('264', '99', '其他', 'LubricantType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('265', '01', '汽油', 'OilType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('266', '02', '柴油', 'OilType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('267', '99', '其他', 'OilType', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('268', '01', '冷却', 'OutfireMode', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('269', '02', '隔离', 'OutfireMode', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('270', '03', '窒息', 'OutfireMode', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('271', '04', '抑制', 'OutfireMode', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('272', '99', '其他', 'OutfireMode', '2017-08-21 16:27:05', null);
INSERT INTO `wl_system_dic` VALUES ('273', '01', '正式号牌', 'CarNumType', '2017-08-22 13:31:36', '见《中国人民武装警察部队“07式”车辆牌证核发与管理规定》');
INSERT INTO `wl_system_dic` VALUES ('274', '02', '大车牌', 'CarNumType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('275', '03', '小车牌', 'CarNumType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('276', '04', '摩托车牌', 'CarNumType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('277', '05', '临时号牌', 'CarNumType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('278', '06', '试车号牌', 'CarNumType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('279', '07', '挂车号牌', 'CarNumType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('280', '08', '教练车牌', 'CarNumType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('281', '99', '其他', 'CarNumType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('282', '01', '矿物油型液压油', 'HydraulicOil', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('283', '02', '合成烃型液压油', 'HydraulicOil', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('284', '03', '10号航空液压油', 'HydraulicOil', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('285', '04', '石油基液压油', 'HydraulicOil', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('286', '05', 'LHL液压油', 'HydraulicOil', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('287', '99', '其他', 'HydraulicOil', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('288', '01', '两轮', 'MotorcycleType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('289', '02', '正三轮', 'MotorcycleType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('290', '03', '边三轮', 'MotorcycleType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('291', '04', '四轮', 'MotorcycleType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('292', '99', '其他', 'MotorcycleType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('293', '01', '夹心式', 'PTO', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('294', '02', '断轴式', 'PTO', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('295', '03', '变速箱末端取力', 'PTO', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('296', '04', '侧取力', 'PTO', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('297', '99', '其他', 'PTO', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('298', '01', '固定翼', 'WingType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('299', '02', '直升机', 'WingType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('300', '04', '四旋翼', 'WingType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('301', '06', '六旋翼', 'WingType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('302', '08', '八旋翼', 'WingType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('303', '99', '其他', 'WingType', '2017-08-22 13:31:36', null);
INSERT INTO `wl_system_dic` VALUES ('304', '00', '无等级', 'CarLevel', '2017-08-22 14:16:02', null);
INSERT INTO `wl_system_dic` VALUES ('305', '01', '轻型', 'CarLevel', '2017-08-22 14:16:02', '1．载液量小于5吨为轻型');
INSERT INTO `wl_system_dic` VALUES ('306', '02', '中型', 'CarLevel', '2017-08-22 14:16:02', '2．载液量5至10吨为中型');
INSERT INTO `wl_system_dic` VALUES ('307', '03', '重型', 'CarLevel', '2017-08-22 14:16:02', '3．载液量大于10吨为重型');
INSERT INTO `wl_system_dic` VALUES ('308', '04', '小于30米', 'CarLevel', '2017-08-22 14:16:02', null);
INSERT INTO `wl_system_dic` VALUES ('309', '05', '30至60米', 'CarLevel', '2017-08-22 14:16:02', null);
INSERT INTO `wl_system_dic` VALUES ('310', '06', '60米以上', 'CarLevel', '2017-08-22 14:16:02', null);
INSERT INTO `wl_system_dic` VALUES ('312', '10', '车载', 'EquipStatus', '2017-09-23 13:12:43', null);
INSERT INTO `wl_system_dic` VALUES ('313', '11', '损耗', 'EquipStatus', '2017-09-23 13:12:43', null);
INSERT INTO `wl_system_dic` VALUES ('314', '00', '损耗出库', 'NoticeType', '2017-09-23 13:12:43', null);
INSERT INTO `wl_system_dic` VALUES ('315', '06', '社会联动单位调派', 'DispatchType', '2017-10-09 20:00:38', null);
INSERT INTO `wl_system_dic` VALUES ('316', '07', '专职队调派', 'DispatchType', '2017-10-09 20:00:38', null);
INSERT INTO `wl_system_dic` VALUES ('317', '08', '微型消防站调派', 'DispatchType', '2017-10-09 20:00:38', null);
INSERT INTO `wl_system_dic` VALUES ('318', '09', '灭火药剂调派', 'DispatchType', '2017-10-09 20:00:39', null);
INSERT INTO `wl_system_dic` VALUES ('319', '1', '国有企业', 'ManufacturerNature', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('320', '2', '集体企业', 'ManufacturerNature', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('321', '3', '民营企业', 'ManufacturerNature', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('322', '4', '个体企业', 'ManufacturerNature', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('323', '5', '中外合资企业', 'ManufacturerNature', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('324', '6', '外商独资企业', 'ManufacturerNature', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('325', '9', '其他', 'ManufacturerNature', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('326', '01', '上级单位', 'ManufacturerType', '2017-10-09 20:04:46', '10');
INSERT INTO `wl_system_dic` VALUES ('327', '02', '下属单位', 'ManufacturerType', '2017-10-09 20:04:46', '20');
INSERT INTO `wl_system_dic` VALUES ('328', '03', '内设', 'ManufacturerType', '2017-10-09 20:04:46', '21');
INSERT INTO `wl_system_dic` VALUES ('329', '04', '直属', 'ManufacturerType', '2017-10-09 20:04:46', '22');
INSERT INTO `wl_system_dic` VALUES ('330', '05', '下辖', 'ManufacturerType', '2017-10-09 20:04:46', '23');
INSERT INTO `wl_system_dic` VALUES ('331', '110000', '北京市', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('332', '120000', '天津市', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('333', '130000', '河北省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('334', '140000', '山西省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('335', '150000', '内蒙古自治区', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('336', '210000', '辽宁省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('337', '220000', '吉林省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('338', '230000', '黑龙江省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('339', '310000', '上海市', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('340', '320000', '江苏省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('341', '330000', '浙江省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('342', '340000', '安徽省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('343', '350000', '福建省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('344', '360000', '江西省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('345', '370000', '山东省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('346', '410000', '河南省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('347', '420000', '湖北省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('348', '430000', '湖南省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('349', '440000', '广东省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('350', '450000', '广西壮族自治区', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('351', '460000', '海南省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('352', '500000', '重庆市', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('353', '510000', '四川省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('354', '520000', '贵州省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('355', '530000', '云南省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('356', '540000', '西藏自治区', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('357', '610000', '陕西省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('358', '620000', '甘肃省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('359', '630000', '青海省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('360', '640000', '宁夏回族自治区', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('361', '650000', '新疆维吾尔自治区', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('362', '710000', '台湾省', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('363', '810000', '香港特别行政区', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('364', '820000', '澳门特别行政区', 'Region', '2017-10-09 20:04:46', null);
INSERT INTO `wl_system_dic` VALUES ('365', '1', '出动', 'CaseState', '2017-10-25 11:49:00', null);
INSERT INTO `wl_system_dic` VALUES ('366', '2', '到场', 'CaseState', '2017-10-25 11:49:00', null);
INSERT INTO `wl_system_dic` VALUES ('367', '3', '返队', 'CaseState', '2017-10-25 11:49:00', null);
INSERT INTO `wl_system_dic` VALUES ('368', '4', '结案', 'CaseState', '2017-10-25 11:49:00', null);
INSERT INTO `wl_system_dic` VALUES ('369', '18', '车辆维修通知', 'NoticeType', '2019-03-11 10:05:53', null);
INSERT INTO `wl_system_dic` VALUES ('370', '1', '火警', 'EquipmentSwitch', '2020-09-15 11:06:36', null);
INSERT INTO `wl_system_dic` VALUES ('371', '2', '开关', 'EquipmentSwitch', '2020-09-15 11:06:36', null);
INSERT INTO `wl_system_dic` VALUES ('372', '3', '换流变', 'EquipmentSwitch', '2020-09-15 11:06:36', null);
INSERT INTO `wl_system_dic` VALUES ('373', '4', '故障', 'EquipmentSwitch', '2020-09-15 11:06:36', null);
INSERT INTO `wl_system_dic` VALUES ('374', '5', '状态', 'EquipmentSwitch', '2020-09-15 11:06:36', null);
INSERT INTO `wl_system_dic` VALUES ('375', '6', '启停', 'EquipmentSwitch', '2020-09-15 11:06:36', null);
INSERT INTO `wl_system_dic` VALUES ('376', '7', '警告', 'EquipmentSwitch', '2020-09-15 11:06:36', null);

-- ----------------------------
-- Table structure for wl_unit
-- ----------------------------
DROP TABLE IF EXISTS `wl_unit`;
CREATE TABLE `wl_unit` (
  `id` bigint(20) NOT NULL COMMENT '计量单位ID',
  `name` varchar(32) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL COMMENT '编码',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '上级单位ID',
  `description` varchar(100) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='计量单位';

-- ----------------------------
-- Records of wl_unit
-- ----------------------------
INSERT INTO `wl_unit` VALUES ('0', '磁场强度', '2200', null, '磁场强度', null);
INSERT INTO `wl_unit` VALUES ('1', '照射强度', '2800', null, '照射强度', null);
INSERT INTO `wl_unit` VALUES ('2', '温度单位', '0700', null, '温度单位', null);
INSERT INTO `wl_unit` VALUES ('3', '电阻单位', '2300', null, '电阻单位', null);
INSERT INTO `wl_unit` VALUES ('4', '计数单位', '2900', null, '计数单位', null);
INSERT INTO `wl_unit` VALUES ('5', '平面角度', '3000', null, '平面角度', null);
INSERT INTO `wl_unit` VALUES ('6', '吨', '1900', null, '重量单位', null);
INSERT INTO `wl_unit` VALUES ('7', '能量单位', '1300', null, '能量单位', null);
INSERT INTO `wl_unit` VALUES ('8', '级差单位', '1600', null, '级差单位', null);
INSERT INTO `wl_unit` VALUES ('10', '电压单位', '2000', null, '电压单位', null);
INSERT INTO `wl_unit` VALUES ('11', '流量单位', '0900', null, '流量单位', null);
INSERT INTO `wl_unit` VALUES ('12', '力的单位', '1000', null, '力的单位', null);
INSERT INTO `wl_unit` VALUES ('13', '时间单位', '0600', null, '时间单位', null);
INSERT INTO `wl_unit` VALUES ('14', '吸收剂量单位', '2600', null, '吸收剂量单位', null);
INSERT INTO `wl_unit` VALUES ('15', '放射性活度单位', '2500', null, '放射性活度单位', null);
INSERT INTO `wl_unit` VALUES ('16', '质量单位', '0400', null, '质量单位', null);
INSERT INTO `wl_unit` VALUES ('17', '长度单位', '0100', null, '长度单位', null);
INSERT INTO `wl_unit` VALUES ('18', '电场强度', '2100', null, '电场强度', null);
INSERT INTO `wl_unit` VALUES ('19', '面积单位', '0200', null, '面积单位', null);
INSERT INTO `wl_unit` VALUES ('20', '电容单位', '2400', null, '电容单位', null);
INSERT INTO `wl_unit` VALUES ('21', '扭矩单位', '1100', null, '扭矩单位', null);
INSERT INTO `wl_unit` VALUES ('22', '压力、压强、应力单位', '1200', null, '压力、压强、应力单位', null);
INSERT INTO `wl_unit` VALUES ('23', '功率单位', '1400', null, '功率单位', null);
INSERT INTO `wl_unit` VALUES ('24', '密度单位', '0500', null, '密度单位', null);
INSERT INTO `wl_unit` VALUES ('25', '剂量当量单位', '2700', null, '剂量当量单位', null);
INSERT INTO `wl_unit` VALUES ('26', '光照度单位', '1800', null, '光照度单位', null);
INSERT INTO `wl_unit` VALUES ('27', '体积单位', '0300', null, '体积单位', null);
INSERT INTO `wl_unit` VALUES ('28', '光通量单位', '1700', null, '光通量单位', null);
INSERT INTO `wl_unit` VALUES ('29', '频率单位', '1500', null, '频率单位', null);
INSERT INTO `wl_unit` VALUES ('30', '速度单位', '0800', null, '速度单位', null);
INSERT INTO `wl_unit` VALUES ('31', '伦琴', '2801', '1', '伦琴', null);
INSERT INTO `wl_unit` VALUES ('32', '摄氏度', '0701', '2', '摄氏度', null);
INSERT INTO `wl_unit` VALUES ('33', '开', '0703', '2', '开', null);
INSERT INTO `wl_unit` VALUES ('34', '华氏度', '0702', '2', '华氏度', null);
INSERT INTO `wl_unit` VALUES ('35', '欧母、欧', '2301', '3', '欧母、欧', null);
INSERT INTO `wl_unit` VALUES ('36', '千欧', '2303', '3', '千欧', null);
INSERT INTO `wl_unit` VALUES ('37', '兆欧', '2302', '3', '兆欧', null);
INSERT INTO `wl_unit` VALUES ('38', '艘', '2908', '4', '艘', null);
INSERT INTO `wl_unit` VALUES ('39', '板', '2920', '4', '板', null);
INSERT INTO `wl_unit` VALUES ('40', '副', '2922', '4', '副', null);
INSERT INTO `wl_unit` VALUES ('41', '双', '2923', '4', '双', null);
INSERT INTO `wl_unit` VALUES ('42', '辆', '2903', '4', '辆', null);
INSERT INTO `wl_unit` VALUES ('43', '盒', '2915', '4', '盒', null);
INSERT INTO `wl_unit` VALUES ('44', '组', '2906', '4', '组', null);
INSERT INTO `wl_unit` VALUES ('45', '包', '2919', '4', '包', null);
INSERT INTO `wl_unit` VALUES ('46', '袋', '2917', '4', '袋', null);
INSERT INTO `wl_unit` VALUES ('47', '具', '2904', '4', '具', null);
INSERT INTO `wl_unit` VALUES ('48', '架', '2909', '4', '架', null);
INSERT INTO `wl_unit` VALUES ('49', '只', '2912', '4', '只', null);
INSERT INTO `wl_unit` VALUES ('50', '件', '2921', '4', '件', null);
INSERT INTO `wl_unit` VALUES ('51', '台', '2902', '4', '台', null);
INSERT INTO `wl_unit` VALUES ('52', '套', '2905', '4', '套', null);
INSERT INTO `wl_unit` VALUES ('53', '条', '2907', '4', '条', null);
INSERT INTO `wl_unit` VALUES ('54', '支', '2918', '4', '支', null);
INSERT INTO `wl_unit` VALUES ('55', '个', '2911', '4', '个', null);
INSERT INTO `wl_unit` VALUES ('56', '瓶', '2916', '4', '瓶', null);
INSERT INTO `wl_unit` VALUES ('57', '部', '2901', '4', '部', null);
INSERT INTO `wl_unit` VALUES ('58', '分', '3002', '5', '分', null);
INSERT INTO `wl_unit` VALUES ('59', '秒', '3003', '5', '秒', null);
INSERT INTO `wl_unit` VALUES ('60', '度', '3001', '5', '度', null);
INSERT INTO `wl_unit` VALUES ('61', '毫安', '1902', '6', '毫安', null);
INSERT INTO `wl_unit` VALUES ('62', '微安', '1903', '6', '微安', null);
INSERT INTO `wl_unit` VALUES ('63', '安培、安', '1901', '6', '安培、安', null);
INSERT INTO `wl_unit` VALUES ('64', '焦耳、焦', '1301', '7', '焦耳、焦', null);
INSERT INTO `wl_unit` VALUES ('65', '兆焦', '1303', '7', '兆焦', null);
INSERT INTO `wl_unit` VALUES ('66', '千焦', '1302', '7', '千焦', null);
INSERT INTO `wl_unit` VALUES ('67', '分贝', '1602', '8', '分贝', null);
INSERT INTO `wl_unit` VALUES ('68', '贝耳', '1601', '8', '贝耳', null);
INSERT INTO `wl_unit` VALUES ('69', '千安/米', '2202', '9', '千安/米', null);
INSERT INTO `wl_unit` VALUES ('70', '安/米', '2201', '9', '安/米', null);
INSERT INTO `wl_unit` VALUES ('71', '千伏', '2002', '10', '千伏', null);
INSERT INTO `wl_unit` VALUES ('72', '伏特、伏', '2001', '10', '伏特、伏', null);
INSERT INTO `wl_unit` VALUES ('73', '毫伏', '2003', '10', '毫伏', null);
INSERT INTO `wl_unit` VALUES ('74', '微伏', '2004', '10', '微伏', null);
INSERT INTO `wl_unit` VALUES ('75', '升/秒', '0901', '11', '升/秒', null);
INSERT INTO `wl_unit` VALUES ('76', '立方米/小时', '0902', '11', '立方米/小时', null);
INSERT INTO `wl_unit` VALUES ('77', '千牛', '1002', '12', '千牛', null);
INSERT INTO `wl_unit` VALUES ('78', '牛顿、牛', '1001', '12', '牛顿、牛', null);
INSERT INTO `wl_unit` VALUES ('79', '季度', '0602', '13', '季度', null);
INSERT INTO `wl_unit` VALUES ('80', '周（星期）', '0604', '13', '周（星期）', null);
INSERT INTO `wl_unit` VALUES ('81', '月', '0603', '13', '月', null);
INSERT INTO `wl_unit` VALUES ('82', '秒', '0608', '13', '秒', null);
INSERT INTO `wl_unit` VALUES ('83', '小时', '0606', '13', '小时', null);
INSERT INTO `wl_unit` VALUES ('84', '年', '0601', '13', '年', null);
INSERT INTO `wl_unit` VALUES ('85', '分钟', '0607', '13', '分钟', null);
INSERT INTO `wl_unit` VALUES ('86', '日（天）', '0605', '13', '日（天）', null);
INSERT INTO `wl_unit` VALUES ('87', '戈瑞、戈', '2601', '14', '戈瑞、戈', null);
INSERT INTO `wl_unit` VALUES ('88', '贝可勒耳、贝可', '2501', '15', '贝可勒耳、贝可', null);
INSERT INTO `wl_unit` VALUES ('89', '克', '0403', '16', '克', null);
INSERT INTO `wl_unit` VALUES ('90', '微克', '0405', '16', '微克', null);
INSERT INTO `wl_unit` VALUES ('91', '吨', '0401', '16', '吨', null);
INSERT INTO `wl_unit` VALUES ('92', '毫克', '0404', '16', '毫克', null);
INSERT INTO `wl_unit` VALUES ('93', '千克（公斤）', '0402', '16', '千克（公斤）', null);
INSERT INTO `wl_unit` VALUES ('94', '微米', '0105', '17', '微米', null);
INSERT INTO `wl_unit` VALUES ('95', '厘米（公分）', '0103', '17', '厘米（公分）', null);
INSERT INTO `wl_unit` VALUES ('96', '毫米', '0104', '17', '毫米', null);
INSERT INTO `wl_unit` VALUES ('97', '1千米（公里）', '0101', '17', '千米（公里）', '2020-07-15 16:38:52');
INSERT INTO `wl_unit` VALUES ('98', '海里', '0106', '17', '海里', null);
INSERT INTO `wl_unit` VALUES ('99', '米', '0102', '17', '米', null);
INSERT INTO `wl_unit` VALUES ('100', '千伏/米', '2102', '18', '千伏/米', null);
INSERT INTO `wl_unit` VALUES ('101', '伏/米', '2101', '18', '伏/米', null);
INSERT INTO `wl_unit` VALUES ('102', '平方毫米', '0205', '19', '平方毫米', null);
INSERT INTO `wl_unit` VALUES ('103', '平方厘米', '0204', '19', '平方厘米', null);
INSERT INTO `wl_unit` VALUES ('104', '平方公里', '0201', '19', '平方公里', null);
INSERT INTO `wl_unit` VALUES ('105', '公顷', '0202', '19', '公顷', null);
INSERT INTO `wl_unit` VALUES ('106', '平方米', '0203', '19', '平方米', null);
INSERT INTO `wl_unit` VALUES ('107', '皮法', '2403', '20', '皮法', null);
INSERT INTO `wl_unit` VALUES ('108', '法拉、法', '2401', '20', '法拉、法', null);
INSERT INTO `wl_unit` VALUES ('109', '微法', '2402', '20', '微法', null);
INSERT INTO `wl_unit` VALUES ('110', '牛*米', '1101', '21', '牛*米', null);
INSERT INTO `wl_unit` VALUES ('111', '帕斯卡、帕', '1201', '22', '帕斯卡、帕', null);
INSERT INTO `wl_unit` VALUES ('112', '千帕', '1202', '22', '千帕', null);
INSERT INTO `wl_unit` VALUES ('113', '巴', '1204', '22', '巴', null);
INSERT INTO `wl_unit` VALUES ('114', '兆帕', '1203', '22', '兆帕', null);
INSERT INTO `wl_unit` VALUES ('115', '瓦', '1401', '23', '瓦', null);
INSERT INTO `wl_unit` VALUES ('116', '千瓦', '1402', '23', '千瓦', null);
INSERT INTO `wl_unit` VALUES ('117', '克/升', '0502', '24', '克/升', null);
INSERT INTO `wl_unit` VALUES ('118', '克/立方厘米', '0501', '24', '克/立方厘米', null);
INSERT INTO `wl_unit` VALUES ('119', '克/毫升', '0503', '24', '克/毫升', null);
INSERT INTO `wl_unit` VALUES ('120', '系沃特、系', '2701', '25', '系沃特、系', null);
INSERT INTO `wl_unit` VALUES ('121', '勒克斯', '1801', '26', '勒克斯', null);
INSERT INTO `wl_unit` VALUES ('122', '升', '0302', '27', '升', null);
INSERT INTO `wl_unit` VALUES ('123', '立方米', '0301', '27', '立方米', null);
INSERT INTO `wl_unit` VALUES ('124', '毫升', '0303', '27', '毫升', null);
INSERT INTO `wl_unit` VALUES ('125', '流明', '1701', '28', '流明', null);
INSERT INTO `wl_unit` VALUES ('126', '千赫', '1502', '29', '千赫', null);
INSERT INTO `wl_unit` VALUES ('127', '兆赫', '1503', '29', '兆赫', null);
INSERT INTO `wl_unit` VALUES ('128', '赫兹、赫', '1501', '29', '赫兹、赫', null);
INSERT INTO `wl_unit` VALUES ('129', '米/秒', '0803', '30', '米/秒', null);
INSERT INTO `wl_unit` VALUES ('130', '千米（公里）/小时', '0801', '30', '千米（公里）/小时', null);
INSERT INTO `wl_unit` VALUES ('131', '节', '0804', '30', '节', null);
INSERT INTO `wl_unit` VALUES ('151', '升/分', '0903', '11', '升/分', null);
INSERT INTO `wl_unit` VALUES ('152', '立方米/分钟', '904', '11', '立方米/分钟', null);
INSERT INTO `wl_unit` VALUES ('153', '立方厘米', '304', '27', '立方厘米', null);
INSERT INTO `wl_unit` VALUES ('154', '马力', '1403', '23', '马力', null);
INSERT INTO `wl_unit` VALUES ('155', '安培小时', '1902', '6', '安培小时', null);
INSERT INTO `wl_unit` VALUES ('156', '次', '2924', '4', '次', null);
INSERT INTO `wl_unit` VALUES ('157', '毫米/秒', '0805', '30', '毫米/秒', null);
INSERT INTO `wl_unit` VALUES ('158', '磅', '0403', '16', '磅', null);
INSERT INTO `wl_unit` VALUES ('159', '升/200巴', '1205', '22', '升/200巴', null);
INSERT INTO `wl_unit` VALUES ('160', '毫安/小时', '1905', '6', '毫安/小时', null);
INSERT INTO `wl_unit` VALUES ('161', '等级', '2929', '4', '等级', '2017-07-22 01:16:12');
INSERT INTO `wl_unit` VALUES ('162', '气透过量单位', '3100', null, '气透过量单位', '2017-07-22 01:16:12');
INSERT INTO `wl_unit` VALUES ('163', '克/每2.24h小时', '3101', '162', '克/每2.24h小时', '2017-07-22 01:16:12');
INSERT INTO `wl_unit` VALUES ('164', '百分比', '2930', '4', '百分比', '2017-07-22 01:16:12');
INSERT INTO `wl_unit` VALUES ('165', '对', '2931', '4', '对', null);
INSERT INTO `wl_unit` VALUES ('166', '人', '2932', '4', '人', null);
INSERT INTO `wl_unit` VALUES ('167', '片', '2933', '4', '片', null);
INSERT INTO `wl_unit` VALUES ('168', '把', '2934', '4', '把', null);
INSERT INTO `wl_unit` VALUES ('169', '卷', '2935', '4', '卷', null);
INSERT INTO `wl_unit` VALUES ('170', '转速单位', '5300', null, '转速单位', '2017-07-21 20:53:36');
INSERT INTO `wl_unit` VALUES ('171', '转/分', '5301', '140', '转/分', '2017-07-21 20:54:06');
INSERT INTO `wl_unit` VALUES ('1310876981446033410', '千吨', '406', '16', '无', '2020-09-29 17:40:02');

-- ----------------------------
-- Table structure for wl_upload_file
-- ----------------------------
DROP TABLE IF EXISTS `wl_upload_file`;
CREATE TABLE `wl_upload_file` (
  `id` bigint(20) NOT NULL,
  `ext_name` varchar(10) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `file_type` varchar(50) DEFAULT NULL COMMENT '文件类型，详情见文件枚举',
  `object_type` varchar(50) DEFAULT NULL COMMENT 'equipment或者car',
  `object_id` bigint(20) DEFAULT NULL COMMENT '装备或车辆id',
  `org_code` varchar(255) DEFAULT NULL COMMENT '公司code',
  `company_name` varchar(255) DEFAULT NULL COMMENT '公司名称',
  `department_name` varchar(255) DEFAULT NULL COMMENT '部门名称',
  `department_orgcode` varchar(255) DEFAULT NULL COMMENT '部门code',
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wl_upload_file
-- ----------------------------

-- ----------------------------
-- Table structure for wl_video
-- ----------------------------
DROP TABLE IF EXISTS `wl_video`;
CREATE TABLE `wl_video` (
  `id` bigint(20) NOT NULL COMMENT 'id',
  `code` char(100) DEFAULT NULL COMMENT '摄像机编号',
  `type` char(100) DEFAULT NULL COMMENT '类型',
  `ip` char(15) DEFAULT NULL COMMENT 'ip',
  `account` char(100) DEFAULT NULL COMMENT '用户名',
  `password` char(100) DEFAULT NULL COMMENT '密码',
  `port` char(100) DEFAULT NULL COMMENT '端口号',
  `tube` char(255) DEFAULT NULL COMMENT '通道',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `creator_name` char(100) DEFAULT NULL COMMENT '创建人名',
  `company_name` char(100) DEFAULT NULL COMMENT '公司名称',
  `org_code` char(100) DEFAULT NULL COMMENT '公司code',
  `department_name` char(100) DEFAULT NULL COMMENT '部门名称',
  `department_orgcode` char(100) DEFAULT NULL COMMENT '部门code',
  `rtsp_address` char(100) DEFAULT NULL COMMENT '视频rtsp',
  `url` char(255) DEFAULT NULL COMMENT '访问url',
  `carmera_type` varchar(255) DEFAULT NULL COMMENT '型号',
  `position3d` varchar(255) DEFAULT NULL COMMENT '三维坐标信息：{\\"x\\":168.4586,\\"y\\":1.1004,\\"z\\":30.3959}',
  `token` varchar(255) DEFAULT NULL COMMENT '摄像头唯一token',
  `name` varchar(255) DEFAULT NULL COMMENT '摄像机名称',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `img` varchar(100) DEFAULT NULL,
  `address` varchar(50) DEFAULT NULL COMMENT '详细位置',
  `preset_position` varchar(255) DEFAULT NULL COMMENT '视频预置位',
  `longitude` double(10,6) DEFAULT NULL COMMENT '经度',
  `latitude` double(10,6) DEFAULT NULL COMMENT '纬度',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wl_video
-- ----------------------------

-- ----------------------------
-- Table structure for wl_video_equipment_specific
-- ----------------------------
DROP TABLE IF EXISTS `wl_video_equipment_specific`;
CREATE TABLE `wl_video_equipment_specific` (
  `id` bigint(20) NOT NULL COMMENT 'id',
  `video_id` bigint(20) NOT NULL COMMENT '视频id',
  `equipment_specific_id` bigint(20) NOT NULL COMMENT '设备id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='视屏监控关联消防设备';

-- ----------------------------
-- Records of wl_video_equipment_specific
-- ----------------------------

-- ----------------------------
-- Table structure for wl_video_important_equipment
-- ----------------------------
DROP TABLE IF EXISTS `wl_video_important_equipment`;
CREATE TABLE `wl_video_important_equipment` (
  `id` bigint(20) NOT NULL COMMENT 'id',
  `video_id` bigint(20) NOT NULL COMMENT '视频id',
  `important_equipment_id` bigint(20) NOT NULL COMMENT '重点设备id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='视屏监控关联重点设备';

-- ----------------------------
-- Records of wl_video_important_equipment
-- ----------------------------

-- ----------------------------
-- Table structure for wl_video_source
-- ----------------------------
DROP TABLE IF EXISTS `wl_video_source`;
CREATE TABLE `wl_video_source` (
  `id` bigint(20) NOT NULL COMMENT 'id',
  `video_id` bigint(20) NOT NULL COMMENT '视频id',
  `source_id` bigint(20) NOT NULL COMMENT '区域id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='视屏监控关联建筑';

-- ----------------------------
-- Records of wl_video_source
-- ----------------------------

-- ----------------------------
-- Table structure for wl_warehouse
-- ----------------------------
DROP TABLE IF EXISTS `wl_warehouse`;
CREATE TABLE `wl_warehouse` (
  `id` bigint(20) NOT NULL COMMENT '仓库ID',
  `name` varchar(100) DEFAULT NULL COMMENT '仓库名称',
  `telephone` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `duty_telephone` varchar(20) DEFAULT NULL COMMENT '值班电话',
  `level` varchar(255) DEFAULT NULL COMMENT '等级',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `org_code` varchar(255) DEFAULT NULL COMMENT '组织结构',
  `company_name` varchar(255) DEFAULT NULL COMMENT '公司名称',
  `user_id` bigint(20) DEFAULT NULL COMMENT '创建人',
  `user_name` varchar(255) DEFAULT NULL COMMENT '创建人名称',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `owner` varchar(255) DEFAULT NULL COMMENT '负责人',
  `source_id` bigint(20) DEFAULT NULL COMMENT '同步预控系统f_risk_source表中的id字段',
  `source_code` varchar(255) DEFAULT NULL COMMENT '同步预控系统f_risk_source表中的code字段',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `source_id_UNIQUE` (`source_id`) USING BTREE COMMENT '源数据表中ID，防止脏数据，添加唯一约束',
  KEY `ix_warehouse_for_creator_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='仓库信息';

-- ----------------------------
-- Records of wl_warehouse
-- ----------------------------
INSERT INTO `wl_warehouse` VALUES ('0', '1', null, null, null, null, '10', '驻马店换流站', '2278365', 'gjq', '2020-11-25 10:26:21', null, '0', '10000');

-- ----------------------------
-- Table structure for wl_warehouse_structure
-- ----------------------------
DROP TABLE IF EXISTS `wl_warehouse_structure`;
CREATE TABLE `wl_warehouse_structure` (
  `id` bigint(20) NOT NULL,
  `code` varchar(30) NOT NULL COMMENT '位置编码',
  `name` varchar(50) NOT NULL COMMENT '名称',
  `full_name` varchar(255) DEFAULT NULL COMMENT '全称',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '父ID',
  `cell_type` bigint(20) DEFAULT NULL COMMENT '位置类型',
  `cell_code` varchar(64) DEFAULT NULL,
  `warehouse_id` bigint(20) DEFAULT NULL COMMENT '仓库ID',
  `remark` varchar(50) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `source_id` bigint(20) DEFAULT NULL COMMENT '同步预控系统f_risk_source表中的id字段',
  `source_code` varchar(255) DEFAULT NULL COMMENT '同步预控系统f_risk_source表中的code字段',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `source_id_UNIQUE` (`source_id`) USING BTREE COMMENT '源数据表中ID，防止脏数据，添加唯一约束',
  KEY `cell_type` (`cell_type`) USING BTREE,
  KEY `parent_id` (`parent_id`) USING BTREE,
  KEY `warehouse_id` (`warehouse_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='货架结构';

-- ----------------------------
-- Records of wl_warehouse_structure
-- ----------------------------

-- ----------------------------
-- Table structure for wl_wastage_bill
-- ----------------------------
DROP TABLE IF EXISTS `wl_wastage_bill`;
CREATE TABLE `wl_wastage_bill` (
  `id` bigint(20) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `bill_code` varchar(50) NOT NULL COMMENT '单据编码',
  `bill_type` char(20) NOT NULL COMMENT '单据类型',
  `creator_id` bigint(20) NOT NULL,
  `org_code` varchar(50) NOT NULL COMMENT '公司code',
  `stock_bill_id` bigint(20) DEFAULT NULL COMMENT '库存单据id',
  `company_name` varchar(255) DEFAULT NULL COMMENT '公司名称',
  `department_name` varchar(255) DEFAULT NULL COMMENT '部门名称',
  `department_orgcode` varchar(255) DEFAULT NULL COMMENT '部门code',
  `creator_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='损耗单据';

-- ----------------------------
-- Records of wl_wastage_bill
-- ----------------------------

-- ----------------------------
-- Table structure for wl_wastage_bill_detail
-- ----------------------------
DROP TABLE IF EXISTS `wl_wastage_bill_detail`;
CREATE TABLE `wl_wastage_bill_detail` (
  `id` bigint(20) NOT NULL,
  `create_date` datetime DEFAULT NULL COMMENT '生成时间',
  `wastage_bill_id` bigint(20) NOT NULL COMMENT '损耗单据id',
  `stock_detail_id` bigint(20) NOT NULL COMMENT '库存明细id',
  `amount` decimal(12,2) NOT NULL COMMENT '库存数量',
  `stock_bill_detail_id` bigint(20) DEFAULT NULL COMMENT '库存单据详情id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='损耗单据详情';

-- ----------------------------
-- Records of wl_wastage_bill_detail
-- ----------------------------

-- ----------------------------
-- View structure for get_break_mom
-- ----------------------------
DROP VIEW IF EXISTS `get_break_mom`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `get_break_mom` AS select if((isnull(`abc`.`mom`) or (`abc`.`mom` = 0)),'--',concat(`abc`.`mom`,'%')) AS `mom`,if((isnull(`abc`.`mom`) or (`abc`.`mom` = 0)),0,`abc`.`flag`) AS `flag` from (select if(((`yesd`.`c` = 0) or (`tod`.`c` = `yesd`.`c`)),0,abs(round((((`tod`.`c` - `yesd`.`c`) / `yesd`.`c`) * 100),0))) AS `mom`,if(((`yesd`.`c` = 0) or (`tod`.`c` = `yesd`.`c`)),0,if((`tod`.`c` > `yesd`.`c`),1,2)) AS `flag` from (((select count(1) AS `c` from `safety-business-3.0.0`.`wl_equipment_specific_alarm` where ((`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date` like concat(curdate(),'%')) and (`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`type` = 'BREAKDOWN')))) `tod` join (select count(1) AS `c` from `safety-business-3.0.0`.`wl_equipment_specific_alarm` where ((`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date` like concat((curdate() - interval 1 day),'%')) and (`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`type` = 'BREAKDOWN'))) `yesd`)) `abc` ;

-- ----------------------------
-- View structure for get_building_tree
-- ----------------------------
DROP VIEW IF EXISTS `get_building_tree`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`172.16.3.39` SQL SECURITY DEFINER VIEW `get_building_tree` AS select `a`.`instance_id` AS `instanceId`,max((case when (`a`.`field_name` = 'parentId') then `a`.`field_value` end)) AS `parentId`,max((case when (`a`.`field_name` = 'name') then `a`.`field_value` end)) AS `instanceName` from `wl_form_instance` `a` group by `a`.`instance_id` ;

-- ----------------------------
-- View structure for get_danger_count
-- ----------------------------
DROP VIEW IF EXISTS `get_danger_count`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `get_danger_count` AS select '计划巡查' AS `name`,count(1) AS `value` from `p_latent_danger` where (`p_latent_danger`.`danger_type` = 2) union select '无计划检查' AS `name`,count(1) AS `value` from `p_latent_danger` where (`p_latent_danger`.`danger_type` = 3) union select '无码检查' AS `name`,count(1) AS `value` from `p_latent_danger` where (`p_latent_danger`.`danger_type` = 1) union select '随手拍' AS `name`,count(1) AS `value` from `p_latent_danger` where (`p_latent_danger`.`danger_type` = 4) ;

-- ----------------------------
-- View structure for get_danger_count_trans
-- ----------------------------
DROP VIEW IF EXISTS `get_danger_count_trans`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `get_danger_count_trans` AS select (select `get_danger_count`.`value` from `get_danger_count` where (convert(`get_danger_count`.`name` using utf8mb4) = '计划巡查')) AS `jhxc`,(select `get_danger_count`.`value` from `get_danger_count` where (convert(`get_danger_count`.`name` using utf8mb4) = '无计划检查')) AS `wjhxc`,(select `get_danger_count`.`value` from `get_danger_count` where (convert(`get_danger_count`.`name` using utf8mb4) = '无码检查')) AS `wmxc`,(select `get_danger_count`.`value` from `get_danger_count` where (convert(`get_danger_count`.`name` using utf8mb4) = '随手拍')) AS `ssp` ;

-- ----------------------------
-- View structure for get_dev_mom
-- ----------------------------
DROP VIEW IF EXISTS `get_dev_mom`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `get_dev_mom` AS select `abc`.`today` AS `today`,if((isnull(`abc`.`mom`) or (`abc`.`mom` = 0)),'--',concat(`abc`.`mom`,'%')) AS `mom`,if((isnull(`abc`.`mom`) or (`abc`.`mom` = 0)),0,`abc`.`flag`) AS `flag` from (select `to`.`c` AS `today`,if(((`ye`.`c` = 0) or (`ye`.`c` = `to`.`c`)),0,abs(round((((`to`.`c` - `ye`.`c`) / `ye`.`c`) * 100),0))) AS `mom`,if(((`ye`.`c` = 0) or (`to`.`c` = `ye`.`c`)),0,if((`to`.`c` > `ye`.`c`),1,2)) AS `flag` from (((select count(1) AS `c` from `safety-business-3.0.0`.`p_plan_task_detail` where ((`safety-business-3.0.0`.`p_plan_task_detail`.`status` = 2) or ((`safety-business-3.0.0`.`p_plan_task_detail`.`status` = 3) and (`safety-business-3.0.0`.`p_plan_task_detail`.`create_date` like concat(curdate(),'%')))))) `to` join (select count(1) AS `c` from `safety-business-3.0.0`.`p_plan_task_detail` where ((`safety-business-3.0.0`.`p_plan_task_detail`.`status` = 2) or ((`safety-business-3.0.0`.`p_plan_task_detail`.`status` = 3) and (`safety-business-3.0.0`.`p_plan_task_detail`.`create_date` like concat((curdate() - interval 1 day),'%'))))) `ye`)) `abc` ;

-- ----------------------------
-- View structure for get_fire_mom
-- ----------------------------
DROP VIEW IF EXISTS `get_fire_mom`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `get_fire_mom` AS select if((isnull(`abc`.`mom`) or (`abc`.`mom` = 0)),'--',concat(`abc`.`mom`,'%')) AS `mom`,if((isnull(`abc`.`mom`) or (`abc`.`mom` = 0)),0,`abc`.`flag`) AS `flag` from (select if(((`yesd`.`c` = 0) or (`tod`.`c` = `yesd`.`c`)),0,abs(round((((`tod`.`c` - `yesd`.`c`) / `yesd`.`c`) * 100),0))) AS `mom`,if(((`yesd`.`c` = 0) or (`tod`.`c` = `yesd`.`c`)),0,if((`tod`.`c` > `yesd`.`c`),1,2)) AS `flag` from (((select count(1) AS `c` from `safety-business-3.0.0`.`wl_equipment_specific_alarm` where ((`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date` like concat(curdate(),'%')) and (`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`type` = 'FIREALARM')))) `tod` join (select count(1) AS `c` from `safety-business-3.0.0`.`wl_equipment_specific_alarm` where ((`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date` like concat((curdate() - interval 1 day),'%')) and (`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`type` = 'FIREALARM'))) `yesd`)) `abc` ;

-- ----------------------------
-- View structure for risk_danger_statistics_week
-- ----------------------------
DROP VIEW IF EXISTS `risk_danger_statistics_week`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `risk_danger_statistics_week` AS select count(1) AS `amount`,left(`l`.`create_date`,10) AS `vest_date`,`s`.`org_code` AS `org_code`,(week((`l`.`create_date` + interval 6 day),2) - 1) AS `week` from (`f_rpn_change_log` `l` left join `f_risk_source` `s` on((`l`.`risk_source_id` = `s`.`id`))) where ((`l`.`rpn` > `l`.`rpni`) and (`l`.`create_date` between (curdate() - interval (weekday(curdate()) + 1) day) and (curdate() - interval (weekday(curdate()) - 5) day))) group by (week((`l`.`create_date` + interval 6 day),2) - 1),`s`.`org_code` ;

-- ----------------------------
-- View structure for statisticsequipment_view
-- ----------------------------
DROP VIEW IF EXISTS `statisticsequipment_view`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `statisticsequipment_view` AS select left(`wl_equipment`.`code`,2) AS `ercode`,`wl_equipment`.`name` AS `name`,`wl_equipment`.`code` AS `code`,`wl_equipment`.`id` AS `id`,`wl_equipment_detail`.`name` AS `name_mx`,`wl_equipment_detail`.`id` AS `id_mx`,`wl_equipment_detail`.`code` AS `code_mx`,`wl_stock_detail`.`warehouse_structure_id` AS `warehouseStructureId`,`wl_equipment_detail`.`brand` AS `brand`,`wl_warehouse_structure`.`full_name` AS `fullName`,`wl_equipment_detail`.`standard` AS `standard`,`wl_stock_detail`.`qr_code` AS `qr_code`,`wl_stock_detail`.`amount` AS `amount`,(select `wl_system_dic`.`name` from `wl_system_dic` where ((`wl_system_dic`.`code` = `wl_stock_detail`.`status`) and (`wl_system_dic`.`type` = 'EquipStatus'))) AS `StateName`,'equipment' AS `type` from ((`wl_stock_detail` left join (`wl_equipment_detail` left join `wl_equipment` on((`wl_equipment`.`id` = `wl_equipment_detail`.`equipment_id`))) on((`wl_stock_detail`.`equipment_detail_id` = `wl_equipment_detail`.`id`))) left join `wl_warehouse_structure` on((`wl_stock_detail`.`warehouse_structure_id` = `wl_warehouse_structure`.`id`))) where ((`wl_stock_detail`.`status` in (1,2,10)) and (left(`wl_equipment`.`code`,1) <> '4')) union all select left(`wl_equipment`.`code`,2) AS `ercode`,`wl_equipment`.`name` AS `name`,`wl_equipment`.`code` AS `code`,`wl_equipment`.`id` AS `id`,`wl_equipment_detail`.`name` AS `name_mx`,`wl_equipment_detail`.`id` AS `id_mx`,`wl_equipment_detail`.`code` AS `code_mx`,`wl_stock_detail`.`warehouse_structure_id` AS `warehouseStructureId`,`wl_equipment_detail`.`brand` AS `brand`,`wl_warehouse_structure`.`full_name` AS `fullName`,`wl_equipment_detail`.`standard` AS `standard`,`wl_stock_detail`.`qr_code` AS `qr_code`,`wl_stock_detail`.`amount` AS `amount`,(select `wl_system_dic`.`name` from `wl_system_dic` where ((`wl_system_dic`.`code` = `wl_stock_detail`.`status`) and (`wl_system_dic`.`type` = 'EquipStatus'))) AS `StateName`,'equipment' AS `type` from ((`wl_stock_detail` left join (`wl_equipment_detail` left join `wl_equipment` on((`wl_equipment`.`id` = `wl_equipment_detail`.`equipment_id`))) on((`wl_stock_detail`.`equipment_detail_id` = `wl_equipment_detail`.`id`))) left join `wl_warehouse_structure` on((`wl_stock_detail`.`warehouse_structure_id` = `wl_warehouse_structure`.`id`))) where ((`wl_stock_detail`.`status` in (1,2,10)) and (left(`wl_equipment`.`code`,1) = '4')) union all select left(`wl_equipment`.`code`,2) AS `ercode`,`wl_equipment`.`name` AS `name`,`wl_equipment`.`code` AS `code`,`wl_equipment`.`id` AS `id`,`wl_equipment`.`name` AS `name_mx`,`wl_car`.`id` AS `id_mx`,`wl_equipment`.`code` AS `code_mx`,'' AS `warehouseStructureId`,`wl_car`.`brand` AS `brand`,'' AS `fullName`,`wl_car`.`standard` AS `standard`,`wl_car`.`qr_code` AS `qr_code`,1 AS `amount`,(select `wl_system_dic`.`name` from `wl_system_dic` where ((`wl_system_dic`.`code` = `wl_car`.`car_state`) and (`wl_system_dic`.`type` = 'CarState'))) AS `StateName`,'car' AS `type` from (`wl_car` join `wl_equipment`) where (`wl_equipment`.`id` = `wl_car`.`equipment_id`) ;

-- ----------------------------
-- View structure for s_danger_govern_count
-- ----------------------------
DROP VIEW IF EXISTS `s_danger_govern_count`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_danger_govern_count` AS select count(distinct `ld`.`id`) AS `danger_govern_count`,cast(now() as date) AS `vest_date` from (`p_latent_danger` `ld` left join `p_latent_danger_flow_record` `ldfr` on((`ldfr`.`danger_id` = `ld`.`id`))) where ((`ld`.`org_code` = '10') and (`ld`.`danger_state` = '5') and (cast(`ldfr`.`create_date` as date) = cast(now() as date))) ;

-- ----------------------------
-- View structure for s_equip_alarm_month
-- ----------------------------
DROP VIEW IF EXISTS `s_equip_alarm_month`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_equip_alarm_month` AS select `temp`.`org_code` AS `org_code`,`temp`.`total` AS `total`,`temp`.`fire_count` AS `fire_count`,`temp`.`fault_count` AS `fault_count`,`temp`.`fault_confirm_count` AS `fault_confirm_count`,`temp`.`fire_confirm_count` AS `fire_confirm_count`,year(now()) AS `year`,month(now()) AS `month`,now() AS `update_date` from (select `safety-business-3.0.0`.`wl_equipment_specific_alarm`.`org_code` AS `org_code`,count(1) AS `total`,sum((case when (`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`type` = 'FIREALARM') then 1 else 0 end)) AS `fire_count`,sum((case when (`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`type` = 'BREAKDOWN') then 1 else 0 end)) AS `fault_count`,sum((case when ((`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`type` = 'BREAKDOWN') and (`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`confirm_type` is not null)) then 1 else 0 end)) AS `fault_confirm_count`,sum((case when ((`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`type` = 'FIREALARM') and (`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`confirm_type` is not null)) then 1 else 0 end)) AS `fire_confirm_count` from `safety-business-3.0.0`.`wl_equipment_specific_alarm` where ((year(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = year(now())) and (month(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = month(now()))) group by `safety-business-3.0.0`.`wl_equipment_specific_alarm`.`org_code`) `temp` ;

-- ----------------------------
-- View structure for s_fighting_system_alarm_state
-- ----------------------------
DROP VIEW IF EXISTS `s_fighting_system_alarm_state`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_fighting_system_alarm_state` AS select `temp`.`name` AS `name`,`temp`.`org_code` AS `org_code`,`temp`.`fault_count` AS `fault_count`,`temp`.`fire_count` AS `fire_count`,(case when ((`temp`.`fire_count` = 0) and (`temp`.`fault_count` = 0)) then 'normal' when (`temp`.`fire_count` > 0) then 'fire' when ((`temp`.`fire_count` = 0) and (`temp`.`fault_count` > 0)) then 'fault' end) AS `state`,`temp`.`code` AS `code`,`temp`.`create_date` AS `create_date` from (select `ffs`.`name` AS `name`,`ffs`.`org_code` AS `org_code`,ifnull(sum((case when ((`esa`.`type` = 'BREAKDOWN') and (`esa`.`status` = 1)) then 1 else 0 end)),0) AS `fault_count`,ifnull(sum((case when ((`esa`.`type` = 'FIREALARM') and (`esa`.`status` = 1)) then 1 else 0 end)),0) AS `fire_count`,`ec`.`code` AS `code`,`esa`.`create_date` AS `create_date` from (((`safety-business-3.0.0`.`f_fire_fighting_system` `ffs` left join `safety-business-3.0.0`.`wl_equipment_specific` `es` on((`es`.`system_id` = `ffs`.`id`))) left join `safety-business-3.0.0`.`wl_equipment_specific_alarm` `esa` on((`esa`.`equipment_specific_id` = `es`.`id`))) left join `safety-business-3.0.0`.`wl_equipment_category` `ec` on((`ffs`.`system_type` = `ec`.`id`))) where ((to_days(now()) - to_days(`esa`.`create_date`)) <= 30) group by `ffs`.`name`,`ffs`.`org_code`) `temp` order by `temp`.`fault_count` desc ;

-- ----------------------------
-- View structure for s_fire_equip_category_stock_statistics
-- ----------------------------
DROP VIEW IF EXISTS `s_fire_equip_category_stock_statistics`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_fire_equip_category_stock_statistics` AS select `temp`.`CODE` AS `CODE`,sum(`temp`.`amount`) AS `total`,`temp`.`org_code` AS `org_code`,(case when (`temp`.`CODE` = '1') then '消防人员防护装备' when (`temp`.`CODE` = '3') then '灭火器材装备' when (`temp`.`CODE` = '4') then '灭火药剂' when (`temp`.`CODE` = '5') then '抢险救援器材' when (`temp`.`CODE` = '6') then '消防通信指挥装备' when (`temp`.`CODE` = '7') then '特种消防装备' when (`temp`.`CODE` = '8') then '防火检查与火灾调查装备' else '其他类消防装备器材' end) AS `NAME` from (select `sd`.`amount` AS `amount`,`eq`.`code` AS `fullCode`,substr(`eq`.`code`,1,8) AS `shortCode`,substr(`eq`.`code`,1,1) AS `CODE`,`sd`.`org_code` AS `org_code` from (((`safety-business-3.0.0`.`wl_stock_detail` `sd` left join `safety-business-3.0.0`.`wl_equipment_detail` `ed` on((`ed`.`id` = `sd`.`equipment_detail_id`))) left join `safety-business-3.0.0`.`wl_equipment` `eq` on((`eq`.`id` = `ed`.`equipment_id`))) left join `safety-business-3.0.0`.`wl_equipment_category` `ec` on((`ec`.`id` = `eq`.`category_id`))) where ((`ec`.`industry_code` = '2') and (substr(`eq`.`code`,1,8) <> '85000000'))) `temp` group by `temp`.`org_code`,`temp`.`CODE` union all select '2' AS `CODE`,count(1) AS `total`,`safety-business-3.0.0`.`wl_car`.`org_code` AS `org_code`,'消防车' AS `NAME` from `safety-business-3.0.0`.`wl_car` ;

-- ----------------------------
-- View structure for s_fire_equip_stock_detail
-- ----------------------------
DROP VIEW IF EXISTS `s_fire_equip_stock_detail`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_fire_equip_stock_detail` AS select `sd`.`equipment_detail_id` AS `equipment_detail_id`,`sd`.`equipment_specific_id` AS `equipment_specific_id`,`sd`.`amount` AS `amount`,`sd`.`status` AS `status`,`sd`.`org_code` AS `org_code`,`we`.`code` AS `equipment_code`,`we`.`name` AS `equipment_name`,`ed`.`code` AS `equipment_detail_code`,`ed`.`name` AS `equipment_detail_name`,`ec`.`parent_id` AS `parent_id`,`ec`.`code` AS `category_code`,`ec`.`name` AS `category_name`,`ec1`.`code` AS `fire_system_category_code`,`ec1`.`name` AS `fire_system_name`,`wu`.`name` AS `unit_name`,`ec`.`industry_code` AS `industry_code` from (((((((`wl_stock_detail` `sd` left join `wl_equipment_specific` `es` on((`sd`.`equipment_specific_id` = `es`.`id`))) left join `wl_equipment_detail` `ed` on((`sd`.`equipment_detail_id` = `ed`.`id`))) left join `wl_equipment` `we` on((`ed`.`equipment_id` = `we`.`id`))) left join `wl_equipment_category` `ec` on((`we`.`category_id` = `ec`.`id`))) left join `f_fire_fighting_system` `fs` on((`es`.`system_id` = `fs`.`id`))) left join `wl_equipment_category` `ec1` on((`fs`.`system_type` = `ec1`.`id`))) left join `wl_unit` `wu` on((`we`.`unit_id` = `wu`.`id`))) where (`ec`.`industry_code` = '2') ;

-- ----------------------------
-- View structure for s_patrol_plan_exec_day
-- ----------------------------
DROP VIEW IF EXISTS `s_patrol_plan_exec_day`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_patrol_plan_exec_day` AS select count(`td`.`point_id`) AS `plan_task_num`,ifnull(sum((case when (`td`.`is_finish` = 0) then 1 else 0 end)),0) AS `unfinished_count`,ifnull(sum((case when (`td`.`is_finish` = 1) then 1 else 0 end)),0) AS `exec_plan_task_num`,ifnull(sum((case when (`td`.`is_finish` = 2) then 1 else 0 end)),0) AS `missed_check_num`,`p`.`org_code` AS `org_code`,cast(now() as date) AS `vest_date` from (`p_plan_task_detail` `td` left join `p_point` `p` on((`p`.`id` = `td`.`point_id`))) where (cast(`td`.`create_date` as date) = cast(now() as date)) ;

-- ----------------------------
-- View structure for s_patrol_plan_exec_week
-- ----------------------------
DROP VIEW IF EXISTS `s_patrol_plan_exec_week`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_patrol_plan_exec_week` AS select count(`td`.`point_id`) AS `plan_task_num`,ifnull(sum((case when (`td`.`is_finish` = 0) then 1 else 0 end)),0) AS `unfinished_count`,ifnull(sum((case when (`td`.`is_finish` = 1) then 1 else 0 end)),0) AS `exec_plan_task_num`,ifnull(sum((case when (`td`.`is_finish` = 2) then 1 else 0 end)),0) AS `missed_check_num`,`p`.`org_code` AS `org_code`,week(now(),0) AS `week`,year(now()) AS `year` from (`p_plan_task_detail` `td` left join `p_point` `p` on((`p`.`id` = `td`.`point_id`))) where ((week(`td`.`create_date`,0) = week(now(),0)) and (year(`td`.`create_date`) = year(now()))) ;

-- ----------------------------
-- View structure for s_patrol_plan_task_exec_day
-- ----------------------------
DROP VIEW IF EXISTS `s_patrol_plan_task_exec_day`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_patrol_plan_task_exec_day` AS select count(`pt`.`id`) AS `plan_task_num`,ifnull(sum((case when ((`pt`.`finish_status` = 0) or (`pt`.`finish_status` = 1)) then 1 else 0 end)),0) AS `unfinished_count`,ifnull(sum((case when (`pt`.`finish_status` = 2) then 1 else 0 end)),0) AS `exec_plan_task_num`,ifnull(sum((case when (`pt`.`finish_status` = 3) then 1 else 0 end)),0) AS `missed_check_num`,ifnull((select count(1) AS `input_abnormal_count` from `p_check` where ((`p_check`.`is_ok` = 2) and ((to_days(now()) - to_days(`p_check`.`check_time`)) = 0))),0) AS `input_abnormal_count`,cast(now() as date) AS `vest_date` from `p_plan_task` `pt` where (((to_days(`pt`.`begin_time`) - to_days(now())) = 0) and ((to_days(now()) - to_days(`pt`.`end_time`)) = 0)) ;

-- ----------------------------
-- View structure for s_risk_danger_day
-- ----------------------------
DROP VIEW IF EXISTS `s_risk_danger_day`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_risk_danger_day` AS select ifnull(sum((case when (`p_latent_danger`.`danger_level` = '1') then 1 else 0 end)),0) AS `general`,ifnull(sum((case when (`p_latent_danger`.`danger_level` = '2') then 1 else 0 end)),0) AS `major`,ifnull(sum((case when (`p_latent_danger`.`danger_level` = '0') then 1 else 0 end)),0) AS `safety_problem`,cast(now() as date) AS `vest_date`,`p_latent_danger`.`org_code` AS `org_code`,now() AS `update_date` from `p_latent_danger` where (cast(`p_latent_danger`.`create_date` as date) = cast(now() as date)) ;

-- ----------------------------
-- View structure for s_risk_danger_month
-- ----------------------------
DROP VIEW IF EXISTS `s_risk_danger_month`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_risk_danger_month` AS select ifnull(sum((case when (`p_latent_danger`.`danger_level` = '1') then 1 else 0 end)),0) AS `general`,ifnull(sum((case when (`p_latent_danger`.`danger_level` = '2') then 1 else 0 end)),0) AS `major`,ifnull(sum((case when (`p_latent_danger`.`danger_level` = '0') then 1 else 0 end)),0) AS `safety_problem`,year(now()) AS `year`,month(now()) AS `month`,`p_latent_danger`.`org_code` AS `org_code`,now() AS `update_date` from `p_latent_danger` where ((month(`p_latent_danger`.`create_date`) = month(now())) and (year(`p_latent_danger`.`create_date`) = year(now()))) ;

-- ----------------------------
-- View structure for s_risk_danger_week
-- ----------------------------
DROP VIEW IF EXISTS `s_risk_danger_week`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_risk_danger_week` AS select ifnull(sum((case when (`p_latent_danger`.`danger_level` = '1') then 1 else 0 end)),0) AS `general`,ifnull(sum((case when (`p_latent_danger`.`danger_level` = '2') then 1 else 0 end)),0) AS `major`,ifnull(sum((case when (`p_latent_danger`.`danger_level` = '0') then 1 else 0 end)),0) AS `safety_problem`,year(now()) AS `year`,week(now(),0) AS `week`,`p_latent_danger`.`org_code` AS `org_code`,now() AS `update_date` from `p_latent_danger` where ((week(`p_latent_danger`.`create_date`,0) = week(now(),0)) and (year(`p_latent_danger`.`create_date`) = year(now()))) ;

-- ----------------------------
-- View structure for s_risk_index_trend
-- ----------------------------
DROP VIEW IF EXISTS `s_risk_index_trend`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_risk_index_trend` AS select `f_safety_index_change_log`.`safety_index` AS `safety_index`,`f_safety_index_change_log`.`org_code` AS `org_code`,`f_safety_index_change_log`.`collect_date` AS `collect_date` from `f_safety_index_change_log` union all (select abs(((`f_risk_source`.`rpn` / 10) - 100)) AS `safety_index`,`f_risk_source`.`org_code` AS `org_code`,cast(now() as date) AS `collect_date` from `f_risk_source` where ((`f_risk_source`.`parent_id` = 0) or isnull(`f_risk_source`.`parent_id`))) ;

-- ----------------------------
-- View structure for s_risk_statistics
-- ----------------------------
DROP VIEW IF EXISTS `s_risk_statistics`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_risk_statistics` AS select count(`rs`.`code`) AS `total`,ifnull(sum((case when (`rl`.`level` = '1') then 1 else 0 end)),0) AS `one_level`,ifnull(sum((case when (`rl`.`level` = '2') then 1 else 0 end)),0) AS `two_level`,ifnull(sum((case when (`rl`.`level` = '3') then 1 else 0 end)),0) AS `three_level`,ifnull(sum((case when (`rl`.`level` = '4') then 1 else 0 end)),0) AS `four_level`,convert('riskArea' using utf8) AS `type`,`rs`.`org_code` AS `org_code` from (`f_risk_source` `rs` left join `f_risk_level` `rl` on((`rl`.`id` = `rs`.`risk_level_id`))) where ((`rs`.`parent_id` <> 0) and (`rs`.`risk_level_id` is not null) and (`rs`.`is_region` = 'TRUE')) union all select count(`rs`.`code`) AS `total`,ifnull(sum((case when (`rl`.`level` = '1') then 1 else 0 end)),0) AS `one_level`,ifnull(sum((case when (`rl`.`level` = '2') then 1 else 0 end)),0) AS `two_level`,ifnull(sum((case when (`rl`.`level` = '3') then 1 else 0 end)),0) AS `three_level`,ifnull(sum((case when (`rl`.`level` = '4') then 1 else 0 end)),0) AS `four_level`,convert('riskSource' using utf8) AS `type`,`rs`.`org_code` AS `org_code` from (`f_risk_source` `rs` left join `f_risk_level` `rl` on((`rl`.`id` = `rs`.`risk_level_id`))) where ((`rs`.`risk_level_id` is not null) and (`rs`.`is_region` = 'FALSE')) union all select count(`fm`.`id`) AS `total`,ifnull(sum((case when (`rl`.`level` = '1') then 1 else 0 end)),0) AS `one_level`,ifnull(sum((case when (`rl`.`level` = '2') then 1 else 0 end)),0) AS `two_level`,ifnull(sum((case when (`rl`.`level` = '3') then 1 else 0 end)),0) AS `three_level`,ifnull(sum((case when (`rl`.`level` = '4') then 1 else 0 end)),0) AS `four_level`,convert('riskFactor' using utf8) AS `type`,`rs`.`org_code` AS `org_code` from ((`f_fmea` `fm` left join `f_risk_source` `rs` on((`rs`.`id` = `fm`.`risk_source_id`))) left join `f_risk_level` `rl` on((`rl`.`id` = `fm`.`risk_level_id`))) where (`fm`.`risk_level_id` is not null) union all select count(`fm`.`id`) AS `total`,ifnull(sum((case when (`rl`.`level` = '1') then 1 else 0 end)),0) AS `one_level`,ifnull(sum((case when (`rl`.`level` = '2') then 1 else 0 end)),0) AS `two_level`,ifnull(sum((case when (`rl`.`level` = '3') then 1 else 0 end)),0) AS `three_level`,ifnull(sum((case when (`rl`.`level` = '4') then 1 else 0 end)),0) AS `four_level`,convert('riskFactorFailure' using utf8) AS `type`,`rs`.`org_code` AS `org_code` from ((`f_fmea` `fm` left join `f_risk_source` `rs` on((`rs`.`id` = `fm`.`risk_source_id`))) left join `f_risk_level` `rl` on((`rl`.`id` = `fm`.`risk_level_id`))) where ((`fm`.`risk_level_id` is not null) and (`fm`.`rpn` > `fm`.`rpni`)) ;

-- ----------------------------
-- View structure for toip_biz_message
-- ----------------------------
DROP VIEW IF EXISTS `toip_biz_message`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `toip_biz_message` AS select `m`.`id` AS `id`,`m`.`id` AS `originId`,`m`.`time` AS `time`,`m`.`content` AS `content`,`m`.`title` AS `title`,`m`.`type` AS `type`,`m`.`sender` AS `sender`,`m`.`receiver` AS `receiver`,`m`.`reader` AS `reader`,`m`.`biz_id` AS `biz_id`,`m`.`bizclass_name` AS `bizclass_name`,`n`.`org_code` AS `org_code` from (`toip_sys_message` `m` join `f_equipment` `n`) where ((`n`.`id` = `m`.`biz_id`) and (`m`.`bizclass_name` = 'class com.yeejoin.amos.fas.business.service.model.FireEquimentDataRo')) union all select `m`.`id` AS `id`,`m`.`id` AS `originId`,`m`.`time` AS `time`,`m`.`content` AS `content`,`m`.`title` AS `title`,`m`.`type` AS `type`,`m`.`sender` AS `sender`,`m`.`receiver` AS `receiver`,`m`.`reader` AS `reader`,`m`.`biz_id` AS `biz_id`,`m`.`bizclass_name` AS `bizclass_name`,`n`.`org_code` AS `org_code` from (`toip_sys_message` `m` join `p_point` `n`) where ((`n`.`id` = `m`.`biz_id`) and (`m`.`bizclass_name` = 'class com.yeejoin.amos.fas.business.service.model.ProtalDataRo')) union all select `m`.`id` AS `id`,`m`.`id` AS `originId`,`m`.`time` AS `time`,`m`.`content` AS `content`,`m`.`title` AS `title`,`m`.`type` AS `type`,`m`.`sender` AS `sender`,`m`.`receiver` AS `receiver`,`m`.`reader` AS `reader`,`m`.`biz_id` AS `biz_id`,`m`.`bizclass_name` AS `bizclass_name`,`n`.`org_code` AS `org_code` from (`toip_sys_message` `m` join `f_risk_source` `n`) where ((`n`.`id` = `m`.`biz_id`) and (`m`.`bizclass_name` = 'class com.yeejoin.amos.fas.business.service.model.RiskSourceRuleRo')) ;

-- ----------------------------
-- View structure for v2
-- ----------------------------
DROP VIEW IF EXISTS `v2`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`172.16.3.39` SQL SECURITY DEFINER VIEW `v2` AS select left(`wl_equipment`.`code`,2) AS `ercode`,`wl_equipment`.`name` AS `name`,`wl_equipment`.`code` AS `code`,`wl_equipment`.`id` AS `id`,`wl_equipment_detail`.`name` AS `name_mx`,`wl_equipment_detail`.`id` AS `id_mx`,`wl_equipment_detail`.`code` AS `code_mx`,`wl_stock_detail`.`warehouse_structure_id` AS `warehouseStructureId`,`wl_equipment_detail`.`brand` AS `brand`,`wl_warehouse_structure`.`full_name` AS `fullName`,`wl_equipment_detail`.`standard` AS `standard`,`wl_stock_detail`.`qr_code` AS `qr_code`,1 AS `amount`,(select `wl_system_dic`.`name` from `wl_system_dic` where ((`wl_system_dic`.`code` = `wl_stock_detail`.`status`) and (`wl_system_dic`.`type` = 'EquipStatus'))) AS `StateName`,'equipment' AS `type` from ((`wl_stock_detail` left join (`wl_equipment_detail` left join `wl_equipment` on((`wl_equipment`.`id` = `wl_equipment_detail`.`equipment_id`))) on((`wl_stock_detail`.`equipment_detail_id` = `wl_equipment_detail`.`id`))) left join `wl_warehouse_structure` on((`wl_stock_detail`.`warehouse_structure_id` = `wl_warehouse_structure`.`id`))) where ((`wl_stock_detail`.`status` in (1,2,10)) and (left(`wl_equipment`.`code`,1) <> '4')) union all select left(`wl_equipment`.`code`,2) AS `ercode`,`wl_equipment`.`name` AS `name`,`wl_equipment`.`code` AS `code`,`wl_equipment`.`id` AS `id`,`wl_equipment_detail`.`name` AS `name_mx`,`wl_equipment_detail`.`id` AS `id_mx`,`wl_equipment_detail`.`code` AS `code_mx`,`wl_stock_detail`.`warehouse_structure_id` AS `warehouseStructureId`,`wl_equipment_detail`.`brand` AS `brand`,`wl_warehouse_structure`.`full_name` AS `fullName`,`wl_equipment_detail`.`standard` AS `standard`,`wl_stock_detail`.`qr_code` AS `qr_code`,`wl_stock_detail`.`amount` AS `amount`,(select `wl_system_dic`.`name` from `wl_system_dic` where ((`wl_system_dic`.`code` = `wl_stock_detail`.`status`) and (`wl_system_dic`.`type` = 'EquipStatus'))) AS `StateName`,'equipment' AS `type` from ((`wl_stock_detail` left join (`wl_equipment_detail` left join `wl_equipment` on((`wl_equipment`.`id` = `wl_equipment_detail`.`equipment_id`))) on((`wl_stock_detail`.`equipment_detail_id` = `wl_equipment_detail`.`id`))) left join `wl_warehouse_structure` on((`wl_stock_detail`.`warehouse_structure_id` = `wl_warehouse_structure`.`id`))) where ((`wl_stock_detail`.`status` in (1,2,10)) and (left(`wl_equipment`.`code`,1) = '4')) union all select left(`wl_equipment`.`code`,2) AS `ercode`,`wl_equipment`.`name` AS `name`,`wl_equipment`.`code` AS `code`,`wl_equipment`.`id` AS `id`,`wl_equipment`.`name` AS `name_mx`,`wl_car`.`id` AS `id_mx`,`wl_equipment`.`code` AS `code_mx`,'' AS `warehouseStructureId`,`wl_car`.`brand` AS `brand`,'' AS `fullName`,`wl_car`.`standard` AS `standard`,`wl_car`.`qr_code` AS `qr_code`,1 AS `amount`,(select `wl_system_dic`.`name` from `wl_system_dic` where ((`wl_system_dic`.`code` = `wl_car`.`car_state`) and (`wl_system_dic`.`type` = 'CarState'))) AS `StateName`,'car' AS `type` from (`wl_car` left join `wl_equipment` on((`wl_equipment`.`id` = `wl_car`.`equipment_id`))) where (`wl_car`.`car_state` in (1,2)) ;

-- ----------------------------
-- View structure for vcheck
-- ----------------------------
DROP VIEW IF EXISTS `vcheck`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `vcheck` AS select `a`.`id` AS `id`,`a`.`org_code` AS `org_code`,`a`.`point_id` AS `point_id`,`b`.`name` AS `point_name`,`b`.`is_fixed` AS `is_fixed`,`b`.`point_no` AS `point_no`,`a`.`user_id` AS `user_id`,date_format(`a`.`check_time`,'%Y-%m-%d %H:%i:%s') AS `check_time`,date_format(`a`.`upload_time`,'%Y-%m-%d %H:%i:%s') AS `upload_time`,(case when ((`a`.`plan_task_detail_id` = 0) or isnull(`a`.`plan_task_detail_id`)) then '0' when ((`a`.`plan_task_detail_id` <> 0) and (`a`.`is_ok` <> 3)) then '1' when (`a`.`is_ok` = 3) then '2' end) AS `Finish_Status`,`a`.`is_ok` AS `is_ok`,`a`.`score` AS `score`,`a`.`route_id` AS `route_id`,`d`.`name` AS `route_name`,`a`.`check_mode` AS `check_mode`,`a`.`plan_id` AS `plan_id`,`e`.`name` AS `plan_name`,`b`.`catalog_id` AS `catalog_id`,`a`.`plan_task_id` AS `plan_task_id`,`a`.`error` AS `error`,`a`.`remark` AS `remark`,`e`.`dept_id` AS `department_id` from ((((`p_check` `a` left join `p_point` `b` on((`a`.`point_id` = `b`.`id`))) left join `p_route` `d` on((`a`.`route_id` = `d`.`id`))) left join `p_plan` `e` on((`a`.`plan_id` = `e`.`id`))) left join `p_catalog_tree` `f` on((`b`.`catalog_id` = `f`.`id`))) ;

-- ----------------------------
-- View structure for v_check_info
-- ----------------------------
DROP VIEW IF EXISTS `v_check_info`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_check_info` AS select `sss`.`CheckTime` AS `CheckTime`,`sss`.`UserID` AS `UserID`,`sss`.`PointID` AS `PointID`,`sss`.`CheckID` AS `CheckID`,`sss`.`STATUS` AS `STATUS`,`sss`.`orgCode` AS `orgCode`,`sss`.`TaskID` AS `TaskID`,(case `sss`.`STATUS` when '2' then (select group_concat(`ii`.`name` separator ';') from (`safety-business-3.0.0`.`p_check_input` `ci` join `safety-business-3.0.0`.`p_input_item` `ii`) where ((`ci`.`check_id` = `sss`.`CheckID`) and (`ci`.`is_ok` = '2') and (`ci`.`input_id` = `ii`.`id`))) end) AS `ErrorMsg` from (select `ss`.`CheckTime` AS `CheckTime`,`ss`.`UserID` AS `UserID`,`ss`.`PointID` AS `PointID`,`ss`.`CheckID` AS `CheckID`,`ss`.`STATUS` AS `STATUS`,`ss`.`orgCode` AS `orgCode`,`ttemp`.`TaskID` AS `TaskID` from (((select `a`.`check_time` AS `CheckTime`,`a`.`user_id` AS `UserID`,`a`.`point_id` AS `PointID`,`a`.`id` AS `CheckID`,`a`.`is_ok` AS `STATUS`,`a`.`org_code` AS `orgCode` from (`safety-business-3.0.0`.`p_check` `a` join `safety-business-3.0.0`.`p_point` `p`) where (`p`.`id` = `a`.`point_id`))) `ss` left join (select `td`.`check_id` AS `check_id`,group_concat(`td`.`task_id` separator ',') AS `TaskID` from (`safety-business-3.0.0`.`p_task_detail` `td` join (select `a`.`check_time` AS `CheckTime`,`a`.`user_id` AS `UserID`,`a`.`point_id` AS `PointID`,`a`.`id` AS `CheckID`,`a`.`is_ok` AS `STATUS`,`p`.`name` AS `pointName`,`a`.`org_code` AS `orgCode` from (`safety-business-3.0.0`.`p_check` `a` join `safety-business-3.0.0`.`p_point` `p`) where (`p`.`id` = `a`.`point_id`)) `ss_`) where (`td`.`check_id` = `ss_`.`CheckID`) group by `td`.`check_id`) `ttemp` on((`ttemp`.`check_id` = `ss`.`CheckID`)))) `sss` ;

-- ----------------------------
-- View structure for v_equipment_specific_alarm
-- ----------------------------
DROP VIEW IF EXISTS `v_equipment_specific_alarm`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equipment_specific_alarm` AS select `c`.`a` AS `name`,`c`.`b` AS `sort`,sum((case `c`.`type` when 'FIREALARM' then 1 else 0 end)) AS `value1`,sum((case `c`.`type` when 'BREAKDOWN' then 1 else 0 end)) AS `value2`,sum((case `c`.`type` when 'SIGNALALARM' then 1 else 0 end)) AS `value3`,`c`.`type` AS `type` from (select (case when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth((now() - interval 6 day))) then date_format((now() - interval 6 day),'%m-%d') when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth((now() - interval 5 day))) then date_format((now() - interval 5 day),'%m-%d') when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth((now() - interval 4 day))) then date_format((now() - interval 4 day),'%m-%d') when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth((now() - interval 3 day))) then date_format((now() - interval 3 day),'%m-%d') when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth((now() - interval 2 day))) then date_format((now() - interval 2 day),'%m-%d') when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth((now() - interval 1 day))) then date_format((now() - interval 1 day),'%m-%d') when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth(now())) then date_format(now(),'%m-%d') end) AS `a`,(case when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth((now() - interval 6 day))) then 1 when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth((now() - interval 5 day))) then 2 when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth((now() - interval 4 day))) then 3 when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth((now() - interval 3 day))) then 4 when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth((now() - interval 2 day))) then 5 when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth((now() - interval 1 day))) then 6 when (dayofmonth(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`) = dayofmonth(now())) then 7 end) AS `b`,`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`type` AS `type` from `safety-business-3.0.0`.`wl_equipment_specific_alarm` where ((`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`status` = 1) and ((date_format(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`create_date`,'%Y-%m-%d') = date_format(now(),'%Y-%m-%d')) or (date_format(`safety-business-3.0.0`.`wl_equipment_specific_alarm`.`update_date`,'%Y-%m-%d') = date_format(now(),'%Y-%m-%d'))))) `c` where ((`c`.`a` <> '') or (`c`.`a` <> NULL)) group by `c`.`a` order by `c`.`b` ;

-- ----------------------------
-- View structure for v_equip_fire_control_water
-- ----------------------------
DROP VIEW IF EXISTS `v_equip_fire_control_water`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equip_fire_control_water` AS select '消防水池' AS `名称`,(select `wf`.`field_value` from `wl_form_instance` `wf` where (`wf`.`field_name` = 'waterStorage')) AS `水量` from `wl_form_instance` `wfi` where (`wfi`.`group_code` like '%pool%') group by `wfi`.`instance_id` ;

-- ----------------------------
-- View structure for v_equip_task_plan
-- ----------------------------
DROP VIEW IF EXISTS `v_equip_task_plan`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equip_task_plan` AS select `ppi`.`name` AS `name`,count(`pptd`.`id`) AS `checkNum` from (`p_plan_task_detail` `pptd` left join `p_point_classify` `ppi` on((`pptd`.`point_id` = `ppi`.`point_id`))) where ((curdate() - interval 30 day) <= cast(`pptd`.`create_date` as date)) group by `ppi`.`name` order by `checkNum` limit 10 ;

-- ----------------------------
-- View structure for v_msg_subscribe_check
-- ----------------------------
DROP VIEW IF EXISTS `v_msg_subscribe_check`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_msg_subscribe_check` AS select `p_msg_subscribe`.`user_id` AS `user_id`,max((case when (`p_msg_subscribe`.`msg_type` = 'checkEmail') then `p_msg_subscribe`.`attribute1` end)) AS `check_email`,max((case when (`p_msg_subscribe`.`msg_type` = 'checkType') then `p_msg_subscribe`.`attribute1` end)) AS `check_type`,max((case when (`p_msg_subscribe`.`msg_type` = 'route') then `p_msg_subscribe`.`attribute1` end)) AS `route` from `p_msg_subscribe` group by `p_msg_subscribe`.`user_id` ;

-- ----------------------------
-- View structure for v_point_last_check
-- ----------------------------
DROP VIEW IF EXISTS `v_point_last_check`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_point_last_check` AS select `a`.`point_id` AS `point_id`,`a`.`check_time` AS `check_time`,(case `a`.`is_ok` when '2' then (select group_concat(`c`.`name` separator ';') from (`p_check_input` `b` join `p_input_item` `c`) where ((`b`.`check_id` = `a`.`id`) and (`b`.`input_id` = `c`.`id`) and (`b`.`is_ok` = '2'))) when '3' then '漏检' end) AS `errorMsg` from `p_check` `a` where (`a`.`id` = (select max(`pc`.`id`) from `p_check` `pc` where (`a`.`point_id` = `pc`.`point_id`))) ;

-- ----------------------------
-- View structure for v_risk_level
-- ----------------------------
DROP VIEW IF EXISTS `v_risk_level`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_risk_level` AS select (case when (abs(((`f_risk_source`.`rpn` / 10) - 100)) between 0 and 49.9) then '高风险' when (abs(((`f_risk_source`.`rpn` / 10) - 100)) between 50 and 89.9) then '中风险' when (abs(((`f_risk_source`.`rpn` / 10) - 100)) between 90 and 94.9) then '低风险' else '安全' end) AS `safetyLevel` from `f_risk_source` where ((`f_risk_source`.`org_code` = '10') and ((`f_risk_source`.`parent_id` = 0) or isnull(`f_risk_source`.`parent_id`))) ;

-- ----------------------------
-- Procedure structure for everyDayInitPlanTaskStatistics
-- ----------------------------
DROP PROCEDURE IF EXISTS `everyDayInitPlanTaskStatistics`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `everyDayInitPlanTaskStatistics`()
BEGIN
			declare userId bigint ;
			declare orgCode VARCHAR(50) ;
			declare currentDate VARCHAR(40) ;
			declare planTaskNum BIGINT ;
			declare planTaskFinishNum BIGINT ;
			declare personNum BIGINT ;
			DECLARE done BOOLEAN DEFAULT 0;
			DECLARE p_p_conf CURSOR FOR select id from s_user u where u.enabled = 1 AND u.is_delete = 0;
			DECLARE CONTINUE HANDLER FOR NOT FOUND SET done=1;
			set currentDate = SYSDATE();
			open p_p_conf;
			REPEAT
			FETCH p_p_conf INTO userId;
			if done != 1 THEN
			BEGIN
			DECLARE orgDone BOOLEAN DEFAULT 0;
			DECLARE org_plan_task CURSOR FOR SELECT sum(finish_num), sum(point_num),org_code FROM p_plan_task WHERE  find_in_set(userId,user_id)>0 AND end_time >= STR_TO_DATE(SYSDATE(),'%Y-%m-%d') GROUP BY org_code;
			DECLARE CONTINUE HANDLER FOR NOT FOUND SET orgDone=1;

			open org_plan_task;
			REPEAT
			FETCH org_plan_task INTO planTaskFinishNum, planTaskNum, orgCode;
			if done != 1 THEN
			if planTaskNum is null then
			set planTaskNum = 0;
			end if;
			if planTaskFinishNum is null then
			set planTaskFinishNum = 0;
			end if;
			SELECT count(1) into personNum FROM p_plan_exec_statistics where check_time = DATE_FORMAT(currentDate, '%Y-%m-%d') AND user_id = userId AND org_code = orgCode;
			if orgCode is not null then
			if personNum > 0 THEN
			update p_plan_exec_statistics SET plan_task_num = planTaskNum, exec_plan_task_num = planTaskFinishNum, missed_check_num=0, outside_plan_num=0  where check_time = DATE_FORMAT(currentDate, '%Y-%m-%d') AND user_id = userId AND org_code = orgCode;
			ELSE
			INSERT INTO p_plan_exec_statistics(check_time,org_code,user_id,plan_task_num,exec_plan_task_num,missed_check_num,outside_plan_num)
			VALUES(DATE_FORMAT(currentDate, '%Y-%m-%d'), orgCode, userId, planTaskNum, planTaskFinishNum, 0, 0);
			end if;
			end if;
			end if;
			UNTIL orgDone END REPEAT;
			CLOSE org_plan_task;
			END;
			end if;

			UNTIL done END REPEAT;
			CLOSE p_p_conf;
			END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for planTaskStatistics
-- ----------------------------
DROP PROCEDURE IF EXISTS `planTaskStatistics`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `planTaskStatistics`(IN `userId` VARCHAR(50) ,IN `currentDate` VARCHAR(40),IN `orgCode` VARCHAR(50))
BEGIN
			declare planTaskNum BIGINT ;
			declare planTaskFinishNum BIGINT ;
			declare missedNum BIGINT ;
			declare personNum BIGINT ;
			declare outsideNum BIGINT ;
			if currentDate is null THEN
			set currentDate = DATE_FORMAT(SYSDATE(), '%Y-%m-%d');
			end if;
			if  userId !='' then
			SELECT sum(a.finish_num), sum(a.point_num), sum(a.miss),org_code FROM (
			SELECT finish_num, point_num, org_code, CASE finish_status WHEN 3 THEN (point_num - finish_num) ELSE 0 END miss
			FROM p_plan_task WHERE find_in_set(userId,user_id)>0 AND DATE_FORMAT(end_time, '%Y-%m-%d') >=currentDate AND DATE_FORMAT(begin_time, '%Y-%m-%d')<=  currentDate AND LOCATE(orgCode, org_code)> 0  ) a INTO planTaskFinishNum, planTaskNum, missedNum, orgCode;
			if planTaskNum is null then
			set planTaskNum = 0;
			end if;
			if planTaskFinishNum is null then
			set planTaskFinishNum = 0;
			end if;
			if outsideNum is null then
			set outsideNum = 0;
			end if;
			if planTaskNum > 0 then

			SELECT count(1) into personNum FROM p_plan_exec_statistics where check_time = currentDate AND user_id = userId AND org_code = orgCode;

			if personNum > 0 then
			SELECT count(1) into outsideNum FROM p_check where DATE_FORMAT(check_time, '%Y-%m-%d') = currentDate AND find_in_set(userId,user_id)>0 and org_code = (select substring(orgCode,1,(SELECT INSTR(orgCode,'-')-1))) and plan_task_id = 0;
			update p_plan_exec_statistics SET plan_task_num = planTaskNum, exec_plan_task_num = planTaskFinishNum, missed_check_num=missedNum, outside_plan_num=outsideNum  where check_time = currentDate AND user_id = userId AND org_code = orgCode;
			ELSE
			SELECT count(1) into outsideNum FROM p_check where DATE_FORMAT(check_time, '%Y-%m-%d') = currentDate AND find_in_set(userId,user_id)>0 and org_code = (select substring(orgCode,1,(SELECT INSTR(orgCode,'-')-1))) and (plan_task_id = 0 or plan_task_id = null);
			INSERT INTO p_plan_exec_statistics(check_time,org_code,user_id,plan_task_num,exec_plan_task_num,missed_check_num,outside_plan_num)
			VALUES(currentDate, orgCode, userId, planTaskNum, planTaskFinishNum, missedNum, outsideNum);
			end if;
			end if;
			end if;
			END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for updatePlanTask
-- ----------------------------
DROP PROCEDURE IF EXISTS `updatePlanTask`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `updatePlanTask`(IN `planTaskId` int,IN `pointId` int,IN `planTaskDetailId` int,IN `executorId` int)
BEGIN
			declare num int ;
			declare orgCode VARCHAR(50) ;
			declare currentTaskNum int ;
			update p_plan_task_detail set is_finish = 1 where id=planTaskDetailId;
			select finish_num, org_code from p_plan_task where id = planTaskId into num, orgCode;
			select count(1) into currentTaskNum from p_plan_task_detail where task_no = planTaskId and is_finish in(0,2);
			UPDATE p_plan_task_detail SET executor_id = executorId,executor_date = current_timestamp where id = planTaskDetailId;
			if currentTaskNum > 0 THEN
			update p_plan_task set finish_num = (num + 1) where id = planTaskId;
			ELSE
			update p_plan_task set finish_num = (num + 1), finish_status = 2 where id = planTaskId;
			end if;
			if executorId > 0 then
			call planTaskStatistics(executorId, null, orgCode);
			end if;
			END
;;
DELIMITER ;

-- ----------------------------
-- Function structure for getBuildingNames
-- ----------------------------
DROP FUNCTION IF EXISTS `getBuildingNames`;
DELIMITER ;;
CREATE DEFINER=`root`@`172.16.3.39` FUNCTION `getBuildingNames`(`rootId` VARCHAR(100)) RETURNS varchar(1000) CHARSET utf8
BEGIN
	DECLARE ptemp VARCHAR(1000);
	DECLARE ctemp VARCHAR(1000);
	DECLARE ctempName VARCHAR(1000);

	SET ptemp ='';
	SET ctemp = rootId;

		WHILE ctemp != '0' DO
		SET ptemp = concat(ptemp,',',ctemp);
		SELECT GROUP_CONCAT(parentId) INTO ctemp
		FROM get_building_tree
		WHERE instanceId = ctemp;
		END WHILE;

	SET ptemp = concat(ptemp,',',rootId);

	SELECT GROUP_CONCAT(instanceName) INTO ctempName
	FROM get_building_tree
	WHERE FIND_IN_SET(instanceId, ptemp);

	RETURN REPLACE(ctempName,',','');
END
;;
DELIMITER ;

-- ----------------------------
-- Function structure for getChildrend
-- ----------------------------
DROP FUNCTION IF EXISTS `getChildrend`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` FUNCTION `getChildrend`(`p_id` VARCHAR(1000)) RETURNS varchar(1000) CHARSET utf8
BEGIN
DECLARE sTemp VARCHAR(20000);
DECLARE sTempChd VARCHAR(5000);
SET sTemp='$';
SET sTempChd = CAST(p_id AS CHAR);
WHILE sTempChd IS NOT NULL DO
SET sTemp = CONCAT(sTemp,',',sTempChd);
SELECT GROUP_CONCAT(distinct id) INTO sTempChd FROM wl_equipment_category WHERE FIND_IN_SET(parent_id,sTempChd) > 0;
END WHILE;
RETURN sTemp;
END
;;
DELIMITER ;

-- ----------------------------
-- Function structure for getChildrenIdsByRootId
-- ----------------------------
DROP FUNCTION IF EXISTS `getChildrenIdsByRootId`;
DELIMITER ;;
CREATE DEFINER=`root`@`172.16.3.39` FUNCTION `getChildrenIdsByRootId`(`rootId` VARCHAR(100)) RETURNS varchar(1000) CHARSET utf8
BEGIN
	DECLARE ids VARCHAR(1000);
	DECLARE ptemp VARCHAR(1000);
	SELECT
		GROUP_CONCAT(c.instanceId) INTO ids
	FROM
		(
			SELECT
				a.instanceId,
			IF (
				FIND_IN_SET(a.parentId ,@pids) > 0,

			IF (
				length(@pids) - length(
					REPLACE (@pids, a.parentId, '')
				) > 1,

			IF (
				length(@pids) - length(REPLACE(@pids, a.instanceId, '')) > 1 ,@pids ,@pids := concat(@pids, ',', a.instanceId)
			) ,@pids := concat(@pids, ',', a.instanceId)
			),
			0
			) AS 'plist',

		IF (
			FIND_IN_SET(a.parentId ,@pids) > 0,
			@pids,
			0
		) AS ischild
		FROM
			(
				SELECT
					r.instanceId,
					r.parentId
				FROM
					get_building_tree r
			) a,
			(SELECT @pids := rootId) b
		) c
	WHERE
		c.ischild != 0;
	IF ISNULL(ids) || LENGTH(trim(ids)) < 1 THEN
		SET ptemp = rootId;
	ELSE
		SET ptemp = concat(rootId,',',ids);
	END IF;
	RETURN ptemp;
END
;;
DELIMITER ;

-- ----------------------------
-- Function structure for getParent
-- ----------------------------
DROP FUNCTION IF EXISTS `getParent`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` FUNCTION `getParent`(`rootId` VARCHAR(1000)) RETURNS varchar(1000) CHARSET utf8
BEGIN
				DECLARE ptemp VARCHAR(1000);
				DECLARE ctemp VARCHAR(1000);
				SET ptemp ='#';
			    SET ctemp =rootId;
			    WHILE ctemp IS NOT NULL DO
			      SET ptemp = concat(ptemp,',',ctemp);
			      SELECT GROUP_CONCAT(id) INTO ctemp
			      FROM wl_equipment_category
			      WHERE id = ( SELECT parent_id FROM wl_equipment_category WHERE FIND_IN_SET(id,ctemp) > 0);
			    END WHILE;
			    RETURN ptemp;
			  END
;;
DELIMITER ;

-- ----------------------------
-- Function structure for queryChildrenAreaInfo
-- ----------------------------
DROP FUNCTION IF EXISTS `queryChildrenAreaInfo`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` FUNCTION `queryChildrenAreaInfo`(areaId INT) RETURNS varchar(4000) CHARSET utf8
BEGIN
DECLARE sTemp VARCHAR(4000);
DECLARE sTempChd VARCHAR(4000);

SET sTemp='$';
SET sTempChd = CAST(areaId AS CHAR);

WHILE sTempChd IS NOT NULL DO
SET sTemp= CONCAT(sTemp,',',sTempChd);
SELECT GROUP_CONCAT(id) INTO sTempChd FROM wl_equipment_category WHERE FIND_IN_SET(parentId,sTempChd)>0;
END WHILE;
RETURN sTemp;
END
;;
DELIMITER ;

-- ----------------------------
-- Function structure for queryRiskSourceChildrenIds
-- ----------------------------
DROP FUNCTION IF EXISTS `queryRiskSourceChildrenIds`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` FUNCTION `queryRiskSourceChildrenIds`(id INT) RETURNS varchar(4000) CHARSET utf8
BEGIN
				DECLARE sTemp VARCHAR(4000);
				DECLARE sTempChd VARCHAR(4000);

				SET sTemp='$';
				SET sTempChd = CAST(id AS char);

				WHILE sTempChd IS NOT NULL DO
					SET sTemp= CONCAT(sTemp,',',sTempChd);
					SELECT GROUP_CONCAT(r.id) INTO sTempChd FROM f_risk_source r WHERE FIND_IN_SET(parent_id,sTempChd)>0;
				END WHILE;
				RETURN sTemp;
			END
;;
DELIMITER ;

-- ----------------------------
-- Event structure for planTaskStatisticsaEvent
-- ----------------------------
DROP EVENT IF EXISTS `planTaskStatisticsaEvent`;
DELIMITER ;;
CREATE DEFINER=`root`@`172.16.3.39` EVENT `planTaskStatisticsaEvent` ON SCHEDULE EVERY 1 DAY STARTS '2020-05-19 00:00:00' ON COMPLETION PRESERVE ENABLE DO CALL everyDayInitPlanTaskStatistics()
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_fire_equipment_point_update`;
DELIMITER ;;
CREATE TRIGGER `trigger_fire_equipment_point_update` AFTER UPDATE ON `f_fire_equipment_point` FOR EACH ROW BEGIN
            DECLARE num1 INT (4) default 0;
            select count(1) into num1 from f_fire_equipment_point where fire_equipment_id = new.fire_equipment_id and type='SWITCH' and  0x4000>=CAST(code  AS SIGNED) and value = 'true';
            if num1 > 0 then
              update f_fire_equipment set equip_status = 1 where id = new.fire_equipment_id;
            else
               update f_fire_equipment set equip_status = 0 where id = new.fire_equipment_id;
            end if;
          END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_fmea_equipment_point_update`;
DELIMITER ;;
CREATE TRIGGER `trigger_fmea_equipment_point_update` AFTER UPDATE ON `f_fmea_equipment_point` FOR EACH ROW BEGIN
			DECLARE riskSourceId BIGINT (20);
			DECLARE num1 int (20);
			DECLARE num2 int (20);
			SELECT fm.risk_source_id INTO riskSourceId FROM f_fmea fm WHERE fm.id = (select fmea_id from f_fmea_equipment_point fep where fep.id = new.id);
			IF new.state = '1' then
				UPDATE f_risk_source rs  set rs.status = 'ANOMALY' where rs.id = riskSourceId;
			ELSEIF new.state = '0' then
				SELECT count(fep.id) INTO num1 FROM f_fmea_equipment_point fep
				LEFT JOIN f_fmea ff ON ff.id = fep.fmea_id
				WHERE fep.state = '1' AND ff.risk_source_id = riskSourceId;

				SELECT count(fpi.id) INTO num2 FROM f_fmea_point_inputitem fpi
				LEFT JOIN f_fmea ff ON ff.id = fpi.fmea_id
				WHERE state = '1' AND ff.risk_source_id = riskSourceId;
				update f_risk_source  rs set rs.`status` = (case when (num1+num2) >0 then 'ANOMALY' else 'NORMAL' END)  where rs.id = riskSourceId;
			END IF;
			END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_fmea_point_inputitem_update`;
DELIMITER ;;
CREATE TRIGGER `trigger_fmea_point_inputitem_update` AFTER UPDATE ON `f_fmea_point_inputitem` FOR EACH ROW BEGIN
			DECLARE riskSourceId BIGINT (20);
			DECLARE num1 int (20);
			DECLARE num2 int (20);

			SELECT fm.risk_source_id INTO riskSourceId FROM f_fmea fm WHERE fm.id = (select fmea_id from f_fmea_point_inputitem fpi where fpi.id = new.id);
				IF new.state = '1' then
				UPDATE f_risk_source rs set rs.status = 'ANOMALY' where rs.id= riskSourceId;
			ELSE
				SELECT count(fep.id) INTO num1 FROM f_fmea_equipment_point fep
				LEFT JOIN f_fmea ff ON ff.id = fep.fmea_id
				WHERE fep.state = '1' AND ff.risk_source_id = riskSourceId;

				SELECT count(fpi.id) INTO num2 FROM f_fmea_point_inputitem fpi
				LEFT JOIN f_fmea ff ON ff.id = fpi.fmea_id
				WHERE state = '1' AND ff.risk_source_id = riskSourceId;
			update f_risk_source  rs set rs.`status` = (case when (num1+num2)>0 then 'ANOMALY' else 'NORMAL' END)  where rs.id = riskSourceId;
			END IF;
		END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_check_insert`;
DELIMITER ;;
CREATE TRIGGER `trigger_check_insert` AFTER INSERT ON `p_check` FOR EACH ROW BEGIN
			UPDATE p_plan_task_detail SET status =  NEW.is_ok WHERE id = NEW.plan_task_detail_id;
			UPDATE p_point SET `status` = NEW.is_ok,error = NEW.error,check_time = NEW.check_time WHERE id = NEW.point_id;
			END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_check_update`;
DELIMITER ;;
CREATE TRIGGER `trigger_check_update` AFTER UPDATE ON `p_check` FOR EACH ROW BEGIN
			UPDATE p_plan_task_detail SET status =  NEW.is_ok WHERE id = NEW.plan_task_detail_id;
			UPDATE p_point SET `status` = NEW.is_ok,error = NEW.error,check_time = NEW.check_time WHERE id = NEW.point_id;
			END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_plan_task_detail_insert`;
DELIMITER ;;
CREATE TRIGGER `trigger_plan_task_detail_insert` AFTER INSERT ON `p_plan_task_detail` FOR EACH ROW BEGIN
			DECLARE pointId bigint(20);
			DECLARE pointStatus varchar (50);
			SET  pointId = NEW.point_id;
			SELECT status into pointStatus FROM p_point WHERE id = pointId;
			IF pointStatus = '0' THEN
			UPDATE p_point SET status = '1' WHERE id = pointId;
			END IF;
			END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `addPointConfig`;
DELIMITER ;;
CREATE TRIGGER `addPointConfig` AFTER INSERT ON `p_point` FOR EACH ROW BEGIN
			INSERT INTO p_point_config(`name`, point_id, point_code, infomation_address, `status`, update_date)
			VALUES(CONCAT(new.name,'漏检'), new.id, CONCAT('N',LPAD(new.id, 10, 0)), 0, 0, SYSDATE());
			INSERT INTO p_point_config(`name`, point_id, point_code, infomation_address, `status`, update_date)
			VALUES(CONCAT(new.name,'合格'), new.id, CONCAT('S',LPAD(new.id, 10, 0)) ,0, 0, SYSDATE());
			END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `updatePointConfig`;
DELIMITER ;;
CREATE TRIGGER `updatePointConfig` AFTER UPDATE ON `p_point` FOR EACH ROW BEGIN
            IF (new.name != old.name)
			THEN
			 UPDATE p_point_config pc SET pc.`name` = CONCAT(new.name,'合格') WHERE pc.name LIKE '%合格' AND pc.point_id = new.id;
			 UPDATE p_point_config pc SET pc.`name` = CONCAT(new.name,'漏检')  WHERE pc.name LIKE '%漏检' AND pc.point_id = new.id;
			END IF;
			END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `deletePointConfig`;
DELIMITER ;;
CREATE TRIGGER `deletePointConfig` AFTER DELETE ON `p_point` FOR EACH ROW BEGIN
			update p_point_config set is_delete = 1 where point_id = old.id;
			END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_p_point_classify_delete`;
DELIMITER ;;
CREATE TRIGGER `trigger_p_point_classify_delete` AFTER DELETE ON `p_point_classify` FOR EACH ROW BEGIN
			update p_route_point_item rpi set rpi.point_classify_id = null where rpi.point_classify_id = old.id;
			update p_point_inputitem pi set pi.classify_ids = substring(replace(concat(',',pi.classify_ids,','),concat(',',old.id,','),','),2,LENGTH(replace(concat(',',pi.classify_ids,','),concat(',',old.id,','),''))-1)  where FIND_IN_SET(old.id, pi.classify_ids);
			END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_route_point_insert_update_point_route_info`;
DELIMITER ;;
CREATE TRIGGER `trigger_route_point_insert_update_point_route_info` AFTER INSERT ON `p_route_point` FOR EACH ROW BEGIN

			DECLARE pointId BIGINT (20);


			DECLARE routeId VARCHAR (1000);


			DECLARE routeName VARCHAR (1000);


			SET pointId = NEW.point_id;

			SELECT
			GROUP_CONCAT(id),
			GROUP_CONCAT(NAME) INTO routeId,
			routeName
			FROM
			(
			SELECT
			pr.id,
			pr. NAME
			FROM
			p_route_point prp
			LEFT JOIN p_route pr ON pr.id = prp.route_id
			WHERE
			prp.point_id = pointId
			GROUP BY
			pr.id
			) t;

			UPDATE p_point
			SET route_id = routeId,
			route_name = routeName
			WHERE
			id = pointId;


			END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_route_point_update_update_point_route_info`;
DELIMITER ;;
CREATE TRIGGER `trigger_route_point_update_update_point_route_info` AFTER UPDATE ON `p_route_point` FOR EACH ROW BEGIN

			DECLARE pointId BIGINT (20);


			DECLARE routeId VARCHAR (1000);


			DECLARE routeName VARCHAR (1000);


			SET pointId = OLD.point_id;

			SELECT
			GROUP_CONCAT(id),
			GROUP_CONCAT(NAME) INTO routeId,
			routeName
			FROM
			(
			SELECT
			pr.id,
			pr. NAME
			FROM
			p_route_point prp
			LEFT JOIN p_route pr ON pr.id = prp.route_id
			WHERE
			prp.point_id = pointId
			GROUP BY
			pr.id
			) t;

			UPDATE p_point
			SET route_id = routeId,
			route_name = routeName
			WHERE
			id = pointId;


			END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_route_point_delete_update_point_route_info`;
DELIMITER ;;
CREATE TRIGGER `trigger_route_point_delete_update_point_route_info` AFTER DELETE ON `p_route_point` FOR EACH ROW BEGIN

			DECLARE pointId BIGINT (20);


			DECLARE routeId VARCHAR (1000);


			DECLARE routeName VARCHAR (1000);


			SET pointId = OLD.point_id;

			SELECT
			GROUP_CONCAT(id),
			GROUP_CONCAT(NAME) INTO routeId,
			routeName
			FROM
			(
			SELECT
			pr.id,
			pr. NAME
			FROM
			p_route_point prp
			LEFT JOIN p_route pr ON pr.id = prp.route_id
			WHERE
			prp.point_id = pointId
			GROUP BY
			pr.id
			) t;

			UPDATE p_point
			SET route_id = routeId,
			route_name = routeName
			WHERE
			id = pointId;


			END
;;
DELIMITER ;
SET FOREIGN_KEY_CHECKS=1;