package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 设计信息
 *
 * @author system_generator
 * @date 2023-07-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="DesignInformationDto", description="设计信息")
public class DesignInformationDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "典型设计图信息")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> typicalDiagram;
    /**
     * 典型设计图信息
     */
    @ApiModelProperty(value = "典型设计图信息")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> engineering;


    @ApiModelProperty(value = "组件排布图")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> componentLayout;

    @ApiModelProperty(value = "组件支架图")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> componentBracket;

    @ApiModelProperty(value = "组串接线图")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> connectionLine;

    @ApiModelProperty(value = "一次接线图")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> onceLine;

    @ApiModelProperty(value = "组件")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> assembly;

    @ApiModelProperty(value = "逆变器")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> inverter;

    @ApiModelProperty(value = "电表箱")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> electricityMeter;

    @ApiModelProperty(value = "电缆")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> cable;

    @ApiModelProperty(value = "支架")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> support;

    @ApiModelProperty(value = " 防滑雪措施")
    private String antiSkiing;

    @ApiModelProperty(value = " 防滑雪措施备注")
    private String antiSkiingNotes;

    @ApiModelProperty(value = " 抽检")
    private String spotCheck;

    @ApiModelProperty(value = " 抽检意见")
    private String spotCheckOpinion;

    @ApiModelProperty(value = "是否定制")
    private String isokCustomized;

    @ApiModelProperty(value = "是否加固")
    private String windResistant;

    @ApiModelProperty(value = "试点方案")
    private String pilotProgram;

    @ApiModelProperty(value = " s试点物料")
    private String pilotMaterials;

    @ApiModelProperty(value = "方位角")
    private String azimuth;

    @ApiModelProperty(value = "倾角")
    private String dipAngle;

    @ApiModelProperty(value = " 应用场景")
    private String applicationScenario;

    @ApiModelProperty(value = "应用场景数量")
    private Integer applicationScenarioNum;

    @ApiModelProperty(value = "支架方案")
    private String supportScheme;

    @ApiModelProperty(value = "支架方案数量")
    private Integer supportSchemeNum;

    @ApiModelProperty(value = "特殊方案")
    private String specialPlan;

    @ApiModelProperty(value = "特殊方案数量")
    private Integer specialPlanNum;

    @ApiModelProperty(value = "农户id")
    private String peasantHouseholdId;

}
