package com.yeejoin.amos.boot.module.hygf.api.tdenginemapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.hygf.api.dto.TdHygfJpInverterWarnDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpStation;
import com.yeejoin.amos.boot.module.hygf.api.entity.TdHygfJpInverterWarn;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 户用光伏监盘逆变器报警表 Mapper 接口
 *
 * @author system_generator
 * @date 2023-09-19
 */
public interface TdHygfJpInverterWarnMapper extends BaseMapper<TdHygfJpInverterWarn> {

    List<Map<String, Object>> getCountTdHygfJpInverterWarn(@Param("dto") List<JpStation> dto);


    List<TdHygfJpInverterWarnDto> list(@Param("param") TdHygfJpInverterWarnDto tdHygfJpInverterWarnDto);

    @Select(" SELECT  *   from house_pv_data. td_hygf_jp_inverter_warn limit 0,10")
    List<TdHygfJpInverterWarnDto> listAll();

    TdHygfJpInverterWarnDto getByTime(@Param("createdTime") long createdTime);

    List<TdHygfJpInverterWarnDto> selectWarnList(String state, String level, String minvalue, String maxValue, String snCode, List<String> stationId, String startTime, String endTime, String content, Integer current, Integer size,String handlerStatus);

    int selectWarnListTotal(String state, String level, String minvalue, String maxValue, String snCode, List<String> stationId, String startTime, String endTime, String content,String handlerStatus);

    @Select("SELECT  *  from td_hygf_jp_inverter_warn  WHERE (third_station_id = #{thirdStationId} AND sn_code = #{sncode} AND created_time = #{createdTime})")
    TdHygfJpInverterWarn getInverTerWarnByparams(@Param("createdTime") long createdTime, @Param("sncode") String snCode, @Param("thirdStationId") String thirdStationId);
}
