package com.yeejoin.precontrol.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 检查项Dto
 *
 * @author duanwei
 * @date 2020-08-24
 */
@Data
@ApiModel(value = "InputItem对象", description = "检查项")
public class InputItemDto  extends BaseDto {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "作业类型")
    private String itemType;

    @ApiModelProperty(value = "检查项名称")
    private String name;

    @ApiModelProperty(value = "是否必填")
    private String isMust;

    @ApiModelProperty(value = "是否有分数")
    private String isScore;

    @ApiModelProperty(value = "是否允许多行")
    private String isMultiline;

    @ApiModelProperty(value = "默认值")
    private String defaultValue;

    @ApiModelProperty(value = "选项数据")
    private String inputJson;

    @ApiModelProperty(value = "图片数据")
    private String pictureJson;

    @ApiModelProperty(value = "描述")
    private String remark;

    @ApiModelProperty(value = "key-前台删除使用,勿传递")
    private Long key;


    private Date createDate;
}
