package com.yeejoin.precontrol.common.entity.publics;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

/**
 * <pre>
 * 分页实体
 * </pre>
 */
public class CommonPageable implements Pageable {
    /**
     * 页号（大于等于0）
     */
    protected int pageNumber = 0;
    /**
     * 每页大小（大于等于0）
     */
    protected int pageSize = 10;
    /**
     * 起始索引
     */
    protected int offset = 0;
    /**
     * 排序
     */
    protected Sort sort = null;

    public CommonPageable() {
        this.pageNumber = 0;
        this.pageSize = 10;
        this.offset = pageSize * pageNumber;
    }

    public CommonPageable(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.offset = pageSize * pageNumber;
    }

    public CommonPageable(int pageNumber, int pageSize, Sort sort) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.sort = sort;
        this.offset = pageSize * pageNumber;
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    @Override
    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public long getOffset() {
        offset = pageSize * pageNumber;
        return offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public Sort getSort() {
        return sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    @Override
    public Pageable next() {
        return null;
    }

    @Override
    public Pageable previousOrFirst() {
        return null;
    }

    @Override
    public Pageable first() {
        return null;
    }

    @Override
    public boolean hasPrevious() {
        return false;
    }
}
