package com.yeejoin.precontrol.common.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.Retribution;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.precontrol.common.vo.RetributionVo;
import com.yeejoin.precontrol.common.vo.RewardListVo;
import com.yeejoin.precontrol.common.vo.RewardOrgCodeVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 惩罚表 Mapper 接口
 *
 * @author duanwei
 * @date 2021-04-06
 */
public interface RetributionMapper extends BaseMapper<Retribution> {

	List<RetributionVo> pageInfo(@Param("retribution") RetributionVo retributionVo, Page<RetributionVo> page);

	List<RetributionVo> pageCompanyInfo(@Param("retribution") RetributionVo retributionVo, Page<RetributionVo> page);

	IPage<RewardListVo> rewardUserListDetail(Page<RewardListVo> page, @Param("rewardOrgCodeVo") RewardListVo rewardVo);

	String selectAllMoneyTotal();

	String selectDayMoneyTotal();

	IPage<RewardOrgCodeVo> listPageComcany(Page<RewardOrgCodeVo> rewardOrgCodeVoPage,
			@Param("companyName") String companyName, @Param("orgCode") String orgCode,
			@Param("orderType") String orderType);

	IPage<RewardOrgCodeVo> listBadPageCompany(Page<RewardOrgCodeVo> rewardOrgCodeVoPage,
			@Param("rewardOrgCodeVo") RewardOrgCodeVo rewardOrgCodeVo, @Param("orgCode") String orgCode,
			@Param("orderType") String orderType);

    Integer dayCountByOrgCode(@Param("orgCode") String orgCode,@Param("projectId") Long projectId);

	Integer dayCompanyCountByOrgCode(@Param("orgCode")  String orgCode,@Param("projectId") Long projectId);
}
