package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.TaskRiskControlTechDto;
import com.yeejoin.precontrol.common.entity.TaskRiskControlTech;
import com.yeejoin.precontrol.common.vo.TaskRiskControlTechVo;
import com.yeejoin.precontrol.common.vo.TaskRiskControlVo;

/**
 * 风险管控任务表 服务类
 *
 * @author duanwei
 * @date 2021-11-01
 */
public interface ITaskRiskControlTechService extends IService<TaskRiskControlTech> {

	TaskRiskControlTechVo createTask(TaskRiskControlTechVo taskRiskControlTechVo);

	TaskRiskControlTechVo createTaskByFbs(TaskRiskControlTechVo taskRiskControlTechVo);

	TaskRiskControlTechVo create(TaskRiskControlTechVo taskRiskControlTechVo);

	TaskRiskControlTechVo nextStage(TaskRiskControlTechVo taskRiskControlTechVo);

	TaskRiskControlTechVo getDetailById(Long id, Long personId, Long taskPersonId);

	/**
	 * 根据当前人员id查询当前所关联计划
	 *
	 * @param page
	 * @param personId
	 * @param taskRiskControlDto
	 * @return
	 */
	Page<TaskRiskControlTechVo> myListByPage(CommonPageableDto page, Long personId,
			TaskRiskControlTechDto taskRiskControlTechDto);

	TaskRiskControlTechVo doDocument(TaskRiskControlTechVo taskRiskControlTechVo);
	
	TaskRiskControlTechVo doDocumentAttach( Long taskPersonKnowledgeId);

	TaskRiskControlTechVo confirm(TaskRiskControlTechVo taskRiskControlTechVo);

	Page<TaskRiskControlTechVo> constructList(CommonPageableDto page, TaskRiskControlTechDto taskRiskControlTechDto);

}
