package com.yeejoin.precontrol.common.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 奖励惩罚配置表Vo
 *
 * @author duanwei
 * @date 2021-04-06
 */
@Data
public class RewardConfigVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "项目id")
    /**
     * 项目id
     */
    private Long projectId;
    @ApiModelProperty(value = "违规类型，关联字典表code")
    /**
     * 违规类型，关联字典表code
     */
    private String code;
    @ApiModelProperty(value = "惩罚金额")
    /**
     * 惩罚金额
     */
    private BigDecimal retributionMoney;
    @ApiModelProperty(value = "奖励金额")
    /**
     * 奖励金额
     */
    private BigDecimal rewardMoney;
    @ApiModelProperty(value = "更新时间")
    /**
     * 更新时间
     */
    private Date updateDate;


}
