package com.yeejoin.precontrol.controller;

import com.yeejoin.precontrol.common.entity.Districts;
import com.yeejoin.precontrol.common.service.IDistrictsService;
import com.yeejoin.precontrol.common.utils.RedisUtil;
import com.yeejoin.precontrol.common.vo.DistrictVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * 地区
 *
 * @author duanwei
 * @date 2020-07-06
 */
@RestController
@ApiIgnore
@Api(tags = "地区Api")
@RequestMapping(value = "/districts", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class DistrictsController {
    /**
     * 省市区服务
     */
    @Autowired
    IDistrictsService iDistrictsService;
    /**
     * 缓存服务
     */
    @Autowired
    RedisUtil redisUtil;

    /**
     * 新增地区
     *
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增地区", notes = "新增地区")
    public Object saveDistricts(HttpServletRequest request, @RequestBody Districts districts) {
        return iDistrictsService.save(districts);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
        return iDistrictsService.removeById(id);
    }

    /**
     * 根据ids删除
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/ids/{ids}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据ids删除", notes = "根据ids删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable List<String> ids) {
        return iDistrictsService.removeByIds(ids);
    }

    /**
     * 修改地区
     *
     * @return
     */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改地区", notes = "修改地区")
    public boolean updateByIdDistricts(HttpServletRequest request, @RequestBody Districts districts) {
        return iDistrictsService.updateById(districts);
    }

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public Districts selectById(HttpServletRequest request, @PathVariable Long id) {
        return iDistrictsService.getById(id);
    }

    /**
     * 列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/tree", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表tree查询", notes = "列表tree查询")
    public Object tree() {
        if (redisUtil.hasKey("city")) {
            return redisUtil.get("city");
        }
        List<Districts> list = iDistrictsService.list();
        List<DistrictVo> districtVos = new ArrayList<>();
        list.forEach(d -> {
            DistrictVo districtVo = new DistrictVo();
            districtVo.setLabel(d.getExtName());
            districtVo.setValue(String.valueOf(d.getId()));
            districtVo.setId(d.getId());
            districtVo.setPid(d.getPid());
            districtVos.add(districtVo);
        });
        List<DistrictVo> menuTreeList = getMenuTreeList(0L, districtVos);
        redisUtil.set("city", menuTreeList, 3600);
        return menuTreeList;
    }

    /**
     * 递归循环
     *
     * @param pid
     * @param list
     * @return
     */
    private List<DistrictVo> getMenuTreeList(Long pid, List<DistrictVo> list) {
        List<DistrictVo> childrenList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            DistrictVo districtVo = list.get(i);
            if (districtVo.getPid().equals(pid)) {
                districtVo.setChildren(getMenuTreeList(districtVo.getId(), list));
                childrenList.add(districtVo);
            }
        }
        return childrenList;
    }
}
