package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.UnitPersonServiceImpl;
import io.swagger.annotations.Api;

import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;


@RestController
@Api(tags = "企业信息表")
@RequestMapping(value = "/UnitPerson")
public class UnitPersonController  extends BaseController {

    @Autowired
    UnitPersonServiceImpl unitPersonServiceimpl;

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/unitInformation")
    @ApiOperation(httpMethod = "GET",value="获取管辖单位",notes = "获取管辖单位")
    public ResponseModel<String> selectUnit(){

        return ResponseHelper.buildResponse(unitPersonServiceimpl.selectUnit());
    }

}
