package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.ugp.api.dto.InstallNoticeDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.InstallNoticeMsgPageDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.InstallNotice;
import com.yeejoin.amos.boot.module.ugp.api.entity.InstallNoticeMsg;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.mapper.InstallNoticeMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.InstallNoticeMsgMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IInstallNoticeMsgService;
import com.yeejoin.amos.boot.module.ugp.api.dto.InstallNoticeMsgDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.*;

/**
 * 项目安装告知短信记录表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class InstallNoticeMsgServiceImpl extends BaseService<InstallNoticeMsgDto,InstallNoticeMsg,InstallNoticeMsgMapper> implements IInstallNoticeMsgService {

    @Autowired
    InstallNoticeMsgMapper installNoticeMsgMapper;
    @Autowired
    ProjectResourceServiceImpl projectResourceService;
    @Autowired
    InstallNoticeMapper installNoticeMapper;
    @Autowired
    OrgServiceImpl orgService;
    @Autowired
    InstallNoticeServiceImpl installNoticeService;
    /**
     * 分页查询
     */
    public Page<InstallNoticeMsgDto> queryForInstallNoticeMsgPage(Page<InstallNoticeMsgDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<InstallNoticeMsgDto> queryForInstallNoticeMsgList()   {
        return this.queryForList("" , false);
    }

    /**
     * 项目安装告知短信通知记录分页查询
     */
    @Override
    public Page<InstallNoticeMsgPageDto> installNoticeMsgList(Page<InstallNoticeMsgPageDto> page, String name, String installationUnit) {
        List<Project> projectList = projectResourceService.getProjectList();
        List<InstallNotice> installNoticeList = new ArrayList<>();
        List<InstallNoticeMsgPageDto> pageDtoList = new ArrayList<>();
        for (Project project : projectList) {
            LambdaQueryWrapper<InstallNotice> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(InstallNotice::getProjectId, project.getSequenceNbr());
            List<InstallNotice> installNotice = installNoticeService.list(wrapper);
            installNoticeList.addAll(installNotice);
        }
        Set<String> seqs = new HashSet<>();
        for (InstallNotice installNotice : installNoticeList) {
            String seq = String.valueOf(installNotice.getSequenceNbr());
            seqs.add(seq);
        }
        Page<InstallNoticeMsgPageDto> installNoticeMsgPageDtoPage = installNoticeMsgMapper.InstallNoticeMsgPage(page, name, installationUnit, seqs);

        for (InstallNoticeMsgPageDto i : installNoticeMsgPageDtoPage.getRecords()) {
            OrgUsr orgUsrById = orgService.getOrgId(String.valueOf(i.getTargetUnitId()));
            //回显
            i.setTargetUnitIdName(String.valueOf(orgUsrById.getBizOrgName()));
            //接收人
            OrgUsr orgUsrById1 = orgService.getOrgUsrById(String.valueOf(i.getTargetPersonId()));
            i.setTargetPersonIdName(String.valueOf(orgUsrById1.getBizOrgName()));

            pageDtoList.add(i);

        }
        installNoticeMsgPageDtoPage.setRecords(pageDtoList);
        return installNoticeMsgPageDtoPage;
    }

    @Override
    public Page<InstallNoticeMsgPageDto> selectByName(Page<InstallNoticeMsgPageDto> page, String name, String unit) {
        return this.getBaseMapper().selectByName(page, name, unit);
    }

    @Override
    public InstallNoticeMsgPageDto customSelectById(Long sequenceNbr) {
        return this.getBaseMapper().customSelectById(sequenceNbr);
    }
}