package com.yeejoin.amos.boot.module.common.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @description:
 * @author: tw
 * @createDate: 2021/7/14
 * 指挥资源，请求坐标类
 */
@Data
@ApiModel(value = "RequestData", description = "指挥资源，请求坐标类")
public class RequestData {
    @ApiModelProperty(value = "经度")
    private Double longitude;

    @ApiModelProperty(value = "纬度")
    private Double latitude;

    @ApiModelProperty(value = "距离")
    private Double distance;

    @ApiModelProperty(value = "水源资源类型（hydrant:消火栓、crane:消防水鹤、natural:天然水源、pool:消防水池）")
    private String resourceType;

    @ApiModelProperty(value = "队伍类型code")
    private String typeCode;

    @ApiModelProperty(value = "是否只显示24小时内警情")
    private  Boolean whether24=false;

    @ApiModelProperty(value = "灾情地址模糊匹配")
    private String address;

    @ApiModelProperty(value = "灾情状态")
    private int status =0;
}
