package com.yeejoin.amos.maintenance.common.enums;

public enum LatentDangerTypeEnum {

    无码检查("无码检查", 1),
    计划检查("计划检查", 2),
    无计划检查("无计划检查", 3),
    随手拍("随手拍", 4);

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    LatentDangerTypeEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static String getEnumName(Integer code) {
        String name = "";
        for(LatentDangerTypeEnum type: LatentDangerTypeEnum.values()) {
            if (type.getCode()==code) {
                name = type.getName();
                break;
            }
        }
        return name;
    }

    public static LatentDangerTypeEnum getByCode(Integer code) {
        for (LatentDangerTypeEnum l : LatentDangerTypeEnum.values()) {
            if (code.equals(l.getCode())) {
                return l;
            }
        }
        return null;
    }
}
