package com.yeejoin.amos.maintenance.common.enums;

public enum RiskFactorWorkFlowActionTypeEnum {

    通过("通过", 1),
    拒绝("拒绝", 2),
    终止流程("终止流程", 3),
    唤起流程("唤起流程", 4),
    重启流程("重启流程", 5);

    private String desc;

    private Integer actionType;

    RiskFactorWorkFlowActionTypeEnum(String desc, Integer actionType) {
        this.desc = desc;
        this.actionType = actionType;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getActionType() {
        return actionType;
    }

    public void setActionType(Integer actionType) {
        this.actionType = actionType;
    }

    public static RiskFactorWorkFlowActionTypeEnum getByActionType(Integer actionType) {
        for (RiskFactorWorkFlowActionTypeEnum e : RiskFactorWorkFlowActionTypeEnum.values()) {
            if (actionType.equals(e.actionType)) {
                return e;
            }
        }
        return null;
    }
}