package com.yeejoin.amos.api.householdapi.face.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpStation;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpStationMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class JpStationServiceImpl {
    @Autowired
    JpStationMapper jpStationMapper;
    @Scheduled(cron = "${dataRequstScheduled.initStation:0 0 0 * * ?}")
    @Async
    public void initStationValue(){

       LambdaUpdateWrapper<JpStation> wrapper = new LambdaUpdateWrapper<>();
       wrapper.set(JpStation::getCapacity,0.0)
               .set(JpStation::getRealTimePower,0.0)
               .set(JpStation::getAccumulatedPower,0.0)
               .set(JpStation::getDayGenerate,0.0)
               .set(JpStation::getMonthGenerate,0.0)
               .set(JpStation::getYearGenerate,0.0)
               .set(JpStation::getDayIncome,0.0)
               .set(JpStation::getMonthIncome,0.0)
               .set(JpStation::getYearIncome,0.0)
               .set(JpStation::getCumulativeIncome,0.0)
               .set(JpStation::getDayPowerUse,0.0)
               .set(JpStation::getMonthPowerUse,0.0)
               .set(JpStation::getYearPowerUse,0.0)
               .set(JpStation::getRatedPower,0.0);
        jpStationMapper.update(null,wrapper);
    }
}
