package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireRpnChangeLogServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * 风险点变化流水
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "风险点变化流水Api")
@RequestMapping(value = "/fire-rpn-change-log")
public class FireRpnChangeLogController extends BaseController {

    @Autowired
    FireRpnChangeLogServiceImpl fireRpnChangeLogServiceImpl;


    /**
     * 风险点(PRN)上升百分比
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "风险点(PRN)上升百分比", notes = "风险点(PRN)上升百分比")
    @GetMapping(value = "/{stationCode}/riseUp")
    public ResponseModel riseUp(@PathVariable String stationCode) {
        return ResponseHelper.buildResponse(fireRpnChangeLogServiceImpl.queryForRiseUp(stationCode));
    }
}
