package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.yeejoin.amos.boot.module.hygf.api.entity.HygfBusinessField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
@ApiModel(value = "StationFieldDto", description = "电站字段Dto")
public class StationFieldDto {
    @ApiModelProperty(value = "电站ID",example = "[1851456410051678210]")
    private List<String> stationIdList;
    @ApiModelProperty(value = "业务字段主键",example = "[\"4\", \"3\"]")
    private List<String> businessIdList;
    @ApiModelProperty(value = "业务字段")
    private List<HygfBusinessField> businessFieldList;
    @ApiModelProperty(value = "导出页面Code",example = "2")
    private String exportPageCode;
    @ApiModelProperty(value = "过滤条件",example = "{\n" +
            "  \"powerStationCode\": \"2\",\n" +
            "  \"ownersName\": \"cz\",\n" +
            "  \"serviceAgent\": \"XXXg公司\",\n" +
            "  \"province\": 610000,\n" +
            "  \"regionalCompaniesName\": \"XXXg公司\",\n" +
            "  \"projectAddress\": \"xx市\",\n" +
            "  \"status\": \"未签署\",\n" +
            "  \"startTime\": null,\n" +
            "  \"endTime\": \"2024-11-28 17:59:38\"\n" +
            "}")
    private Map<String, Object> filters;
}
