package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.Date;

/**
 * 人员消息
 *
 * @author system_generator
 * @date 2023-09-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_user_message")
@ApiModel(value = "UserMessage",description = "人员消息")
public class UserMessage extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 任务类型
     */
    @ApiModelProperty(value = "任务类型",example = "经销商审核")
	@TableField("type")
    private String type;

    /**
     * 业务id
     */
    @ApiModelProperty(value = "业务id",example = "1706869110685569025")
	@TableField("business_id")
    private Long businessId;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id",example = "5214012")
	@TableField("amos_user_id")
    private String amosUserId;

    /**
     *  消息创建时间
     */
    @ApiModelProperty(value = " 消息创建时间",example = "2023-09-27 11:11:23")
	@TableField("creation_time")
    private Date creationTime;

    /**
     * 消息内容
     */
    @ApiModelProperty(value = "消息内容",example = "经销商四川锦绣天地建筑工程有限公司南昌分公司待经销商审核待完成")
	@TableField("task_name")
    private String taskName;

    /**
     * 经销商orgCode
     */
    @ApiModelProperty(value = "经销商orgCode",example = "86*355*443*479")
	@TableField("amos_org_code")
    private String amosOrgCode;


    public UserMessage(String type, Long businessId, String amosUserId, Date creationTime, String taskName, String amosOrgCode) {
        addOperator();
        this.type = type;
        this.businessId = businessId;
        this.amosUserId = amosUserId;
        this.creationTime = creationTime;
        this.taskName = taskName;
        this.amosOrgCode = amosOrgCode;
    }

    private void addOperator() {
        try {
            this.recDate = new Date();
            this.recUserId = RequestContext.getExeUserId();
            this.recUserName = RequestContext.getLoginId();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UserMessage() {
    }
}
