package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizFanPointVarCorrelationDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanPointVarCorrelation;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.IdxBizFanPointVarCorrelationServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 
 *
 * @author system_generator
 * @date 2023-08-15
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/idx-biz-fan-point-var-correlation")
public class IdxBizFanPointVarCorrelationController extends BaseController {

    @Autowired
    IdxBizFanPointVarCorrelationServiceImpl idxBizFanPointVarCorrelationServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<IdxBizFanPointVarCorrelationDto> save(@RequestBody IdxBizFanPointVarCorrelationDto model) {
	    model = idxBizFanPointVarCorrelationServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<IdxBizFanPointVarCorrelationDto> updateBySequenceNbrIdxBizFanPointVarCorrelation(@RequestBody IdxBizFanPointVarCorrelationDto model,@PathVariable(value = "sequenceNbr") String sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(idxBizFanPointVarCorrelationServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(idxBizFanPointVarCorrelationServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<IdxBizFanPointVarCorrelationDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(idxBizFanPointVarCorrelationServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<IdxBizFanPointVarCorrelationDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<IdxBizFanPointVarCorrelationDto> page = new Page<IdxBizFanPointVarCorrelationDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(idxBizFanPointVarCorrelationServiceImpl.queryForIdxBizFanPointVarCorrelationPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<IdxBizFanPointVarCorrelationDto>> selectForList() {
	    return ResponseHelper.buildResponse(idxBizFanPointVarCorrelationServiceImpl.queryForIdxBizFanPointVarCorrelationList());
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "查询当前点位所选择的工况变量",   notes = "查询当前点位所选择的工况变量")
	@GetMapping(value = "/getCurrentChoosePoint")
	public ResponseModel<Map<String,Object>> getCurrentChoosePoint(String gatewayId,String analysePointId) {

		return ResponseHelper.buildResponse(idxBizFanPointVarCorrelationServiceImpl.getCurrentChoosePoint(gatewayId,analysePointId));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "查询当前点位所选择的工况变量",   notes = "查询当前点位所选择的工况变量")
	@PostMapping(value = "/updatePointChoose")
	public ResponseModel updatePointChoose(@RequestBody IdxBizFanPointVarCorrelationDto dto) {


		idxBizFanPointVarCorrelationServiceImpl.updatePointChoose(dto.getAnalysisGatewayId(),dto.getAnalysisPointId(),dto.getProcessPointIds());
		return CommonResponseUtil.success();
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "查询当前点位的工况变量",   notes = "查询当前点位的工况变量")
	@GetMapping(value = "/getPointProcess")
	public ResponseModel<Map<String,Object>> getPointProcess(String gatewayId, String analysePointId) {
		return ResponseHelper.buildResponse(idxBizFanPointVarCorrelationServiceImpl.getPointProcess(gatewayId,analysePointId));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "查询当前点位的工况变量详情",   notes = "查询当前点位的工况变量详情")
	@GetMapping(value = "/getDetailBySequenceNbr")
	public ResponseModel<List<IdxBizFanPointVarCorrelation>> getDetailBySequenceNbr(@RequestParam("sequenceNbr")String sequenceNbr ) {
		return ResponseHelper.buildResponse(idxBizFanPointVarCorrelationServiceImpl.getDetailBySequenceNbr(sequenceNbr));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "查询当前点位所选择的工况变量",   notes = "查询当前点位所选择的工况变量")
	@PostMapping(value = "/updatePointChooseBySequenceNbrList")
	public ResponseModel updatePointChooseBySequenceNbrList(@RequestBody IdxBizFanPointVarCorrelationDto dto) {
		idxBizFanPointVarCorrelationServiceImpl.updatePointChooseBySequenceNbrList(dto.getSequenceNbrList());
		return CommonResponseUtil.success();
	}

}
