package com.yeejoin.amos.boot.module.jxiop.api.Enum;


import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum KGName {
    DLQ("断路器","dlq"),
    DAZ("刀闸","daz"),
    DCK("低测控","dck"),
    GCK("高测控","gck"),
    CK("测控","ck"),
    MXDZ("母线PT刀闸","mxdc"),
    BTCK("本体测控","btck"),
    QGYX("前光Ⅰ线", "qgyx"),
    QGEX("前光Ⅱ线", "qgex"),
    YZYB("Ⅰ母PT", "yzyb");



    private String name;
    private String code;

    public static String getCode(String name) {

        for (KGName electricQuantity : KGName.values())
        {
            if (electricQuantity.getName().equals(name))
            {
                return electricQuantity.getCode();
            }
        }
        return null;
    }

}
