package com.yeejoin.amos.boot.module.jxiop.biz.jxdz.factory;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.MockPvDeviceDataMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.MockPvStationDataMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.MockWindDeviceDataMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.MockWindStationDataMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.Enum.JXDZAccessTypeEnum;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.Enum.JXDZCodeEnum;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.Enum.JXDZDataTypeEnum;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.entity.MockPvDeviceDataEntity;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.entity.MockPvStationDataEntity;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.entity.MockWindDeviceDataEntity;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.entity.MockWindStationDataEntity;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.utils.JXDZUtils;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import javax.annotation.PostConstruct;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component
@Slf4j
public class JXDZExecute {

    @Autowired
    JXDZUtils jxdzUtils;
    @Autowired
    JXDZFactory jxdzFactory;
    @Value("${jxdzScheduledEnable:false}")
    private Boolean jxdzScheduledEnable;
    @Autowired
    MockServiceImpl mockService;

    @Autowired
    MockWindStationDataMapper mockWindStationDataMapper;
    @Autowired
    MockPvStationDataMapper mockPvStationDataMapper;
    @Autowired
    MockPvDeviceDataMapper mockPvDeviceDataMapper;
    @Autowired
    MockWindDeviceDataMapper mockWindDeviceDataMapper;


    @Scheduled(cron = "0 0 */1 * * ?")
    @PostConstruct
    public void hourInterface() {
        if (!jxdzScheduledEnable) {
            return;
        }
        log.info("开始执行小时任务");
        //发送请求传入的参数
        NeedDataVO needDataVO = new NeedDataVO();
        needDataVO.setPlatformId(Long.valueOf(1360001));
        needDataVO.setDateTime(LocalDateTime.now().withMinute(0).withSecond(0).withNano(0).atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli());
        //构建数据
        IJXDZService fdzjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.FDZJC);
        IJXDZService gfdzjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.GFDZJC);
        IJXDZService fdzsbjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.FDZSBJC);
        IJXDZService gfdzsbjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.GFDZSBJC);

        LocalDateTime today = LocalDateTime.now();
        int day =today.getDayOfMonth();
        int hour=today.getHour();

        List<MockWindStationDataEntity> list1 =mockWindStationDataMapper.selectList(
                new LambdaQueryWrapper<MockWindStationDataEntity>()
                      //  .eq(MockWindStationDataEntity::getDay,day)
                        .eq(MockWindStationDataEntity::getHour,hour)
        );
        List<WindStationDataVO> windStationDataVOList = new ArrayList<>();
        for (MockWindStationDataEntity entity : list1)
        {
            WindStationDataVO vo = new WindStationDataVO();
            BeanUtils.copyProperties(entity,vo);
            windStationDataVOList.add(vo);
        }
        List<MockPvStationDataEntity> list2 =mockPvStationDataMapper.selectList(
                new LambdaQueryWrapper<MockPvStationDataEntity>()
                       // .eq(MockPvStationDataEntity::getDay,day)
                        .eq(MockPvStationDataEntity::getHour,hour)
        );
        List<PvStationDataVO> pvStationDataVOList = new ArrayList<>();
        for (MockPvStationDataEntity entity : list2)
        {
            PvStationDataVO vo = new PvStationDataVO();
            BeanUtils.copyProperties(entity,vo);
            pvStationDataVOList.add(vo);
        }
        List<MockWindDeviceDataEntity> list3 =mockWindDeviceDataMapper.selectList(
                new LambdaQueryWrapper<MockWindDeviceDataEntity>()
                      //  .eq(MockWindDeviceDataEntity::getDay,day)
                        .eq(MockWindDeviceDataEntity::getHour,hour)
        );
        List<WindDeviceDataVO> windDeviceDataVOList = new ArrayList<>();
        for (MockWindDeviceDataEntity entity : list3)
        {
            WindDeviceDataVO vo = new WindDeviceDataVO();
            BeanUtils.copyProperties(entity,vo);
            windDeviceDataVOList.add(vo);
        }
        List<MockPvDeviceDataEntity> list4 =mockPvDeviceDataMapper.selectList(
                new LambdaQueryWrapper<MockPvDeviceDataEntity>()
                      //  .eq(MockPvDeviceDataEntity::getDay,day)
                        .eq(MockPvDeviceDataEntity::getHour,hour)
        );
        List<PvDeviceDataVO> pvDeviceDataVOList = new ArrayList<>();
        for (MockPvDeviceDataEntity entity : list4)
        {
            PvDeviceDataVO vo = new PvDeviceDataVO();
            BeanUtils.copyProperties(entity,vo);
            pvDeviceDataVOList.add(vo);
        }

        //List<WindStationDataVO> windStationDataVOList =mockService.getFD();
        //List<PvStationDataVO> pvStationDataVOList = mockService.getGF();
        //List<WindDeviceDataVO> windDeviceDataVOList =mockService.getFDSB();
        //List<PvDeviceDataVO> pvDeviceDataVOList = mockService.getGFSB();
        //List<WindStationDataVO> windStationDataVOList = fdzjcService.buildData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO.getDateTime());
       // List<PvStationDataVO> pvStationDataVOList = gfdzjcService.buildData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO.getDateTime());
       // List<WindDeviceDataVO> windDeviceDataVOList = fdzsbjcService.buildData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO.getDateTime());
       // List<PvDeviceDataVO> pvDeviceDataVOList = gfdzsbjcService.buildData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO.getDateTime());
        //备份数据
        fdzjcService.backupData(windStationDataVOList, needDataVO.getDateTime());
        gfdzjcService.backupData(pvStationDataVOList, needDataVO.getDateTime());
        fdzsbjcService.backupData(windDeviceDataVOList, needDataVO.getDateTime());
        gfdzsbjcService.backupData(pvDeviceDataVOList, needDataVO.getDateTime());
        //发送请求
        fdzjcService.sendData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO, windStationDataVOList);
        gfdzjcService.sendData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO, pvStationDataVOList);
        fdzsbjcService.sendData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO, windDeviceDataVOList);
        gfdzsbjcService.sendData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO, pvDeviceDataVOList);
        log.info("小时任务执行成功");
    }

    @Scheduled(cron = "0 0 1 * * ?")
    @PostConstruct
    public void dayInterface() {
        if (!jxdzScheduledEnable) {
            return;
        }
        log.info("开始执行天任务");
        //发送请求传入的参数
        NeedDataVO needDataVO = new NeedDataVO();
        needDataVO.setPlatformId(Long.valueOf(1360001));
        needDataVO.setDateTime(LocalDateTime.now().withHour(0).withMinute(0).withSecond(0).withNano(0).atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli());
        //构建数据
        IJXDZService dzmtsjService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.DZMTSJ);
        List<StationDailyDataVO> stationDailyDataVOList = dzmtsjService.buildData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO.getDateTime());

        //备份数据
        dzmtsjService.backupData(stationDailyDataVOList, needDataVO.getDateTime());
        //发送请求
        dzmtsjService.sendData(JXDZAccessTypeEnum.CAIJI.getCode(), needDataVO, stationDailyDataVOList);
        //处理补录
        //listNeed();
        log.info("天任务执行成功");
    }


    /**
     * 处理需要补录的数据
     */
    private void listNeed() {
        log.info("处理补录数据中");
        JSONObject listNeedJson = jxdzUtils.sendJXDZGetRequest("/ngnsyncjiangxiyw/needreaccess/listNeed?platformId=1360001");
        if (HttpStatus.OK.value() == listNeedJson.getInteger("code")) {
            JSONArray data = listNeedJson.getJSONArray("data");
            if (CollectionUtil.isNotEmpty(data)) {
                log.info("需要补录的数据有{}条", data.size());
                for (Object o : data) {
                    if (o instanceof Map) {
                        Map needData = (Map) o;
                        dealListNeedData(new JSONObject(needData));
                    }
                }
            } else {
                log.info("没有补录的数据需要处理");
            }
        }
        log.info("补录数据处理完成");
    }

    private void dealListNeedData(JSONObject needData) {
        NeedDataVO needDataVO = JSONObject.parseObject(needData.toJSONString(), NeedDataVO.class);
        JXDZDataTypeEnum dataTypeEnum = JXDZDataTypeEnum.getEnumByCode(needDataVO.getDataType());
        IJXDZService fdzjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.FDZJC);
        IJXDZService gfdzjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.GFDZJC);
        IJXDZService fdzsbjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.FDZSBJC);
        IJXDZService gfdzsbjcService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.GFDZSBJC);
        IJXDZService gzmtsjService = jxdzFactory.getJXDZService(JXDZDataTypeEnum.DZMTSJ);
        switch (dataTypeEnum) {
            case FDZJC:
                fdzjcService.sendData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO, fdzjcService.buildData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO.getDateTime()));
                break;
            case GFDZJC:
                gfdzjcService.sendData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO, gfdzjcService.buildData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO.getDateTime()));
                break;
            case FDZSBJC:
                fdzsbjcService.sendData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO, fdzsbjcService.buildData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO.getDateTime()));
                break;
            case GFDZSBJC:
                gfdzsbjcService.sendData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO, gfdzsbjcService.buildData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO.getDateTime()));
                break;
            case DZMTSJ:
                gzmtsjService.sendData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO, gzmtsjService.buildData(JXDZAccessTypeEnum.BULU.getCode(), needDataVO.getDateTime()));
                break;
            default:
                throw new BadRequest("没有找到匹配的补录数据类型");
        }
    }
}
