package com.yeejoin.equipmanage.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.common.vo
 * @ClassName: FireFightingSystem3dVo
 * @Author: Jianqiang Gao
 * @Description: FireFightingSystem3dVo
 * @Date: 2021/5/28 10:02
 * @Version: 1.0
 */
@Data
@ApiModel(description = "三维消防系统vo")
public class FireFightingSystem3dVo {

    @ApiModelProperty(value = "系统ID")
    private Long id;

    @ApiModelProperty(value = "系统名称")
    private String name;

    @ApiModelProperty(value = "系统状态", notes = "异常：系统下设备物联指标无一异常状态，否则正常")
    private Integer status;

    @ApiModelProperty(value = "负责人电话")
    private String chargePersonPhone;

    @ApiModelProperty(value = "负责人姓名")
    private String chargePersonName;

    @ApiModelProperty(value = "mRid")
    private String mRid;

    @ApiModelProperty(value = "核心部件Ids ")
    private String coreComponentIds;

}