package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jcs.api.service.IFireResourceSupervisionService;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/fire-resource-superv")
public class FireResourceSupervisionController extends BaseController {
    @Autowired
    private IFireResourceSupervisionService iFireResourceSupervisionService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "驻站消防员、运维人员统计信息查询", notes = "驻站消防员、运维人员统计信息查询")
    @RequestMapping(value = "/stats", method = RequestMethod.GET)
    public ResponseModel<Object> stats(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode) {
        if (StringUtils.isBlank(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtils.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        }
        Map<String, Map<String, Number>> personnelStats = iFireResourceSupervisionService.getPersonnelStats(bizOrgCode);
        return ResponseHelper.buildResponse(personnelStats);
    }
}
