package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.util.List;

@Getter
@AllArgsConstructor
public enum CommonEnum {

    居民("居民","jm","业主类型"),
    非居民("非居民","fjm","业主类型"),
    自建资产("自建资产","zx","电站类型"),
    经销商代建("经销商代建","fzx","电站类型"),
    平顶屋("平顶屋","pdw","屋顶类型"),
    斜顶屋("斜顶屋","xdw","屋顶类型"),
    庭院("庭院","ty","屋顶类型"),
    别墅("别墅","bs","房屋整体情况"),
    普通民房("普通民房","pymf","房屋整体情况"),
    单门独院("单门独院","dmdy","房屋整体情况"),
    一栋多户("一栋多户","yddh","房屋整体情况"),
    一户一表("一户一表","yhyb","电表位置"),
    集中电表("集中电表","jzdb","电表位置"),
    南偏东("南偏东","npd","房屋偏向"),
    南偏西("南偏西","npx","房屋偏向"),
    正南("正南","zn","房屋偏向"),
    移除遮挡物("移除遮挡物","yczdw","解决措施"),
    设计规避("设计规避","sjgb","解决措施"),
    公共共有("公共共有","gy","房屋产权情况"),
    按份共有("按份共有","br","房屋产权情况"),
    单独所有("单独所有","dy","房屋产权情况"),
    高树("高树","gs","周边障碍物"),
    建筑物("建筑物","jzw","周边障碍物"),
    电线杆("电线杆","dxg","周边障碍物"),
    带电线路("带电线路","ddxl","周边障碍物"),
    变压器("变压器","byq","周边障碍物"),
    阳台("阳台","yt","上至屋顶通道"),
    孔洞("孔洞","kd","上至屋顶通道"),
    楼梯间("楼梯间","ltj","上至屋顶通道"),
    女儿墙("女儿墙","nrq","屋面遮挡物"),
    热水器("热水器","rsq","屋面遮挡物"),
    烟囱("烟囱","yc","屋面遮挡物"),
    老虎窗("老虎窗","lhc","屋面遮挡物"),
    水箱("水箱","sx","屋面遮挡物"),
    无("无","wu","屋面遮挡物"),
    无需防滑雪措施("无需防滑雪措施","wxfhxcs","防滑雪措施"),
    预留防滑雪缓冲通道("预留防滑雪缓冲通道","ylfhxhctd","防滑雪措施"),
    安装挡雪夹具("安装挡雪夹具","azdxjj","防滑雪措施"),
    自然人("自然人","zrr","商务类型"),
    非自然人("非自然人","fzrr","商务类型"),
    宅基地农户屋顶("宅基地农户屋顶","zjdnhw","法务类型"),
    法人私有的宅基地建筑屋顶("法人私有的宅基地建筑屋顶","frsydzjd","法务类型"),
    单晶("单晶","danjing","组件类型"),
    多晶("多晶","duojing","组件类型"),
    不限("不限","bx","逆变器系列"),
    全额上网("全额上网","qesw","上网模式"),
    余电上网("余电上网","ydsw","上网模式"),
    单相("单相","dx","相位"),
    三相("三相","ydsw","相位"),
    SMC("SMC","smc","材质"),
    不锈钢("不锈钢","bxg","材质"),
    钢板喷塑("钢板喷塑","gbps","材质"),
    单面("单面","dm","组件类型"),
    双面("双面","sm","组件类型"),
    其他("其他","other","公用");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    /**
     * 编码
     */
    private String type;


    public static String getNameByCode(String code) {
        String name = "";
        for(CommonEnum obj: CommonEnum.values()) {
            if (obj.getCode().equals(code)) {
                name = obj.getName();
                break;
            }
        }
        return StringUtils.isEmpty(name)?code:name;
    }

    public static String getNameByCodeList(List<String> codes) {


        String name = null;
        for (String code : codes) {
            for(CommonEnum obj: CommonEnum.values()) {
                if (obj.getCode().equals(code)) {
                    name =     name == null?obj.getName(): name +","+obj.getName() ;
                }
            }
        }
        return StringUtils.isEmpty(name)? String.valueOf(codes) :name;
    }
}
