package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2024/1/4
 */

@Data
@ApiModel(value = "WorkOrderPage",description = "派工单分页")
public class WorkOrderPage {


    @ApiModelProperty(value = "农户id",example = "1712049025391267842")
    protected Long sequenceNbr;

    @ApiModelProperty(value = "农户信息编号",example = "NH004GXZZZZYLBL202405164277")
    private String peasantHouseholdNo;

    @ApiModelProperty(value = "开发商",example = "admin")
    private String developerName;

    @ApiModelProperty(value = "区域公司",example = "户用光伏测试有限公司")
    private String regionalCompaniesName;

    @ApiModelProperty(value = "派工单编号",example = "PG060HBWHXZ202404149953")
    private String workOrderNum;

    @ApiModelProperty(value = "业主姓名",example = "admin")
    private String ownersName;

    @ApiModelProperty(value = "工程负责人",example = "admin")
    private String projectRegionManager;


    @ApiModelProperty(value = "施工负责人",example = "admin")
    private String constructionRegionManager;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "完工时间",example = "2024-10-25")
    private Date completionDate;

    @ApiModelProperty(value = "项目地址",example = "北京市/北京城区/东城")
    private String projectAddressName;

    @ApiModelProperty(value = "电站施工状态",example = "已完工")
    private String powerStationConstructionStatus;

    @ApiModelProperty(value = "派工电站id",example = "1712049025391267842")
    protected Long workOrderPowerStationId;
    @ApiModelProperty(value = "派工电站节点标识",example = "1712049025391267842")
    protected String workOrderPowerStationNode;

    @ApiModelProperty(value = "派工单id",example = "1712049025391267842")
    protected String workOrderId;
    /**
     * 区域公司id
     */
    @ApiModelProperty(value = "区域公司id",example = "1703949560172277762")
    private Long regionCompanyId;

    @ApiModelProperty(value = "平台经销商单位id",example = "1761919380884582402")
    private Long amosDealerId;
    @ApiModelProperty(value = "类型",example = "2")
    private String  type;
    @ApiModelProperty(value = "片区审核",example = "通过")
    private String  powerStationAreaStatus ;
    @ApiModelProperty(value = "设计审核",example = "通过")
    private String  powerStationDesignStatus ;
    @ApiModelProperty(value = "工程审核",example = "通过")
    private String  powerStationEngineeringStatus ;
    @ApiModelProperty(value = "判断是否有进行中的整改单数量",example = "33")
    private Long  rectificationNum ;
    @ApiModelProperty(value = "最后一条作废整改单id",example = "1720655712712945666")
    private Long  rollbackOrderId ;
    @ApiModelProperty(value = "页码",example = "1")
    int current;
    @ApiModelProperty(value = "大小",example = "20")
    int size;
    @ApiModelProperty(value = "数据过滤标识",example = "[\"yseq\",\"tet\"]")
    private List<String> workOrderPowerStationNodes ;
    @ApiModelProperty(value = "判断是否可以审核,默认不可以",example = "不可以")
    private String  isAudit ;

    @ApiModelProperty(value = "历史审核意见",example = "不通过")
    private String  auditIdea ;
    @ApiModelProperty(value = "实例id",example = "8dbc3974-a160-11ef-aa06-02420a1c0010")
    private String  instanceId ;

    @ApiModelProperty(value = "电站安装规模",example = "245.55")
    private String  scale ;
    @ApiModelProperty(value = "电站实际规模",example = "245.75")
    private String  realScale ;
    @ApiModelProperty(value = "省份",example = "陕西省")
    private String province;

    @ApiModelProperty(value = "首次编辑施工资料日期",example = "2024-10-14 10:12:31")
    private String firstConstructionDate;
    @ApiModelProperty(value = "开始时间",example = "2024-10-14 10:12:31")
    private String startTime;
    @ApiModelProperty(value = "结束时间",example = "2024-10-15 10:12:31")
    private String endTime;
    @ApiModelProperty(value = "路由地址Id",example = "17068690861069734112")
    @TableField(exist = false)
    private String routhPathId;
}
