package com.yeejoin.amos.boot.module.hygf.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpower;
import com.yeejoin.amos.boot.module.hygf.api.dto.RepaymentBatchDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.RepaymentDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.PrivilegeCompany;
import com.yeejoin.amos.boot.module.hygf.api.entity.Repayment;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *  Mapper 接口
 *
 * @author hzz
 * @date 2024-09-26
 */
public interface RepaymentMapper extends BaseMapper<Repayment> {
    @UserEmpower(field = {"regional_companies_code"}, dealerField = {"regional_companies_code"}, fieldConditions = {"in"}, relationship = "and")
    List<RepaymentDto> queryPage(@Param("sequenceNbr") String sequenceNbr, @Param("companyName")String companyName, @Param("loanPeriod")String loanPeriod,
                                 @Param("messageState")String messageState, @Param("repayState")String repayState,@Param("repayDate")String repayDate,@Param("period")String period);

    /**
     * 获取区域公司通过OrgCode
     * @param orgCode
     * @return
     */
    PrivilegeCompany getPrivilegeCompanyByOrgCode(@Param("orgCode")String orgCode);


    List<String> getTodoTelephones(@Param("userIds") List<String> userIds);

    @UserEmpower(field = {"regional_companies_code"}, dealerField = {"regional_companies_code"}, fieldConditions = {"in"}, relationship = "and")
    List<Repayment> getAllData(@Param("dto") RepaymentBatchDto repaymentBatchDto);
}
