package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.BasicGridRecordServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.BasicGridRecordDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 并网验收节点
 *
 * @author system_generator
 * @date 2024-08-21
 */
@RestController
@Api(tags = "并网验收节点Api")
@RequestMapping(value = "/basic-grid-record")
public class BasicGridRecordController extends BaseController {

    @Autowired
    BasicGridRecordServiceImpl basicGridRecordServiceImpl;

    /**
     * 新增并网验收节点
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增并网验收节点", notes = "新增并网验收节点")
	public ResponseModel<BasicGridRecordDto> save(@RequestBody BasicGridRecordDto model) {
	    model = basicGridRecordServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新并网验收节点", notes = "根据sequenceNbr更新并网验收节点")
	public ResponseModel<BasicGridRecordDto> updateBySequenceNbrBasicGridRecord(@RequestBody BasicGridRecordDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(basicGridRecordServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除并网验收节点", notes = "根据sequenceNbr删除并网验收节点")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(basicGridRecordServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个并网验收节点",  notes = "根据sequenceNbr查询单个并网验收节点")
	public ResponseModel<BasicGridRecordDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(basicGridRecordServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "并网验收节点分页查询",  notes = "并网验收节点分页查询")
	public ResponseModel<Page<BasicGridRecordDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<BasicGridRecordDto> page = new Page<BasicGridRecordDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(basicGridRecordServiceImpl.queryForBasicGridRecordPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "并网验收节点列表全部数据查询",   notes = "并网验收节点列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<BasicGridRecordDto>> selectForList() {
	    return ResponseHelper.buildResponse(basicGridRecordServiceImpl.queryForBasicGridRecordList());
	}
}
