package com.yeejoin.amos.boot.module.hygf.biz.excel.impl;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.hygf.api.dto.WorkOrderPage;
import com.yeejoin.amos.boot.module.hygf.api.mapper.BusinessFieldMapper;
import com.yeejoin.amos.boot.module.hygf.biz.excel.service.IExportPageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.*;

@Service
public class SgysServiceImpl implements IExportPageService {
    @Autowired
    private BusinessFieldMapper businessFieldMapper;
    @Autowired
    private RedisUtils redisUtils;
    @Value("${admin.engineering.roleId}")
    Long engineeringId;
    @Value("${admin.area.roleId}")
    Long areaId;
    @Value("${admin.design.roleId}")
    Long designId;
    @Value("${admin.delerAdmin.roleId}")
    Long delerAdminId;
    @Override
    public List<String> getStationId(Map<String, Object> filters) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        List<String> workOrderPowerStationNodes = new ArrayList<>();
        Map<String,Object> map =new HashMap<>();
        if (Objects.nonNull(filters)) {
            map.putAll(filters);
        }
        List<Long> roleIds = new ArrayList<>();
        for (Long aLong : reginParams.getUserModel().getOrgRoleSeqs().keySet()) {
            List<Long> longs = reginParams.getUserModel().getOrgRoleSeqs().get(aLong);

            if (longs.contains(areaId)) {
                workOrderPowerStationNodes.add("area");
            }
            if (longs.contains(engineeringId)) {
                workOrderPowerStationNodes.add("engineering");
            }
            if (longs.contains(designId)) {
                workOrderPowerStationNodes.add("design");
            }
            if (longs.contains(delerAdminId)) {
                workOrderPowerStationNodes.add("design");
                workOrderPowerStationNodes.add("engineering");
                workOrderPowerStationNodes.add("area");
            }
            roleIds.addAll(longs);
        }
        map.put("workOrderPowerStationNodes",workOrderPowerStationNodes);
        map.put("type","3");
        return businessFieldMapper.getSgysStationId(map);
    }
}
