package com.yeejoin.amos.boot.module.hygf.biz.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(value = "IcbcExcelVO", description = "聚富通管理ExcelVO")
public class IcbcExcelVO implements Serializable {
    private static final long serialVersionUID = 1L;

    @Excel(name = "序号", width = 20, orderNum = "1")
    private Integer index;

    @ApiModelProperty(value = "扣款批次号")
    @Excel(name = "扣款批次号", width = 50, orderNum = "2")
    private String batchNo;

    @ApiModelProperty(value = "代扣公司")
    @Excel(name = "代扣公司", width = 50, orderNum = "3")
    private String paymentTarget;

    @ApiModelProperty(value = "批扣总金额(元)")
    @Excel(name = "批扣总金额(元)", width = 30, orderNum = "4")
    private String paymentAmount;

    @ApiModelProperty(value = "操作人")
    @Excel(name = "操作人", width = 30, orderNum = "5")
    private String confirmator;

    @ApiModelProperty(value = "操作时间")
    @Excel(name = "操作时间", width = 50, orderNum = "6")
    private String confirmationTime;

    @ApiModelProperty(value = "说明")
    @Excel(name = "说明", width = 50, orderNum = "7")
    private String desc;

    @ApiModelProperty(value = "上传状态")
    @Excel(name = "上传状态", width = 30, orderNum = "8")
    private String uploadStatus;

    @ApiModelProperty(value = "上传人员")
    @Excel(name = "上传人员", width = 30, orderNum = "9")
    private String uploader;

    @ApiModelProperty(value = "上传时间")
    @Excel(name = "上传时间", width = 50, orderNum = "10")
    private String uploadTime;

    @ApiModelProperty(value = "代扣状态")
    @Excel(name = "代扣状态", width = 30, orderNum = "11")
    private String withholdStatus;

    @ApiModelProperty(value = "失败原因")
    @Excel(name = "失败原因", width = 50, orderNum = "12")
    private String paymentErrorDesc;


}
