package com.yeejoin.amos.boot.module.jxiop.biz.service;

import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.PvHealthIndex;

import java.util.List;


/**
 * <p>
 * ProjectName: amos-boot-zx-biz
 * PackageName: com.yeejoin.amos.boot.module.jxiop.biz.service.impl
 *
 * @author yangyang
 * @version v1.0
 * @date 2024/7/23 21:59
 */
public interface IPvHealthIndexService {

    List<PvHealthIndex> getInfoListByGroupByCdPv(String startTime,
                                                 String tableName,
                                                 String analysisObjectType);


    /**
     * 设备加权平均
     * 加权平均数 = (w1 * x1 + w2 * x2 + … + wn * xn) / (w1 + w2 + … + wn)
     * w1, w2, …, wn 是各个数据点的权重；
     * x1, x2, …, xn 是各个数据点的数值；
     * n 是数据点的总数。
     *
     * @param startTime          startTime
     * @param tableName          tableName
     * @param analysisObjectType analysisObjectType
     * @return {@link  List <  FanHealthIndex >}
     * @throws
     * @author yangyang
     * @date 2024/7/23 21:02
     */
    List<PvHealthIndex> getInfoListByGroupBySbPv(String startTime,
                                                 String tableName,
                                                 String analysisObjectType);

    /**
     * 子阵加权平均
     * 加权平均数 = (w1 * x1 + w2 * x2 + … + wn * xn) / (w1 + w2 + … + wn)
     * w1, w2, …, wn 是各个数据点的权重；
     * x1, x2, …, xn 是各个数据点的数值；
     * n 是数据点的总数。
     *
     * @param startTime          startTime
     * @param tableName          tableName
     * @param analysisObjectType analysisObjectType
     * @return {@link  List< FanHealthIndex>}
     * @throws
     * @author yangyang
     * @date 2024/7/23 21:02
     */
    List<PvHealthIndex> getInfoListByGroupByZzPv(String startTime,
                                                 String tableName,
                                                 String analysisObjectType);

    /**
     * 场站加权平均
     * 加权平均数 = (w1 * x1 + w2 * x2 + … + wn * xn) / (w1 + w2 + … + wn)
     * w1, w2, …, wn 是各个数据点的权重；
     * x1, x2, …, xn 是各个数据点的数值；
     * n 是数据点的总数。
     *
     * @param startTime          startTime
     * @param tableName          tableName
     * @param analysisObjectType analysisObjectType
     * @return {@link  List< FanHealthIndex>}
     * @throws
     * @author yangyang
     * @date 2024/7/23 21:02
     */
    List<PvHealthIndex> getInfoListByGroupByCzPv(String startTime,
                                                 String tableName,
                                                 String analysisObjectType);

    /**
     * 片区加权平均
     * 加权平均数 = (w1 * x1 + w2 * x2 + … + wn * xn) / (w1 + w2 + … + wn)
     * w1, w2, …, wn 是各个数据点的权重；
     * x1, x2, …, xn 是各个数据点的数值；
     * n 是数据点的总数。
     *
     * @param startTime          startTime
     * @param tableName          tableName
     * @param analysisObjectType analysisObjectType
     * @return {@link  List< FanHealthIndex>}
     * @throws
     * @author yangyang
     * @date 2024/7/23 21:02
     */
    List<PvHealthIndex> getInfoListByGroupByQyPv(String startTime,
                                                 String tableName,
                                                 String analysisObjectType);

    /**
     * 全域【所有 / 全国】加权平均
     * 加权平均数 = (w1 * x1 + w2 * x2 + … + wn * xn) / (w1 + w2 + … + wn)
     * w1, w2, …, wn 是各个数据点的权重；
     * x1, x2, …, xn 是各个数据点的数值；
     * n 是数据点的总数。
     *
     * @param startTime          startTime
     * @param tableName          tableName
     * @param analysisObjectType analysisObjectType
     * @return {@link  List< FanHealthIndex>}
     * @throws
     * @author yangyang
     * @date 2024/7/23 21:02
     */
    List<PvHealthIndex> getInfoListByGroupByQgPv(String startTime,
                                                 String tableName,
                                                 String analysisObjectType);
}
